/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class GrpcHeaderInterceptor
implements ClientInterceptor {
    private final Metadata metadata = new Metadata();

    public GrpcHeaderInterceptor(String tenantId) {
        this.metadata.put(Metadata.Key.of((String)"tenant-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)tenantId);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new HeaderAttachingClientCall(next.newCall(method, callOptions), this.metadata);
    }

    private static final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Metadata metadata;

        HeaderAttachingClientCall(ClientCall<ReqT, RespT> call, Metadata metadataToAttach) {
            super(call);
            this.metadata = metadataToAttach;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            headers.merge(this.metadata);
            super.start(responseListener, headers);
        }
    }
}

