/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="endpoints_grafana")
public class GrafanaEndpoint {
    @Id
    @SequenceGenerator(name="endpointsSequence", sequenceName="endpointsnxtid")
    @GeneratedValue(generator="endpointsSequence")
    @Column(name="id", nullable=false)
    private Long id;
    @Column(name="uid", unique=true, nullable=false)
    private String uid;
    @Column(name="url", nullable=false)
    private String url;
    @Column(name="api_key", nullable=false)
    private String apiKey;
    @Column(name="description")
    private String description;
    @Column(name="connect_timeout")
    private Integer connectTimeout;
    @Column(name="read_timeout")
    private Integer readTimeout;

    public GrafanaEndpoint() {
    }

    public GrafanaEndpoint(GrafanaEndpoint endpoint) {
        Objects.requireNonNull(endpoint);
        this.merge(endpoint);
        this.setId(endpoint.getId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void merge(GrafanaEndpoint endpoint) {
        Objects.requireNonNull(endpoint);
        this.setApiKey(endpoint.getApiKey());
        this.setUid(endpoint.getUid());
        this.setUrl(endpoint.getUrl());
        this.setConnectTimeout(endpoint.getConnectTimeout());
        this.setReadTimeout(endpoint.getReadTimeout());
        this.setDescription(endpoint.getDescription());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof GrafanaEndpoint) {
            GrafanaEndpoint that = (GrafanaEndpoint)other;
            return Objects.equals(this.id, that.id) && Objects.equals(this.uid, that.uid) && Objects.equals(this.url, that.url) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.description, that.description) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uid, this.url, this.apiKey, this.description, this.connectTimeout, this.readTimeout);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("uid", this.uid).add("url", this.url).add("apiKey", this.apiKey).add("description", this.description).add("connectTimeout", this.connectTimeout).add("readTimeout", this.readTimeout).toString();
    }
}

