/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import java.util.Random;

final class ExponentialBackoff {
    private final Random random;
    private final int base;
    private final int cap;
    private int attempt = -1;

    ExponentialBackoff(int base, int cap, Random random) {
        this.base = base;
        this.cap = cap;
        this.random = random;
    }

    final int error() {
        ++this.attempt;
        int multiplier = this.cap / this.base;
        if (this.attempt < 32 && multiplier >> this.attempt > 0) {
            multiplier = 1 << this.attempt;
        }
        return this.random.nextInt(this.base * multiplier);
    }

    final void reset() {
        this.attempt = -1;
    }
}

