/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.Profiler;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.kotlin.random.Random;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ContinuousProfilingScheduler
implements ProfilingScheduler {
    final Config config;
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("PyroscopeProfilingScheduler");
        t.setDaemon(true);
        return t;
    });
    private final Exporter exporter;
    private Logger logger;
    private Instant profilingIntervalStartTime;
    private ScheduledFuture<?> job;

    public ContinuousProfilingScheduler(Config config, Exporter exporter, Logger logger) {
        this.config = config;
        this.exporter = exporter;
        this.logger = logger;
    }

    @Override
    public void start(Profiler profiler) {
        Duration firstProfilingDuration;
        try {
            firstProfilingDuration = this.startFirst(profiler);
        }
        catch (Throwable throwable) {
            this.stop();
            throw new IllegalStateException(throwable);
        }
        Runnable dumpProfile = () -> {
            Snapshot snapshot;
            Instant now;
            try {
                profiler.stop();
                now = Instant.now();
                snapshot = profiler.dumpProfile(this.profilingIntervalStartTime, now);
                profiler.start();
            }
            catch (Throwable throwable) {
                this.logger.log(Logger.Level.ERROR, "Error dumping profiler %s", throwable);
                this.stop();
                return;
            }
            this.profilingIntervalStartTime = now;
            this.exporter.export(snapshot);
        };
        this.job = this.executor.scheduleAtFixedRate(dumpProfile, firstProfilingDuration.toMillis(), this.config.uploadInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void stop() {
        if (this.job != null) {
            this.job.cancel(true);
        }
        this.executor.shutdown();
    }

    private Duration startFirst(Profiler profiler) {
        Instant now = Instant.now();
        long uploadIntervalMillis = this.config.uploadInterval.toMillis();
        float randomOffset = Random.Default.nextFloat();
        if ((uploadIntervalMillis = (long)((float)uploadIntervalMillis * randomOffset)) < 2000L) {
            uploadIntervalMillis = 2000L;
        }
        Duration firstProfilingDuration = Duration.ofMillis(uploadIntervalMillis);
        profiler.start();
        this.profilingIntervalStartTime = now;
        return firstProfilingDuration;
    }
}

