/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.com.squareup.moshi;

import io.pyroscope.com.squareup.moshi.JsonDataException;
import io.pyroscope.com.squareup.moshi.JsonScope;
import io.pyroscope.com.squareup.moshi.JsonUtf8Writer;
import io.pyroscope.com.squareup.moshi.JsonValueWriter;
import io.pyroscope.okio.BufferedSink;
import io.pyroscope.okio.BufferedSource;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public abstract class JsonWriter
implements Closeable,
Flushable {
    int stackSize = 0;
    int[] scopes = new int[32];
    String[] pathNames = new String[32];
    int[] pathIndices = new int[32];
    String indent;
    boolean lenient;
    boolean serializeNulls;
    boolean promoteValueToName;
    int flattenStackSize = -1;
    private Map<Class<?>, Object> tags;

    @CheckReturnValue
    public static JsonWriter of(BufferedSink sink2) {
        return new JsonUtf8Writer(sink2);
    }

    JsonWriter() {
    }

    final int peekScope() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.scopes[this.stackSize - 1];
    }

    final boolean checkStack() {
        if (this.stackSize != this.scopes.length) {
            return false;
        }
        if (this.stackSize == 256) {
            throw new JsonDataException("Nesting too deep at " + this.getPath() + ": circular reference?");
        }
        this.scopes = Arrays.copyOf(this.scopes, this.scopes.length * 2);
        this.pathNames = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
        this.pathIndices = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
        if (this instanceof JsonValueWriter) {
            ((JsonValueWriter)this).stack = Arrays.copyOf(((JsonValueWriter)this).stack, ((JsonValueWriter)this).stack.length * 2);
        }
        return true;
    }

    final void pushScope(int newTop) {
        this.scopes[this.stackSize++] = newTop;
    }

    final void replaceTop(int topOfStack) {
        this.scopes[this.stackSize - 1] = topOfStack;
    }

    public void setIndent(String indent) {
        this.indent = !indent.isEmpty() ? indent : null;
    }

    @CheckReturnValue
    public final String getIndent() {
        return this.indent != null ? this.indent : "";
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @CheckReturnValue
    public final boolean isLenient() {
        return this.lenient;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @CheckReturnValue
    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public abstract JsonWriter beginArray() throws IOException;

    public abstract JsonWriter endArray() throws IOException;

    public abstract JsonWriter beginObject() throws IOException;

    public abstract JsonWriter endObject() throws IOException;

    public abstract JsonWriter name(String var1) throws IOException;

    public abstract JsonWriter value(@Nullable String var1) throws IOException;

    public abstract JsonWriter nullValue() throws IOException;

    public abstract JsonWriter value(boolean var1) throws IOException;

    public abstract JsonWriter value(@Nullable Boolean var1) throws IOException;

    public abstract JsonWriter value(double var1) throws IOException;

    public abstract JsonWriter value(long var1) throws IOException;

    public abstract JsonWriter value(@Nullable Number var1) throws IOException;

    public final JsonWriter value(BufferedSource source2) throws IOException {
        if (this.promoteValueToName) {
            throw new IllegalStateException("BufferedSource cannot be used as a map key in JSON at path " + this.getPath());
        }
        try (BufferedSink sink2 = this.valueSink();){
            source2.readAll(sink2);
        }
        return this;
    }

    @CheckReturnValue
    public abstract BufferedSink valueSink() throws IOException;

    public final JsonWriter jsonValue(@Nullable Object value) throws IOException {
        if (value instanceof Map) {
            this.beginObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException(key == null ? "Map keys must be non-null" : "Map keys must be of type String: " + key.getClass().getName());
                }
                this.name((String)key);
                this.jsonValue(entry.getValue());
            }
            this.endObject();
        } else if (value instanceof List) {
            this.beginArray();
            for (Object element : (List)value) {
                this.jsonValue(element);
            }
            this.endArray();
        } else if (value instanceof String) {
            this.value((String)value);
        } else if (value instanceof Boolean) {
            this.value((boolean)((Boolean)value));
        } else if (value instanceof Double) {
            this.value((Double)value);
        } else if (value instanceof Long) {
            this.value((Long)value);
        } else if (value instanceof Number) {
            this.value((Number)value);
        } else if (value == null) {
            this.nullValue();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
        return this;
    }

    public final void promoteValueToName() throws IOException {
        int context = this.peekScope();
        if (context != 5 && context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.promoteValueToName = true;
    }

    @CheckReturnValue
    public final int beginFlatten() {
        int context = this.peekScope();
        if (context != 5 && context != 3 && context != 2 && context != 1) {
            throw new IllegalStateException("Nesting problem.");
        }
        int token = this.flattenStackSize;
        this.flattenStackSize = this.stackSize;
        return token;
    }

    public final void endFlatten(int token) {
        this.flattenStackSize = token;
    }

    @CheckReturnValue
    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }

    @CheckReturnValue
    @Nullable
    public final <T> T tag(Class<T> clazz) {
        if (this.tags == null) {
            return null;
        }
        return (T)this.tags.get(clazz);
    }

    public final <T> void setTag(Class<T> clazz, T value) {
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Tag value must be of type " + clazz.getName());
        }
        if (this.tags == null) {
            this.tags = new LinkedHashMap();
        }
        this.tags.put(clazz, value);
    }
}

