/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.perspectivepoller;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.ServicePerspective;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="PerspectiveServiceTracker")
public class PerspectiveServiceTracker
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(PerspectiveServiceTracker.class);
    public static final String REFRESH_RATE_LIMIT_PROPERTY = "org.opennms.netmgt.perspectivepoller.trackerRefreshRateLimit";
    private static final long REFRESH_RATE_LIMIT_MS = SystemProperties.getLong((String)"org.opennms.netmgt.perspectivepoller.trackerRefreshRateLimit", (Long)TimeUnit.SECONDS.toMillis(30L));
    private final SessionUtils sessionUtils;
    private final ApplicationDao applicationDao;
    private final Set<Session> sessions = Sets.newHashSet();
    private final Timer timer = new Timer("PerspectiveServiceTracker-Timer");

    @Autowired
    public PerspectiveServiceTracker(SessionUtils sessionUtils, ApplicationDao applicationDao) {
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.applicationDao = Objects.requireNonNull(applicationDao);
        long timerIntervalMs = Math.min(REFRESH_RATE_LIMIT_MS, TimeUnit.SECONDS.toMillis(5L));
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PerspectiveServiceTracker.this.update(false);
            }
        }, timerIntervalMs, timerIntervalMs);
    }

    public AutoCloseable track(Listener listener) {
        Session session = new Session(listener);
        session.update(true);
        return session;
    }

    public void destroy() throws Exception {
        this.timer.cancel();
    }

    @EventHandler(ueis={"uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/serviceDeleted", "uei.opennms.org/nodes/nodeCategoryMembershipChanged", "uei.opennms.org/nodes/nodeLocationChanged", "uei.opennms.org/nodes/nodeAdded", "uei.opennms.org/nodes/nodeDeleted", "uei.opennms.org/nodes/nodeGainedInterface", "uei.opennms.org/nodes/interfaceDeleted", "uei.opennms.org/nodes/interfaceReparented", "uei.opennms.org/internal/poller/suspendPollingService", "uei.opennms.org/internal/poller/resumePollingService", "uei.opennms.org/internal/applicationChanged", "uei.opennms.org/internal/applicationCreated", "uei.opennms.org/internal/applicationDeleted"})
    public void handleEvent(IEvent event) {
        this.update(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean dirty) {
        Set<Session> set = this.sessions;
        synchronized (set) {
            try {
                this.sessions.forEach(session -> session.update(dirty));
            }
            catch (Exception e) {
                LOG.warn("Error refreshing service perspectives.", (Throwable)e);
            }
        }
    }

    private class Session
    implements AutoCloseable {
        private final Listener listener;
        private final Set<ServicePerspectiveRef> active = Sets.newHashSet();
        private Instant lastRefresh = Instant.MIN;
        private boolean dirty = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session(Listener listener) {
            this.listener = Objects.requireNonNull(listener);
            Set<Session> set = PerspectiveServiceTracker.this.sessions;
            synchronized (set) {
                PerspectiveServiceTracker.this.sessions.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            Set<Session> set = PerspectiveServiceTracker.this.sessions;
            synchronized (set) {
                PerspectiveServiceTracker.this.sessions.remove(this);
            }
        }

        public synchronized void update(boolean dirty) {
            this.dirty |= dirty;
            if (!this.dirty) {
                return;
            }
            Instant now = Instant.now();
            if (this.lastRefresh.isAfter(now.minusMillis(REFRESH_RATE_LIMIT_MS))) {
                return;
            }
            PerspectiveServiceTracker.this.sessionUtils.withTransaction(() -> {
                Map candidates = PerspectiveServiceTracker.this.applicationDao.getServicePerspectives().stream().collect(Collectors.toMap(ServicePerspectiveRef::from, Function.identity()));
                HashSet current = Sets.newHashSet(this.active);
                Sets.SetView additions = Sets.difference(candidates.keySet(), (Set)current);
                Sets.SetView removals = Sets.difference((Set)current, candidates.keySet());
                for (ServicePerspectiveRef servicePerspective : additions) {
                    try {
                        this.listener.onServicePerspectiveAdded(servicePerspective, (ServicePerspective)candidates.get(servicePerspective));
                        this.active.add(servicePerspective);
                    }
                    catch (Exception e) {
                        LOG.error("Adding service failed", (Throwable)e);
                    }
                }
                for (ServicePerspectiveRef servicePerspective : removals) {
                    try {
                        this.listener.onServicePerspectiveRemoved(servicePerspective);
                        this.active.remove(servicePerspective);
                    }
                    catch (Exception e) {
                        LOG.error("Adding service failed", (Throwable)e);
                    }
                }
            });
            this.lastRefresh = now;
            this.dirty = false;
        }
    }

    public static class ServicePerspectiveRef {
        private final int nodeId;
        private final InetAddress ipAddress;
        private final String serviceName;
        private final String perspectiveLocation;

        public ServicePerspectiveRef(int nodeId, InetAddress ipAddress, String serviceName, String perspectiveLocation) {
            this.nodeId = Objects.requireNonNull(nodeId);
            this.ipAddress = Objects.requireNonNull(ipAddress);
            this.serviceName = Objects.requireNonNull(serviceName);
            this.perspectiveLocation = Objects.requireNonNull(perspectiveLocation);
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public InetAddress getIpAddress() {
            return this.ipAddress;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getPerspectiveLocation() {
            return this.perspectiveLocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServicePerspectiveRef)) {
                return false;
            }
            ServicePerspectiveRef that = (ServicePerspectiveRef)o;
            return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.perspectiveLocation, that.perspectiveLocation);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.ipAddress, this.serviceName, this.perspectiveLocation);
        }

        public static ServicePerspectiveRef from(ServicePerspective servicePerspective) {
            return new ServicePerspectiveRef(servicePerspective.getService().getNodeId(), servicePerspective.getService().getIpAddress(), servicePerspective.getService().getServiceName(), servicePerspective.getPerspectiveLocation().getLocationName());
        }
    }

    public static interface Listener {
        public void onServicePerspectiveAdded(ServicePerspectiveRef var1, ServicePerspective var2);

        public void onServicePerspectiveRemoved(ServicePerspectiveRef var1);
    }
}

