/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.event.Action;
import com.vaadin.event.ContextClickEvent;
import com.vaadin.event.SerializableEventListener;
import com.vaadin.event.Transferable;
import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DragSource;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.DropTarget;
import com.vaadin.event.dd.acceptcriteria.ClientSideCriterion;
import com.vaadin.event.dd.acceptcriteria.ServerSideCriterion;
import com.vaadin.event.dd.acceptcriteria.TargetDetailIs;
import com.vaadin.server.KeyMapper;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.server.Resource;
import com.vaadin.server.VariableOwner;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.MultiSelectMode;
import com.vaadin.shared.ui.dd.VerticalDropLocation;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.ContainerHierarchicalWrapper;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.event.DataBoundTransferable;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.tree.TreeServerRpc;
import com.vaadin.v7.shared.ui.tree.TreeState;
import com.vaadin.v7.ui.AbstractSelect;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public class Tree
extends AbstractSelect
implements Container.Hierarchical,
Action.Container,
ItemClickEvent.ItemClickNotifier,
DragSource,
DropTarget {
    private static final String NULL_ALT_EXCEPTION_MESSAGE = "Parameter 'altText' needs to be non null";
    private final Map<Object, String> itemIconAlts = new HashMap<Object, String>();
    private HashSet<Object> expanded = new HashSet();
    private LinkedList<Action.Handler> actionHandlers = null;
    private KeyMapper<Action> actionMapper = null;
    private boolean selectable = true;
    private boolean partialUpdate = false;
    private Object expandedItemId;
    private boolean initialPaint = true;
    private AbstractSelect.ItemDescriptionGenerator itemDescriptionGenerator;
    private TreeDragMode dragMode = TreeDragMode.NONE;
    private MultiSelectMode multiSelectMode = MultiSelectMode.DEFAULT;
    private ItemStyleGenerator itemStyleGenerator;
    private DropHandler dropHandler;
    private boolean htmlContentAllowed;

    public Tree() {
        this(null);
        this.registerRpc((ServerRpc)new TreeServerRpc(){

            public void contextClick(String rowKey, MouseEventDetails details) {
                Tree.this.fireEvent((EventObject)((Object)new TreeContextClickEvent(Tree.this, Tree.this.itemIdMapper.get(rowKey), details)));
            }
        });
    }

    public Tree(String caption) {
        this(caption, new HierarchicalContainer());
    }

    public Tree(String caption, Container dataSource) {
        super(caption, dataSource);
    }

    @Override
    public void setItemIcon(Object itemId, Resource icon) {
        this.setItemIcon(itemId, icon, "");
    }

    public void setItemIcon(Object itemId, Resource icon, String altText) {
        if (itemId != null) {
            super.setItemIcon(itemId, icon);
            if (icon == null) {
                this.itemIconAlts.remove(itemId);
            } else {
                if (altText == null) {
                    throw new IllegalArgumentException(NULL_ALT_EXCEPTION_MESSAGE);
                }
                this.itemIconAlts.put(itemId, altText);
            }
            this.markAsDirty();
        }
    }

    public void setItemIconAlternateText(Object itemId, String altText) {
        if (itemId != null) {
            if (altText == null) {
                throw new IllegalArgumentException(NULL_ALT_EXCEPTION_MESSAGE);
            }
            this.itemIconAlts.put(itemId, altText);
        }
    }

    public String getItemIconAlternateText(Object itemId) {
        String storedAlt = this.itemIconAlts.get(itemId);
        return storedAlt == null ? "" : storedAlt;
    }

    public boolean isExpanded(Object itemId) {
        return this.expanded.contains(itemId);
    }

    public boolean expandItem(Object itemId) {
        boolean success = this.expandItem(itemId, true);
        this.markAsDirty();
        return success;
    }

    private boolean expandItem(Object itemId, boolean sendChildTree) {
        if (this.isExpanded(itemId)) {
            return true;
        }
        if (!this.areChildrenAllowed(itemId)) {
            return false;
        }
        this.expanded.add(itemId);
        this.expandedItemId = itemId;
        if (this.initialPaint) {
            this.markAsDirty();
        } else if (sendChildTree) {
            this.requestPartialRepaint();
        }
        this.fireExpandEvent(itemId);
        return true;
    }

    public void markAsDirty() {
        super.markAsDirty();
        this.partialUpdate = false;
    }

    private void requestPartialRepaint() {
        super.markAsDirty();
        this.partialUpdate = true;
    }

    public boolean expandItemsRecursively(Object startItemId) {
        boolean result = true;
        Stack<Object> todo = new Stack<Object>();
        todo.add(startItemId);
        while (!todo.isEmpty()) {
            Object id = todo.pop();
            if (this.areChildrenAllowed(id) && !this.expandItem(id, false)) {
                result = false;
            }
            if (!this.hasChildren(id)) continue;
            todo.addAll(this.getChildren(id));
        }
        this.markAsDirty();
        return result;
    }

    public boolean collapseItem(Object itemId) {
        if (!this.isExpanded(itemId)) {
            return true;
        }
        this.expanded.remove(itemId);
        this.markAsDirty();
        this.fireCollapseEvent(itemId);
        return true;
    }

    public boolean collapseItemsRecursively(Object startItemId) {
        boolean result = true;
        Stack<Object> todo = new Stack<Object>();
        todo.add(startItemId);
        while (!todo.isEmpty()) {
            Object id = todo.pop();
            if (this.areChildrenAllowed(id) && !this.collapseItem(id)) {
                result = false;
            }
            if (!this.hasChildren(id)) continue;
            todo.addAll(this.getChildren(id));
        }
        return result;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        if (this.selectable != selectable) {
            this.selectable = selectable;
            this.markAsDirty();
        }
    }

    public void setMultiselectMode(MultiSelectMode mode) {
        if (this.multiSelectMode != mode && mode != null) {
            this.multiSelectMode = mode;
            this.markAsDirty();
        }
    }

    public MultiSelectMode getMultiselectMode() {
        return this.multiSelectMode;
    }

    @Override
    public void changeVariables(Object source, Map<String, Object> variables) {
        StringTokenizer st;
        if (variables.containsKey("clickedKey")) {
            String[] key = (String[])variables.get("clickedKey");
            String[] id = this.itemIdMapper.get((String)key);
            MouseEventDetails details = MouseEventDetails.deSerialize((String)((String)variables.get("clickEvent")));
            Item item = this.getItem(id);
            if (item != null) {
                this.fireEvent((EventObject)((Object)new ItemClickEvent((Component)this, item, id, null, details)));
            }
        }
        if (!this.isSelectable() && variables.containsKey("selected")) {
            variables = new HashMap<String, Object>(variables);
            variables.remove("selected");
        }
        if (variables.containsKey("collapse")) {
            for (String key : (String[])variables.get("collapse")) {
                Object id = this.itemIdMapper.get(key);
                if (id == null || !this.isExpanded(id)) continue;
                this.expanded.remove(id);
                if (this.expandedItemId == id) {
                    this.expandedItemId = null;
                }
                this.fireCollapseEvent(id);
            }
        }
        if (variables.containsKey("expand")) {
            boolean sendChildTree = false;
            if (variables.containsKey("requestChildTree")) {
                sendChildTree = true;
            }
            for (String key : (String[])variables.get("expand")) {
                Object id = this.itemIdMapper.get(key);
                if (id == null) continue;
                this.expandItem(id, sendChildTree);
            }
        }
        if (variables.containsKey("selected") && this.isMultiSelect() && this.multiSelectMode == MultiSelectMode.DEFAULT) {
            this.handleSelectedItems(variables);
            variables = new HashMap<String, Object>(variables);
            variables.remove("selected");
        }
        super.changeVariables(source, variables);
        if (variables.containsKey("action") && (st = new StringTokenizer((String)variables.get("action"), ",")).countTokens() == 2) {
            Object itemId = this.itemIdMapper.get(st.nextToken());
            Action action = (Action)this.actionMapper.get(st.nextToken());
            if (action != null && (itemId == null || this.containsId(itemId)) && this.actionHandlers != null) {
                for (Action.Handler ah : this.actionHandlers) {
                    ah.handleAction(action, (Object)this, itemId);
                }
            }
        }
    }

    private void handleSelectedItems(Map<String, Object> variables) {
        LinkedList<Object> s = new LinkedList<Object>();
        for (String key : (String[])variables.get("selected")) {
            Object id = this.itemIdMapper.get(key);
            if (!(this.isNullSelectionAllowed() || id != null && id != this.getNullSelectionItemId())) {
                this.markAsDirty();
                continue;
            }
            if (id == null || !this.containsId(id)) continue;
            s.add(id);
        }
        if (!this.isNullSelectionAllowed() && s.isEmpty()) {
            this.markAsDirty();
            return;
        }
        this.setValue(s, true);
    }

    @Override
    public void paintContent(PaintTarget target) throws PaintException {
        this.initialPaint = false;
        if (this.partialUpdate) {
            target.addAttribute("partialUpdate", true);
            target.addAttribute("rootKey", this.itemIdMapper.key(this.expandedItemId));
        } else {
            this.getCaptionChangeListener().clear();
            if (this.getTabIndex() > 0) {
                target.addAttribute("tabindex", this.getTabIndex());
            }
            if (this.isSelectable()) {
                target.addAttribute("selectmode", this.isMultiSelect() ? "multi" : "single");
                if (this.isMultiSelect()) {
                    target.addAttribute("multiselectmode", this.multiSelectMode.toString());
                }
            } else {
                target.addAttribute("selectmode", "none");
            }
            if (this.isNewItemsAllowed()) {
                target.addAttribute("allownewitem", true);
            }
            if (this.isNullSelectionAllowed()) {
                target.addAttribute("nullselect", true);
            }
            if (this.dragMode != TreeDragMode.NONE) {
                target.addAttribute("dragMode", this.dragMode.ordinal());
            }
            if (this.isHtmlContentAllowed()) {
                target.addAttribute("htmlAllowed", true);
            }
        }
        LinkedHashSet<Action> actionSet = new LinkedHashSet<Action>();
        LinkedList<String> selectedKeys = new LinkedList<String>();
        Stack iteratorStack = new Stack();
        Collection<?> ids = this.partialUpdate ? this.getChildren(this.expandedItemId) : this.rootItemIds();
        if (ids != null) {
            iteratorStack.push(ids.iterator());
        }
        if (this.actionHandlers != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Action.Handler ah : this.actionHandlers) {
                Action[] aa = ah.getActions(null, (Object)this);
                if (aa == null) continue;
                for (int ai = 0; ai < aa.length; ++ai) {
                    String akey = this.actionMapper.key((Object)aa[ai]);
                    actionSet.add(aa[ai]);
                    keys.add(akey);
                }
            }
            target.addAttribute("alb", keys.toArray());
        }
        while (!iteratorStack.isEmpty()) {
            String description;
            String stylename;
            Iterator i = (Iterator)iteratorStack.peek();
            if (!i.hasNext()) {
                iteratorStack.pop();
                if (iteratorStack.isEmpty()) continue;
                target.endTag("node");
                continue;
            }
            Object itemId = i.next();
            boolean isNode = this.areChildrenAllowed(itemId);
            if (isNode) {
                target.startTag("node");
            } else {
                target.startTag("leaf");
            }
            if (this.itemStyleGenerator != null && (stylename = this.itemStyleGenerator.getStyle(this, itemId)) != null) {
                target.addAttribute("style", stylename);
            }
            if (this.itemDescriptionGenerator != null && (description = this.itemDescriptionGenerator.generateDescription((Component)this, itemId, null)) != null && !description.equals("")) {
                target.addAttribute("descr", description);
            }
            target.addAttribute("caption", this.getItemCaption(itemId));
            Resource icon = this.getItemIcon(itemId);
            if (icon != null) {
                target.addAttribute("icon", this.getItemIcon(itemId));
                target.addAttribute("iconalt", this.getItemIconAlternateText(itemId));
            }
            String key = this.itemIdMapper.key(itemId);
            target.addAttribute("key", key);
            if (this.isSelected(itemId)) {
                target.addAttribute("selected", true);
                selectedKeys.add(key);
            }
            if (this.areChildrenAllowed(itemId) && this.isExpanded(itemId)) {
                target.addAttribute("expanded", true);
            }
            this.getCaptionChangeListener().addNotifierForItem(itemId);
            if (this.actionHandlers != null) {
                ArrayList<String> keys = new ArrayList<String>();
                for (Action.Handler ah : this.actionHandlers) {
                    Action[] aa = ah.getActions(itemId, (Object)this);
                    if (aa == null) continue;
                    for (int ai = 0; ai < aa.length; ++ai) {
                        String akey = this.actionMapper.key((Object)aa[ai]);
                        actionSet.add(aa[ai]);
                        keys.add(akey);
                    }
                }
                target.addAttribute("al", keys.toArray());
            }
            if (this.isExpanded(itemId) && this.hasChildren(itemId) && this.areChildrenAllowed(itemId)) {
                iteratorStack.push(this.getChildren(itemId).iterator());
                continue;
            }
            if (isNode) {
                target.endTag("node");
                continue;
            }
            target.endTag("leaf");
        }
        if (!actionSet.isEmpty()) {
            target.addVariable((VariableOwner)this, "action", "");
            target.startTag("actions");
            for (Action a : actionSet) {
                target.startTag("action");
                if (a.getCaption() != null) {
                    target.addAttribute("caption", a.getCaption());
                }
                if (a.getIcon() != null) {
                    target.addAttribute("icon", a.getIcon());
                }
                target.addAttribute("key", this.actionMapper.key((Object)a));
                target.endTag("action");
            }
            target.endTag("actions");
        }
        if (this.partialUpdate) {
            this.partialUpdate = false;
        } else {
            target.addVariable((VariableOwner)this, "selected", selectedKeys.toArray(new String[selectedKeys.size()]));
            target.addVariable((VariableOwner)this, "expand", new String[0]);
            target.addVariable((VariableOwner)this, "collapse", new String[0]);
            target.addVariable((VariableOwner)this, "newitem", new String[0]);
            if (this.dropHandler != null) {
                this.dropHandler.getAcceptCriterion().paint(target);
            }
        }
    }

    @Override
    public boolean areChildrenAllowed(Object itemId) {
        return ((Container.Hierarchical)this.items).areChildrenAllowed(itemId);
    }

    @Override
    public Collection<?> getChildren(Object itemId) {
        return ((Container.Hierarchical)this.items).getChildren(itemId);
    }

    @Override
    public Object getParent(Object itemId) {
        return ((Container.Hierarchical)this.items).getParent(itemId);
    }

    @Override
    public boolean hasChildren(Object itemId) {
        return ((Container.Hierarchical)this.items).hasChildren(itemId);
    }

    @Override
    public boolean isRoot(Object itemId) {
        return ((Container.Hierarchical)this.items).isRoot(itemId);
    }

    @Override
    public Collection<?> rootItemIds() {
        return ((Container.Hierarchical)this.items).rootItemIds();
    }

    @Override
    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) {
        boolean success = ((Container.Hierarchical)this.items).setChildrenAllowed(itemId, areChildrenAllowed);
        if (success) {
            this.markAsDirty();
        }
        return success;
    }

    @Override
    public boolean setParent(Object itemId, Object newParentId) {
        boolean success = ((Container.Hierarchical)this.items).setParent(itemId, newParentId);
        if (success) {
            this.markAsDirty();
        }
        return success;
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        if (newDataSource == null) {
            newDataSource = new HierarchicalContainer();
        }
        if (Container.Hierarchical.class.isAssignableFrom(newDataSource.getClass())) {
            super.setContainerDataSource(newDataSource);
        } else {
            super.setContainerDataSource(new ContainerHierarchicalWrapper(newDataSource));
        }
        if (this.expanded != null) {
            this.cleanupExpandedItems();
        }
    }

    @Override
    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        super.containerItemSetChange(event);
        if (this.getContainerDataSource() instanceof Container.Filterable) {
            boolean hasFilters;
            boolean bl = hasFilters = !((Container.Filterable)this.getContainerDataSource()).getContainerFilters().isEmpty();
            if (!hasFilters) {
                this.cleanupExpandedItems();
            }
        }
    }

    public void addExpandListener(ExpandListener listener) {
        this.addListener(ExpandEvent.class, listener, ExpandListener.EXPAND_METHOD);
    }

    @Deprecated
    public void addListener(ExpandListener listener) {
        this.addExpandListener(listener);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.removeListener(ExpandEvent.class, listener, ExpandListener.EXPAND_METHOD);
    }

    @Deprecated
    public void removeListener(ExpandListener listener) {
        this.removeExpandListener(listener);
    }

    protected void fireExpandEvent(Object itemId) {
        this.fireEvent((EventObject)((Object)new ExpandEvent((Component)this, itemId)));
    }

    public void addCollapseListener(CollapseListener listener) {
        this.addListener(CollapseEvent.class, listener, CollapseListener.COLLAPSE_METHOD);
    }

    @Deprecated
    public void addListener(CollapseListener listener) {
        this.addCollapseListener(listener);
    }

    public void removeCollapseListener(CollapseListener listener) {
        this.removeListener(CollapseEvent.class, listener, CollapseListener.COLLAPSE_METHOD);
    }

    @Deprecated
    public void removeListener(CollapseListener listener) {
        this.removeCollapseListener(listener);
    }

    protected void fireCollapseEvent(Object itemId) {
        this.fireEvent((EventObject)((Object)new CollapseEvent((Component)this, itemId)));
    }

    public void addActionHandler(Action.Handler actionHandler) {
        if (actionHandler != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new LinkedList();
                this.actionMapper = new KeyMapper();
            }
            if (!this.actionHandlers.contains(actionHandler)) {
                this.actionHandlers.add(actionHandler);
                this.markAsDirty();
            }
        }
    }

    public void removeActionHandler(Action.Handler actionHandler) {
        if (this.actionHandlers != null && this.actionHandlers.contains(actionHandler)) {
            this.actionHandlers.remove(actionHandler);
            if (this.actionHandlers.isEmpty()) {
                this.actionHandlers = null;
                this.actionMapper = null;
            }
            this.markAsDirty();
        }
    }

    public void removeAllActionHandlers() {
        this.actionHandlers = null;
        this.actionMapper = null;
        this.markAsDirty();
    }

    @Override
    public Collection<?> getVisibleItemIds() {
        LinkedList visible = new LinkedList();
        Stack iteratorStack = new Stack();
        Collection<?> ids = this.rootItemIds();
        if (ids != null) {
            iteratorStack.push(ids.iterator());
        }
        while (!iteratorStack.isEmpty()) {
            Iterator i = (Iterator)iteratorStack.peek();
            if (!i.hasNext()) {
                iteratorStack.pop();
                continue;
            }
            Object itemId = i.next();
            visible.add(itemId);
            if (!this.isExpanded(itemId) || !this.hasChildren(itemId)) continue;
            iteratorStack.push(this.getChildren(itemId).iterator());
        }
        return visible;
    }

    @Override
    public void setNullSelectionItemId(Object nullSelectionItemId) throws UnsupportedOperationException {
        if (nullSelectionItemId != null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setNewItemsAllowed(boolean allowNewOptions) throws UnsupportedOperationException {
        if (allowNewOptions) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void addItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.addListener("itemClick", ItemClickEvent.class, listener, ItemClickEvent.ITEM_CLICK_METHOD);
    }

    @Override
    @Deprecated
    public void addListener(ItemClickEvent.ItemClickListener listener) {
        this.addItemClickListener(listener);
    }

    @Override
    public void removeItemClickListener(ItemClickEvent.ItemClickListener listener) {
        this.removeListener("itemClick", ItemClickEvent.class, listener);
    }

    @Override
    @Deprecated
    public void removeListener(ItemClickEvent.ItemClickListener listener) {
        this.removeItemClickListener(listener);
    }

    public void setItemStyleGenerator(ItemStyleGenerator itemStyleGenerator) {
        if (this.itemStyleGenerator != itemStyleGenerator) {
            this.itemStyleGenerator = itemStyleGenerator;
            this.markAsDirty();
        }
    }

    public ItemStyleGenerator getItemStyleGenerator() {
        return this.itemStyleGenerator;
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        return super.removeItem(itemId);
    }

    public DropHandler getDropHandler() {
        return this.dropHandler;
    }

    public void setDropHandler(DropHandler dropHandler) {
        this.dropHandler = dropHandler;
    }

    public TreeTargetDetails translateDropTargetDetails(Map<String, Object> clientVariables) {
        return new TreeTargetDetails(clientVariables);
    }

    private String key(Object itemId) {
        return this.itemIdMapper.key(itemId);
    }

    public void setDragMode(TreeDragMode dragMode) {
        this.dragMode = dragMode;
        this.markAsDirty();
    }

    public TreeDragMode getDragMode() {
        return this.dragMode;
    }

    public Transferable getTransferable(Map<String, Object> payload) {
        TreeTransferable transferable = new TreeTransferable((Component)this, payload);
        Object object = payload.get("itemId");
        if (object != null) {
            transferable.setData("itemId", this.itemIdMapper.get((String)object));
        }
        return transferable;
    }

    public void setItemDescriptionGenerator(AbstractSelect.ItemDescriptionGenerator generator) {
        if (generator != this.itemDescriptionGenerator) {
            this.itemDescriptionGenerator = generator;
            this.markAsDirty();
        }
    }

    public AbstractSelect.ItemDescriptionGenerator getItemDescriptionGenerator() {
        return this.itemDescriptionGenerator;
    }

    private void cleanupExpandedItems() {
        HashSet<Object> removedItemIds = new HashSet<Object>();
        for (Object expandedItemId : this.expanded) {
            if (this.getItem(expandedItemId) != null) continue;
            removedItemIds.add(expandedItemId);
            if (this.expandedItemId != expandedItemId) continue;
            this.expandedItemId = null;
        }
        this.expanded.removeAll(removedItemIds);
    }

    @Override
    protected String readItem(Element node, Set<String> selected, DesignContext context) {
        if (!"node".equals(node.tagName())) {
            throw new DesignException("Unrecognized child element in " + this.getClass().getSimpleName() + ": " + node.tagName());
        }
        String itemId = node.attr("text");
        this.addItem(itemId);
        if (node.hasAttr("icon")) {
            Resource icon = (Resource)DesignAttributeHandler.readAttribute((String)"icon", (Attributes)node.attributes(), Resource.class);
            this.setItemIcon(itemId, icon);
        }
        if (node.hasAttr("selected")) {
            selected.add(itemId);
        }
        for (Element child : node.children()) {
            Object childItemId = this.readItem(child, (Set)selected, context);
            this.setParent(childItemId, itemId);
        }
        return itemId;
    }

    @Override
    protected void writeItems(Element design, DesignContext context) {
        for (Object itemId : this.rootItemIds()) {
            this.writeItem(design, itemId, context);
        }
    }

    @Override
    protected Element writeItem(Element design, Object itemId, DesignContext context) {
        Collection<?> children;
        Element element = design.appendElement("node");
        element.attr("text", itemId.toString());
        Resource icon = this.getItemIcon(itemId);
        if (icon != null) {
            DesignAttributeHandler.writeAttribute((String)"icon", (Attributes)element.attributes(), (Object)icon, null, Resource.class, (DesignContext)context);
        }
        if (this.isSelected(itemId)) {
            element.attr("selected", "");
        }
        if ((children = this.getChildren(itemId)) != null) {
            for (Object childItemId : children) {
                this.writeItem(element, childItemId, context);
            }
        }
        return element;
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.htmlContentAllowed = htmlContentAllowed;
        this.markAsDirty();
    }

    public boolean isHtmlContentAllowed() {
        return this.htmlContentAllowed;
    }

    protected TreeState getState() {
        return (TreeState)super.getState();
    }

    @Deprecated
    public class TargetInSubtree
    extends ClientSideCriterion {
        private Object rootId;
        private int depthToCheck = -1;

        public TargetInSubtree(Object parentItemId) {
            this.rootId = parentItemId;
        }

        public TargetInSubtree(Object rootId, int depthToCheck) {
            this.rootId = rootId;
            this.depthToCheck = depthToCheck;
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            try {
                TreeTargetDetails eventDetails = (TreeTargetDetails)dragEvent.getTargetDetails();
                if (eventDetails.getItemIdOver() != null) {
                    Object itemId = eventDetails.getItemIdOver();
                    for (int i = 0; itemId != null && (this.depthToCheck == -1 || i <= this.depthToCheck); ++i) {
                        if (itemId.equals(this.rootId)) {
                            return true;
                        }
                        itemId = Tree.this.getParent(itemId);
                    }
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        public void paintContent(PaintTarget target) throws PaintException {
            super.paintContent(target);
            target.addAttribute("depth", this.depthToCheck);
            target.addAttribute("key", Tree.this.key(this.rootId));
        }
    }

    @Deprecated
    public static class TargetItemAllowsChildren
    extends TargetDetailIs {
        private static TargetItemAllowsChildren instance = new TargetItemAllowsChildren();

        public static TargetItemAllowsChildren get() {
            return instance;
        }

        private TargetItemAllowsChildren() {
            super("itemIdOverIsNode", Boolean.TRUE);
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            try {
                TreeTargetDetails eventDetails = (TreeTargetDetails)dragEvent.getTargetDetails();
                Object itemIdOver = eventDetails.getItemIdOver();
                if (!eventDetails.getTarget().areChildrenAllowed(itemIdOver)) {
                    return false;
                }
                return eventDetails.getDropLocation() == VerticalDropLocation.MIDDLE;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    @Deprecated
    public static abstract class TreeDropCriterion
    extends ServerSideCriterion {
        private Tree tree;
        private Set<Object> allowedItemIds;

        protected String getIdentifier() {
            return TreeDropCriterion.class.getCanonicalName();
        }

        public boolean accept(DragAndDropEvent dragEvent) {
            AbstractSelect.AbstractSelectTargetDetails dropTargetData = (AbstractSelect.AbstractSelectTargetDetails)dragEvent.getTargetDetails();
            this.tree = (Tree)dragEvent.getTargetDetails().getTarget();
            this.allowedItemIds = this.getAllowedItemIds(dragEvent, this.tree);
            return this.allowedItemIds.contains(dropTargetData.getItemIdOver());
        }

        public void paintResponse(PaintTarget target) throws PaintException {
            Object[] array = this.allowedItemIds.toArray();
            for (int i = 0; i < array.length; ++i) {
                String key = this.tree.key(array[i]);
                array[i] = key;
            }
            target.addAttribute("allowedIds", array);
        }

        protected abstract Set<Object> getAllowedItemIds(DragAndDropEvent var1, Tree var2);
    }

    @Deprecated
    protected class TreeTransferable
    extends DataBoundTransferable {
        public TreeTransferable(Component sourceComponent, Map<String, Object> rawVariables) {
            super(sourceComponent, rawVariables);
        }

        @Override
        public Object getItemId() {
            return this.getData("itemId");
        }

        @Override
        public Object getPropertyId() {
            return Tree.this.getItemCaptionPropertyId();
        }
    }

    @Deprecated
    public class TreeTargetDetails
    extends AbstractSelect.AbstractSelectTargetDetails {
        TreeTargetDetails(Map<String, Object> rawVariables) {
            super(rawVariables);
        }

        public Tree getTarget() {
            return (Tree)super.getTarget();
        }

        public Object getItemIdInto() {
            Object itemIdOver = this.getItemIdOver();
            if (Tree.this.areChildrenAllowed(itemIdOver) && this.getDropLocation() == VerticalDropLocation.MIDDLE) {
                return itemIdOver;
            }
            return Tree.this.getParent(itemIdOver);
        }

        public Object getItemIdAfter() {
            Object itemIdInto2;
            Object itemIdOver = this.getItemIdOver();
            if (itemIdOver.equals(itemIdInto2 = this.getItemIdInto())) {
                return null;
            }
            VerticalDropLocation dropLocation = this.getDropLocation();
            if (VerticalDropLocation.TOP == dropLocation) {
                Object itemIdInto = this.getItemIdInto();
                Collection<?> children = itemIdInto != null ? Tree.this.getChildren(itemIdInto) : Tree.this.rootItemIds();
                Object ref = null;
                for (Object object : children) {
                    if (object.equals(itemIdOver)) {
                        return ref;
                    }
                    ref = object;
                }
            }
            return itemIdOver;
        }
    }

    @Deprecated
    public static interface ItemStyleGenerator
    extends Serializable {
        public String getStyle(Tree var1, Object var2);
    }

    @Deprecated
    public static interface CollapseListener
    extends SerializableEventListener {
        public static final Method COLLAPSE_METHOD = ReflectTools.findMethod(CollapseListener.class, (String)"nodeCollapse", (Class[])new Class[]{CollapseEvent.class});

        public void nodeCollapse(CollapseEvent var1);
    }

    @Deprecated
    public static class CollapseEvent
    extends Component.Event {
        private final Object collapsedItemId;

        public CollapseEvent(Component source, Object collapsedItemId) {
            super(source);
            this.collapsedItemId = collapsedItemId;
        }

        public Object getItemId() {
            return this.collapsedItemId;
        }
    }

    @Deprecated
    public static interface ExpandListener
    extends SerializableEventListener {
        public static final Method EXPAND_METHOD = ReflectTools.findMethod(ExpandListener.class, (String)"nodeExpand", (Class[])new Class[]{ExpandEvent.class});

        public void nodeExpand(ExpandEvent var1);
    }

    @Deprecated
    public static class ExpandEvent
    extends Component.Event {
        private final Object expandedItemId;

        public ExpandEvent(Component source, Object expandedItemId) {
            super(source);
            this.expandedItemId = expandedItemId;
        }

        public Object getItemId() {
            return this.expandedItemId;
        }
    }

    @Deprecated
    public static enum TreeDragMode {
        NONE,
        NODE;

    }

    @Deprecated
    public static class TreeContextClickEvent
    extends ContextClickEvent {
        private final Object itemId;

        public TreeContextClickEvent(Tree source, Object itemId, MouseEventDetails mouseEventDetails) {
            super((Component)source, mouseEventDetails);
            this.itemId = itemId;
        }

        public Tree getComponent() {
            return (Tree)super.getComponent();
        }

        public Object getItemId() {
            return this.itemId;
        }
    }
}

