/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Preconditions;
import org.apache.commons.jexl2.JexlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleArrayFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(SampleArrayFunctions.class);
    private JexlContext m_context = null;

    public SampleArrayFunctions(JexlContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"JexlContext context");
        this.m_context = context;
    }

    public Double arrayZero(String sampleName, Integer n) {
        double[] sample = null;
        Integer i = null;
        try {
            Preconditions.checkNotNull((Object)sampleName, (Object)"sampleName");
            Preconditions.checkNotNull((Object)n, (Object)"n");
            sample = (double[])this.m_context.get("__" + sampleName);
            if (sample == null) {
                LOG.warn("fn:arrayZero attribute not in jexl context: __" + sampleName);
                return Double.NaN;
            }
            i = (Integer)this.m_context.get("__i");
            Preconditions.checkNotNull((Object)i, (Object)"sample index __i");
            if (i - n < 0) {
                return 0.0;
            }
            return sample[i - n];
        }
        catch (Exception ex) {
            LOG.error("fn:arrayZero problem retrieving prior attribute sample  " + sampleName + " (i - n) (" + i + "-" + n + ")", (Throwable)ex);
            return Double.NaN;
        }
    }

    public Double arrayFirst(String sampleName, int n) {
        double[] sample = null;
        Integer i = null;
        try {
            Preconditions.checkNotNull((Object)sampleName, (Object)"sampleName");
            Preconditions.checkNotNull((Object)n, (Object)"n");
            sample = (double[])this.m_context.get("__" + sampleName);
            if (sample == null) {
                LOG.warn("fn:arrayFirst attribute not in jexl context: __" + sampleName);
                return Double.NaN;
            }
            i = (Integer)this.m_context.get("__i");
            Preconditions.checkNotNull((Object)i, (Object)"sample index __i");
            if (i - n < 0) {
                return sample[0];
            }
            return sample[i - n];
        }
        catch (Exception ex) {
            LOG.error("fn:arrayFirst problem retrieving prior attribute sample " + sampleName + " (i - n) (" + i + "-" + n + ")", (Throwable)ex);
            return Double.NaN;
        }
    }

    public Double arrayNaN(String sampleName, int n) {
        double[] sample = null;
        Integer i = null;
        try {
            Preconditions.checkNotNull((Object)sampleName, (Object)"sampleName");
            Preconditions.checkNotNull((Object)n, (Object)"n");
            sample = (double[])this.m_context.get("__" + sampleName);
            if (sample == null) {
                LOG.warn("fn:arrayNaN attribute not in jexl context: __" + sampleName);
                return Double.NaN;
            }
            i = (Integer)this.m_context.get("__i");
            Preconditions.checkNotNull((Object)i, (Object)"sample index __i");
            if (i - n < 0) {
                return Double.NaN;
            }
            return sample[i - n];
        }
        catch (Exception ex) {
            LOG.error("fn:arrayNaN problem retrieving prior attribute sample " + sampleName + " (i - n) (" + i + "-" + n + ")", (Throwable)ex);
            return Double.NaN;
        }
    }

    public Double arrayStart(String sampleName, int n, double start) {
        double[] sample = null;
        Integer i = null;
        try {
            Preconditions.checkNotNull((Object)sampleName, (Object)"sampleName");
            Preconditions.checkNotNull((Object)n, (Object)"n");
            sample = (double[])this.m_context.get("__" + sampleName);
            if (sample == null) {
                LOG.warn("fn:arrayStart attribute not in jexl context: __" + sampleName);
                return Double.NaN;
            }
            i = (Integer)this.m_context.get("__i");
            Preconditions.checkNotNull((Object)i, (Object)"sample index __i");
            if (i - n < 0) {
                return start;
            }
            return sample[i - n];
        }
        catch (Exception ex) {
            LOG.error("fn:arrayStart problem retrieving prior attribute sample  " + sampleName + " (i - n) (" + i + "-" + n + ")", (Throwable)ex);
            return Double.NaN;
        }
    }
}

