/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.websso;

import java.util.Random;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.common.binding.decoding.BasicURLComparator;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.Assert;

public abstract class AbstractProfileBase
implements InitializingBean {
    private int responseSkew = 60;
    private int maxAssertionTime = 3000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected MetadataManager metadata;
    protected SAMLProcessor processor;
    protected SAMLArtifactMap artifactMap;
    protected XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    protected URIComparator uriComparator = new BasicURLComparator();

    public AbstractProfileBase() {
    }

    public AbstractProfileBase(SAMLProcessor processor, MetadataManager manager) {
        this();
        this.processor = processor;
        this.metadata = manager;
    }

    public abstract String getProfileIdentifier();

    public void setResponseSkew(int responseSkew) {
        this.responseSkew = responseSkew;
    }

    public int getResponseSkew() {
        return this.responseSkew;
    }

    public int getMaxAssertionTime() {
        return this.maxAssertionTime;
    }

    public void setMaxAssertionTime(int maxAssertionTime) {
        this.maxAssertionTime = maxAssertionTime;
    }

    protected void sendMessage(SAMLMessageContext context, boolean sign) throws MetadataProviderException, SAMLException, MessageEncodingException {
        this.processor.sendMessage(context, sign);
    }

    protected void sendMessage(SAMLMessageContext context, boolean sign, String binding) throws MetadataProviderException, SAMLException, MessageEncodingException {
        this.processor.sendMessage(context, sign, binding);
    }

    protected Status getStatus(String code, String statusMessage) {
        SAMLObjectBuilder codeBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)codeBuilder.buildObject();
        statusCode.setValue(code);
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = (Status)statusBuilder.buildObject();
        status.setStatusCode(statusCode);
        if (statusMessage != null) {
            SAMLObjectBuilder messageBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
            StatusMessage statusMessageObject = (StatusMessage)messageBuilder.buildObject();
            statusMessageObject.setMessage(statusMessage);
            status.setStatusMessage(statusMessageObject);
        }
        return status;
    }

    protected void buildCommonAttributes(String localEntityId, RequestAbstractType request, Endpoint service) {
        request.setID(this.generateID());
        request.setIssuer(this.getIssuer(localEntityId));
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(new DateTime());
        if (service != null) {
            request.setDestination(service.getLocation());
        }
    }

    protected Issuer getIssuer(String localEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(localEntityId);
        return issuer;
    }

    protected String generateID() {
        Random r = new Random();
        return 'a' + Long.toString(Math.abs(r.nextLong()), 20) + Long.toString(Math.abs(r.nextLong()), 20);
    }

    protected void verifyIssuer(Issuer issuer, SAMLMessageContext context) throws SAMLException {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLException("Issuer invalidated by issuer type " + issuer.getFormat());
        }
        if (!context.getPeerEntityMetadata().getEntityID().equals(issuer.getValue())) {
            throw new SAMLException("Issuer invalidated by issuer value " + issuer.getValue());
        }
    }

    protected void verifyEndpoint(Endpoint endpoint, String destination) throws SAMLException {
        if (destination != null && !this.uriComparator.compare(destination, endpoint.getLocation()) && !this.uriComparator.compare(destination, endpoint.getResponseLocation())) {
            throw new SAMLException("Intended destination " + destination + " doesn't match any of the endpoint URLs on endpoint " + endpoint.getLocation() + " for profile " + this.getProfileIdentifier());
        }
    }

    protected void verifySignature(Signature signature, String IDPEntityID, SignatureTrustEngine trustEngine) throws SecurityException, ValidationException {
        if (trustEngine == null) {
            throw new java.lang.SecurityException("Trust engine is not set, signature can't be verified");
        }
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        validator.validate(signature);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(IDPEntityID));
        criteriaSet.add((Object)new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        this.log.debug("Verifying signature", (Object)signature);
        if (!trustEngine.validate((Object)signature, criteriaSet)) {
            throw new ValidationException("Signature is not trusted or invalid");
        }
    }

    protected String getEndpointBinding(Endpoint endpoint) {
        return SAMLUtil.getBindingForEndpoint(endpoint);
    }

    protected boolean isEndpointMatching(Endpoint endpoint, String binding) {
        return binding.equals(this.getEndpointBinding(endpoint));
    }

    @Autowired
    public void setMetadata(MetadataManager metadata) {
        this.metadata = metadata;
    }

    @Autowired(required=false)
    public void setProcessor(SAMLProcessor processor) {
        this.processor = processor;
    }

    public void setArtifactMap(SAMLArtifactMap artifactMap) {
        this.artifactMap = artifactMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.metadata, (String)"Metadata must be set");
        Assert.notNull((Object)this.processor, (String)"SAML Processor must be set");
    }
}

