/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.javamail.End2endMailConfig;
import org.opennms.netmgt.config.javamail.ReadmailConfig;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="javamail-configuration", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class JavamailConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="default-send-config-name", required=true)
    private String m_defaultSendConfigName;
    @XmlAttribute(name="default-read-config-name", required=true)
    private String m_defaultReadConfigName;
    @XmlElement(name="sendmail-config", required=true)
    private List<SendmailConfig> m_sendmailConfigs = new ArrayList<SendmailConfig>();
    @XmlElement(name="readmail-config", required=true)
    private List<ReadmailConfig> m_readmailConfigs = new ArrayList<ReadmailConfig>();
    @XmlElement(name="end2end-mail-config", required=true)
    private List<End2endMailConfig> m_end2endMailConfigs = new ArrayList<End2endMailConfig>();

    public String getDefaultSendConfigName() {
        return this.m_defaultSendConfigName;
    }

    public void setDefaultSendConfigName(String defaultSendConfigName) {
        this.m_defaultSendConfigName = ConfigUtils.assertNotEmpty(defaultSendConfigName, "default-send-config-name");
    }

    public String getDefaultReadConfigName() {
        return this.m_defaultReadConfigName;
    }

    public void setDefaultReadConfigName(String defaultReadConfigName) {
        this.m_defaultReadConfigName = ConfigUtils.assertNotEmpty(defaultReadConfigName, "default-read-config-name");
    }

    public List<SendmailConfig> getSendmailConfigs() {
        return this.m_sendmailConfigs;
    }

    public void setSendmailConfigs(List<SendmailConfig> configs) {
        if (configs == this.m_sendmailConfigs) {
            return;
        }
        this.m_sendmailConfigs.clear();
        if (configs != null) {
            this.m_sendmailConfigs.addAll(configs);
        }
    }

    public List<ReadmailConfig> getReadmailConfigs() {
        return this.m_readmailConfigs;
    }

    public void setReadmailConfigs(List<ReadmailConfig> configs) {
        if (configs == this.m_readmailConfigs) {
            return;
        }
        this.m_readmailConfigs.clear();
        if (configs != null) {
            this.m_readmailConfigs.addAll(configs);
        }
    }

    public List<End2endMailConfig> getEnd2endMailConfigs() {
        return this.m_end2endMailConfigs;
    }

    public void setEnd2endMailConfigs(List<End2endMailConfig> configs) {
        if (configs == this.m_end2endMailConfigs) {
            return;
        }
        this.m_end2endMailConfigs.clear();
        if (configs != null) {
            this.m_end2endMailConfigs.addAll(configs);
        }
    }

    public int hashCode() {
        return Objects.hash(this.m_defaultSendConfigName, this.m_defaultReadConfigName, this.m_sendmailConfigs, this.m_readmailConfigs, this.m_end2endMailConfigs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavamailConfiguration) {
            JavamailConfiguration that = (JavamailConfiguration)obj;
            return Objects.equals(this.m_defaultSendConfigName, that.m_defaultSendConfigName) && Objects.equals(this.m_defaultReadConfigName, that.m_defaultReadConfigName) && Objects.equals(this.m_sendmailConfigs, that.m_sendmailConfigs) && Objects.equals(this.m_readmailConfigs, that.m_readmailConfigs) && Objects.equals(this.m_end2endMailConfigs, that.m_end2endMailConfigs);
        }
        return false;
    }
}

