/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.shell;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.renderer.GraphRenderer;
import org.opennms.netmgt.graph.api.search.GraphSearchService;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.shell.completer.NamespaceCompleter;
import org.opennms.netmgt.graph.shell.completer.SuggestionCompleter;

@Service
@Command(scope="opennms", name="graph-search", description="Searches vertices in a given namespace (graph)")
public class GraphSearchCommand
implements Action {
    @Reference
    private GraphService graphService;
    @Reference
    private GraphSearchService graphSearchService;
    @Reference
    private GraphRenderer graphRenderer;
    @Completion(value=NamespaceCompleter.class)
    @Option(name="--namespace", description="The namespace of the graph", required=true)
    private String namespace;
    @Completion(value=SuggestionCompleter.class)
    @Option(name="--search", description="The search input", required=true, multiValued=false)
    private String input;

    public Object execute() {
        GenericGraph genericGraph = this.graphService.getGraph(this.namespace);
        if (genericGraph == null) {
            System.out.println("No graph with namespace " + this.namespace + " found");
        } else {
            String searchString = this.input.replace("_", " ");
            List suggestions = this.graphSearchService.getSuggestions(this.namespace, searchString);
            if (suggestions.size() > 0) {
                SearchSuggestion suggestion = (SearchSuggestion)suggestions.get(0);
                SearchCriteria searchCriteria = new SearchCriteria(suggestion.getProvider(), this.namespace, suggestion.getId());
                List vertices = this.graphSearchService.search(searchCriteria);
                String rendered = vertices.stream().map(vertex -> this.graphRenderer.render(2, (Vertex)vertex)).collect(Collectors.joining(",\n"));
                System.out.println("Search results: " + vertices.size() + " vertices found.");
                System.out.println(rendered);
            } else {
                System.out.println(String.format("No vertices found for namespace='%s' and input='%s'", this.namespace, this.input));
            }
        }
        return null;
    }
}

