/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.core.time.CentralizedDateTimeFormat;
import org.opennms.web.rest.support.menu.HttpMenuRequestContext;
import org.opennms.web.rest.support.menu.MainMenu;
import org.opennms.web.rest.support.menu.MenuProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="menu")
@Tag(name="Menu", description="Menu API")
public class MenuRestService {
    private static final Logger LOG = LoggerFactory.getLogger(MenuRestService.class);
    private static final String WEB_INF_PREFIX = "/WEB-INF";
    private CentralizedDateTimeFormat dateTimeFormat = new CentralizedDateTimeFormat();
    @Autowired
    private MenuProvider menuProvider;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(summary="Get main menu", description="Get main menu", operationId="MenuRestServiceGetMainMenu")
    public Response getMainMenu(@Context HttpServletRequest request) {
        try {
            MainMenu mainMenu = this.buildMenu(request);
            return Response.ok((Object)mainMenu).build();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Error building menu.").build());
        }
    }

    private MainMenu buildMenu(HttpServletRequest request) throws Exception {
        int index;
        MainMenu mainMenu = null;
        String webInfRealPath = request.getServletContext().getRealPath(WEB_INF_PREFIX);
        if (this.menuProvider.getDispatcherServletPath().contains("${opennms.home}") && (index = this.menuProvider.getDispatcherServletPath().indexOf(WEB_INF_PREFIX)) >= 0) {
            String path = webInfRealPath + this.menuProvider.getDispatcherServletPath().substring(index + WEB_INF_PREFIX.length());
            this.menuProvider.setDispatcherServletPath(path);
        }
        if (this.menuProvider != null) {
            try {
                HttpMenuRequestContext context = new HttpMenuRequestContext(request);
                mainMenu = this.menuProvider.getMainMenu(context);
            }
            catch (Exception e) {
                LOG.error("Error creating menu entries: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return mainMenu;
    }
}

