/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.InetAddress;
import java.text.ParseException;
import javax.annotation.PreDestroy;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryFactory;
import org.opennms.netmgt.provision.persist.requisition.DeployedRequisitionStats;
import org.opennms.netmgt.provision.persist.requisition.DeployedStats;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAssetCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategoryCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredServiceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNodeCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.api.RequisitionAccessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="requisitionRestService")
@Path(value="requisitions")
@Tag(name="Requisitions", description="Requisitions API")
public class RequisitionRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionRestService.class);
    @Autowired
    private RequisitionAccessService m_accessService;
    @Autowired
    private ForeignSourceRepositoryFactory m_foreignSourceRepositoryFactory;

    @PreDestroy
    protected void tearDown() {
        if (this.m_accessService != null) {
            this.m_accessService.flushAll();
        }
    }

    @GET
    @Path(value="deployed/count")
    @Produces(value={"text/plain"})
    @Operation(summary="Get the number of deployed requisitions", description="Get the number of deployed requisitions (returns plaintext rather than XML or JSON).", responses={@ApiResponse(responseCode="200", description="Get the number of deployed requisitions (returns plaintext rather than XML or JSON).")})
    public String getDeployedCount() {
        return Integer.toString(this.m_accessService.getDeployedCount());
    }

    @GET
    @Path(value="deployed/stats")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public DeployedStats getDeployedStats() {
        return this.m_accessService.getDeployedStats();
    }

    @GET
    @Path(value="deployed/stats/{foreignSource}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public DeployedRequisitionStats getDeployedStats(@PathParam(value="foreignSource") String foreignSource) {
        return this.m_accessService.getDeployedStats(foreignSource);
    }

    @GET
    @Path(value="repositoryStrategy")
    @Produces(value={"text/plain"})
    public String getForeignSourceRepositoryStrategy() {
        return this.m_foreignSourceRepositoryFactory.getRepositoryStrategy().toString();
    }

    @GET
    @Path(value="deployed")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get a list of all deployed (active) requisitions.", responses={@ApiResponse(responseCode="200", description="Get a list of all deployed (active) requisitions.")})
    public RequisitionCollection getDeployedRequisitions() throws ParseException {
        return this.m_accessService.getDeployedRequisitions();
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get all active requisitions.", responses={@ApiResponse(responseCode="200", description="Get all active requisitions.")})
    public RequisitionCollection getRequisitions() throws ParseException {
        return this.m_accessService.getRequisitions();
    }

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    @Operation(summary="Get the number of undeployed requisitions", responses={@ApiResponse(responseCode="200", description="Get the number of undeployed requisitions (returns plaintext rather than XML or JSON).")})
    public String getPendingCount() {
        return Integer.toString(this.m_accessService.getPendingCount());
    }

    @GET
    @Path(value="{foreignSource}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the active requisition for the given foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the active requisition for the given foreign source name."), @ApiResponse(responseCode="404")})
    public Requisition getRequisition(@PathParam(value="foreignSource") String foreignSource) {
        Requisition requisition = this.m_accessService.getRequisition(foreignSource);
        if (requisition == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Foreign source '{}' not found.", foreignSource);
        }
        return requisition;
    }

    @GET
    @Path(value="{foreignSource}/nodes")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the list of nodes being requisitioned for the given foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the list of nodes being requisitioned for the given foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionNodeCollection getNodes(@PathParam(value="foreignSource") String foreignSource) throws ParseException {
        RequisitionNodeCollection results = this.m_accessService.getNodes(foreignSource);
        if (results == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Foreign source '{}' not found.", foreignSource);
        }
        return results;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the node with the given foreign ID for the given foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the node with the given foreign ID for the given foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionNode getNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionNode node = this.m_accessService.getNode(foreignSource, foreignId);
        if (node == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Node with Foreign ID '{}' and Foreign source '{}' not found.", foreignId, foreignSource);
        }
        return node;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the interfaces for the node with the given foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the interfaces for the node with the given foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionInterfaceCollection getInterfacesForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionInterfaceCollection ifaces = this.m_accessService.getInterfacesForNode(foreignSource, foreignId);
        if (ifaces == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Node with Foreign ID '{}' and Foreign source '{}' not found.", foreignId, foreignSource);
        }
        return ifaces;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the interface with the given IP for the node with the specified foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the interface with the given IP for the node with the specified foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionInterface getInterfaceForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        RequisitionInterface iface = this.m_accessService.getInterfaceForNode(foreignSource, foreignId, ipAddress);
        if (iface == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "IP Interface {} on node with Foreign ID '{}' and Foreign source '{}' not found.", ipAddress, foreignId, foreignSource);
        }
        return iface;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the services for the interface with the specified IP address, foreign ID, and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the services for the interface with the specified IP address, foreign ID, and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionMonitoredServiceCollection getServicesForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        RequisitionMonitoredServiceCollection services = this.m_accessService.getServicesForInterface(foreignSource, foreignId, ipAddress);
        if (services == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "IP Interface {} on node with Foreign ID '{}' and Foreign source '{}' not found.", ipAddress, foreignId, foreignSource);
        }
        return services;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the given service with the specified IP address, foreign ID, and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the given service with the specified IP address, foreign ID, and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionMonitoredService getServiceForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) throws ParseException {
        RequisitionMonitoredService monitoredService = this.m_accessService.getServiceForInterface(foreignSource, foreignId, ipAddress, service);
        if (monitoredService == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Monitored Service {} on IP Interface {} on node with Foreign ID '{}' and Foreign source '{}' not found.", service, ipAddress, foreignId, foreignSource);
        }
        return monitoredService;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the categories for the node with the given foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the categories for the node with the given foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionCategoryCollection getCategories(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionCategoryCollection categories = this.m_accessService.getCategories(foreignSource, foreignId);
        if (categories == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Node with Foreign ID '{}' and Foreign source '{}' not found.", foreignId, foreignSource);
        }
        return categories;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the category with the given name for the node with the specified foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the category with the given name for the node with the specified foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionCategory getCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="category") String category) throws ParseException {
        RequisitionCategory reqCategory = this.m_accessService.getCategory(foreignSource, foreignId, category);
        if (reqCategory == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Category {} on node with Foreign ID '{}' and Foreign source '{}' not found.", category, foreignId, foreignSource);
        }
        return reqCategory;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the assets for the node with the given foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the assets for the node with the given foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionAssetCollection getAssetParameters(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionAssetCollection assets = this.m_accessService.getAssetParameters(foreignSource, foreignId);
        if (assets == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Node with Foreign ID '{}' and Foreign source '{}' not found.", foreignId, foreignSource);
        }
        return assets;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Operation(summary="Get the value of the asset for the given assetName for the node with the given foreign ID and foreign source name.", responses={@ApiResponse(responseCode="200", description="Get the value of the asset for the given assetName for the node with the given foreign ID and foreign source name."), @ApiResponse(responseCode="404")})
    public RequisitionAsset getAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="parameter") String parameter) throws ParseException {
        RequisitionAsset asset = this.m_accessService.getAssetParameter(foreignSource, foreignId, parameter);
        if (asset == null) {
            throw RequisitionRestService.getException(Response.Status.NOT_FOUND, "Asset {} on node with Foreign ID '{}' and Foreign source '{}' not found.", parameter, foreignId, foreignSource);
        }
        return asset;
    }

    @POST
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces a requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces a requisition.")})
    public Response addOrReplaceRequisition(@Context UriInfo uriInfo, @RequestBody(description="Requisition") Requisition requisition) {
        try {
            requisition.validate();
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming requisition with foreign source '{}'", (Object)requisition.getForeignSource(), (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceRequisition: Adding requisition {} (containing {} nodes)", (Object)requisition.getForeignSource(), (Object)requisition.getNodeCount());
        this.m_accessService.addOrReplaceRequisition(requisition);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, requisition.getForeignSource())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces a node in the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces a node in the specified requisition. This operation can be very helpful when working with large requisitions.")})
    public Response addOrReplaceNode(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @RequestBody(description="Node") RequisitionNode node) {
        try {
            node.validate();
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming node '{}'", (Object)node, (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceNode: Adding node {} to requisition {}", (Object)node.getForeignId(), (Object)foreignSource);
        this.m_accessService.addOrReplaceNode(foreignSource, node);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, node.getForeignId())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces an interface for the given node in the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces an interface for the given node in the specified requisition.")})
    public Response addOrReplaceInterface(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @RequestBody(description="Interface") RequisitionInterface iface) {
        try {
            RequisitionNode node = this.m_accessService.getNode(foreignSource, foreignId);
            iface.validate(node);
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming interface '{}'", (Object)iface, (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceInterface: Adding interface {} to node {}/{}", new Object[]{iface, foreignSource, foreignId});
        this.m_accessService.addOrReplaceInterface(foreignSource, foreignId, iface);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, InetAddressUtils.str((InetAddress)iface.getIpAddr()))).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces a service on the given interface in the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces a service on the given interface in the specified requisition.")})
    public Response addOrReplaceService(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="ipAddress") String ipAddress, @RequestBody(description="Monitored Service") RequisitionMonitoredService service) {
        try {
            service.validate();
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming service '{}'", (Object)service, (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceService: Adding service {} to node {}/{}, interface {}", new Object[]{service.getServiceName(), foreignSource, foreignId, ipAddress});
        this.m_accessService.addOrReplaceService(foreignSource, foreignId, ipAddress, service);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, service.getServiceName())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces a category for the given node in the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces a category for the given node in the specified requisition.")})
    public Response addOrReplaceNodeCategory(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @RequestBody(description="Category") RequisitionCategory category) {
        try {
            category.validate();
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming category '{}'", (Object)category, (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceNodeCategory: Adding category {} to node {}/{}", new Object[]{category.getName(), foreignSource, foreignId});
        this.m_accessService.addOrReplaceNodeCategory(foreignSource, foreignId, category);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, category.getName())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    @Operation(summary="Adds or replaces an asset for the given node in the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Adds or replaces an asset for the given node in the specified requisition.")})
    public Response addOrReplaceNodeAssetParameter(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @RequestBody(description="Asset") RequisitionAsset asset) {
        try {
            asset.validate();
        }
        catch (ValidationException e) {
            LOG.debug("error validating incoming asset '{}'", (Object)asset, (Object)e);
            throw RequisitionRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        LOG.debug("addOrReplaceNodeCategory: Adding asset {} to node {}/{}", new Object[]{asset.getName(), foreignSource, foreignId});
        this.m_accessService.addOrReplaceNodeAssetParameter(foreignSource, foreignId, asset);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, asset.getName())).build();
    }

    @PUT
    @Path(value="{foreignSource}/import")
    @Transactional
    @Operation(summary="Performs an import or synchronize on the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Performs an import or synchronize on the specified requisition. This turns the \"active\" requisition into a \"deployed\" requisition.")})
    public Response importRequisition(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(description="If it is newly added or removed. Existing nodes are not scanned until the next rescan interval. This request type is useful when applying changes to a subset of nodes in a requisition.") @QueryParam(value="rescanExisting") String rescanExisting) {
        LOG.debug("importRequisition: Importing requisition for foreign source {}", (Object)foreignSource);
        this.m_accessService.importRequisition(foreignSource, rescanExisting);
        return Response.accepted().header("Location", (Object)uriInfo.getBaseUriBuilder().path(this.getClass()).path(this.getClass(), "getRequisition").build(new Object[]{foreignSource})).build();
    }

    @PUT
    @Path(value="{foreignSource}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    @Operation(summary="Update the specified requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Update the specified requisition.")})
    public Response updateRequisition(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @RequestBody(description="Requisition key/value pairs") MultivaluedMapImpl params) {
        this.m_accessService.updateRequisition(foreignSource, (MultivaluedMap)params);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, new Object[0])).build();
    }

    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    @Operation(summary="Update the specified node for the given requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Update the specified node for the given requisition.")})
    public Response updateNode(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @RequestBody(description="Node key/value pairs") MultivaluedMapImpl params) {
        this.m_accessService.updateNode(foreignSource, foreignId, (MultivaluedMap)params);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, new Object[0])).build();
    }

    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    @Operation(summary="Update the specified IP address for the given node and requisition.", responses={@ApiResponse(headers={@Header(name="Location")}, responseCode="202", description="Update the specified IP address for the given node and requisition.")})
    public Response updateInterface(@Context UriInfo uriInfo, @Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="ipAddress") String ipAddress, @RequestBody(description="Interface key/value pairs") MultivaluedMapImpl params) {
        this.m_accessService.updateInterface(foreignSource, foreignId, ipAddress, (MultivaluedMap)params);
        return Response.accepted().header("Location", (Object)RequisitionRestService.getRedirectUri(uriInfo, new Object[0])).build();
    }

    @DELETE
    @Path(value="{foreignSource}")
    @Transactional
    @Operation(summary="Delete the pending requisition for the named foreign source.", responses={@ApiResponse(responseCode="202", description="Delete the pending requisition for the named foreign source.")})
    public Response deletePendingRequisition(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource) {
        this.m_accessService.deletePendingRequisition(foreignSource);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="deployed/{foreignSource}")
    @Transactional
    @Operation(summary="Delete the active requisition for the named foreign source.", responses={@ApiResponse(responseCode="202", description="Delete the active requisition for the named foreign source.")})
    public Response deleteDeployedRequisition(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource) {
        this.m_accessService.deleteDeployedRequisition(foreignSource);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Transactional
    @Operation(summary="Delete the node with the given foreign ID from the given requisition.", responses={@ApiResponse(responseCode="202", description="Delete the node with the given foreign ID from the given requisition.")})
    public Response deleteNode(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId) {
        this.m_accessService.deleteNode(foreignSource, foreignId);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Transactional
    @Operation(summary="Delete the IP address from the requisitioned node with the given foreign ID.", description="Delete the IP address from the requisitioned node with the given foreign ID.", responses={@ApiResponse(responseCode="202")})
    public Response deleteInterface(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="ipAddress") String ipAddress) {
        this.m_accessService.deleteInterface(foreignSource, foreignId, ipAddress);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Transactional
    @Operation(summary="Delete the service from the requisitioned interface with the given IP address and foreign ID.", responses={@ApiResponse(responseCode="202", description="Delete the service from the requisitioned interface with the given IP address and foreign ID.")})
    public Response deleteInterfaceService(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="ipAddress") String ipAddress, @Parameter(required=true) @PathParam(value="service") String service) {
        this.m_accessService.deleteInterfaceService(foreignSource, foreignId, ipAddress, service);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Transactional
    @Operation(summary="Delete the category from the node with the given foreign ID.", responses={@ApiResponse(responseCode="202", description="Delete the category from the node with the given foreign ID.")})
    public Response deleteCategory(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="category") String category) {
        this.m_accessService.deleteCategory(foreignSource, foreignId, category);
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Transactional
    @Operation(summary="Delete the field from the node\u2019s assets with the given foreign ID and asset name.", responses={@ApiResponse(responseCode="202", description="Delete the field from the node\u2019s assets with the given foreign ID and asset name.")})
    public Response deleteAssetParameter(@Parameter(required=true) @PathParam(value="foreignSource") String foreignSource, @Parameter(required=true) @PathParam(value="foreignId") String foreignId, @Parameter(required=true) @PathParam(value="parameter") String parameter) {
        this.m_accessService.deleteAssetParameter(foreignSource, foreignId, parameter);
        return Response.accepted().build();
    }
}

