/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.api.KscReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="kscRestService")
@Path(value="ksc")
@Tag(name="Ksc", description="Ksc API")
public class KscRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(KscRestService.class);
    @Autowired
    private KscReportService m_kscReportService;
    @Autowired
    private KSC_PerformanceReportFactory m_kscReportFactory;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public KscReportCollection getReports() throws ParseException {
        KscReportCollection reports = new KscReportCollection(this.m_kscReportService.getReportMap(), true);
        reports.setTotalCount(reports.size());
        return reports;
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{reportId}")
    @Transactional
    public KscReport getReport(@PathParam(value="reportId") Integer reportId) {
        Map reportList = this.m_kscReportService.getReportMap();
        Report report = (Report)reportList.get(reportId);
        if (report == null) {
            throw KscRestService.getException(Response.Status.NOT_FOUND, "No such report id {}.", Integer.toString(reportId));
        }
        return new KscReport(report);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_kscReportService.getReportList().size());
    }

    @PUT
    @Path(value="reloadConfig")
    @Transactional
    public Response reloadConfiguration() {
        this.writeLock();
        try {
            KSC_PerformanceReportFactory.getInstance().reload();
            Response response = Response.noContent().build();
            return response;
        }
        catch (Exception e) {
            throw KscRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, e);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{kscReportId}")
    @Transactional
    public Response addGraph(@PathParam(value="kscReportId") Integer kscReportId, @QueryParam(value="title") String title, @QueryParam(value="reportName") String reportName, @QueryParam(value="resourceId") String resourceId, @QueryParam(value="timespan") String timespan) {
        this.writeLock();
        try {
            if (kscReportId == null || reportName == null || reportName == "" || resourceId == null || resourceId == "") {
                throw KscRestService.getException(Response.Status.BAD_REQUEST, "Invalid request: reportName and resourceId cannot be empty!", new String[0]);
            }
            Report report = this.m_kscReportFactory.getReportByIndex(kscReportId.intValue());
            if (report == null) {
                throw KscRestService.getException(Response.Status.NOT_FOUND, "Invalid request: No KSC report found with ID: {}.", Integer.toString(kscReportId));
            }
            Graph graph = new Graph();
            if (title != null) {
                graph.setTitle(title);
            }
            boolean found = false;
            for (String valid : KSC_PerformanceReportFactory.TIMESPAN_OPTIONS) {
                if (!valid.equals(timespan)) continue;
                found = true;
                break;
            }
            if (!found) {
                LOG.debug("invalid timespan ('{}'), setting to '7_day' instead.", (Object)timespan);
                timespan = "7_day";
            }
            graph.setGraphtype(reportName);
            graph.setResourceId(resourceId);
            graph.setTimespan(timespan);
            report.addGraph(graph);
            this.m_kscReportFactory.setReport(kscReportId.intValue(), report);
            try {
                this.m_kscReportFactory.saveCurrent();
            }
            catch (Exception e) {
                throw KscRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Cannot save report with Id {} : {} ", kscReportId.toString(), e.getMessage());
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addKscReport(@Context UriInfo uriInfo, KscReport kscReport) {
        this.writeLock();
        try {
            LOG.debug("addKscReport: Adding KSC Report {}", (Object)kscReport);
            Report report = this.m_kscReportFactory.getReportByIndex(kscReport.getId().intValue());
            if (report != null) {
                throw KscRestService.getException(Response.Status.CONFLICT, "Invalid request: Existing KSC report found with ID: {}.", Integer.toString(kscReport.getId()));
            }
            report = new Report();
            report.setId(kscReport.getId());
            report.setTitle(kscReport.getLabel());
            if (kscReport.getShowGraphtypeButton() != null) {
                report.setShowGraphtypeButton(kscReport.getShowGraphtypeButton());
            }
            if (kscReport.getShowTimespanButton() != null) {
                report.setShowTimespanButton(kscReport.getShowTimespanButton());
            }
            if (kscReport.getGraphsPerLine() != null) {
                report.setGraphsPerLine(kscReport.getGraphsPerLine());
            }
            if (kscReport.hasGraphs()) {
                for (KscGraph kscGraph : kscReport.getGraphs()) {
                    Graph graph = kscGraph.buildGraph();
                    report.addGraph(graph);
                }
            }
            this.m_kscReportFactory.addReport(report);
            try {
                this.m_kscReportFactory.saveCurrent();
            }
            catch (Exception e) {
                throw KscRestService.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
            }
            Response response = Response.created((URI)KscRestService.getRedirectUri(uriInfo, kscReport.getId())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @XmlRootElement(name="kscGraph")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class KscGraph {
        @XmlAttribute(name="title", required=true)
        private String m_title;
        @XmlAttribute(name="timespan", required=true)
        private String m_timespan;
        @XmlAttribute(name="graphtype", required=true)
        private String m_graphtype;
        @XmlAttribute(name="resourceId", required=false)
        private String m_resourceId;
        @XmlAttribute(name="nodeId", required=false)
        private String m_nodeId;
        @XmlAttribute(name="nodeSource", required=false)
        private String m_nodeSource;
        @XmlAttribute(name="domain", required=false)
        private String m_domain;
        @XmlAttribute(name="interfaceId", required=false)
        private String m_interfaceId;
        @XmlAttribute(name="extlink", required=false)
        private String m_extlink;

        public KscGraph() {
        }

        public KscGraph(Graph graph) {
            this.m_title = graph.getTitle();
            this.m_timespan = graph.getTimespan();
            this.m_graphtype = graph.getGraphtype();
            this.m_resourceId = graph.getResourceId().orElse(null);
            this.m_nodeId = graph.getNodeId().orElse(null);
            this.m_nodeSource = graph.getNodeSource().orElse(null);
            this.m_domain = graph.getDomain().orElse(null);
            this.m_interfaceId = graph.getInterfaceId().orElse(null);
            this.m_extlink = graph.getExtlink().orElse(null);
        }

        public Graph buildGraph() {
            boolean found = false;
            for (String valid : KSC_PerformanceReportFactory.TIMESPAN_OPTIONS) {
                if (!valid.equals(this.m_timespan)) continue;
                found = true;
                break;
            }
            if (!found) {
                LOG.debug("invalid timespan ('{}'), setting to '7_day' instead.", (Object)this.m_timespan);
                this.m_timespan = "7_day";
            }
            Graph graph = new Graph();
            graph.setTitle(this.m_title);
            graph.setTimespan(this.m_timespan);
            graph.setGraphtype(this.m_graphtype);
            graph.setResourceId(this.m_resourceId);
            graph.setNodeId(this.m_nodeId);
            graph.setNodeSource(this.m_nodeSource);
            graph.setDomain(this.m_domain);
            graph.setInterfaceId(this.m_interfaceId);
            graph.setExtlink(this.m_extlink);
            return graph;
        }
    }

    @XmlRootElement(name="kscReport")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class KscReport {
        @XmlAttribute(name="id", required=true)
        private Integer m_id;
        @XmlAttribute(name="label", required=true)
        private String m_label;
        @XmlAttribute(name="show_timespan_button", required=false)
        private Boolean m_show_timespan_button;
        @XmlAttribute(name="show_graphtype_button", required=false)
        private Boolean m_show_graphtype_button;
        @XmlAttribute(name="graphs_per_line", required=false)
        private Integer m_graphs_per_line;
        @XmlElement(name="kscGraph")
        private List<KscGraph> m_graphs = new ArrayList<KscGraph>();

        public KscReport() {
        }

        public KscReport(Integer reportId, String label) {
            this.m_id = reportId;
            this.m_label = label;
        }

        public KscReport(Report report) {
            this.m_id = report.getId();
            this.m_label = report.getTitle();
            this.m_show_timespan_button = report.getShowTimespanButton().orElse(null);
            this.m_show_graphtype_button = report.getShowGraphtypeButton().orElse(null);
            this.m_graphs_per_line = report.getGraphsPerLine().orElse(0);
            this.m_graphs.clear();
            for (Graph graph : report.getGraphs()) {
                this.m_graphs.add(new KscGraph(graph));
            }
        }

        public Integer getId() {
            return this.m_id;
        }

        public void setId(Integer id) {
            this.m_id = id;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public Boolean getShowTimespanButton() {
            return this.m_show_timespan_button;
        }

        public void setShowTimespanButton(Boolean show) {
            this.m_show_timespan_button = show;
        }

        public Boolean getShowGraphtypeButton() {
            return this.m_show_graphtype_button;
        }

        public void setShowGraphtypeButton(Boolean show) {
            this.m_show_graphtype_button = show;
        }

        public Integer getGraphsPerLine() {
            return this.m_graphs_per_line;
        }

        public void setGraphsPerLine(Integer graphs) {
            this.m_graphs_per_line = graphs;
        }

        public boolean hasGraphs() {
            return !this.m_graphs.isEmpty();
        }

        public List<KscGraph> getGraphs() {
            return this.m_graphs;
        }
    }

    @XmlRootElement(name="kscReports")
    public static final class KscReportCollection
    extends JaxbListWrapper<KscReport> {
        private static final long serialVersionUID = 1L;

        public KscReportCollection() {
        }

        public KscReportCollection(Collection<? extends KscReport> reports) {
            super(reports);
        }

        public KscReportCollection(Map<Integer, Report> reportList, boolean terse) {
            for (Report report : reportList.values()) {
                if (terse) {
                    this.add(new KscReport(report.getId(), report.getTitle()));
                    continue;
                }
                this.add(new KscReport(report));
            }
        }

        @XmlElement(name="kscReport")
        public List<KscReport> getObjects() {
            return super.getObjects();
        }
    }
}

