/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.HeatMapDTOCollection;
import org.opennms.netmgt.model.HeatMapDTOItem;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="heatMapRestService")
@Path(value="heatmap")
@Tag(name="Heatmap", description="Heatmap API")
public class HeatMapRestService
extends OnmsRestService {
    private static final String CATEGORY_FILTER_PROPERTY_KEY = "org.opennms.heatmap.categoryFilter";
    private static final String CATEGORY_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String FOREIGNSOURCE_FILTER_PROPERTY_KEY = "org.opennms.heatmap.foreignSourceFilter";
    private static final String FOREIGNSOURCE_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String SERVICE_FILTER_PROPERTY_KEY = "org.opennms.heatmap.serviceFilter";
    private static final String SERVICE_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String ONLY_UNACKNOWLEDGED_PROPERTY_KEY = "org.opennms.heatmap.onlyUnacknowledged";
    private static final String ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT = "false";
    private static final Logger LOG = LoggerFactory.getLogger(HeatMapRestService.class);
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private AlarmDao m_alarmDao;

    private HeatMapDTOCollection transformResults(List<HeatMapElement> heatMapElements, String filter) {
        ArrayList<HeatMapDTOItem> itemList = new ArrayList<HeatMapDTOItem>();
        HashMap<String, Integer> elementSizes = new HashMap<String, Integer>();
        int totalServices = 0;
        for (HeatMapElement heatMapElement : heatMapElements) {
            if (heatMapElement.getServicesTotal() <= 0 || filter != null && !heatMapElement.getName().matches(filter)) continue;
            elementSizes.put(heatMapElement.getName(), heatMapElement.getServicesTotal());
            HeatMapDTOItem heatMapDTOItem = new HeatMapDTOItem();
            heatMapDTOItem.setId(heatMapElement.getName());
            heatMapDTOItem.setElementId(Integer.valueOf(heatMapElement.getId()));
            heatMapDTOItem.setColor((List)Lists.newArrayList((Object[])new Double[]{heatMapElement.getColor()}));
            itemList.add(heatMapDTOItem);
            totalServices += heatMapElement.getServicesTotal();
        }
        for (HeatMapDTOItem heatMapDTOItem : itemList) {
            int servicesInEntity = (Integer)elementSizes.get(heatMapDTOItem.getId());
            double size = (double)servicesInEntity / (double)totalServices;
            heatMapDTOItem.setSize((List)Lists.newArrayList((Object[])new Double[]{size}));
        }
        HeatMapDTOCollection heatMapDTOCollection = new HeatMapDTOCollection();
        heatMapDTOCollection.setHeatMapDTOItems(itemList);
        return heatMapDTOCollection;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/categories")
    public Response outagesByCategories() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", null, null, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(CATEGORY_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/foreignSources")
    public Response outagesByForeignsources() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.foreignsource", null, null, null, new String[]{"node.foreignsource"});
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(FOREIGNSOURCE_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/monitoredServices")
    public Response outagesByServices() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("service.servicename", "service.serviceid", null, null, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(SERVICE_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/nodesByCategory/{category}")
    public Response outagesOfNodesByCategory(@PathParam(value="category") String category) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "categories.categoryname", category, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/nodesByForeignSource/{foreignSource}")
    public Response outagesOfNodesByForeignSource(@PathParam(value="foreignSource") String foreignSource) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "node.foreignsource", foreignSource, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="outages/nodesByMonitoredService/{monitoredService}")
    public Response outagesOfNodesByService(@PathParam(value="monitoredService") String monitoredService) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "service.servicename", monitoredService, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/categories")
    public Response alarmsByCategories() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", processAcknowledged, null, null, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(CATEGORY_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/foreignSources")
    public Response alarmsByForeignsources() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.foreignsource", null, processAcknowledged, null, null, new String[]{"node.foreignsource"});
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(FOREIGNSOURCE_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/monitoredServices")
    public Response alarmsByServices() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("service.servicename", "service.serviceid", processAcknowledged, null, null, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, System.getProperty(SERVICE_FILTER_PROPERTY_KEY, ".*"))).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/nodesByCategory/{category}")
    public Response alarmsOfNodesByCategory(@PathParam(value="category") String category) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "categories.categoryname", category, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/nodesByForeignSource/{foreignSource}")
    public Response alarmsOfNodesByForeignSource(@PathParam(value="foreignSource") String foreignSource) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "node.foreignsource", foreignSource, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    @Path(value="alarms/nodesByMonitoredService/{monitoredService}")
    public Response alarmsOfNodesByService(@PathParam(value="monitoredService") String monitoredService) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "service.servicename", monitoredService, new String[0]);
        return Response.ok((Object)this.transformResults(heatMapElements, null)).build();
    }
}

