/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.opennms.core.utils.ConfigFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component
@Path(value="filesystem")
@Tag(name="FileSystem", description="File System API")
public class FilesystemRestService {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemRestService.class);
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = ImmutableSet.of((Object)"xml", (Object)"properties", (Object)"boot", (Object)"cfg", (Object)"drl", (Object)"groovy", (Object[])new String[]{"bsh", "dcb"});
    private final java.nio.file.Path usersXml;
    private final java.nio.file.Path etcFolder = Paths.get(System.getProperty("opennms.home"), "etc");
    private final java.nio.file.Path etcPristineFolder = Paths.get(System.getProperty("opennms.home"), "share", "etc-pristine");

    public FilesystemRestService() {
        try {
            this.usersXml = ConfigFileConstants.getFile((int)ConfigFileConstants.USERS_CONF_FILE_NAME).toPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    FilesystemRestService(java.nio.file.Path usersXml) {
        this.usersXml = usersXml;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public List<String> getFiles(@QueryParam(value="changedFilesOnly") boolean changedFilesOnly, @Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for enumerating files.");
        }
        try {
            return Files.find(this.etcFolder, 4, (path, basicFileAttributes) -> FilesystemRestService.isSupportedExtension(path), FileVisitOption.FOLLOW_LINKS).filter(p -> !p.equals(this.usersXml) || securityContext.isUserInRole("ROLE_ADMIN")).map(p -> this.etcFolder.relativize((java.nio.file.Path)p).toString()).filter(p -> !changedFilesOnly || !this.doesFileExistAndMatchContentsWithEtcPristine((String)p, securityContext)).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to enumerate files in path: " + this.etcFolder, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean doesFileExistAndMatchContentsWithEtcPristine(String file, SecurityContext securityContext) {
        java.nio.file.Path etcPath = this.ensureFileIsAllowed(file, securityContext);
        java.nio.file.Path etcPristinePath = this.etcPristineFolder.resolve(file);
        if (!Files.exists(etcPristinePath, new LinkOption[0])) {
            return false;
        }
        try (BufferedReader pathReader = Files.newBufferedReader(etcPath);){
            boolean bl;
            block15: {
                BufferedReader etcPristineReader = Files.newBufferedReader(etcPristinePath);
                try {
                    bl = IOUtils.contentEqualsIgnoreEOL((Reader)pathReader, (Reader)etcPristineReader);
                    if (etcPristineReader == null) break block15;
                }
                catch (Throwable throwable) {
                    if (etcPristineReader != null) {
                        try {
                            ((Reader)etcPristineReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)etcPristineReader).close();
            }
            return bl;
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/help")
    @Produces(value={"text/markdown"})
    public InputStream getFileHelp(@QueryParam(value="f") String fileName, @Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for retrieving help.");
        }
        this.ensureFileIsAllowed(fileName, securityContext);
        return this.getClass().getResourceAsStream("/help/" + fileName + ".md");
    }

    @GET
    @Path(value="/extensions")
    @Produces(value={"application/json"})
    public List<String> getSupportedExtensions(@Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for retrieving supported extensions.");
        }
        return SUPPORTED_FILE_EXTENSIONS.stream().sorted().collect(Collectors.toList());
    }

    @GET
    @Path(value="/contents")
    public Response getFileContents(@QueryParam(value="f") String fileName, @Context SecurityContext securityContext) {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for reading files.");
        }
        return FilesystemRestService.fileContents(this.ensureFileIsAllowed(fileName, securityContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/contents")
    @Produces(value={"text/html"})
    @Consumes(value={"multipart/form-data"})
    public String uploadFile(@QueryParam(value="f") String fileName, @Multipart(value="upload") Attachment attachment, @Context SecurityContext securityContext) throws IOException {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for uploading file contents.");
        }
        java.nio.file.Path targetPath = this.ensureFileIsAllowed(fileName, securityContext);
        File tempFile = File.createTempFile("upload-", targetPath.getFileName().toString());
        try {
            tempFile.deleteOnExit();
            InputStream in = (InputStream)attachment.getObject(InputStream.class);
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.maybeValidateXml(tempFile);
            Files.copy(tempFile.toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
            String string = String.format("Successfully wrote to '%s'.", targetPath);
            return string;
        }
        finally {
            if (!tempFile.delete()) {
                LOG.warn("Failed to delete temporary file '{}' when uploading contents for '{}'.", (Object)tempFile, (Object)targetPath);
            }
        }
    }

    @DELETE
    @Path(value="/contents")
    @Produces(value={"text/html"})
    public String deleteFile(@QueryParam(value="f") String fileName, @Context SecurityContext securityContext) throws IOException {
        if (!securityContext.isUserInRole("ROLE_FILESYSTEM_EDITOR")) {
            throw new ForbiddenException("FILESYSTEM EDITOR role is required for deleting file contents.");
        }
        java.nio.file.Path targetPath = this.ensureFileIsAllowed(fileName, securityContext);
        Files.delete(targetPath);
        return String.format("Successfully deleted to '%s'.", targetPath);
    }

    public static Response fileContents(java.nio.file.Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return Response.noContent().build();
        }
        try {
            String mimeType = Files.probeContentType(path);
            return Response.ok((Object)Files.readString(path, StandardCharsets.UTF_8)).type(mimeType).header("Content-Disposition", (Object)path.getFileName().toString()).header("Last-Modified", (Object)new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis())).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSupportedExtension(java.nio.file.Path path) {
        return SUPPORTED_FILE_EXTENSIONS.contains(FilenameUtils.getExtension((String)path.getFileName().toString()));
    }

    private java.nio.file.Path ensureFileIsAllowed(String fileName, SecurityContext securityContext) {
        java.nio.file.Path etcFolderNormalized = this.etcFolder.normalize();
        java.nio.file.Path fileNormalized = this.etcFolder.resolve(fileName).normalize();
        if (fileNormalized.equals(this.usersXml) && !securityContext.isUserInRole("ROLE_ADMIN")) {
            throw new ForbiddenException("ADMIN role is required for accessing users.xml file contents.");
        }
        if (fileNormalized.getNameCount() <= etcFolderNormalized.getNameCount() || !fileNormalized.startsWith(etcFolderNormalized)) {
            throw new BadRequestException("Cannot access files outside of folder! Filename given: " + fileName);
        }
        if (!SUPPORTED_FILE_EXTENSIONS.contains(FilenameUtils.getExtension((String)fileNormalized.getFileName().toString()))) {
            throw new BadRequestException("Unsupported file extension: " + fileName);
        }
        return fileNormalized;
    }

    void maybeValidateXml(File file) {
        if (!file.getName().endsWith(".xml")) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error configuring parser factory: " + e.getMessage())).build());
        }
        CapturingErrorHandler errorHandler = new CapturingErrorHandler();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(errorHandler);
            builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Validation failed: " + e.getMessage())).build());
        }
    }

    public static class CapturingErrorHandler
    implements ErrorHandler {
        final StringBuilder sb = new StringBuilder();

        @Override
        public void warning(SAXParseException e) {
            this.sb.append("WARNING: ");
            this.sb.append(e.getMessage());
            this.sb.append("\n");
        }

        @Override
        public void error(SAXParseException e) {
            this.sb.append("ERROR: ");
            this.sb.append(e.getMessage());
            this.sb.append("\n");
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.sb.append("FATAL ERROR: ");
            this.sb.append(e.getMessage());
            this.sb.append("\n");
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

