/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations.monitoringLocations16;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.upgrade.implementations.monitoringLocations16.Tag;

@XmlRootElement(name="location-def")
@XmlAccessorType(value=XmlAccessType.NONE)
public class LocationDef
implements Serializable {
    private static final long serialVersionUID = -7651610012389148818L;
    @XmlAttribute(name="location-name")
    private String m_locationName;
    @XmlAttribute(name="monitoring-area")
    private String m_monitoringArea;
    @XmlAttribute(name="geolocation")
    private String m_geolocation;
    @XmlAttribute(name="coordinates")
    private String m_coordinates;
    @XmlAttribute(name="priority")
    private Long m_priority;
    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    private List<Tag> m_tags;

    public LocationDef() {
    }

    public LocationDef(String locationName, String monitoringArea, String pollingPackageName, String collectionPackageName, String geolocation, String coordinates, Long priority, String ... tags) {
        this();
        this.m_locationName = locationName;
        this.m_monitoringArea = monitoringArea;
        this.m_geolocation = geolocation;
        this.m_coordinates = coordinates;
        this.m_priority = priority;
        for (String tag : tags) {
            if (this.m_tags == null) {
                this.m_tags = new ArrayList<Tag>(tags.length);
            }
            this.m_tags.add(new Tag(tag));
        }
    }

    public String getLocationName() {
        return this.m_locationName;
    }

    public void setLocationName(String locationName) {
        this.m_locationName = locationName;
    }

    public String getMonitoringArea() {
        return this.m_monitoringArea;
    }

    public void setMonitoringArea(String monitoringArea) {
        this.m_monitoringArea = monitoringArea;
    }

    public String getGeolocation() {
        return this.m_geolocation;
    }

    public void setGeolocation(String geolocation) {
        this.m_geolocation = geolocation;
    }

    public String getCoordinates() {
        return this.m_coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.m_coordinates = coordinates;
    }

    public Long getPriority() {
        return this.m_priority == null ? 100L : this.m_priority;
    }

    public void setPriority(Long priority) {
        this.m_priority = priority;
    }

    public List<Tag> getTags() {
        if (this.m_tags == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_tags);
    }

    public void setTags(List<Tag> tags) {
        this.m_tags = tags == null || tags.size() == 0 ? null : new ArrayList<Tag>(tags);
    }

    public int hashCode() {
        int prime = 353;
        int result = 1;
        result = 353 * result + (this.m_coordinates == null ? 0 : this.m_coordinates.hashCode());
        result = 353 * result + (this.m_geolocation == null ? 0 : this.m_geolocation.hashCode());
        result = 353 * result + (this.m_locationName == null ? 0 : this.m_locationName.hashCode());
        result = 353 * result + (this.m_monitoringArea == null ? 0 : this.m_monitoringArea.hashCode());
        result = 353 * result + (this.m_priority == null ? 0 : this.m_priority.hashCode());
        result = 353 * result + (this.m_tags == null || this.m_tags.size() == 0 ? 0 : this.m_tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationDef)) {
            return false;
        }
        LocationDef other = (LocationDef)obj;
        if (this.m_coordinates == null ? other.m_coordinates != null : !this.m_coordinates.equals(other.m_coordinates)) {
            return false;
        }
        if (this.m_geolocation == null ? other.m_geolocation != null : !this.m_geolocation.equals(other.m_geolocation)) {
            return false;
        }
        if (this.m_locationName == null ? other.m_locationName != null : !this.m_locationName.equals(other.m_locationName)) {
            return false;
        }
        if (this.m_monitoringArea == null ? other.m_monitoringArea != null : !this.m_monitoringArea.equals(other.m_monitoringArea)) {
            return false;
        }
        if (this.m_priority == null ? other.m_priority != null : !this.m_priority.equals(other.m_priority)) {
            return false;
        }
        if (this.m_tags == null || this.m_tags.size() == 0) {
            if (other.m_tags != null && other.m_tags.size() > 0) {
                return false;
            }
        } else {
            if (other.m_tags == null || other.m_tags.size() == 0) {
                return false;
            }
            if (!this.m_tags.equals(other.m_tags)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "OnmsMonitoringLocation [location-name=" + this.m_locationName + ", monitoring-area=" + this.m_monitoringArea + ", geolocation=" + this.m_geolocation + ", coordinates=" + this.m_coordinates + ", priority=" + this.m_priority + ", tags=" + this.m_tags + "]";
    }
}

