/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DiscoveryConfigurationLocationMigratorOffline
extends AbstractOnmsUpgrade {
    private File m_configFile = Paths.get(ConfigFileConstants.getHome(), "etc", "discovery-configuration.xml").toFile();
    private File m_backupFile;
    public static final String OLD_DEFAULT_LOCATION = "localhost";
    public static final String NEW_DEFAULT_LOCATION = "Default";

    @Override
    public int getOrder() {
        return 13;
    }

    @Override
    public String getDescription() {
        return "Changes the name for the default location from 'localhost' to 'Default'. See HZN-940.";
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.log("Backing up discovery-configuration.xml\n", new Object[0]);
        this.m_backupFile = this.zipFile(this.m_configFile);
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        if (this.m_backupFile.exists()) {
            this.log("Removing backup %s\n", this.m_backupFile);
            FileUtils.deleteQuietly((File)this.m_backupFile);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        if (!this.m_backupFile.exists()) {
            throw new OnmsUpgradeException(String.format("Backup %s not found. Can't rollback.", this.m_backupFile));
        }
        this.log("Unzipping backup %s to %s\n", this.m_backupFile, this.m_configFile.getParentFile());
        this.unzipFile(this.m_backupFile, this.m_configFile.getParentFile());
        this.log("Rollback successful. The backup file %s will be kept.\n", this.m_backupFile);
    }

    private void updateLocations(Document document, String tag) {
        NodeList nodeList = document.getElementsByTagName(tag);
        for (int a = 0; a < nodeList.getLength(); ++a) {
            Node node = nodeList.item(a).getAttributes().getNamedItem("location");
            if (node == null || !OLD_DEFAULT_LOCATION.equals(node.getNodeValue())) continue;
            node.setNodeValue(NEW_DEFAULT_LOCATION);
        }
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        StringWriter out = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.m_configFile);
            this.updateLocations(doc, "discovery-configuration");
            this.updateLocations(doc, "include-range");
            this.updateLocations(doc, "include-url");
            this.updateLocations(doc, "specific");
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            tf.setOutputProperty("indent", "yes");
            out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            FileUtils.write((File)this.m_configFile, (CharSequence)((Object)out).toString());
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            try {
                throw new OnmsUpgradeException("Failed to upgrade discovery-configuration.xml", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }
}

