/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.log;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;

public class ConsoleLogAdapter
implements LogAdapter {
    private boolean debug;

    @Override
    public void warn(String warnMessage, Object ... args) {
        System.out.println(String.format("WARNING: %s", this.format(warnMessage, args)));
    }

    @Override
    public void error(String message, Object ... args) {
        System.err.println(this.format(message, args));
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.debug) {
            System.out.println(this.format(message, args));
        }
    }

    @Override
    public void info(String message, Object ... args) {
        System.out.println(this.format(message, args));
    }

    @Override
    public void info(InputStream inputStream) {
        try {
            ByteStreams.copy((InputStream)inputStream, (OutputStream)System.out);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    public OutputStream getErrorOutputStream() {
        return System.err;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public OutputStream getOutputStream() {
        return System.out;
    }
}

