/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.graphs;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.opennms.features.jmxconfiggenerator.graphs.Report;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;

public class GraphConfigGenerator {
    protected static final String INTERN_TEMPLATE_NAME = "graphTemplate.vm";
    private final LogAdapter logger;

    public GraphConfigGenerator(LogAdapter logger) {
        this.logger = logger;
    }

    public String generateSnmpGraph(Collection<Report> reports) {
        return this.generateSnmpGraph(reports, null);
    }

    public String generateSnmpGraph(Collection<Report> reports, String graphTemplate) {
        if (graphTemplate != null) {
            return this.generateSnmpGraphInternal(reports, graphTemplate);
        }
        return this.generateSnmpGraphInternal(reports);
    }

    private String generateSnmpGraphInternal(Collection<Report> reports, String graphTemplate) {
        Velocity.init();
        VelocityContext context = new VelocityContext();
        context.put("reportsList", reports.iterator());
        context.put("reportsBody", reports.iterator());
        Template template = Velocity.getTemplate((String)graphTemplate);
        StringWriter sw = new StringWriter();
        if (template != null) {
            template.merge((Context)context, (Writer)sw);
        }
        return sw.toString();
    }

    private String generateSnmpGraphInternal(Collection<Report> reports) {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        InputStream templateInputStream = this.getClass().getClassLoader().getResourceAsStream(INTERN_TEMPLATE_NAME);
        StringWriter templateWriter = new StringWriter();
        InputStreamReader templateReader = new InputStreamReader(templateInputStream);
        VelocityContext context = new VelocityContext();
        context.put("reportsList", reports.iterator());
        context.put("reportsBody", reports.iterator());
        Velocity.evaluate((Context)context, (Writer)templateWriter, (String)INTERN_TEMPLATE_NAME, (Reader)templateReader);
        return templateWriter.toString();
    }
}

