/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.JdbcSupportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSupportLoader {
    private static final Logger log = LoggerFactory.getLogger(JdbcSupportLoader.class);
    private static final Class[] NO_ARG_SIG = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public static JdbcSupport loadJdbcSupport(Connection jdbcConnection) {
        return new JdbcSupportImpl(JdbcSupportLoader.useContextualLobCreation(jdbcConnection));
    }

    private static boolean useContextualLobCreation(Connection jdbcConnection) {
        block10: {
            if (jdbcConnection == null) {
                log.info("Disabling contextual LOB creation as connection was null");
                return false;
            }
            try {
                try {
                    DatabaseMetaData meta = jdbcConnection.getMetaData();
                    if (meta.getJDBCMajorVersion() < 4) {
                        log.info("Disabling contextual LOB creation as JDBC driver reported JDBC version [" + meta.getJDBCMajorVersion() + "] less than 4");
                        return false;
                    }
                }
                catch (SQLException meta) {
                    // empty catch block
                }
                Class<Connection> connectionClass = Connection.class;
                Method createClobMethod = connectionClass.getMethod("createClob", NO_ARG_SIG);
                if (!createClobMethod.getDeclaringClass().equals(Connection.class)) break block10;
                try {
                    Object clob = createClobMethod.invoke((Object)jdbcConnection, NO_ARGS);
                    try {
                        Method freeMethod = clob.getClass().getMethod("free", NO_ARG_SIG);
                        freeMethod.invoke(clob, NO_ARGS);
                    }
                    catch (Throwable ignore) {
                        log.trace("Unable to free CLOB created to test createClob() implementation : " + ignore);
                    }
                    return true;
                }
                catch (Throwable t) {
                    log.info("Disabling contextual LOB creation as createClob() method threw error : " + t);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }
}

