/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Opaque;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CountersSample;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CountersSampleExpanded;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowSample;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowSampleExpanded;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Record;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleData;

public class SampleRecord
extends Record<SampleData> {
    private static Map<Record.DataFormat, Opaque.Parser<SampleData>> sampleDataFormats = ImmutableMap.builder().put((Object)Record.DataFormat.from(1), FlowSample::new).put((Object)Record.DataFormat.from(2), CountersSample::new).put((Object)Record.DataFormat.from(3), FlowSampleExpanded::new).put((Object)Record.DataFormat.from(4), CountersSampleExpanded::new).build();

    public SampleRecord(ByteBuf buffer) throws InvalidPacketException {
        super(buffer, sampleDataFormats);
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeString("format", this.dataFormat.toId());
        if (this.data.value != null) {
            bsonWriter.writeName("data");
            ((SampleData)this.data.value).writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
        if (this.data.value != null) {
            ((SampleData)this.data.value).visit(visitor);
        }
    }
}

