<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page import="com.google.common.base.Strings"%>
<%@page import="org.opennms.web.svclayer.model.SnmpInfo"%>
<%@page import="org.opennms.netmgt.snmp.SnmpConfiguration"%>
<%@page import="org.opennms.core.utils.WebSecurityUtils" %>
<%@page language="java" contentType="text/html" session="true"%>

<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("SNMP Configuration")
          .headTitle("Admin")
          .breadcrumb("Admin", "admin/index.jsp")
          .breadcrumb("Configure SNMP by IP")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />

<jsp:include page="/assets/load-assets.jsp" flush="false">
    <jsp:param name="asset" value="ipaddress-js" />
</jsp:include>

<script type="text/javascript">
	function verifySnmpConfig() {
		var ipValue = new String("");

		// validate Ip-Address
		ipValue = new String(document.snmpConfigForm.firstIPAddress.value);
		if (ipValue == "") {
			alert("Please enter a valid first IP address!");
			return false;
		}
		if (!isValidIPAddress(ipValue)) {
			alert(ipValue + " is not a valid IP address!");
			return false;
		}
		ipValue = new String(document.snmpConfigForm.lastIPAddress.value);
		if (ipValue != "" && !isValidIPAddress(ipValue)) {
			alert(ipValue + " is not a valid IP address!");
			return false;
		}

		//validate timeout
		var timeout = new String(document.snmpConfigForm.timeout.value);
		if (timeout != "" && (!isNumber(timeout) || parseInt(timeout) <= 0)) {
			alert(timeout
					+ " is not a valid timeout. Please enter a number greater than 0 or leave it empty.");
			return false;
		}

		//validate retryCount
		var retryCount = new String(document.snmpConfigForm.retryCount.value);
		if (retryCount != ""
				&& (!isNumber(retryCount) || parseInt(retryCount) < 0)) {
			alert(retryCount
					+ " is not a valid Retry Count. Please enter a number greater than or equal to 0, or leave it empty.");
			return false;
		}

		// validate port
		var port = new String(document.snmpConfigForm.port.value);
		if (port != "" && (!isNumber(port) || parseInt(port) <= 0)) {
			alert(port
					+ " is not a valid Port. Please enter a number greater than 0 or leave it empty.");
			return false;
		}

		// validate maxRequestSize
		var maxRequestSize = new String(
				document.snmpConfigForm.maxRequestSize.value);
		if (maxRequestSize != ""
				&& (!isNumber(maxRequestSize) || parseInt(maxRequestSize) < 484)) {
			alert(maxRequestSize
					+ " is not a valid Max Request Size. Please enter a number greater or equal than 484 or leave it empty.");
			return false;
		}

		// validate maxVarsPerPdu
		var maxVarsPerPdu = new String(
				document.snmpConfigForm.maxVarsPerPdu.value);
		if (maxVarsPerPdu != ""
				&& (!isNumber(maxVarsPerPdu) || parseInt(maxVarsPerPdu) <= 0)) {
			alert(maxVarsPerPdu
					+ " is not a valid Max Vars Per Pdu. Please enter a number greater than 0 or leave it empty.");
			return false;
		}

		// validate maxRepetitions
		var maxRepetitions = new String(
				document.snmpConfigForm.maxRepetitions.value);
		if (maxRepetitions != ""
				&& (!isNumber(maxRepetitions) || parseInt(maxRepetitions) <= 0)) {
			alert(maxRepetitions
					+ " is not a valid Max Repetitions. Please enter a number greater than 0 or leave it empty.");
			return false;
		}

		//validate ttl
		var ttl = new String(document.snmpConfigForm.ttl.value);
		if (ttl != "" && (!isNumber(ttl) || parseInt(ttl) <= 0)) {
			alert(ttl
					+ " is not a valid ttl. Please enter a number greater than 0 or leave it empty.");
			return false;
		}
		
		// validate save options (at least one must be selected)
		var sendEventOption = document.snmpConfigForm.sendEventOption.checked;
		var sendLocallyOption = document.snmpConfigForm.saveLocallyOption.checked;
		if (!sendEventOption && !sendLocallyOption) {
			alert("You must select either 'Send Event' or 'Save Locally'. It is possible to select both options.");
			return false;
		}
		
		return true;
	}
	
<%/*  checks if the given parameter is a number, so we assume it can be parsed as an integer*/%>
	function isNumber(input) {
		return !isNaN(input - 0) && input != null && input !== null
				&& input !== "" && input !== false;
	}

    function getVersion(id) {
        var element = document.getElementById(id);
        if (element == null || element.options == null || element.selectedIndex == null) {
            return "v2c";
        }

        return element.options[element.selectedIndex].value;
    }

	/*
	 * On Version change only the specificy section is shown.
	 */
	function onVersionChange() {
	    var version = getVersion("version");

	    $("select[name='version'] option[value!='" + version + "']").removeAttr('selected');
        $("select[name='version'] option[value='" + version + "']").attr('selected', true);

        var activeClass = 'snmp-' + version;

		// hide all not selected elements and show selected Element
		$("div[class*='snmp-']").each(function() {
		  if ($(this).hasClass(activeClass)) { // show
            $(this).css("display", "block");
		  } else { // hide
		    $(this).css("display", "none");
		  }
		});
		return true;
	}

	function cancel() {
		document.snmpConfigForm.action = "admin/index.jsp";
		document.snmpConfigForm.submit();
	}

  $(document).ready(function() {
      // function to update all locatoin input fields
      var updateLocations = function(locations) {
          if (!locations) return;
          // ensure that they are sorted by priority
          locations.sort(function(a,b) {
              return b.priority - a.priority;
          });

          // update input fields
          var locationSelectors = ["#location", "#lookup_location"]
          for (var i = 0; i < locationSelectors.length; i++) {
              var selector = locationSelectors[i];
              $.each(locations, function(index, location) {
                  var locationName = location['location-name'];
                  $(selector).append($("<option" + (locationName == 'Default' ? " selected" : "")+"/>").val(locationName).text(locationName));
              });
          }
      };

      // Get all available locations
      $.get('api/v2/monitoringLocations?limit=0', function(locationList) {
          if (locationList && locationList.location && locationList.location.length > 0) {
              updateLocations(locationList.location);
          }
          var selectedLocation = '<%= getValue(request.getAttribute("location")) %>';
          if (!selectedLocation) {
              selectedLocation = 'Default';
          }
          $("#location").val(selectedLocation);
      });
  });
</script>

<%!// does Null Pointer handling
	public String getValue(Object input) {
		if (input == null) return "";
		return input.toString();
	}

	public String getOptions(String selectedOption, String defaultOption, String... options) {
		// prevent Nullpointer
		if (defaultOption == null) defaultOption = "";
		// ensure that there is a default :)
		if (Strings.isNullOrEmpty(selectedOption)) selectedOption = defaultOption;

		final String optionTemplate = "<option value=\"%s\" %s>%s</option>";
		String optionsString = "";
		for (String eachOption : options) {
			optionsString += String.format(optionTemplate, eachOption, eachOption.equals(selectedOption) ? "selected" : "", eachOption);
			optionsString += "\n";
		}
		return optionsString.trim();
	}%>

<%
	Object obj = request.getAttribute("snmpConfigForIp");
	SnmpInfo snmpInfo = obj == null ? new SnmpInfo() : (SnmpInfo) obj;

	String firstIpAddress = getValue(request.getAttribute("firstIPAddress"));
	String version = getValue(snmpInfo.getVersion());
	String timeout = getValue(snmpInfo.getTimeout());
	String retryCount = getValue(snmpInfo.getRetries());
	String port = getValue(snmpInfo.getPort());
	String proxyHost = getValue(snmpInfo.getProxyHost()); 
	String maxRequestSize = getValue(snmpInfo.getMaxRequestSize());
	String maxVarsPerPdu = getValue(snmpInfo.getMaxVarsPerPdu());
	String maxRepetitions = getValue(snmpInfo.getMaxRepetitions());
	String readCommunityString = getValue(snmpInfo.getReadCommunity());
	String writeCommunityString = getValue(snmpInfo.getWriteCommunity());
	String securityName = getValue(snmpInfo.getSecurityName());
	String securityLevel = getValue(snmpInfo.getSecurityLevel());
	String authPassPhrase = getValue(snmpInfo.getAuthPassPhrase());
	String authProtocol = getValue(snmpInfo.getAuthProtocol());
	String privPassPhrase = getValue(snmpInfo.getPrivPassPhrase());
	String privProtocol = getValue(snmpInfo.getPrivProtocol());
	String engineId = getValue(snmpInfo.getEngineId());
	String contextEngineId = getValue(snmpInfo.getContextEngineId());
	String contextName = getValue(snmpInfo.getContextName());
	String enterpriseId = getValue(snmpInfo.getEnterpriseId());
	String ttl = getValue(snmpInfo.getTTL());
%>


<%
if (request.getAttribute("success") != null) {
%>
  <h3 class="alert alert-success">Finished configuring SNMP. OpenNMS does not need to be restarted.</h3>
<%
}
%>

<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <span>SNMP Config Lookup</span>
      </div>
      <div class="card-body">
        <form role="form" class="form" method="post" name="snmpConfigGetForm" action="admin/snmpConfig?action=get">
          <input type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}"/>
          <div class="form-group form-row">
            <label for="lookup_ipAddress" class="col-form-label col-sm-3" data-toggle="tooltip" data-placement="right" title="Specify the IP Address for which you want to lookup the SNMP configuration. Either IPv4 or IPv6 format is allowed.">
            IP Address
            </label>
            <div class="col-sm-9">
              <input type="text" class="form-control" name="ipAddress" id="lookup_ipAddress"/>
            </div>
          </div>
          <div class="form-group form-row">
            <label for="lookup_location" class="col-form-label col-sm-3" data-toggle="tooltip" data-placement="right" title="Specify the location for which you want to lookup the SNMP configuration.">
            Location
            </label>
            <div class="col-sm-9">
              <select id="lookup_location" name="location" class="form-control custom-select">
              </select>
            </div>
          </div>
          <div class="form-group form-row">
            <div class="col-sm-9 col-sm-offset-2">
              <button type="submit" class="btn btn-secondary" name="getConfig">Look up</button>
            </div>
          </div>
        </form>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- column -->

  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <span>Descriptions</span>
      </div>
      <div class="card-body">
		<p>
			<b>SNMP Config Lookup:</b> You can look up the actual SNMP
			configuration for a specific IP and location. To do so enter the IP Address 
			and location in the SNMP Config Lookup box and press "Look up". 
			The configuration will then be shown in the "Updateing SNMP Community Names" area.
		</p>

		<p>
			<b>Updating SNMP Configuration:</b> In the boxes on the left, enter
			in a specific IP address and community string, or a range of IP
			addresses and a community string, and other SNMP parameters.
		</p>
		<p>OpenNMS will optimize this list, so enter the most generic
			first (i.e. the largest range) and the specific IP addresses last,
			because if a range is added that includes a specific IP address, the
			community name for the specific address will be changed to be that of
			the range.</p>
		<p>For devices that have already been provisioned and that have an
			event stating that data collection has failed because the community
			name changed, it may be necessary to update the SNMP information on
			the interface page for that device (by selecting the "Update SNMP"
			link) for these changes to take effect.</p>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- col-md-6 -->
</div> <!--  row -->

<a id="updateForm"/>
<form role="form" class="form-horizontal" method="post" name="snmpConfigForm"
  action="admin/snmpConfig?action=add" onsubmit="return verifySnmpConfig();">
  <input type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}"/>

<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <span>Updating SNMP Configuration</span>
      </div>
      <div class="card-body">
          <div class="form-group form-row">
            <div class="col-sm-12">
              <h3>General Parameters</h3>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="version" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="Specify the SNMP version you want to use. You are not allowed to set v1/v2c and v3 parameters at the same time.">
            Version
            </label>
            <div class="col-sm-9">
              <select id="version" name="version" class="form-control custom-select" onChange="onVersionChange()">
                <%=getOptions(version, "v2c", "v1", "v2c", "v3")%>
              </select>
              <p class="form-text text-muted"><b>Default: </b>v2c</p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="firstIPAddress" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="Specify the IP Address you want to define as the first IP address. Even if you just want to add a specific IP address enter that one here. Either IPv4 or IPv6 format is allowed.">
              First IP Address
            </label>
            <div class="col-sm-9">
              <input id="firstIPAddress" name="firstIPAddress" class="form-control" required="required" value="<%=firstIpAddress%>">
            </div>
          </div>

          <div class="form-group form-row">
            <label for="lastIPAddress" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="If you want to define a range of IP addresses, specify the last IP address. If you just want to add a specific IP address to your SNMP configuration leave this field empty. Either IPv4 or IPv6 format is allowed.">
            Last IP Address
            </label>
            <div class="col-sm-9">
              <input id="lastIPAddress" name="lastIPAddress" class="form-control">
            </div>
          </div>

          <div class="form-group form-row">
            <label for="location" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="Specify the location at which SNMP Config needs to be updated">
            Location
            </label>
            <div class="col-sm-9">
              <select id="location" name="location" class="form-control custom-select">
              </select>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="timeout" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The amount of time, in milliseconds, that OpenNMS will wait for a response from the agent.">
            Timeout
            </label>
            <div class="col-sm-9">
              <input id="timeout" name="timeout" class="form-control" value="<%=timeout%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_TIMEOUT %> ms</p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="retryCount" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The number of retries that will be made to connect to the SNMP agent if the initial attempt fails.">
            Retries
            </label>
            <div class="col-sm-9">
              <input id="retryCount" name="retryCount" class="form-control" value="<%=retryCount%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_RETRIES %></p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="port" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="This overrides the default port.">
            Port
            </label>
            <div class="col-sm-9">
              <input id="port" name="port" class="form-control" value="<%=port%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_PORT %></p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="proxyHost" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="This overrides the default port.">
            Proxy Host
            </label>
            <div class="col-sm-9">
              <input id="proxyHost" name="proxyHost" class="form-control" value="<%=proxyHost%>">
            </div>
          </div>

          <div class="form-group form-row">
            <label for="maxRequestSize" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The maximum size of outgoing SNMP requests. It must be at least 484.">
            Max Request Size
            </label>
            <div class="col-sm-9">
              <input id="maxRequestSize" name="maxRequestSize" class="form-control" value="<%=maxRequestSize%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_MAX_REQUEST_SIZE %></p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="maxVarsPerPdu" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The maximum number of variables per SNMP request.">
            Max Vars Per Pdu
            </label>
            <div class="col-sm-9">
              <input id="maxVarsPerPdu" name="maxVarsPerPdu" class="form-control" value="<%=maxVarsPerPdu%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_MAX_VARS_PER_PDU %></p>
            </div>
          </div>

          <div class="form-group form-row">
            <label for="maxRepetitions" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The maximum number of instances which the agent may return for any variables beyond those specified by the non-repeaters field. Applies only to v2c and v3.">
            Max Repetitions
            </label>
            <div class="col-sm-9">
              <input id="maxRepetitions" name="maxRepetitions" class="form-control" value="<%=maxRepetitions%>">
              <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_MAX_REPETITIONS %></p>
           </div>
          </div>

          <div class="form-group form-row">
            <label for="ttl" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The amount of time, in milliseconds, that OpenNMS will wait for a response from Minion.">
            TTL
            </label>
            <div class="col-sm-9">
              <input id="ttl" name="ttl" class="form-control" value="<%=ttl%>">
            </div>
          </div>

          </div>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- column -->

  <!-- v1/v2c parameters -->
  <div class="col-md-6 snmp-v1 snmp-v2c" style="display:none">
    <div class="card">
      <div class="card-header">
        <span>v1/v2c specific parameters</span>
      </div>
      <div class="card-body">
        <div class="form-group form-row">
          <label for="readCommunityString" class="col-sm-4 col-form-label" data-toggle="tooltip" data-placement="right" title="The default 'read' community string for SNMP queries.">
          Read Community String
          </label>
          <div class="col-sm-8">
            <input id="readCommunityString" class="form-control" name="readCommunityString" value="<%=WebSecurityUtils.sanitizeString(readCommunityString)%>">
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_READ_COMMUNITY %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="writeCommunityString" class="col-sm-4 col-form-label" data-toggle="tooltip" data-placement="right" title="The default 'write' community string for SNMP queries. Note that this is for future development - OpenNMS does not perform SNMP 'sets' at the moment.">
          Write Community String
          </label>
          <div class="col-sm-8">
            <input id="writeCommunityString" class="form-control" name="writeCommunityString" value="<%=WebSecurityUtils.sanitizeString(writeCommunityString)%>">
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_WRITE_COMMUNITY %></p>
          </div>
        </div>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- column -->

  <!--  v3 parameters -->
  <div class="col-md-6 snmp-v3" style="display:none">
    <div class="card">
      <div class="card-header">
        <span>v3 specific parameters</span>
      </div>
      <div class="card-body">
        <div class="form-group form-row">
          <label for="securityName" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="A security name for SNMP v3 authentication.">
          Security Name
          </label>
          <div class="col-sm-9">
            <input id="securityName" class="form-control" name="securityName" value="<%=securityName%>">
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_SECURITY_NAME %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="securityLevel" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The security level for SNMP v3 authentication. If you leave it empty the security level is determined automatically as follows: 1) if no authentication passphrase is set noAuthNoPriv is determined 2) if authentication passphrase is set but a privacy passphrase is not authNoPriv is determined 3) if authentication and privacy passphrase is set authPriv is determined">
          Security Level
          </label>
          <div class="col-sm-9">
            <select id="securityLevel" name="securityLevel" class="form-control custom-select">
              <option value=""></option>
              <option value="1"
                <%="1".equals(securityLevel) ? "selected" : ""%>>noAuthNoPriv</option>
              <option value="2"
                <%="2".equals(securityLevel) ? "selected" : ""%>>authNoPriv</option>
              <option value="3"
                <%="3".equals(securityLevel) ? "selected" : ""%>>authPriv</option>
            </select>
            <p class="form-text text-muted"><b>Default: </b> noAuthNoPriv|authNoPriv|authPriv</p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="authPassPhrase" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The passphrase to use for SNMP v3 authentication.">
          Auth Passphrase
          </label>
          <div class="col-sm-9">
            <input id="authPassPhrase" class="form-control" name="authPassPhrase" value="<%=authPassPhrase%>">
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_AUTH_PASS_PHRASE %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="authProtocol" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The authentication protocol for SNMP v3.">
          Auth Protocol
          </label>
          <div class="col-sm-9">
			<select id="authProtocol" name="authProtocol" class="form-control custom-select">
			  <%=getOptions(authProtocol, "", "", "MD5", "SHA", "SHA-224", "SHA-256", "SHA-512")%>
			</select>
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_AUTH_PROTOCOL %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="privPassPhrase" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="A privacy pass phrase used to encrypt the contents of SNMP v3 PDUs.">
          Privacy Passphrase
          </label>
          <div class="col-sm-9">
            <input id="privPassPhrase" class="form-control" name="privPassPhrase" value="<%=privPassPhrase%>">
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_PRIV_PASS_PHRASE %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="privProtocol" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The privacy protocol used to encrypt the contents of SNMP v3 PDUs.">
          Privacy Protocol
          </label>
          <div class="col-sm-9">
            <select id="privProtocol" name="privProtocol" class="form-control custom-select">
              <%=getOptions(privProtocol, "", "", "DES", "AES", "AES192", "AES256")%>
            </select>
            <p class="form-text text-muted"><b>Default: </b><%=SnmpConfiguration.DEFAULT_PRIV_PROTOCOL %></p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="engineId" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The engine id of the target agent.">
          Engine Id
          </label>
          <div class="col-sm-9">
            <input id="engineId" class="form-control" name="engineId" value="<%=engineId%>">
          </div>
        </div>

        <div class="form-group form-row">
          <label for="contextEngineId" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="The name of the context to obtain data from the target agent.">
          Context Engine Id
          </label>
          <div class="col-sm-9">
            <input id="contextEngineId" class="form-control" name="contextEngineId" value="<%=contextEngineId%>">
          </div>
        </div>

        <div class="form-group form-row">
          <label for="contextName" class="col-sm-3 col-form-label">
          Context Name
          </label>
          <div class="col-sm-9">
            <input id="contextName" class="form-control" name="contextName" value="<%=contextName%>">
          </div>
        </div>

        <div class="form-group form-row">
          <label for="enterpriseId" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="An enterprise id for SNMP v3 collection.">
          Enterprise Id
          </label>
          <div class="col-sm-9">
            <input id="enterpriseId" class="form-control" name="enterpriseId" value="<%=enterpriseId%>">
          </div>
        </div>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- column -->
</div> <!--  row -->

<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <span>Save Options</span>
      </div>
      <div class="card-body">
        <div class="form-group form-row">
          <label for="sendEventOption" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="By default the snmp configuration is published to the system by sending an event. This is useful if you have multiple OpenNMS instances running and want to notify all of them about the changes. If you do not which to send the event, unmark the checkbox. Be aware that collectd must be activated to process the event!">
          Send Event
          </label>
          <div class="col-sm-9">
            <input type="checkbox" id="sendEventOption" name="sendEventOption" checked="checked"/>
            <p class="form-text text-muted"><b>Default: </b>enabled</p>
          </div>
        </div>

        <div class="form-group form-row">
          <label for="saveLocallyOption" class="col-sm-3 col-form-label" data-toggle="tooltip" data-placement="right" title="This option saves the changes directly in snmp-config.xml and does not send an event. The difference to the 'Send Event' option is that Collectd is not needed. If Collectd is not running select this option.">
          Send Locally
          </label>
          <div class="col-sm-9">
            <input type="checkbox" id="saveLocallyOption" name="saveLocallyOption"/>
            <p class="form-text text-muted"><b>Default: </b>disabled</p>
          </div>
        </div>

        <div class="form-group form-row">
          <div class="col-sm-9 col-sm-offset-3">
            <button type="submit" class="btn btn-secondary" name="saveConfig">Save Config</button>
            <button type="button" class="btn btn-secondary" name="cancelButton" onClick="cancel();">Cancel</button>
          </div>
        </div>
      </div> <!-- card-body -->
    </div> <!-- panel -->
  </div> <!-- column -->
</div> <!-- row -->

</form>

<script type="text/javascript">
$(function () {
  $('[data-toggle="tooltip"]').tooltip();
  onVersionChange();
})
</script>

<jsp:include page="/includes/bootstrap-footer.jsp" flush="false" />
