/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: transport.proto

package org.opennms.netmgt.telemetry.protocols.bmp.transport;

public final class Transport {
    private Transport() {}
    public static void registerAllExtensions(
            com.google.protobuf.ExtensionRegistryLite registry) {
    }

    public static void registerAllExtensions(
            com.google.protobuf.ExtensionRegistry registry) {
        registerAllExtensions(
                (com.google.protobuf.ExtensionRegistryLite) registry);
    }
    public interface IpAddressOrBuilder extends
            // @@protoc_insertion_point(interface_extends:IpAddress)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>bytes v4 = 1;</code>
         * @return Whether the v4 field is set.
         */
        boolean hasV4();
        /**
         * <code>bytes v4 = 1;</code>
         * @return The v4.
         */
        com.google.protobuf.ByteString getV4();

        /**
         * <code>bytes v6 = 2;</code>
         * @return Whether the v6 field is set.
         */
        boolean hasV6();
        /**
         * <code>bytes v6 = 2;</code>
         * @return The v6.
         */
        com.google.protobuf.ByteString getV6();

        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.AddressCase getAddressCase();
    }
    /**
     * Protobuf type {@code IpAddress}
     */
    public static final class IpAddress extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:IpAddress)
            IpAddressOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use IpAddress.newBuilder() to construct.
        private IpAddress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private IpAddress() {
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new IpAddress();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_IpAddress_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_IpAddress_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder.class);
        }

        private int addressCase_ = 0;
        @SuppressWarnings("serial")
        private java.lang.Object address_;
        public enum AddressCase
                implements com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
            V4(1),
            V6(2),
            ADDRESS_NOT_SET(0);
            private final int value;
            private AddressCase(int value) {
                this.value = value;
            }
            /**
             * @param value The number of the enum to look for.
             * @return The enum associated with the given number.
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static AddressCase valueOf(int value) {
                return forNumber(value);
            }

            public static AddressCase forNumber(int value) {
                switch (value) {
                    case 1: return V4;
                    case 2: return V6;
                    case 0: return ADDRESS_NOT_SET;
                    default: return null;
                }
            }
            public int getNumber() {
                return this.value;
            }
        };

        public AddressCase
        getAddressCase() {
            return AddressCase.forNumber(
                    addressCase_);
        }

        public static final int V4_FIELD_NUMBER = 1;
        /**
         * <code>bytes v4 = 1;</code>
         * @return Whether the v4 field is set.
         */
        @java.lang.Override
        public boolean hasV4() {
            return addressCase_ == 1;
        }
        /**
         * <code>bytes v4 = 1;</code>
         * @return The v4.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getV4() {
            if (addressCase_ == 1) {
                return (com.google.protobuf.ByteString) address_;
            }
            return com.google.protobuf.ByteString.EMPTY;
        }

        public static final int V6_FIELD_NUMBER = 2;
        /**
         * <code>bytes v6 = 2;</code>
         * @return Whether the v6 field is set.
         */
        @java.lang.Override
        public boolean hasV6() {
            return addressCase_ == 2;
        }
        /**
         * <code>bytes v6 = 2;</code>
         * @return The v6.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getV6() {
            if (addressCase_ == 2) {
                return (com.google.protobuf.ByteString) address_;
            }
            return com.google.protobuf.ByteString.EMPTY;
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (addressCase_ == 1) {
                output.writeBytes(
                        1, (com.google.protobuf.ByteString) address_);
            }
            if (addressCase_ == 2) {
                output.writeBytes(
                        2, (com.google.protobuf.ByteString) address_);
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (addressCase_ == 1) {
                size += com.google.protobuf.CodedOutputStream
                        .computeBytesSize(
                                1, (com.google.protobuf.ByteString) address_);
            }
            if (addressCase_ == 2) {
                size += com.google.protobuf.CodedOutputStream
                        .computeBytesSize(
                                2, (com.google.protobuf.ByteString) address_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress) obj;

            if (!getAddressCase().equals(other.getAddressCase())) return false;
            switch (addressCase_) {
                case 1:
                    if (!getV4()
                            .equals(other.getV4())) return false;
                    break;
                case 2:
                    if (!getV6()
                            .equals(other.getV6())) return false;
                    break;
                case 0:
                default:
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            switch (addressCase_) {
                case 1:
                    hash = (37 * hash) + V4_FIELD_NUMBER;
                    hash = (53 * hash) + getV4().hashCode();
                    break;
                case 2:
                    hash = (37 * hash) + V6_FIELD_NUMBER;
                    hash = (53 * hash) + getV6().hashCode();
                    break;
                case 0:
                default:
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code IpAddress}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:IpAddress)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_IpAddress_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_IpAddress_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.newBuilder()
            private Builder() {

            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);

            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                addressCase_ = 0;
                address_ = null;
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_IpAddress_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                buildPartialOneofs(result);
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress result) {
                int from_bitField0_ = bitField0_;
            }

            private void buildPartialOneofs(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress result) {
                result.addressCase_ = addressCase_;
                result.address_ = this.address_;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) return this;
                switch (other.getAddressCase()) {
                    case V4: {
                        setV4(other.getV4());
                        break;
                    }
                    case V6: {
                        setV6(other.getV6());
                        break;
                    }
                    case ADDRESS_NOT_SET: {
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 10: {
                                address_ = input.readBytes();
                                addressCase_ = 1;
                                break;
                            } // case 10
                            case 18: {
                                address_ = input.readBytes();
                                addressCase_ = 2;
                                break;
                            } // case 18
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int addressCase_ = 0;
            private java.lang.Object address_;
            public AddressCase
            getAddressCase() {
                return AddressCase.forNumber(
                        addressCase_);
            }

            public Builder clearAddress() {
                addressCase_ = 0;
                address_ = null;
                onChanged();
                return this;
            }

            private int bitField0_;

            /**
             * <code>bytes v4 = 1;</code>
             * @return Whether the v4 field is set.
             */
            public boolean hasV4() {
                return addressCase_ == 1;
            }
            /**
             * <code>bytes v4 = 1;</code>
             * @return The v4.
             */
            public com.google.protobuf.ByteString getV4() {
                if (addressCase_ == 1) {
                    return (com.google.protobuf.ByteString) address_;
                }
                return com.google.protobuf.ByteString.EMPTY;
            }
            /**
             * <code>bytes v4 = 1;</code>
             * @param value The v4 to set.
             * @return This builder for chaining.
             */
            public Builder setV4(com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                addressCase_ = 1;
                address_ = value;
                onChanged();
                return this;
            }
            /**
             * <code>bytes v4 = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearV4() {
                if (addressCase_ == 1) {
                    addressCase_ = 0;
                    address_ = null;
                    onChanged();
                }
                return this;
            }

            /**
             * <code>bytes v6 = 2;</code>
             * @return Whether the v6 field is set.
             */
            public boolean hasV6() {
                return addressCase_ == 2;
            }
            /**
             * <code>bytes v6 = 2;</code>
             * @return The v6.
             */
            public com.google.protobuf.ByteString getV6() {
                if (addressCase_ == 2) {
                    return (com.google.protobuf.ByteString) address_;
                }
                return com.google.protobuf.ByteString.EMPTY;
            }
            /**
             * <code>bytes v6 = 2;</code>
             * @param value The v6 to set.
             * @return This builder for chaining.
             */
            public Builder setV6(com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                addressCase_ = 2;
                address_ = value;
                onChanged();
                return this;
            }
            /**
             * <code>bytes v6 = 2;</code>
             * @return This builder for chaining.
             */
            public Builder clearV6() {
                if (addressCase_ == 2) {
                    addressCase_ = 0;
                    address_ = null;
                    onChanged();
                }
                return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:IpAddress)
        }

        // @@protoc_insertion_point(class_scope:IpAddress)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<IpAddress>
                PARSER = new com.google.protobuf.AbstractParser<IpAddress>() {
            @java.lang.Override
            public IpAddress parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<IpAddress> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<IpAddress> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface PeerOrBuilder extends
            // @@protoc_insertion_point(interface_extends:Peer)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.Peer.Type type = 1;</code>
         * @return The enum numeric value on the wire for type.
         */
        int getTypeValue();
        /**
         * <code>.Peer.Type type = 1;</code>
         * @return The type.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type getType();

        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         * @return Whether the peerFlags field is set.
         */
        boolean hasPeerFlags();
        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         * @return The peerFlags.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getPeerFlags();
        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder getPeerFlagsOrBuilder();

        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         * @return Whether the locRibFlags field is set.
         */
        boolean hasLocRibFlags();
        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         * @return The locRibFlags.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getLocRibFlags();
        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder getLocRibFlagsOrBuilder();

        /**
         * <code>fixed64 distinguisher = 4;</code>
         * @return The distinguisher.
         */
        long getDistinguisher();

        /**
         * <code>.IpAddress address = 5;</code>
         * @return Whether the address field is set.
         */
        boolean hasAddress();
        /**
         * <code>.IpAddress address = 5;</code>
         * @return The address.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress();
        /**
         * <code>.IpAddress address = 5;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder();

        /**
         * <code>fixed32 as = 6;</code>
         * @return The as.
         */
        int getAs();

        /**
         * <code>.IpAddress id = 7;</code>
         * @return Whether the id field is set.
         */
        boolean hasId();
        /**
         * <code>.IpAddress id = 7;</code>
         * @return The id.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId();
        /**
         * <code>.IpAddress id = 7;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder();

        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         * @return Whether the timestamp field is set.
         */
        boolean hasTimestamp();
        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         * @return The timestamp.
         */
        com.google.protobuf.Timestamp getTimestamp();
        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         */
        com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder();

        /**
         * <code>string hostname = 15;</code>
         * @return The hostname.
         */
        java.lang.String getHostname();
        /**
         * <code>string hostname = 15;</code>
         * @return The bytes for hostname.
         */
        com.google.protobuf.ByteString
        getHostnameBytes();

        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.FlagsCase getFlagsCase();
    }
    /**
     * Protobuf type {@code Peer}
     */
    public static final class Peer extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:Peer)
            PeerOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Peer.newBuilder() to construct.
        private Peer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private Peer() {
            type_ = 0;
            hostname_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new Peer();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder.class);
        }

        /**
         * Protobuf enum {@code Peer.Type}
         */
        public enum Type
                implements com.google.protobuf.ProtocolMessageEnum {
            /**
             * <code>GLOBAL_INSTANCE = 0;</code>
             */
            GLOBAL_INSTANCE(0),
            /**
             * <code>RD_INSTANCE = 1;</code>
             */
            RD_INSTANCE(1),
            /**
             * <code>LOCAL_INSTANCE = 2;</code>
             */
            LOCAL_INSTANCE(2),
            /**
             * <code>LOC_RIB_INSTANCE = 3;</code>
             */
            LOC_RIB_INSTANCE(3),
            UNRECOGNIZED(-1),
            ;

            /**
             * <code>GLOBAL_INSTANCE = 0;</code>
             */
            public static final int GLOBAL_INSTANCE_VALUE = 0;
            /**
             * <code>RD_INSTANCE = 1;</code>
             */
            public static final int RD_INSTANCE_VALUE = 1;
            /**
             * <code>LOCAL_INSTANCE = 2;</code>
             */
            public static final int LOCAL_INSTANCE_VALUE = 2;
            /**
             * <code>LOC_RIB_INSTANCE = 3;</code>
             */
            public static final int LOC_RIB_INSTANCE_VALUE = 3;


            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new java.lang.IllegalArgumentException(
                            "Can't get the number of an unknown enum value.");
                }
                return value;
            }

            /**
             * @param value The numeric wire value of the corresponding enum entry.
             * @return The enum associated with the given numeric wire value.
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static Type valueOf(int value) {
                return forNumber(value);
            }

            /**
             * @param value The numeric wire value of the corresponding enum entry.
             * @return The enum associated with the given numeric wire value.
             */
            public static Type forNumber(int value) {
                switch (value) {
                    case 0: return GLOBAL_INSTANCE;
                    case 1: return RD_INSTANCE;
                    case 2: return LOCAL_INSTANCE;
                    case 3: return LOC_RIB_INSTANCE;
                    default: return null;
                }
            }

            public static com.google.protobuf.Internal.EnumLiteMap<Type>
            internalGetValueMap() {
                return internalValueMap;
            }
            private static final com.google.protobuf.Internal.EnumLiteMap<
                    Type> internalValueMap =
                    new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                        public Type findValueByNumber(int number) {
                            return Type.forNumber(number);
                        }
                    };

            public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new java.lang.IllegalStateException(
                            "Can't get the descriptor of an unrecognized enum value.");
                }
                return getDescriptor().getValues().get(ordinal());
            }
            public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
                return getDescriptor();
            }
            public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDescriptor().getEnumTypes().get(0);
            }

            private static final Type[] VALUES = values();

            public static Type valueOf(
                    com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != getDescriptor()) {
                    throw new java.lang.IllegalArgumentException(
                            "EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private final int value;

            private Type(int value) {
                this.value = value;
            }

            // @@protoc_insertion_point(enum_scope:Peer.Type)
        }

        public interface LocRibFlagsOrBuilder extends
                // @@protoc_insertion_point(interface_extends:Peer.LocRibFlags)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>bool filtered = 1;</code>
             * @return The filtered.
             */
            boolean getFiltered();
        }
        /**
         * Protobuf type {@code Peer.LocRibFlags}
         */
        public static final class LocRibFlags extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:Peer.LocRibFlags)
                LocRibFlagsOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use LocRibFlags.newBuilder() to construct.
            private LocRibFlags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private LocRibFlags() {
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new LocRibFlags();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_LocRibFlags_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_LocRibFlags_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder.class);
            }

            public static final int FILTERED_FIELD_NUMBER = 1;
            private boolean filtered_ = false;
            /**
             * <code>bool filtered = 1;</code>
             * @return The filtered.
             */
            @java.lang.Override
            public boolean getFiltered() {
                return filtered_;
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (filtered_ != false) {
                    output.writeBool(1, filtered_);
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (filtered_ != false) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeBoolSize(1, filtered_);
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) obj;

                if (getFiltered()
                        != other.getFiltered()) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                hash = (37 * hash) + FILTERED_FIELD_NUMBER;
                hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
                        getFiltered());
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code Peer.LocRibFlags}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:Peer.LocRibFlags)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_LocRibFlags_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_LocRibFlags_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.newBuilder()
                private Builder() {

                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);

                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    filtered_ = false;
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_LocRibFlags_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags result) {
                    int from_bitField0_ = bitField0_;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.filtered_ = filtered_;
                    }
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance()) return this;
                    if (other.getFiltered() != false) {
                        setFiltered(other.getFiltered());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 8: {
                                    filtered_ = input.readBool();
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 8
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private boolean filtered_ ;
                /**
                 * <code>bool filtered = 1;</code>
                 * @return The filtered.
                 */
                @java.lang.Override
                public boolean getFiltered() {
                    return filtered_;
                }
                /**
                 * <code>bool filtered = 1;</code>
                 * @param value The filtered to set.
                 * @return This builder for chaining.
                 */
                public Builder setFiltered(boolean value) {

                    filtered_ = value;
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>bool filtered = 1;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearFiltered() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    filtered_ = false;
                    onChanged();
                    return this;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:Peer.LocRibFlags)
            }

            // @@protoc_insertion_point(class_scope:Peer.LocRibFlags)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<LocRibFlags>
                    PARSER = new com.google.protobuf.AbstractParser<LocRibFlags>() {
                @java.lang.Override
                public LocRibFlags parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<LocRibFlags> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<LocRibFlags> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        public interface PeerFlagsOrBuilder extends
                // @@protoc_insertion_point(interface_extends:Peer.PeerFlags)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
             * @return The enum numeric value on the wire for ipVersion.
             */
            int getIpVersionValue();
            /**
             * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
             * @return The ipVersion.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion getIpVersion();

            /**
             * <code>.Peer.PeerFlags.Policy policy = 2;</code>
             * @return The enum numeric value on the wire for policy.
             */
            int getPolicyValue();
            /**
             * <code>.Peer.PeerFlags.Policy policy = 2;</code>
             * @return The policy.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy getPolicy();

            /**
             * <code>bool legacy_as_path = 3;</code>
             * @return The legacyAsPath.
             */
            boolean getLegacyAsPath();

            /**
             * <code>bool adjIn = 4;</code>
             * @return The adjIn.
             */
            boolean getAdjIn();
        }
        /**
         * Protobuf type {@code Peer.PeerFlags}
         */
        public static final class PeerFlags extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:Peer.PeerFlags)
                PeerFlagsOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use PeerFlags.newBuilder() to construct.
            private PeerFlags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private PeerFlags() {
                ipVersion_ = 0;
                policy_ = 0;
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new PeerFlags();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_PeerFlags_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_PeerFlags_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder.class);
            }

            /**
             * Protobuf enum {@code Peer.PeerFlags.IpVersion}
             */
            public enum IpVersion
                    implements com.google.protobuf.ProtocolMessageEnum {
                /**
                 * <code>IP_V4 = 0;</code>
                 */
                IP_V4(0),
                /**
                 * <code>IP_V6 = 1;</code>
                 */
                IP_V6(1),
                UNRECOGNIZED(-1),
                ;

                /**
                 * <code>IP_V4 = 0;</code>
                 */
                public static final int IP_V4_VALUE = 0;
                /**
                 * <code>IP_V6 = 1;</code>
                 */
                public static final int IP_V6_VALUE = 1;


                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalArgumentException(
                                "Can't get the number of an unknown enum value.");
                    }
                    return value;
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 * @deprecated Use {@link #forNumber(int)} instead.
                 */
                @java.lang.Deprecated
                public static IpVersion valueOf(int value) {
                    return forNumber(value);
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 */
                public static IpVersion forNumber(int value) {
                    switch (value) {
                        case 0: return IP_V4;
                        case 1: return IP_V6;
                        default: return null;
                    }
                }

                public static com.google.protobuf.Internal.EnumLiteMap<IpVersion>
                internalGetValueMap() {
                    return internalValueMap;
                }
                private static final com.google.protobuf.Internal.EnumLiteMap<
                        IpVersion> internalValueMap =
                        new com.google.protobuf.Internal.EnumLiteMap<IpVersion>() {
                            public IpVersion findValueByNumber(int number) {
                                return IpVersion.forNumber(number);
                            }
                        };

                public final com.google.protobuf.Descriptors.EnumValueDescriptor
                getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalStateException(
                                "Can't get the descriptor of an unrecognized enum value.");
                    }
                    return getDescriptor().getValues().get(ordinal());
                }
                public final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptorForType() {
                    return getDescriptor();
                }
                public static final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDescriptor().getEnumTypes().get(0);
                }

                private static final IpVersion[] VALUES = values();

                public static IpVersion valueOf(
                        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != getDescriptor()) {
                        throw new java.lang.IllegalArgumentException(
                                "EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private final int value;

                private IpVersion(int value) {
                    this.value = value;
                }

                // @@protoc_insertion_point(enum_scope:Peer.PeerFlags.IpVersion)
            }

            /**
             * Protobuf enum {@code Peer.PeerFlags.Policy}
             */
            public enum Policy
                    implements com.google.protobuf.ProtocolMessageEnum {
                /**
                 * <code>PRE_POLICY = 0;</code>
                 */
                PRE_POLICY(0),
                /**
                 * <code>POST_POLICY = 1;</code>
                 */
                POST_POLICY(1),
                UNRECOGNIZED(-1),
                ;

                /**
                 * <code>PRE_POLICY = 0;</code>
                 */
                public static final int PRE_POLICY_VALUE = 0;
                /**
                 * <code>POST_POLICY = 1;</code>
                 */
                public static final int POST_POLICY_VALUE = 1;


                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalArgumentException(
                                "Can't get the number of an unknown enum value.");
                    }
                    return value;
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 * @deprecated Use {@link #forNumber(int)} instead.
                 */
                @java.lang.Deprecated
                public static Policy valueOf(int value) {
                    return forNumber(value);
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 */
                public static Policy forNumber(int value) {
                    switch (value) {
                        case 0: return PRE_POLICY;
                        case 1: return POST_POLICY;
                        default: return null;
                    }
                }

                public static com.google.protobuf.Internal.EnumLiteMap<Policy>
                internalGetValueMap() {
                    return internalValueMap;
                }
                private static final com.google.protobuf.Internal.EnumLiteMap<
                        Policy> internalValueMap =
                        new com.google.protobuf.Internal.EnumLiteMap<Policy>() {
                            public Policy findValueByNumber(int number) {
                                return Policy.forNumber(number);
                            }
                        };

                public final com.google.protobuf.Descriptors.EnumValueDescriptor
                getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalStateException(
                                "Can't get the descriptor of an unrecognized enum value.");
                    }
                    return getDescriptor().getValues().get(ordinal());
                }
                public final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptorForType() {
                    return getDescriptor();
                }
                public static final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDescriptor().getEnumTypes().get(1);
                }

                private static final Policy[] VALUES = values();

                public static Policy valueOf(
                        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != getDescriptor()) {
                        throw new java.lang.IllegalArgumentException(
                                "EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private final int value;

                private Policy(int value) {
                    this.value = value;
                }

                // @@protoc_insertion_point(enum_scope:Peer.PeerFlags.Policy)
            }

            public static final int IP_VERSION_FIELD_NUMBER = 1;
            private int ipVersion_ = 0;
            /**
             * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
             * @return The enum numeric value on the wire for ipVersion.
             */
            @java.lang.Override public int getIpVersionValue() {
                return ipVersion_;
            }
            /**
             * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
             * @return The ipVersion.
             */
            @java.lang.Override public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion getIpVersion() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.forNumber(ipVersion_);
                return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.UNRECOGNIZED : result;
            }

            public static final int POLICY_FIELD_NUMBER = 2;
            private int policy_ = 0;
            /**
             * <code>.Peer.PeerFlags.Policy policy = 2;</code>
             * @return The enum numeric value on the wire for policy.
             */
            @java.lang.Override public int getPolicyValue() {
                return policy_;
            }
            /**
             * <code>.Peer.PeerFlags.Policy policy = 2;</code>
             * @return The policy.
             */
            @java.lang.Override public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy getPolicy() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.forNumber(policy_);
                return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.UNRECOGNIZED : result;
            }

            public static final int LEGACY_AS_PATH_FIELD_NUMBER = 3;
            private boolean legacyAsPath_ = false;
            /**
             * <code>bool legacy_as_path = 3;</code>
             * @return The legacyAsPath.
             */
            @java.lang.Override
            public boolean getLegacyAsPath() {
                return legacyAsPath_;
            }

            public static final int ADJIN_FIELD_NUMBER = 4;
            private boolean adjIn_ = false;
            /**
             * <code>bool adjIn = 4;</code>
             * @return The adjIn.
             */
            @java.lang.Override
            public boolean getAdjIn() {
                return adjIn_;
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (ipVersion_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.IP_V4.getNumber()) {
                    output.writeEnum(1, ipVersion_);
                }
                if (policy_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.PRE_POLICY.getNumber()) {
                    output.writeEnum(2, policy_);
                }
                if (legacyAsPath_ != false) {
                    output.writeBool(3, legacyAsPath_);
                }
                if (adjIn_ != false) {
                    output.writeBool(4, adjIn_);
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (ipVersion_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.IP_V4.getNumber()) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeEnumSize(1, ipVersion_);
                }
                if (policy_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.PRE_POLICY.getNumber()) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeEnumSize(2, policy_);
                }
                if (legacyAsPath_ != false) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeBoolSize(3, legacyAsPath_);
                }
                if (adjIn_ != false) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeBoolSize(4, adjIn_);
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) obj;

                if (ipVersion_ != other.ipVersion_) return false;
                if (policy_ != other.policy_) return false;
                if (getLegacyAsPath()
                        != other.getLegacyAsPath()) return false;
                if (getAdjIn()
                        != other.getAdjIn()) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                hash = (37 * hash) + IP_VERSION_FIELD_NUMBER;
                hash = (53 * hash) + ipVersion_;
                hash = (37 * hash) + POLICY_FIELD_NUMBER;
                hash = (53 * hash) + policy_;
                hash = (37 * hash) + LEGACY_AS_PATH_FIELD_NUMBER;
                hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
                        getLegacyAsPath());
                hash = (37 * hash) + ADJIN_FIELD_NUMBER;
                hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
                        getAdjIn());
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code Peer.PeerFlags}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:Peer.PeerFlags)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_PeerFlags_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_PeerFlags_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.newBuilder()
                private Builder() {

                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);

                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    ipVersion_ = 0;
                    policy_ = 0;
                    legacyAsPath_ = false;
                    adjIn_ = false;
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_PeerFlags_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags result) {
                    int from_bitField0_ = bitField0_;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.ipVersion_ = ipVersion_;
                    }
                    if (((from_bitField0_ & 0x00000002) != 0)) {
                        result.policy_ = policy_;
                    }
                    if (((from_bitField0_ & 0x00000004) != 0)) {
                        result.legacyAsPath_ = legacyAsPath_;
                    }
                    if (((from_bitField0_ & 0x00000008) != 0)) {
                        result.adjIn_ = adjIn_;
                    }
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance()) return this;
                    if (other.ipVersion_ != 0) {
                        setIpVersionValue(other.getIpVersionValue());
                    }
                    if (other.policy_ != 0) {
                        setPolicyValue(other.getPolicyValue());
                    }
                    if (other.getLegacyAsPath() != false) {
                        setLegacyAsPath(other.getLegacyAsPath());
                    }
                    if (other.getAdjIn() != false) {
                        setAdjIn(other.getAdjIn());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 8: {
                                    ipVersion_ = input.readEnum();
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 8
                                case 16: {
                                    policy_ = input.readEnum();
                                    bitField0_ |= 0x00000002;
                                    break;
                                } // case 16
                                case 24: {
                                    legacyAsPath_ = input.readBool();
                                    bitField0_ |= 0x00000004;
                                    break;
                                } // case 24
                                case 32: {
                                    adjIn_ = input.readBool();
                                    bitField0_ |= 0x00000008;
                                    break;
                                } // case 32
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private int ipVersion_ = 0;
                /**
                 * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
                 * @return The enum numeric value on the wire for ipVersion.
                 */
                @java.lang.Override public int getIpVersionValue() {
                    return ipVersion_;
                }
                /**
                 * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
                 * @param value The enum numeric value on the wire for ipVersion to set.
                 * @return This builder for chaining.
                 */
                public Builder setIpVersionValue(int value) {
                    ipVersion_ = value;
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
                 * @return The ipVersion.
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion getIpVersion() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.forNumber(ipVersion_);
                    return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion.UNRECOGNIZED : result;
                }
                /**
                 * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
                 * @param value The ipVersion to set.
                 * @return This builder for chaining.
                 */
                public Builder setIpVersion(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.IpVersion value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    bitField0_ |= 0x00000001;
                    ipVersion_ = value.getNumber();
                    onChanged();
                    return this;
                }
                /**
                 * <code>.Peer.PeerFlags.IpVersion ip_version = 1;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearIpVersion() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    ipVersion_ = 0;
                    onChanged();
                    return this;
                }

                private int policy_ = 0;
                /**
                 * <code>.Peer.PeerFlags.Policy policy = 2;</code>
                 * @return The enum numeric value on the wire for policy.
                 */
                @java.lang.Override public int getPolicyValue() {
                    return policy_;
                }
                /**
                 * <code>.Peer.PeerFlags.Policy policy = 2;</code>
                 * @param value The enum numeric value on the wire for policy to set.
                 * @return This builder for chaining.
                 */
                public Builder setPolicyValue(int value) {
                    policy_ = value;
                    bitField0_ |= 0x00000002;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.Peer.PeerFlags.Policy policy = 2;</code>
                 * @return The policy.
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy getPolicy() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.forNumber(policy_);
                    return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy.UNRECOGNIZED : result;
                }
                /**
                 * <code>.Peer.PeerFlags.Policy policy = 2;</code>
                 * @param value The policy to set.
                 * @return This builder for chaining.
                 */
                public Builder setPolicy(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Policy value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    bitField0_ |= 0x00000002;
                    policy_ = value.getNumber();
                    onChanged();
                    return this;
                }
                /**
                 * <code>.Peer.PeerFlags.Policy policy = 2;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearPolicy() {
                    bitField0_ = (bitField0_ & ~0x00000002);
                    policy_ = 0;
                    onChanged();
                    return this;
                }

                private boolean legacyAsPath_ ;
                /**
                 * <code>bool legacy_as_path = 3;</code>
                 * @return The legacyAsPath.
                 */
                @java.lang.Override
                public boolean getLegacyAsPath() {
                    return legacyAsPath_;
                }
                /**
                 * <code>bool legacy_as_path = 3;</code>
                 * @param value The legacyAsPath to set.
                 * @return This builder for chaining.
                 */
                public Builder setLegacyAsPath(boolean value) {

                    legacyAsPath_ = value;
                    bitField0_ |= 0x00000004;
                    onChanged();
                    return this;
                }
                /**
                 * <code>bool legacy_as_path = 3;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearLegacyAsPath() {
                    bitField0_ = (bitField0_ & ~0x00000004);
                    legacyAsPath_ = false;
                    onChanged();
                    return this;
                }

                private boolean adjIn_ ;
                /**
                 * <code>bool adjIn = 4;</code>
                 * @return The adjIn.
                 */
                @java.lang.Override
                public boolean getAdjIn() {
                    return adjIn_;
                }
                /**
                 * <code>bool adjIn = 4;</code>
                 * @param value The adjIn to set.
                 * @return This builder for chaining.
                 */
                public Builder setAdjIn(boolean value) {

                    adjIn_ = value;
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return this;
                }
                /**
                 * <code>bool adjIn = 4;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearAdjIn() {
                    bitField0_ = (bitField0_ & ~0x00000008);
                    adjIn_ = false;
                    onChanged();
                    return this;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:Peer.PeerFlags)
            }

            // @@protoc_insertion_point(class_scope:Peer.PeerFlags)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<PeerFlags>
                    PARSER = new com.google.protobuf.AbstractParser<PeerFlags>() {
                @java.lang.Override
                public PeerFlags parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<PeerFlags> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<PeerFlags> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        private int bitField0_;
        private int flagsCase_ = 0;
        @SuppressWarnings("serial")
        private java.lang.Object flags_;
        public enum FlagsCase
                implements com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
            PEERFLAGS(2),
            LOCRIBFLAGS(3),
            FLAGS_NOT_SET(0);
            private final int value;
            private FlagsCase(int value) {
                this.value = value;
            }
            /**
             * @param value The number of the enum to look for.
             * @return The enum associated with the given number.
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static FlagsCase valueOf(int value) {
                return forNumber(value);
            }

            public static FlagsCase forNumber(int value) {
                switch (value) {
                    case 2: return PEERFLAGS;
                    case 3: return LOCRIBFLAGS;
                    case 0: return FLAGS_NOT_SET;
                    default: return null;
                }
            }
            public int getNumber() {
                return this.value;
            }
        };

        public FlagsCase
        getFlagsCase() {
            return FlagsCase.forNumber(
                    flagsCase_);
        }

        public static final int TYPE_FIELD_NUMBER = 1;
        private int type_ = 0;
        /**
         * <code>.Peer.Type type = 1;</code>
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override public int getTypeValue() {
            return type_;
        }
        /**
         * <code>.Peer.Type type = 1;</code>
         * @return The type.
         */
        @java.lang.Override public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type getType() {
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.forNumber(type_);
            return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.UNRECOGNIZED : result;
        }

        public static final int PEERFLAGS_FIELD_NUMBER = 2;
        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         * @return Whether the peerFlags field is set.
         */
        @java.lang.Override
        public boolean hasPeerFlags() {
            return flagsCase_ == 2;
        }
        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         * @return The peerFlags.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getPeerFlags() {
            if (flagsCase_ == 2) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
        }
        /**
         * <code>.Peer.PeerFlags peerFlags = 2;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder getPeerFlagsOrBuilder() {
            if (flagsCase_ == 2) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
        }

        public static final int LOCRIBFLAGS_FIELD_NUMBER = 3;
        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         * @return Whether the locRibFlags field is set.
         */
        @java.lang.Override
        public boolean hasLocRibFlags() {
            return flagsCase_ == 3;
        }
        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         * @return The locRibFlags.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getLocRibFlags() {
            if (flagsCase_ == 3) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
        }
        /**
         * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder getLocRibFlagsOrBuilder() {
            if (flagsCase_ == 3) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
        }

        public static final int DISTINGUISHER_FIELD_NUMBER = 4;
        private long distinguisher_ = 0L;
        /**
         * <code>fixed64 distinguisher = 4;</code>
         * @return The distinguisher.
         */
        @java.lang.Override
        public long getDistinguisher() {
            return distinguisher_;
        }

        public static final int ADDRESS_FIELD_NUMBER = 5;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
        /**
         * <code>.IpAddress address = 5;</code>
         * @return Whether the address field is set.
         */
        @java.lang.Override
        public boolean hasAddress() {
            return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>.IpAddress address = 5;</code>
         * @return The address.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
            return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
        }
        /**
         * <code>.IpAddress address = 5;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
            return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
        }

        public static final int AS_FIELD_NUMBER = 6;
        private int as_ = 0;
        /**
         * <code>fixed32 as = 6;</code>
         * @return The as.
         */
        @java.lang.Override
        public int getAs() {
            return as_;
        }

        public static final int ID_FIELD_NUMBER = 7;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress id_;
        /**
         * <code>.IpAddress id = 7;</code>
         * @return Whether the id field is set.
         */
        @java.lang.Override
        public boolean hasId() {
            return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>.IpAddress id = 7;</code>
         * @return The id.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId() {
            return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
        }
        /**
         * <code>.IpAddress id = 7;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder() {
            return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
        }

        public static final int TIMESTAMP_FIELD_NUMBER = 8;
        private com.google.protobuf.Timestamp timestamp_;
        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         * @return Whether the timestamp field is set.
         */
        @java.lang.Override
        public boolean hasTimestamp() {
            return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         * @return The timestamp.
         */
        @java.lang.Override
        public com.google.protobuf.Timestamp getTimestamp() {
            return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
        }
        /**
         * <code>.google.protobuf.Timestamp timestamp = 8;</code>
         */
        @java.lang.Override
        public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
            return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
        }

        public static final int HOSTNAME_FIELD_NUMBER = 15;
        @SuppressWarnings("serial")
        private volatile java.lang.Object hostname_ = "";
        /**
         * <code>string hostname = 15;</code>
         * @return The hostname.
         */
        @java.lang.Override
        public java.lang.String getHostname() {
            java.lang.Object ref = hostname_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                hostname_ = s;
                return s;
            }
        }
        /**
         * <code>string hostname = 15;</code>
         * @return The bytes for hostname.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getHostnameBytes() {
            java.lang.Object ref = hostname_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                hostname_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (type_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.GLOBAL_INSTANCE.getNumber()) {
                output.writeEnum(1, type_);
            }
            if (flagsCase_ == 2) {
                output.writeMessage(2, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_);
            }
            if (flagsCase_ == 3) {
                output.writeMessage(3, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_);
            }
            if (distinguisher_ != 0L) {
                output.writeFixed64(4, distinguisher_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                output.writeMessage(5, getAddress());
            }
            if (as_ != 0) {
                output.writeFixed32(6, as_);
            }
            if (((bitField0_ & 0x00000002) != 0)) {
                output.writeMessage(7, getId());
            }
            if (((bitField0_ & 0x00000004) != 0)) {
                output.writeMessage(8, getTimestamp());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 15, hostname_);
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (type_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.GLOBAL_INSTANCE.getNumber()) {
                size += com.google.protobuf.CodedOutputStream
                        .computeEnumSize(1, type_);
            }
            if (flagsCase_ == 2) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(2, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_);
            }
            if (flagsCase_ == 3) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(3, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_);
            }
            if (distinguisher_ != 0L) {
                size += com.google.protobuf.CodedOutputStream
                        .computeFixed64Size(4, distinguisher_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(5, getAddress());
            }
            if (as_ != 0) {
                size += com.google.protobuf.CodedOutputStream
                        .computeFixed32Size(6, as_);
            }
            if (((bitField0_ & 0x00000002) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(7, getId());
            }
            if (((bitField0_ & 0x00000004) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(8, getTimestamp());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, hostname_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer) obj;

            if (type_ != other.type_) return false;
            if (getDistinguisher()
                    != other.getDistinguisher()) return false;
            if (hasAddress() != other.hasAddress()) return false;
            if (hasAddress()) {
                if (!getAddress()
                        .equals(other.getAddress())) return false;
            }
            if (getAs()
                    != other.getAs()) return false;
            if (hasId() != other.hasId()) return false;
            if (hasId()) {
                if (!getId()
                        .equals(other.getId())) return false;
            }
            if (hasTimestamp() != other.hasTimestamp()) return false;
            if (hasTimestamp()) {
                if (!getTimestamp()
                        .equals(other.getTimestamp())) return false;
            }
            if (!getHostname()
                    .equals(other.getHostname())) return false;
            if (!getFlagsCase().equals(other.getFlagsCase())) return false;
            switch (flagsCase_) {
                case 2:
                    if (!getPeerFlags()
                            .equals(other.getPeerFlags())) return false;
                    break;
                case 3:
                    if (!getLocRibFlags()
                            .equals(other.getLocRibFlags())) return false;
                    break;
                case 0:
                default:
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + TYPE_FIELD_NUMBER;
            hash = (53 * hash) + type_;
            hash = (37 * hash) + DISTINGUISHER_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
                    getDistinguisher());
            if (hasAddress()) {
                hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
                hash = (53 * hash) + getAddress().hashCode();
            }
            hash = (37 * hash) + AS_FIELD_NUMBER;
            hash = (53 * hash) + getAs();
            if (hasId()) {
                hash = (37 * hash) + ID_FIELD_NUMBER;
                hash = (53 * hash) + getId().hashCode();
            }
            if (hasTimestamp()) {
                hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
                hash = (53 * hash) + getTimestamp().hashCode();
            }
            hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
            hash = (53 * hash) + getHostname().hashCode();
            switch (flagsCase_) {
                case 2:
                    hash = (37 * hash) + PEERFLAGS_FIELD_NUMBER;
                    hash = (53 * hash) + getPeerFlags().hashCode();
                    break;
                case 3:
                    hash = (37 * hash) + LOCRIBFLAGS_FIELD_NUMBER;
                    hash = (53 * hash) + getLocRibFlags().hashCode();
                    break;
                case 0:
                default:
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code Peer}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:Peer)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                    getAddressFieldBuilder();
                    getIdFieldBuilder();
                    getTimestampFieldBuilder();
                }
            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                type_ = 0;
                if (peerFlagsBuilder_ != null) {
                    peerFlagsBuilder_.clear();
                }
                if (locRibFlagsBuilder_ != null) {
                    locRibFlagsBuilder_.clear();
                }
                distinguisher_ = 0L;
                address_ = null;
                if (addressBuilder_ != null) {
                    addressBuilder_.dispose();
                    addressBuilder_ = null;
                }
                as_ = 0;
                id_ = null;
                if (idBuilder_ != null) {
                    idBuilder_.dispose();
                    idBuilder_ = null;
                }
                timestamp_ = null;
                if (timestampBuilder_ != null) {
                    timestampBuilder_.dispose();
                    timestampBuilder_ = null;
                }
                hostname_ = "";
                flagsCase_ = 0;
                flags_ = null;
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_Peer_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                buildPartialOneofs(result);
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                    result.type_ = type_;
                }
                if (((from_bitField0_ & 0x00000008) != 0)) {
                    result.distinguisher_ = distinguisher_;
                }
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000010) != 0)) {
                    result.address_ = addressBuilder_ == null
                            ? address_
                            : addressBuilder_.build();
                    to_bitField0_ |= 0x00000001;
                }
                if (((from_bitField0_ & 0x00000020) != 0)) {
                    result.as_ = as_;
                }
                if (((from_bitField0_ & 0x00000040) != 0)) {
                    result.id_ = idBuilder_ == null
                            ? id_
                            : idBuilder_.build();
                    to_bitField0_ |= 0x00000002;
                }
                if (((from_bitField0_ & 0x00000080) != 0)) {
                    result.timestamp_ = timestampBuilder_ == null
                            ? timestamp_
                            : timestampBuilder_.build();
                    to_bitField0_ |= 0x00000004;
                }
                if (((from_bitField0_ & 0x00000100) != 0)) {
                    result.hostname_ = hostname_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            private void buildPartialOneofs(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer result) {
                result.flagsCase_ = flagsCase_;
                result.flags_ = this.flags_;
                if (flagsCase_ == 2 &&
                        peerFlagsBuilder_ != null) {
                    result.flags_ = peerFlagsBuilder_.build();
                }
                if (flagsCase_ == 3 &&
                        locRibFlagsBuilder_ != null) {
                    result.flags_ = locRibFlagsBuilder_.build();
                }
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance()) return this;
                if (other.type_ != 0) {
                    setTypeValue(other.getTypeValue());
                }
                if (other.getDistinguisher() != 0L) {
                    setDistinguisher(other.getDistinguisher());
                }
                if (other.hasAddress()) {
                    mergeAddress(other.getAddress());
                }
                if (other.getAs() != 0) {
                    setAs(other.getAs());
                }
                if (other.hasId()) {
                    mergeId(other.getId());
                }
                if (other.hasTimestamp()) {
                    mergeTimestamp(other.getTimestamp());
                }
                if (!other.getHostname().isEmpty()) {
                    hostname_ = other.hostname_;
                    bitField0_ |= 0x00000100;
                    onChanged();
                }
                switch (other.getFlagsCase()) {
                    case PEERFLAGS: {
                        mergePeerFlags(other.getPeerFlags());
                        break;
                    }
                    case LOCRIBFLAGS: {
                        mergeLocRibFlags(other.getLocRibFlags());
                        break;
                    }
                    case FLAGS_NOT_SET: {
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 8: {
                                type_ = input.readEnum();
                                bitField0_ |= 0x00000001;
                                break;
                            } // case 8
                            case 18: {
                                input.readMessage(
                                        getPeerFlagsFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                flagsCase_ = 2;
                                break;
                            } // case 18
                            case 26: {
                                input.readMessage(
                                        getLocRibFlagsFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                flagsCase_ = 3;
                                break;
                            } // case 26
                            case 33: {
                                distinguisher_ = input.readFixed64();
                                bitField0_ |= 0x00000008;
                                break;
                            } // case 33
                            case 42: {
                                input.readMessage(
                                        getAddressFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000010;
                                break;
                            } // case 42
                            case 53: {
                                as_ = input.readFixed32();
                                bitField0_ |= 0x00000020;
                                break;
                            } // case 53
                            case 58: {
                                input.readMessage(
                                        getIdFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000040;
                                break;
                            } // case 58
                            case 66: {
                                input.readMessage(
                                        getTimestampFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000080;
                                break;
                            } // case 66
                            case 122: {
                                hostname_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000100;
                                break;
                            } // case 122
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int flagsCase_ = 0;
            private java.lang.Object flags_;
            public FlagsCase
            getFlagsCase() {
                return FlagsCase.forNumber(
                        flagsCase_);
            }

            public Builder clearFlags() {
                flagsCase_ = 0;
                flags_ = null;
                onChanged();
                return this;
            }

            private int bitField0_;

            private int type_ = 0;
            /**
             * <code>.Peer.Type type = 1;</code>
             * @return The enum numeric value on the wire for type.
             */
            @java.lang.Override public int getTypeValue() {
                return type_;
            }
            /**
             * <code>.Peer.Type type = 1;</code>
             * @param value The enum numeric value on the wire for type to set.
             * @return This builder for chaining.
             */
            public Builder setTypeValue(int value) {
                type_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>.Peer.Type type = 1;</code>
             * @return The type.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type getType() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.forNumber(type_);
                return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type.UNRECOGNIZED : result;
            }
            /**
             * <code>.Peer.Type type = 1;</code>
             * @param value The type to set.
             * @return This builder for chaining.
             */
            public Builder setType(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Type value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                bitField0_ |= 0x00000001;
                type_ = value.getNumber();
                onChanged();
                return this;
            }
            /**
             * <code>.Peer.Type type = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearType() {
                bitField0_ = (bitField0_ & ~0x00000001);
                type_ = 0;
                onChanged();
                return this;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder> peerFlagsBuilder_;
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             * @return Whether the peerFlags field is set.
             */
            @java.lang.Override
            public boolean hasPeerFlags() {
                return flagsCase_ == 2;
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             * @return The peerFlags.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags getPeerFlags() {
                if (peerFlagsBuilder_ == null) {
                    if (flagsCase_ == 2) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
                } else {
                    if (flagsCase_ == 2) {
                        return peerFlagsBuilder_.getMessage();
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
                }
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            public Builder setPeerFlags(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags value) {
                if (peerFlagsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    flags_ = value;
                    onChanged();
                } else {
                    peerFlagsBuilder_.setMessage(value);
                }
                flagsCase_ = 2;
                return this;
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            public Builder setPeerFlags(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder builderForValue) {
                if (peerFlagsBuilder_ == null) {
                    flags_ = builderForValue.build();
                    onChanged();
                } else {
                    peerFlagsBuilder_.setMessage(builderForValue.build());
                }
                flagsCase_ = 2;
                return this;
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            public Builder mergePeerFlags(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags value) {
                if (peerFlagsBuilder_ == null) {
                    if (flagsCase_ == 2 &&
                            flags_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance()) {
                        flags_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.newBuilder((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        flags_ = value;
                    }
                    onChanged();
                } else {
                    if (flagsCase_ == 2) {
                        peerFlagsBuilder_.mergeFrom(value);
                    } else {
                        peerFlagsBuilder_.setMessage(value);
                    }
                }
                flagsCase_ = 2;
                return this;
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            public Builder clearPeerFlags() {
                if (peerFlagsBuilder_ == null) {
                    if (flagsCase_ == 2) {
                        flagsCase_ = 0;
                        flags_ = null;
                        onChanged();
                    }
                } else {
                    if (flagsCase_ == 2) {
                        flagsCase_ = 0;
                        flags_ = null;
                    }
                    peerFlagsBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder getPeerFlagsBuilder() {
                return getPeerFlagsFieldBuilder().getBuilder();
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder getPeerFlagsOrBuilder() {
                if ((flagsCase_ == 2) && (peerFlagsBuilder_ != null)) {
                    return peerFlagsBuilder_.getMessageOrBuilder();
                } else {
                    if (flagsCase_ == 2) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
                }
            }
            /**
             * <code>.Peer.PeerFlags peerFlags = 2;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder>
            getPeerFlagsFieldBuilder() {
                if (peerFlagsBuilder_ == null) {
                    if (!(flagsCase_ == 2)) {
                        flags_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.getDefaultInstance();
                    }
                    peerFlagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlagsOrBuilder>(
                            (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.PeerFlags) flags_,
                            getParentForChildren(),
                            isClean());
                    flags_ = null;
                }
                flagsCase_ = 2;
                onChanged();
                return peerFlagsBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder> locRibFlagsBuilder_;
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             * @return Whether the locRibFlags field is set.
             */
            @java.lang.Override
            public boolean hasLocRibFlags() {
                return flagsCase_ == 3;
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             * @return The locRibFlags.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags getLocRibFlags() {
                if (locRibFlagsBuilder_ == null) {
                    if (flagsCase_ == 3) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
                } else {
                    if (flagsCase_ == 3) {
                        return locRibFlagsBuilder_.getMessage();
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
                }
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            public Builder setLocRibFlags(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags value) {
                if (locRibFlagsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    flags_ = value;
                    onChanged();
                } else {
                    locRibFlagsBuilder_.setMessage(value);
                }
                flagsCase_ = 3;
                return this;
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            public Builder setLocRibFlags(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder builderForValue) {
                if (locRibFlagsBuilder_ == null) {
                    flags_ = builderForValue.build();
                    onChanged();
                } else {
                    locRibFlagsBuilder_.setMessage(builderForValue.build());
                }
                flagsCase_ = 3;
                return this;
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            public Builder mergeLocRibFlags(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags value) {
                if (locRibFlagsBuilder_ == null) {
                    if (flagsCase_ == 3 &&
                            flags_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance()) {
                        flags_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.newBuilder((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        flags_ = value;
                    }
                    onChanged();
                } else {
                    if (flagsCase_ == 3) {
                        locRibFlagsBuilder_.mergeFrom(value);
                    } else {
                        locRibFlagsBuilder_.setMessage(value);
                    }
                }
                flagsCase_ = 3;
                return this;
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            public Builder clearLocRibFlags() {
                if (locRibFlagsBuilder_ == null) {
                    if (flagsCase_ == 3) {
                        flagsCase_ = 0;
                        flags_ = null;
                        onChanged();
                    }
                } else {
                    if (flagsCase_ == 3) {
                        flagsCase_ = 0;
                        flags_ = null;
                    }
                    locRibFlagsBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder getLocRibFlagsBuilder() {
                return getLocRibFlagsFieldBuilder().getBuilder();
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder getLocRibFlagsOrBuilder() {
                if ((flagsCase_ == 3) && (locRibFlagsBuilder_ != null)) {
                    return locRibFlagsBuilder_.getMessageOrBuilder();
                } else {
                    if (flagsCase_ == 3) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
                }
            }
            /**
             * <code>.Peer.LocRibFlags locRibFlags = 3;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder>
            getLocRibFlagsFieldBuilder() {
                if (locRibFlagsBuilder_ == null) {
                    if (!(flagsCase_ == 3)) {
                        flags_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.getDefaultInstance();
                    }
                    locRibFlagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlagsOrBuilder>(
                            (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.LocRibFlags) flags_,
                            getParentForChildren(),
                            isClean());
                    flags_ = null;
                }
                flagsCase_ = 3;
                onChanged();
                return locRibFlagsBuilder_;
            }

            private long distinguisher_ ;
            /**
             * <code>fixed64 distinguisher = 4;</code>
             * @return The distinguisher.
             */
            @java.lang.Override
            public long getDistinguisher() {
                return distinguisher_;
            }
            /**
             * <code>fixed64 distinguisher = 4;</code>
             * @param value The distinguisher to set.
             * @return This builder for chaining.
             */
            public Builder setDistinguisher(long value) {

                distinguisher_ = value;
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }
            /**
             * <code>fixed64 distinguisher = 4;</code>
             * @return This builder for chaining.
             */
            public Builder clearDistinguisher() {
                bitField0_ = (bitField0_ & ~0x00000008);
                distinguisher_ = 0L;
                onChanged();
                return this;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> addressBuilder_;
            /**
             * <code>.IpAddress address = 5;</code>
             * @return Whether the address field is set.
             */
            public boolean hasAddress() {
                return ((bitField0_ & 0x00000010) != 0);
            }
            /**
             * <code>.IpAddress address = 5;</code>
             * @return The address.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
                if (addressBuilder_ == null) {
                    return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                } else {
                    return addressBuilder_.getMessage();
                }
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public Builder setAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (addressBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    address_ = value;
                } else {
                    addressBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public Builder setAddress(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                if (addressBuilder_ == null) {
                    address_ = builderForValue.build();
                } else {
                    addressBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public Builder mergeAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (addressBuilder_ == null) {
                    if (((bitField0_ & 0x00000010) != 0) &&
                            address_ != null &&
                            address_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                        getAddressBuilder().mergeFrom(value);
                    } else {
                        address_ = value;
                    }
                } else {
                    addressBuilder_.mergeFrom(value);
                }
                if (address_ != null) {
                    bitField0_ |= 0x00000010;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public Builder clearAddress() {
                bitField0_ = (bitField0_ & ~0x00000010);
                address_ = null;
                if (addressBuilder_ != null) {
                    addressBuilder_.dispose();
                    addressBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getAddressBuilder() {
                bitField0_ |= 0x00000010;
                onChanged();
                return getAddressFieldBuilder().getBuilder();
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
                if (addressBuilder_ != null) {
                    return addressBuilder_.getMessageOrBuilder();
                } else {
                    return address_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                }
            }
            /**
             * <code>.IpAddress address = 5;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
            getAddressFieldBuilder() {
                if (addressBuilder_ == null) {
                    addressBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                            getAddress(),
                            getParentForChildren(),
                            isClean());
                    address_ = null;
                }
                return addressBuilder_;
            }

            private int as_ ;
            /**
             * <code>fixed32 as = 6;</code>
             * @return The as.
             */
            @java.lang.Override
            public int getAs() {
                return as_;
            }
            /**
             * <code>fixed32 as = 6;</code>
             * @param value The as to set.
             * @return This builder for chaining.
             */
            public Builder setAs(int value) {

                as_ = value;
                bitField0_ |= 0x00000020;
                onChanged();
                return this;
            }
            /**
             * <code>fixed32 as = 6;</code>
             * @return This builder for chaining.
             */
            public Builder clearAs() {
                bitField0_ = (bitField0_ & ~0x00000020);
                as_ = 0;
                onChanged();
                return this;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress id_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> idBuilder_;
            /**
             * <code>.IpAddress id = 7;</code>
             * @return Whether the id field is set.
             */
            public boolean hasId() {
                return ((bitField0_ & 0x00000040) != 0);
            }
            /**
             * <code>.IpAddress id = 7;</code>
             * @return The id.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId() {
                if (idBuilder_ == null) {
                    return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
                } else {
                    return idBuilder_.getMessage();
                }
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public Builder setId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (idBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    id_ = value;
                } else {
                    idBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000040;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public Builder setId(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                if (idBuilder_ == null) {
                    id_ = builderForValue.build();
                } else {
                    idBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000040;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public Builder mergeId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (idBuilder_ == null) {
                    if (((bitField0_ & 0x00000040) != 0) &&
                            id_ != null &&
                            id_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                        getIdBuilder().mergeFrom(value);
                    } else {
                        id_ = value;
                    }
                } else {
                    idBuilder_.mergeFrom(value);
                }
                if (id_ != null) {
                    bitField0_ |= 0x00000040;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public Builder clearId() {
                bitField0_ = (bitField0_ & ~0x00000040);
                id_ = null;
                if (idBuilder_ != null) {
                    idBuilder_.dispose();
                    idBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getIdBuilder() {
                bitField0_ |= 0x00000040;
                onChanged();
                return getIdFieldBuilder().getBuilder();
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder() {
                if (idBuilder_ != null) {
                    return idBuilder_.getMessageOrBuilder();
                } else {
                    return id_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
                }
            }
            /**
             * <code>.IpAddress id = 7;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
            getIdFieldBuilder() {
                if (idBuilder_ == null) {
                    idBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                            getId(),
                            getParentForChildren(),
                            isClean());
                    id_ = null;
                }
                return idBuilder_;
            }

            private com.google.protobuf.Timestamp timestamp_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> timestampBuilder_;
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             * @return Whether the timestamp field is set.
             */
            public boolean hasTimestamp() {
                return ((bitField0_ & 0x00000080) != 0);
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             * @return The timestamp.
             */
            public com.google.protobuf.Timestamp getTimestamp() {
                if (timestampBuilder_ == null) {
                    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
                } else {
                    return timestampBuilder_.getMessage();
                }
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public Builder setTimestamp(com.google.protobuf.Timestamp value) {
                if (timestampBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    timestamp_ = value;
                } else {
                    timestampBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000080;
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public Builder setTimestamp(
                    com.google.protobuf.Timestamp.Builder builderForValue) {
                if (timestampBuilder_ == null) {
                    timestamp_ = builderForValue.build();
                } else {
                    timestampBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000080;
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
                if (timestampBuilder_ == null) {
                    if (((bitField0_ & 0x00000080) != 0) &&
                            timestamp_ != null &&
                            timestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
                        getTimestampBuilder().mergeFrom(value);
                    } else {
                        timestamp_ = value;
                    }
                } else {
                    timestampBuilder_.mergeFrom(value);
                }
                if (timestamp_ != null) {
                    bitField0_ |= 0x00000080;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public Builder clearTimestamp() {
                bitField0_ = (bitField0_ & ~0x00000080);
                timestamp_ = null;
                if (timestampBuilder_ != null) {
                    timestampBuilder_.dispose();
                    timestampBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
                bitField0_ |= 0x00000080;
                onChanged();
                return getTimestampFieldBuilder().getBuilder();
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
                if (timestampBuilder_ != null) {
                    return timestampBuilder_.getMessageOrBuilder();
                } else {
                    return timestamp_ == null ?
                            com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
                }
            }
            /**
             * <code>.google.protobuf.Timestamp timestamp = 8;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>
            getTimestampFieldBuilder() {
                if (timestampBuilder_ == null) {
                    timestampBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                            getTimestamp(),
                            getParentForChildren(),
                            isClean());
                    timestamp_ = null;
                }
                return timestampBuilder_;
            }

            private java.lang.Object hostname_ = "";
            /**
             * <code>string hostname = 15;</code>
             * @return The hostname.
             */
            public java.lang.String getHostname() {
                java.lang.Object ref = hostname_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    hostname_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string hostname = 15;</code>
             * @return The bytes for hostname.
             */
            public com.google.protobuf.ByteString
            getHostnameBytes() {
                java.lang.Object ref = hostname_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    hostname_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string hostname = 15;</code>
             * @param value The hostname to set.
             * @return This builder for chaining.
             */
            public Builder setHostname(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                hostname_ = value;
                bitField0_ |= 0x00000100;
                onChanged();
                return this;
            }
            /**
             * <code>string hostname = 15;</code>
             * @return This builder for chaining.
             */
            public Builder clearHostname() {
                hostname_ = getDefaultInstance().getHostname();
                bitField0_ = (bitField0_ & ~0x00000100);
                onChanged();
                return this;
            }
            /**
             * <code>string hostname = 15;</code>
             * @param value The bytes for hostname to set.
             * @return This builder for chaining.
             */
            public Builder setHostnameBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                hostname_ = value;
                bitField0_ |= 0x00000100;
                onChanged();
                return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:Peer)
        }

        // @@protoc_insertion_point(class_scope:Peer)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Peer>
                PARSER = new com.google.protobuf.AbstractParser<Peer>() {
            @java.lang.Override
            public Peer parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<Peer> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Peer> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface InitiationPacketOrBuilder extends
            // @@protoc_insertion_point(interface_extends:InitiationPacket)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>string sys_name = 1;</code>
         * @return The sysName.
         */
        java.lang.String getSysName();
        /**
         * <code>string sys_name = 1;</code>
         * @return The bytes for sysName.
         */
        com.google.protobuf.ByteString
        getSysNameBytes();

        /**
         * <code>repeated string sys_desc = 2;</code>
         * @return A list containing the sysDesc.
         */
        java.util.List<java.lang.String>
        getSysDescList();
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @return The count of sysDesc.
         */
        int getSysDescCount();
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @param index The index of the element to return.
         * @return The sysDesc at the given index.
         */
        java.lang.String getSysDesc(int index);
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @param index The index of the value to return.
         * @return The bytes of the sysDesc at the given index.
         */
        com.google.protobuf.ByteString
        getSysDescBytes(int index);

        /**
         * <code>repeated string message = 3;</code>
         * @return A list containing the message.
         */
        java.util.List<java.lang.String>
        getMessageList();
        /**
         * <code>repeated string message = 3;</code>
         * @return The count of message.
         */
        int getMessageCount();
        /**
         * <code>repeated string message = 3;</code>
         * @param index The index of the element to return.
         * @return The message at the given index.
         */
        java.lang.String getMessage(int index);
        /**
         * <code>repeated string message = 3;</code>
         * @param index The index of the value to return.
         * @return The bytes of the message at the given index.
         */
        com.google.protobuf.ByteString
        getMessageBytes(int index);

        /**
         * <code>repeated string admin_label = 4;</code>
         * @return A list containing the adminLabel.
         */
        java.util.List<java.lang.String>
        getAdminLabelList();
        /**
         * <code>repeated string admin_label = 4;</code>
         * @return The count of adminLabel.
         */
        int getAdminLabelCount();
        /**
         * <code>repeated string admin_label = 4;</code>
         * @param index The index of the element to return.
         * @return The adminLabel at the given index.
         */
        java.lang.String getAdminLabel(int index);
        /**
         * <code>repeated string admin_label = 4;</code>
         * @param index The index of the value to return.
         * @return The bytes of the adminLabel at the given index.
         */
        com.google.protobuf.ByteString
        getAdminLabelBytes(int index);

        /**
         * <code>.IpAddress bgpId = 65531;</code>
         * @return Whether the bgpId field is set.
         */
        boolean hasBgpId();
        /**
         * <code>.IpAddress bgpId = 65531;</code>
         * @return The bgpId.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getBgpId();
        /**
         * <code>.IpAddress bgpId = 65531;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getBgpIdOrBuilder();

        /**
         * <code>string hostname = 65535;</code>
         * @return The hostname.
         */
        java.lang.String getHostname();
        /**
         * <code>string hostname = 65535;</code>
         * @return The bytes for hostname.
         */
        com.google.protobuf.ByteString
        getHostnameBytes();
    }
    /**
     * Protobuf type {@code InitiationPacket}
     */
    public static final class InitiationPacket extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:InitiationPacket)
            InitiationPacketOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use InitiationPacket.newBuilder() to construct.
        private InitiationPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private InitiationPacket() {
            sysName_ = "";
            sysDesc_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            message_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            adminLabel_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            hostname_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new InitiationPacket();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_InitiationPacket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_InitiationPacket_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.Builder.class);
        }

        private int bitField0_;
        public static final int SYS_NAME_FIELD_NUMBER = 1;
        @SuppressWarnings("serial")
        private volatile java.lang.Object sysName_ = "";
        /**
         * <code>string sys_name = 1;</code>
         * @return The sysName.
         */
        @java.lang.Override
        public java.lang.String getSysName() {
            java.lang.Object ref = sysName_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                sysName_ = s;
                return s;
            }
        }
        /**
         * <code>string sys_name = 1;</code>
         * @return The bytes for sysName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getSysNameBytes() {
            java.lang.Object ref = sysName_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                sysName_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        public static final int SYS_DESC_FIELD_NUMBER = 2;
        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList sysDesc_ =
                com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @return A list containing the sysDesc.
         */
        public com.google.protobuf.ProtocolStringList
        getSysDescList() {
            return sysDesc_;
        }
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @return The count of sysDesc.
         */
        public int getSysDescCount() {
            return sysDesc_.size();
        }
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @param index The index of the element to return.
         * @return The sysDesc at the given index.
         */
        public java.lang.String getSysDesc(int index) {
            return sysDesc_.get(index);
        }
        /**
         * <code>repeated string sys_desc = 2;</code>
         * @param index The index of the value to return.
         * @return The bytes of the sysDesc at the given index.
         */
        public com.google.protobuf.ByteString
        getSysDescBytes(int index) {
            return sysDesc_.getByteString(index);
        }

        public static final int MESSAGE_FIELD_NUMBER = 3;
        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList message_ =
                com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         * <code>repeated string message = 3;</code>
         * @return A list containing the message.
         */
        public com.google.protobuf.ProtocolStringList
        getMessageList() {
            return message_;
        }
        /**
         * <code>repeated string message = 3;</code>
         * @return The count of message.
         */
        public int getMessageCount() {
            return message_.size();
        }
        /**
         * <code>repeated string message = 3;</code>
         * @param index The index of the element to return.
         * @return The message at the given index.
         */
        public java.lang.String getMessage(int index) {
            return message_.get(index);
        }
        /**
         * <code>repeated string message = 3;</code>
         * @param index The index of the value to return.
         * @return The bytes of the message at the given index.
         */
        public com.google.protobuf.ByteString
        getMessageBytes(int index) {
            return message_.getByteString(index);
        }

        public static final int ADMIN_LABEL_FIELD_NUMBER = 4;
        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList adminLabel_ =
                com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         * <code>repeated string admin_label = 4;</code>
         * @return A list containing the adminLabel.
         */
        public com.google.protobuf.ProtocolStringList
        getAdminLabelList() {
            return adminLabel_;
        }
        /**
         * <code>repeated string admin_label = 4;</code>
         * @return The count of adminLabel.
         */
        public int getAdminLabelCount() {
            return adminLabel_.size();
        }
        /**
         * <code>repeated string admin_label = 4;</code>
         * @param index The index of the element to return.
         * @return The adminLabel at the given index.
         */
        public java.lang.String getAdminLabel(int index) {
            return adminLabel_.get(index);
        }
        /**
         * <code>repeated string admin_label = 4;</code>
         * @param index The index of the value to return.
         * @return The bytes of the adminLabel at the given index.
         */
        public com.google.protobuf.ByteString
        getAdminLabelBytes(int index) {
            return adminLabel_.getByteString(index);
        }

        public static final int BGPID_FIELD_NUMBER = 65531;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress bgpId_;
        /**
         * <code>.IpAddress bgpId = 65531;</code>
         * @return Whether the bgpId field is set.
         */
        @java.lang.Override
        public boolean hasBgpId() {
            return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>.IpAddress bgpId = 65531;</code>
         * @return The bgpId.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getBgpId() {
            return bgpId_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : bgpId_;
        }
        /**
         * <code>.IpAddress bgpId = 65531;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getBgpIdOrBuilder() {
            return bgpId_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : bgpId_;
        }

        public static final int HOSTNAME_FIELD_NUMBER = 65535;
        @SuppressWarnings("serial")
        private volatile java.lang.Object hostname_ = "";
        /**
         * <code>string hostname = 65535;</code>
         * @return The hostname.
         */
        @java.lang.Override
        public java.lang.String getHostname() {
            java.lang.Object ref = hostname_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                hostname_ = s;
                return s;
            }
        }
        /**
         * <code>string hostname = 65535;</code>
         * @return The bytes for hostname.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getHostnameBytes() {
            java.lang.Object ref = hostname_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                hostname_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysName_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sysName_);
            }
            for (int i = 0; i < sysDesc_.size(); i++) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sysDesc_.getRaw(i));
            }
            for (int i = 0; i < message_.size(); i++) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 3, message_.getRaw(i));
            }
            for (int i = 0; i < adminLabel_.size(); i++) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 4, adminLabel_.getRaw(i));
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                output.writeMessage(65531, getBgpId());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 65535, hostname_);
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysName_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sysName_);
            }
            {
                int dataSize = 0;
                for (int i = 0; i < sysDesc_.size(); i++) {
                    dataSize += computeStringSizeNoTag(sysDesc_.getRaw(i));
                }
                size += dataSize;
                size += 1 * getSysDescList().size();
            }
            {
                int dataSize = 0;
                for (int i = 0; i < message_.size(); i++) {
                    dataSize += computeStringSizeNoTag(message_.getRaw(i));
                }
                size += dataSize;
                size += 1 * getMessageList().size();
            }
            {
                int dataSize = 0;
                for (int i = 0; i < adminLabel_.size(); i++) {
                    dataSize += computeStringSizeNoTag(adminLabel_.getRaw(i));
                }
                size += dataSize;
                size += 1 * getAdminLabelList().size();
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(65531, getBgpId());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(65535, hostname_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket) obj;

            if (!getSysName()
                    .equals(other.getSysName())) return false;
            if (!getSysDescList()
                    .equals(other.getSysDescList())) return false;
            if (!getMessageList()
                    .equals(other.getMessageList())) return false;
            if (!getAdminLabelList()
                    .equals(other.getAdminLabelList())) return false;
            if (hasBgpId() != other.hasBgpId()) return false;
            if (hasBgpId()) {
                if (!getBgpId()
                        .equals(other.getBgpId())) return false;
            }
            if (!getHostname()
                    .equals(other.getHostname())) return false;
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + SYS_NAME_FIELD_NUMBER;
            hash = (53 * hash) + getSysName().hashCode();
            if (getSysDescCount() > 0) {
                hash = (37 * hash) + SYS_DESC_FIELD_NUMBER;
                hash = (53 * hash) + getSysDescList().hashCode();
            }
            if (getMessageCount() > 0) {
                hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
                hash = (53 * hash) + getMessageList().hashCode();
            }
            if (getAdminLabelCount() > 0) {
                hash = (37 * hash) + ADMIN_LABEL_FIELD_NUMBER;
                hash = (53 * hash) + getAdminLabelList().hashCode();
            }
            if (hasBgpId()) {
                hash = (37 * hash) + BGPID_FIELD_NUMBER;
                hash = (53 * hash) + getBgpId().hashCode();
            }
            hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
            hash = (53 * hash) + getHostname().hashCode();
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code InitiationPacket}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:InitiationPacket)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacketOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_InitiationPacket_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_InitiationPacket_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                    getBgpIdFieldBuilder();
                }
            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                sysName_ = "";
                sysDesc_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                message_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                adminLabel_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                bgpId_ = null;
                if (bgpIdBuilder_ != null) {
                    bgpIdBuilder_.dispose();
                    bgpIdBuilder_ = null;
                }
                hostname_ = "";
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_InitiationPacket_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                    result.sysName_ = sysName_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                    sysDesc_.makeImmutable();
                    result.sysDesc_ = sysDesc_;
                }
                if (((from_bitField0_ & 0x00000004) != 0)) {
                    message_.makeImmutable();
                    result.message_ = message_;
                }
                if (((from_bitField0_ & 0x00000008) != 0)) {
                    adminLabel_.makeImmutable();
                    result.adminLabel_ = adminLabel_;
                }
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000010) != 0)) {
                    result.bgpId_ = bgpIdBuilder_ == null
                            ? bgpId_
                            : bgpIdBuilder_.build();
                    to_bitField0_ |= 0x00000001;
                }
                if (((from_bitField0_ & 0x00000020) != 0)) {
                    result.hostname_ = hostname_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket.getDefaultInstance()) return this;
                if (!other.getSysName().isEmpty()) {
                    sysName_ = other.sysName_;
                    bitField0_ |= 0x00000001;
                    onChanged();
                }
                if (!other.sysDesc_.isEmpty()) {
                    if (sysDesc_.isEmpty()) {
                        sysDesc_ = other.sysDesc_;
                        bitField0_ |= 0x00000002;
                    } else {
                        ensureSysDescIsMutable();
                        sysDesc_.addAll(other.sysDesc_);
                    }
                    onChanged();
                }
                if (!other.message_.isEmpty()) {
                    if (message_.isEmpty()) {
                        message_ = other.message_;
                        bitField0_ |= 0x00000004;
                    } else {
                        ensureMessageIsMutable();
                        message_.addAll(other.message_);
                    }
                    onChanged();
                }
                if (!other.adminLabel_.isEmpty()) {
                    if (adminLabel_.isEmpty()) {
                        adminLabel_ = other.adminLabel_;
                        bitField0_ |= 0x00000008;
                    } else {
                        ensureAdminLabelIsMutable();
                        adminLabel_.addAll(other.adminLabel_);
                    }
                    onChanged();
                }
                if (other.hasBgpId()) {
                    mergeBgpId(other.getBgpId());
                }
                if (!other.getHostname().isEmpty()) {
                    hostname_ = other.hostname_;
                    bitField0_ |= 0x00000020;
                    onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 10: {
                                sysName_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000001;
                                break;
                            } // case 10
                            case 18: {
                                java.lang.String s = input.readStringRequireUtf8();
                                ensureSysDescIsMutable();
                                sysDesc_.add(s);
                                break;
                            } // case 18
                            case 26: {
                                java.lang.String s = input.readStringRequireUtf8();
                                ensureMessageIsMutable();
                                message_.add(s);
                                break;
                            } // case 26
                            case 34: {
                                java.lang.String s = input.readStringRequireUtf8();
                                ensureAdminLabelIsMutable();
                                adminLabel_.add(s);
                                break;
                            } // case 34
                            case 524250: {
                                input.readMessage(
                                        getBgpIdFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000010;
                                break;
                            } // case 524250
                            case 524282: {
                                hostname_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000020;
                                break;
                            } // case 524282
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int bitField0_;

            private java.lang.Object sysName_ = "";
            /**
             * <code>string sys_name = 1;</code>
             * @return The sysName.
             */
            public java.lang.String getSysName() {
                java.lang.Object ref = sysName_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    sysName_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string sys_name = 1;</code>
             * @return The bytes for sysName.
             */
            public com.google.protobuf.ByteString
            getSysNameBytes() {
                java.lang.Object ref = sysName_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    sysName_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string sys_name = 1;</code>
             * @param value The sysName to set.
             * @return This builder for chaining.
             */
            public Builder setSysName(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                sysName_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>string sys_name = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearSysName() {
                sysName_ = getDefaultInstance().getSysName();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }
            /**
             * <code>string sys_name = 1;</code>
             * @param value The bytes for sysName to set.
             * @return This builder for chaining.
             */
            public Builder setSysNameBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                sysName_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }

            private com.google.protobuf.LazyStringArrayList sysDesc_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            private void ensureSysDescIsMutable() {
                if (!sysDesc_.isModifiable()) {
                    sysDesc_ = new com.google.protobuf.LazyStringArrayList(sysDesc_);
                }
                bitField0_ |= 0x00000002;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @return A list containing the sysDesc.
             */
            public com.google.protobuf.ProtocolStringList
            getSysDescList() {
                sysDesc_.makeImmutable();
                return sysDesc_;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @return The count of sysDesc.
             */
            public int getSysDescCount() {
                return sysDesc_.size();
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param index The index of the element to return.
             * @return The sysDesc at the given index.
             */
            public java.lang.String getSysDesc(int index) {
                return sysDesc_.get(index);
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param index The index of the value to return.
             * @return The bytes of the sysDesc at the given index.
             */
            public com.google.protobuf.ByteString
            getSysDescBytes(int index) {
                return sysDesc_.getByteString(index);
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param index The index to set the value at.
             * @param value The sysDesc to set.
             * @return This builder for chaining.
             */
            public Builder setSysDesc(
                    int index, java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureSysDescIsMutable();
                sysDesc_.set(index, value);
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param value The sysDesc to add.
             * @return This builder for chaining.
             */
            public Builder addSysDesc(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureSysDescIsMutable();
                sysDesc_.add(value);
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param values The sysDesc to add.
             * @return This builder for chaining.
             */
            public Builder addAllSysDesc(
                    java.lang.Iterable<java.lang.String> values) {
                ensureSysDescIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, sysDesc_);
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @return This builder for chaining.
             */
            public Builder clearSysDesc() {
                sysDesc_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                bitField0_ = (bitField0_ & ~0x00000002);;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string sys_desc = 2;</code>
             * @param value The bytes of the sysDesc to add.
             * @return This builder for chaining.
             */
            public Builder addSysDescBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                ensureSysDescIsMutable();
                sysDesc_.add(value);
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }

            private com.google.protobuf.LazyStringArrayList message_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            private void ensureMessageIsMutable() {
                if (!message_.isModifiable()) {
                    message_ = new com.google.protobuf.LazyStringArrayList(message_);
                }
                bitField0_ |= 0x00000004;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @return A list containing the message.
             */
            public com.google.protobuf.ProtocolStringList
            getMessageList() {
                message_.makeImmutable();
                return message_;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @return The count of message.
             */
            public int getMessageCount() {
                return message_.size();
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param index The index of the element to return.
             * @return The message at the given index.
             */
            public java.lang.String getMessage(int index) {
                return message_.get(index);
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param index The index of the value to return.
             * @return The bytes of the message at the given index.
             */
            public com.google.protobuf.ByteString
            getMessageBytes(int index) {
                return message_.getByteString(index);
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param index The index to set the value at.
             * @param value The message to set.
             * @return This builder for chaining.
             */
            public Builder setMessage(
                    int index, java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureMessageIsMutable();
                message_.set(index, value);
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param value The message to add.
             * @return This builder for chaining.
             */
            public Builder addMessage(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureMessageIsMutable();
                message_.add(value);
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param values The message to add.
             * @return This builder for chaining.
             */
            public Builder addAllMessage(
                    java.lang.Iterable<java.lang.String> values) {
                ensureMessageIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, message_);
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @return This builder for chaining.
             */
            public Builder clearMessage() {
                message_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                bitField0_ = (bitField0_ & ~0x00000004);;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 3;</code>
             * @param value The bytes of the message to add.
             * @return This builder for chaining.
             */
            public Builder addMessageBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                ensureMessageIsMutable();
                message_.add(value);
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }

            private com.google.protobuf.LazyStringArrayList adminLabel_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            private void ensureAdminLabelIsMutable() {
                if (!adminLabel_.isModifiable()) {
                    adminLabel_ = new com.google.protobuf.LazyStringArrayList(adminLabel_);
                }
                bitField0_ |= 0x00000008;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @return A list containing the adminLabel.
             */
            public com.google.protobuf.ProtocolStringList
            getAdminLabelList() {
                adminLabel_.makeImmutable();
                return adminLabel_;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @return The count of adminLabel.
             */
            public int getAdminLabelCount() {
                return adminLabel_.size();
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param index The index of the element to return.
             * @return The adminLabel at the given index.
             */
            public java.lang.String getAdminLabel(int index) {
                return adminLabel_.get(index);
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param index The index of the value to return.
             * @return The bytes of the adminLabel at the given index.
             */
            public com.google.protobuf.ByteString
            getAdminLabelBytes(int index) {
                return adminLabel_.getByteString(index);
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param index The index to set the value at.
             * @param value The adminLabel to set.
             * @return This builder for chaining.
             */
            public Builder setAdminLabel(
                    int index, java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureAdminLabelIsMutable();
                adminLabel_.set(index, value);
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param value The adminLabel to add.
             * @return This builder for chaining.
             */
            public Builder addAdminLabel(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureAdminLabelIsMutable();
                adminLabel_.add(value);
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param values The adminLabel to add.
             * @return This builder for chaining.
             */
            public Builder addAllAdminLabel(
                    java.lang.Iterable<java.lang.String> values) {
                ensureAdminLabelIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, adminLabel_);
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @return This builder for chaining.
             */
            public Builder clearAdminLabel() {
                adminLabel_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                bitField0_ = (bitField0_ & ~0x00000008);;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string admin_label = 4;</code>
             * @param value The bytes of the adminLabel to add.
             * @return This builder for chaining.
             */
            public Builder addAdminLabelBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                ensureAdminLabelIsMutable();
                adminLabel_.add(value);
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress bgpId_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> bgpIdBuilder_;
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             * @return Whether the bgpId field is set.
             */
            public boolean hasBgpId() {
                return ((bitField0_ & 0x00000010) != 0);
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             * @return The bgpId.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getBgpId() {
                if (bgpIdBuilder_ == null) {
                    return bgpId_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : bgpId_;
                } else {
                    return bgpIdBuilder_.getMessage();
                }
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public Builder setBgpId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (bgpIdBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    bgpId_ = value;
                } else {
                    bgpIdBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public Builder setBgpId(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                if (bgpIdBuilder_ == null) {
                    bgpId_ = builderForValue.build();
                } else {
                    bgpIdBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public Builder mergeBgpId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (bgpIdBuilder_ == null) {
                    if (((bitField0_ & 0x00000010) != 0) &&
                            bgpId_ != null &&
                            bgpId_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                        getBgpIdBuilder().mergeFrom(value);
                    } else {
                        bgpId_ = value;
                    }
                } else {
                    bgpIdBuilder_.mergeFrom(value);
                }
                if (bgpId_ != null) {
                    bitField0_ |= 0x00000010;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public Builder clearBgpId() {
                bitField0_ = (bitField0_ & ~0x00000010);
                bgpId_ = null;
                if (bgpIdBuilder_ != null) {
                    bgpIdBuilder_.dispose();
                    bgpIdBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getBgpIdBuilder() {
                bitField0_ |= 0x00000010;
                onChanged();
                return getBgpIdFieldBuilder().getBuilder();
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getBgpIdOrBuilder() {
                if (bgpIdBuilder_ != null) {
                    return bgpIdBuilder_.getMessageOrBuilder();
                } else {
                    return bgpId_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : bgpId_;
                }
            }
            /**
             * <code>.IpAddress bgpId = 65531;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
            getBgpIdFieldBuilder() {
                if (bgpIdBuilder_ == null) {
                    bgpIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                            getBgpId(),
                            getParentForChildren(),
                            isClean());
                    bgpId_ = null;
                }
                return bgpIdBuilder_;
            }

            private java.lang.Object hostname_ = "";
            /**
             * <code>string hostname = 65535;</code>
             * @return The hostname.
             */
            public java.lang.String getHostname() {
                java.lang.Object ref = hostname_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    hostname_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string hostname = 65535;</code>
             * @return The bytes for hostname.
             */
            public com.google.protobuf.ByteString
            getHostnameBytes() {
                java.lang.Object ref = hostname_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    hostname_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string hostname = 65535;</code>
             * @param value The hostname to set.
             * @return This builder for chaining.
             */
            public Builder setHostname(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                hostname_ = value;
                bitField0_ |= 0x00000020;
                onChanged();
                return this;
            }
            /**
             * <code>string hostname = 65535;</code>
             * @return This builder for chaining.
             */
            public Builder clearHostname() {
                hostname_ = getDefaultInstance().getHostname();
                bitField0_ = (bitField0_ & ~0x00000020);
                onChanged();
                return this;
            }
            /**
             * <code>string hostname = 65535;</code>
             * @param value The bytes for hostname to set.
             * @return This builder for chaining.
             */
            public Builder setHostnameBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                hostname_ = value;
                bitField0_ |= 0x00000020;
                onChanged();
                return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:InitiationPacket)
        }

        // @@protoc_insertion_point(class_scope:InitiationPacket)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<InitiationPacket>
                PARSER = new com.google.protobuf.AbstractParser<InitiationPacket>() {
            @java.lang.Override
            public InitiationPacket parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<InitiationPacket> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<InitiationPacket> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.InitiationPacket getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface TerminationPacketOrBuilder extends
            // @@protoc_insertion_point(interface_extends:TerminationPacket)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated string message = 1;</code>
         * @return A list containing the message.
         */
        java.util.List<java.lang.String>
        getMessageList();
        /**
         * <code>repeated string message = 1;</code>
         * @return The count of message.
         */
        int getMessageCount();
        /**
         * <code>repeated string message = 1;</code>
         * @param index The index of the element to return.
         * @return The message at the given index.
         */
        java.lang.String getMessage(int index);
        /**
         * <code>repeated string message = 1;</code>
         * @param index The index of the value to return.
         * @return The bytes of the message at the given index.
         */
        com.google.protobuf.ByteString
        getMessageBytes(int index);

        /**
         * <code>uint32 reason = 2;</code>
         * @return The reason.
         */
        int getReason();

        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         * @return Whether the unknown field is set.
         */
        boolean hasUnknown();
        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         * @return The unknown.
         */
        com.google.protobuf.Empty getUnknown();
        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         */
        com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder();
    }
    /**
     * Protobuf type {@code TerminationPacket}
     */
    public static final class TerminationPacket extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:TerminationPacket)
            TerminationPacketOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use TerminationPacket.newBuilder() to construct.
        private TerminationPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private TerminationPacket() {
            message_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new TerminationPacket();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_TerminationPacket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_TerminationPacket_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.Builder.class);
        }

        private int bitField0_;
        public static final int MESSAGE_FIELD_NUMBER = 1;
        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList message_ =
                com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         * <code>repeated string message = 1;</code>
         * @return A list containing the message.
         */
        public com.google.protobuf.ProtocolStringList
        getMessageList() {
            return message_;
        }
        /**
         * <code>repeated string message = 1;</code>
         * @return The count of message.
         */
        public int getMessageCount() {
            return message_.size();
        }
        /**
         * <code>repeated string message = 1;</code>
         * @param index The index of the element to return.
         * @return The message at the given index.
         */
        public java.lang.String getMessage(int index) {
            return message_.get(index);
        }
        /**
         * <code>repeated string message = 1;</code>
         * @param index The index of the value to return.
         * @return The bytes of the message at the given index.
         */
        public com.google.protobuf.ByteString
        getMessageBytes(int index) {
            return message_.getByteString(index);
        }

        public static final int REASON_FIELD_NUMBER = 2;
        private int reason_ = 0;
        /**
         * <code>uint32 reason = 2;</code>
         * @return The reason.
         */
        @java.lang.Override
        public int getReason() {
            return reason_;
        }

        public static final int UNKNOWN_FIELD_NUMBER = 3;
        private com.google.protobuf.Empty unknown_;
        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         * @return Whether the unknown field is set.
         */
        @java.lang.Override
        public boolean hasUnknown() {
            return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         * @return The unknown.
         */
        @java.lang.Override
        public com.google.protobuf.Empty getUnknown() {
            return unknown_ == null ? com.google.protobuf.Empty.getDefaultInstance() : unknown_;
        }
        /**
         * <code>.google.protobuf.Empty unknown = 3;</code>
         */
        @java.lang.Override
        public com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder() {
            return unknown_ == null ? com.google.protobuf.Empty.getDefaultInstance() : unknown_;
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            for (int i = 0; i < message_.size(); i++) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, message_.getRaw(i));
            }
            if (reason_ != 0) {
                output.writeUInt32(2, reason_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                output.writeMessage(3, getUnknown());
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < message_.size(); i++) {
                    dataSize += computeStringSizeNoTag(message_.getRaw(i));
                }
                size += dataSize;
                size += 1 * getMessageList().size();
            }
            if (reason_ != 0) {
                size += com.google.protobuf.CodedOutputStream
                        .computeUInt32Size(2, reason_);
            }
            if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(3, getUnknown());
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket) obj;

            if (!getMessageList()
                    .equals(other.getMessageList())) return false;
            if (getReason()
                    != other.getReason()) return false;
            if (hasUnknown() != other.hasUnknown()) return false;
            if (hasUnknown()) {
                if (!getUnknown()
                        .equals(other.getUnknown())) return false;
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getMessageCount() > 0) {
                hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
                hash = (53 * hash) + getMessageList().hashCode();
            }
            hash = (37 * hash) + REASON_FIELD_NUMBER;
            hash = (53 * hash) + getReason();
            if (hasUnknown()) {
                hash = (37 * hash) + UNKNOWN_FIELD_NUMBER;
                hash = (53 * hash) + getUnknown().hashCode();
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code TerminationPacket}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:TerminationPacket)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacketOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_TerminationPacket_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_TerminationPacket_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                    getUnknownFieldBuilder();
                }
            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                message_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                reason_ = 0;
                unknown_ = null;
                if (unknownBuilder_ != null) {
                    unknownBuilder_.dispose();
                    unknownBuilder_ = null;
                }
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_TerminationPacket_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                    message_.makeImmutable();
                    result.message_ = message_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                    result.reason_ = reason_;
                }
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000004) != 0)) {
                    result.unknown_ = unknownBuilder_ == null
                            ? unknown_
                            : unknownBuilder_.build();
                    to_bitField0_ |= 0x00000001;
                }
                result.bitField0_ |= to_bitField0_;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket.getDefaultInstance()) return this;
                if (!other.message_.isEmpty()) {
                    if (message_.isEmpty()) {
                        message_ = other.message_;
                        bitField0_ |= 0x00000001;
                    } else {
                        ensureMessageIsMutable();
                        message_.addAll(other.message_);
                    }
                    onChanged();
                }
                if (other.getReason() != 0) {
                    setReason(other.getReason());
                }
                if (other.hasUnknown()) {
                    mergeUnknown(other.getUnknown());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 10: {
                                java.lang.String s = input.readStringRequireUtf8();
                                ensureMessageIsMutable();
                                message_.add(s);
                                break;
                            } // case 10
                            case 16: {
                                reason_ = input.readUInt32();
                                bitField0_ |= 0x00000002;
                                break;
                            } // case 16
                            case 26: {
                                input.readMessage(
                                        getUnknownFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000004;
                                break;
                            } // case 26
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int bitField0_;

            private com.google.protobuf.LazyStringArrayList message_ =
                    com.google.protobuf.LazyStringArrayList.emptyList();
            private void ensureMessageIsMutable() {
                if (!message_.isModifiable()) {
                    message_ = new com.google.protobuf.LazyStringArrayList(message_);
                }
                bitField0_ |= 0x00000001;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @return A list containing the message.
             */
            public com.google.protobuf.ProtocolStringList
            getMessageList() {
                message_.makeImmutable();
                return message_;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @return The count of message.
             */
            public int getMessageCount() {
                return message_.size();
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param index The index of the element to return.
             * @return The message at the given index.
             */
            public java.lang.String getMessage(int index) {
                return message_.get(index);
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param index The index of the value to return.
             * @return The bytes of the message at the given index.
             */
            public com.google.protobuf.ByteString
            getMessageBytes(int index) {
                return message_.getByteString(index);
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param index The index to set the value at.
             * @param value The message to set.
             * @return This builder for chaining.
             */
            public Builder setMessage(
                    int index, java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureMessageIsMutable();
                message_.set(index, value);
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param value The message to add.
             * @return This builder for chaining.
             */
            public Builder addMessage(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                ensureMessageIsMutable();
                message_.add(value);
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param values The message to add.
             * @return This builder for chaining.
             */
            public Builder addAllMessage(
                    java.lang.Iterable<java.lang.String> values) {
                ensureMessageIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, message_);
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @return This builder for chaining.
             */
            public Builder clearMessage() {
                message_ =
                        com.google.protobuf.LazyStringArrayList.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);;
                onChanged();
                return this;
            }
            /**
             * <code>repeated string message = 1;</code>
             * @param value The bytes of the message to add.
             * @return This builder for chaining.
             */
            public Builder addMessageBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                ensureMessageIsMutable();
                message_.add(value);
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }

            private int reason_ ;
            /**
             * <code>uint32 reason = 2;</code>
             * @return The reason.
             */
            @java.lang.Override
            public int getReason() {
                return reason_;
            }
            /**
             * <code>uint32 reason = 2;</code>
             * @param value The reason to set.
             * @return This builder for chaining.
             */
            public Builder setReason(int value) {

                reason_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>uint32 reason = 2;</code>
             * @return This builder for chaining.
             */
            public Builder clearReason() {
                bitField0_ = (bitField0_ & ~0x00000002);
                reason_ = 0;
                onChanged();
                return this;
            }

            private com.google.protobuf.Empty unknown_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> unknownBuilder_;
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             * @return Whether the unknown field is set.
             */
            public boolean hasUnknown() {
                return ((bitField0_ & 0x00000004) != 0);
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             * @return The unknown.
             */
            public com.google.protobuf.Empty getUnknown() {
                if (unknownBuilder_ == null) {
                    return unknown_ == null ? com.google.protobuf.Empty.getDefaultInstance() : unknown_;
                } else {
                    return unknownBuilder_.getMessage();
                }
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public Builder setUnknown(com.google.protobuf.Empty value) {
                if (unknownBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    unknown_ = value;
                } else {
                    unknownBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public Builder setUnknown(
                    com.google.protobuf.Empty.Builder builderForValue) {
                if (unknownBuilder_ == null) {
                    unknown_ = builderForValue.build();
                } else {
                    unknownBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public Builder mergeUnknown(com.google.protobuf.Empty value) {
                if (unknownBuilder_ == null) {
                    if (((bitField0_ & 0x00000004) != 0) &&
                            unknown_ != null &&
                            unknown_ != com.google.protobuf.Empty.getDefaultInstance()) {
                        getUnknownBuilder().mergeFrom(value);
                    } else {
                        unknown_ = value;
                    }
                } else {
                    unknownBuilder_.mergeFrom(value);
                }
                if (unknown_ != null) {
                    bitField0_ |= 0x00000004;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public Builder clearUnknown() {
                bitField0_ = (bitField0_ & ~0x00000004);
                unknown_ = null;
                if (unknownBuilder_ != null) {
                    unknownBuilder_.dispose();
                    unknownBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public com.google.protobuf.Empty.Builder getUnknownBuilder() {
                bitField0_ |= 0x00000004;
                onChanged();
                return getUnknownFieldBuilder().getBuilder();
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            public com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder() {
                if (unknownBuilder_ != null) {
                    return unknownBuilder_.getMessageOrBuilder();
                } else {
                    return unknown_ == null ?
                            com.google.protobuf.Empty.getDefaultInstance() : unknown_;
                }
            }
            /**
             * <code>.google.protobuf.Empty unknown = 3;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>
            getUnknownFieldBuilder() {
                if (unknownBuilder_ == null) {
                    unknownBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>(
                            getUnknown(),
                            getParentForChildren(),
                            isClean());
                    unknown_ = null;
                }
                return unknownBuilder_;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:TerminationPacket)
        }

        // @@protoc_insertion_point(class_scope:TerminationPacket)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<TerminationPacket>
                PARSER = new com.google.protobuf.AbstractParser<TerminationPacket>() {
            @java.lang.Override
            public TerminationPacket parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<TerminationPacket> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<TerminationPacket> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.TerminationPacket getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface PeerUpPacketOrBuilder extends
            // @@protoc_insertion_point(interface_extends:PeerUpPacket)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.Peer peer = 1;</code>
         * @return Whether the peer field is set.
         */
        boolean hasPeer();
        /**
         * <code>.Peer peer = 1;</code>
         * @return The peer.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer();
        /**
         * <code>.Peer peer = 1;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder();

        /**
         * <code>.IpAddress local_address = 2;</code>
         * @return Whether the localAddress field is set.
         */
        boolean hasLocalAddress();
        /**
         * <code>.IpAddress local_address = 2;</code>
         * @return The localAddress.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getLocalAddress();
        /**
         * <code>.IpAddress local_address = 2;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getLocalAddressOrBuilder();

        /**
         * <code>uint32 local_port = 3;</code>
         * @return The localPort.
         */
        int getLocalPort();

        /**
         * <code>uint32 remote_port = 4;</code>
         * @return The remotePort.
         */
        int getRemotePort();

        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         * @return Whether the sendMsg field is set.
         */
        boolean hasSendMsg();
        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         * @return The sendMsg.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getSendMsg();
        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getSendMsgOrBuilder();

        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         * @return Whether the recvMsg field is set.
         */
        boolean hasRecvMsg();
        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         * @return The recvMsg.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getRecvMsg();
        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getRecvMsgOrBuilder();

        /**
         * <code>string sys_name = 7;</code>
         * @return The sysName.
         */
        java.lang.String getSysName();
        /**
         * <code>string sys_name = 7;</code>
         * @return The bytes for sysName.
         */
        com.google.protobuf.ByteString
        getSysNameBytes();

        /**
         * <code>string sys_desc = 8;</code>
         * @return The sysDesc.
         */
        java.lang.String getSysDesc();
        /**
         * <code>string sys_desc = 8;</code>
         * @return The bytes for sysDesc.
         */
        com.google.protobuf.ByteString
        getSysDescBytes();

        /**
         * <code>string message = 9;</code>
         * @return The message.
         */
        java.lang.String getMessage();
        /**
         * <code>string message = 9;</code>
         * @return The bytes for message.
         */
        com.google.protobuf.ByteString
        getMessageBytes();

        /**
         * <code>string table_name = 10;</code>
         * @return The tableName.
         */
        java.lang.String getTableName();
        /**
         * <code>string table_name = 10;</code>
         * @return The bytes for tableName.
         */
        com.google.protobuf.ByteString
        getTableNameBytes();
    }
    /**
     * Protobuf type {@code PeerUpPacket}
     */
    public static final class PeerUpPacket extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:PeerUpPacket)
            PeerUpPacketOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use PeerUpPacket.newBuilder() to construct.
        private PeerUpPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private PeerUpPacket() {
            sysName_ = "";
            sysDesc_ = "";
            message_ = "";
            tableName_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new PeerUpPacket();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Builder.class);
        }

        public interface CapabilityOrBuilder extends
                // @@protoc_insertion_point(interface_extends:PeerUpPacket.Capability)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>uint32 code = 1;</code>
             * @return The code.
             */
            int getCode();

            /**
             * <code>uint32 length = 2;</code>
             * @return The length.
             */
            int getLength();

            /**
             * <code>bytes value = 3;</code>
             * @return The value.
             */
            com.google.protobuf.ByteString getValue();
        }
        /**
         * Protobuf type {@code PeerUpPacket.Capability}
         */
        public static final class Capability extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:PeerUpPacket.Capability)
                CapabilityOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use Capability.newBuilder() to construct.
            private Capability(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private Capability() {
                value_ = com.google.protobuf.ByteString.EMPTY;
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new Capability();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_Capability_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_Capability_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder.class);
            }

            public static final int CODE_FIELD_NUMBER = 1;
            private int code_ = 0;
            /**
             * <code>uint32 code = 1;</code>
             * @return The code.
             */
            @java.lang.Override
            public int getCode() {
                return code_;
            }

            public static final int LENGTH_FIELD_NUMBER = 2;
            private int length_ = 0;
            /**
             * <code>uint32 length = 2;</code>
             * @return The length.
             */
            @java.lang.Override
            public int getLength() {
                return length_;
            }

            public static final int VALUE_FIELD_NUMBER = 3;
            private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
            /**
             * <code>bytes value = 3;</code>
             * @return The value.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getValue() {
                return value_;
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (code_ != 0) {
                    output.writeUInt32(1, code_);
                }
                if (length_ != 0) {
                    output.writeUInt32(2, length_);
                }
                if (!value_.isEmpty()) {
                    output.writeBytes(3, value_);
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (code_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(1, code_);
                }
                if (length_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(2, length_);
                }
                if (!value_.isEmpty()) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeBytesSize(3, value_);
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability) obj;

                if (getCode()
                        != other.getCode()) return false;
                if (getLength()
                        != other.getLength()) return false;
                if (!getValue()
                        .equals(other.getValue())) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                hash = (37 * hash) + CODE_FIELD_NUMBER;
                hash = (53 * hash) + getCode();
                hash = (37 * hash) + LENGTH_FIELD_NUMBER;
                hash = (53 * hash) + getLength();
                hash = (37 * hash) + VALUE_FIELD_NUMBER;
                hash = (53 * hash) + getValue().hashCode();
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code PeerUpPacket.Capability}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:PeerUpPacket.Capability)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_Capability_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_Capability_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.newBuilder()
                private Builder() {

                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);

                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    code_ = 0;
                    length_ = 0;
                    value_ = com.google.protobuf.ByteString.EMPTY;
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_Capability_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability result) {
                    int from_bitField0_ = bitField0_;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.code_ = code_;
                    }
                    if (((from_bitField0_ & 0x00000002) != 0)) {
                        result.length_ = length_;
                    }
                    if (((from_bitField0_ & 0x00000004) != 0)) {
                        result.value_ = value_;
                    }
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.getDefaultInstance()) return this;
                    if (other.getCode() != 0) {
                        setCode(other.getCode());
                    }
                    if (other.getLength() != 0) {
                        setLength(other.getLength());
                    }
                    if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
                        setValue(other.getValue());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 8: {
                                    code_ = input.readUInt32();
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 8
                                case 16: {
                                    length_ = input.readUInt32();
                                    bitField0_ |= 0x00000002;
                                    break;
                                } // case 16
                                case 26: {
                                    value_ = input.readBytes();
                                    bitField0_ |= 0x00000004;
                                    break;
                                } // case 26
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private int code_ ;
                /**
                 * <code>uint32 code = 1;</code>
                 * @return The code.
                 */
                @java.lang.Override
                public int getCode() {
                    return code_;
                }
                /**
                 * <code>uint32 code = 1;</code>
                 * @param value The code to set.
                 * @return This builder for chaining.
                 */
                public Builder setCode(int value) {

                    code_ = value;
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 code = 1;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearCode() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    code_ = 0;
                    onChanged();
                    return this;
                }

                private int length_ ;
                /**
                 * <code>uint32 length = 2;</code>
                 * @return The length.
                 */
                @java.lang.Override
                public int getLength() {
                    return length_;
                }
                /**
                 * <code>uint32 length = 2;</code>
                 * @param value The length to set.
                 * @return This builder for chaining.
                 */
                public Builder setLength(int value) {

                    length_ = value;
                    bitField0_ |= 0x00000002;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 length = 2;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearLength() {
                    bitField0_ = (bitField0_ & ~0x00000002);
                    length_ = 0;
                    onChanged();
                    return this;
                }

                private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
                /**
                 * <code>bytes value = 3;</code>
                 * @return The value.
                 */
                @java.lang.Override
                public com.google.protobuf.ByteString getValue() {
                    return value_;
                }
                /**
                 * <code>bytes value = 3;</code>
                 * @param value The value to set.
                 * @return This builder for chaining.
                 */
                public Builder setValue(com.google.protobuf.ByteString value) {
                    if (value == null) { throw new NullPointerException(); }
                    value_ = value;
                    bitField0_ |= 0x00000004;
                    onChanged();
                    return this;
                }
                /**
                 * <code>bytes value = 3;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearValue() {
                    bitField0_ = (bitField0_ & ~0x00000004);
                    value_ = getDefaultInstance().getValue();
                    onChanged();
                    return this;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:PeerUpPacket.Capability)
            }

            // @@protoc_insertion_point(class_scope:PeerUpPacket.Capability)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<Capability>
                    PARSER = new com.google.protobuf.AbstractParser<Capability>() {
                @java.lang.Override
                public Capability parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<Capability> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<Capability> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        public interface CapabilityListOrBuilder extends
                // @@protoc_insertion_point(interface_extends:PeerUpPacket.CapabilityList)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability>
            getCapabilityList();
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getCapability(int index);
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            int getCapabilityCount();
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder>
            getCapabilityOrBuilderList();
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder getCapabilityOrBuilder(
                    int index);
        }
        /**
         * Protobuf type {@code PeerUpPacket.CapabilityList}
         */
        public static final class CapabilityList extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:PeerUpPacket.CapabilityList)
                CapabilityListOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use CapabilityList.newBuilder() to construct.
            private CapabilityList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private CapabilityList() {
                capability_ = java.util.Collections.emptyList();
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new CapabilityList();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_CapabilityList_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_CapabilityList_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder.class);
            }

            public static final int CAPABILITY_FIELD_NUMBER = 1;
            @SuppressWarnings("serial")
            private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability> capability_;
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            @java.lang.Override
            public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability> getCapabilityList() {
                return capability_;
            }
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            @java.lang.Override
            public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder>
            getCapabilityOrBuilderList() {
                return capability_;
            }
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            @java.lang.Override
            public int getCapabilityCount() {
                return capability_.size();
            }
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getCapability(int index) {
                return capability_.get(index);
            }
            /**
             * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder getCapabilityOrBuilder(
                    int index) {
                return capability_.get(index);
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                for (int i = 0; i < capability_.size(); i++) {
                    output.writeMessage(1, capability_.get(i));
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                for (int i = 0; i < capability_.size(); i++) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeMessageSize(1, capability_.get(i));
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList) obj;

                if (!getCapabilityList()
                        .equals(other.getCapabilityList())) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                if (getCapabilityCount() > 0) {
                    hash = (37 * hash) + CAPABILITY_FIELD_NUMBER;
                    hash = (53 * hash) + getCapabilityList().hashCode();
                }
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code PeerUpPacket.CapabilityList}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:PeerUpPacket.CapabilityList)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_CapabilityList_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_CapabilityList_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.newBuilder()
                private Builder() {

                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);

                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    if (capabilityBuilder_ == null) {
                        capability_ = java.util.Collections.emptyList();
                    } else {
                        capability_ = null;
                        capabilityBuilder_.clear();
                    }
                    bitField0_ = (bitField0_ & ~0x00000001);
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_CapabilityList_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList(this);
                    buildPartialRepeatedFields(result);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartialRepeatedFields(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList result) {
                    if (capabilityBuilder_ == null) {
                        if (((bitField0_ & 0x00000001) != 0)) {
                            capability_ = java.util.Collections.unmodifiableList(capability_);
                            bitField0_ = (bitField0_ & ~0x00000001);
                        }
                        result.capability_ = capability_;
                    } else {
                        result.capability_ = capabilityBuilder_.build();
                    }
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList result) {
                    int from_bitField0_ = bitField0_;
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance()) return this;
                    if (capabilityBuilder_ == null) {
                        if (!other.capability_.isEmpty()) {
                            if (capability_.isEmpty()) {
                                capability_ = other.capability_;
                                bitField0_ = (bitField0_ & ~0x00000001);
                            } else {
                                ensureCapabilityIsMutable();
                                capability_.addAll(other.capability_);
                            }
                            onChanged();
                        }
                    } else {
                        if (!other.capability_.isEmpty()) {
                            if (capabilityBuilder_.isEmpty()) {
                                capabilityBuilder_.dispose();
                                capabilityBuilder_ = null;
                                capability_ = other.capability_;
                                bitField0_ = (bitField0_ & ~0x00000001);
                                capabilityBuilder_ =
                                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                                getCapabilityFieldBuilder() : null;
                            } else {
                                capabilityBuilder_.addAllMessages(other.capability_);
                            }
                        }
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 10: {
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability m =
                                            input.readMessage(
                                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.parser(),
                                                    extensionRegistry);
                                    if (capabilityBuilder_ == null) {
                                        ensureCapabilityIsMutable();
                                        capability_.add(m);
                                    } else {
                                        capabilityBuilder_.addMessage(m);
                                    }
                                    break;
                                } // case 10
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability> capability_ =
                        java.util.Collections.emptyList();
                private void ensureCapabilityIsMutable() {
                    if (!((bitField0_ & 0x00000001) != 0)) {
                        capability_ = new java.util.ArrayList<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability>(capability_);
                        bitField0_ |= 0x00000001;
                    }
                }

                private com.google.protobuf.RepeatedFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder> capabilityBuilder_;

                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability> getCapabilityList() {
                    if (capabilityBuilder_ == null) {
                        return java.util.Collections.unmodifiableList(capability_);
                    } else {
                        return capabilityBuilder_.getMessageList();
                    }
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public int getCapabilityCount() {
                    if (capabilityBuilder_ == null) {
                        return capability_.size();
                    } else {
                        return capabilityBuilder_.getCount();
                    }
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability getCapability(int index) {
                    if (capabilityBuilder_ == null) {
                        return capability_.get(index);
                    } else {
                        return capabilityBuilder_.getMessage(index);
                    }
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder setCapability(
                        int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability value) {
                    if (capabilityBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        ensureCapabilityIsMutable();
                        capability_.set(index, value);
                        onChanged();
                    } else {
                        capabilityBuilder_.setMessage(index, value);
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder setCapability(
                        int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder builderForValue) {
                    if (capabilityBuilder_ == null) {
                        ensureCapabilityIsMutable();
                        capability_.set(index, builderForValue.build());
                        onChanged();
                    } else {
                        capabilityBuilder_.setMessage(index, builderForValue.build());
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder addCapability(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability value) {
                    if (capabilityBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        ensureCapabilityIsMutable();
                        capability_.add(value);
                        onChanged();
                    } else {
                        capabilityBuilder_.addMessage(value);
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder addCapability(
                        int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability value) {
                    if (capabilityBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        ensureCapabilityIsMutable();
                        capability_.add(index, value);
                        onChanged();
                    } else {
                        capabilityBuilder_.addMessage(index, value);
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder addCapability(
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder builderForValue) {
                    if (capabilityBuilder_ == null) {
                        ensureCapabilityIsMutable();
                        capability_.add(builderForValue.build());
                        onChanged();
                    } else {
                        capabilityBuilder_.addMessage(builderForValue.build());
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder addCapability(
                        int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder builderForValue) {
                    if (capabilityBuilder_ == null) {
                        ensureCapabilityIsMutable();
                        capability_.add(index, builderForValue.build());
                        onChanged();
                    } else {
                        capabilityBuilder_.addMessage(index, builderForValue.build());
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder addAllCapability(
                        java.lang.Iterable<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability> values) {
                    if (capabilityBuilder_ == null) {
                        ensureCapabilityIsMutable();
                        com.google.protobuf.AbstractMessageLite.Builder.addAll(
                                values, capability_);
                        onChanged();
                    } else {
                        capabilityBuilder_.addAllMessages(values);
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder clearCapability() {
                    if (capabilityBuilder_ == null) {
                        capability_ = java.util.Collections.emptyList();
                        bitField0_ = (bitField0_ & ~0x00000001);
                        onChanged();
                    } else {
                        capabilityBuilder_.clear();
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public Builder removeCapability(int index) {
                    if (capabilityBuilder_ == null) {
                        ensureCapabilityIsMutable();
                        capability_.remove(index);
                        onChanged();
                    } else {
                        capabilityBuilder_.remove(index);
                    }
                    return this;
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder getCapabilityBuilder(
                        int index) {
                    return getCapabilityFieldBuilder().getBuilder(index);
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder getCapabilityOrBuilder(
                        int index) {
                    if (capabilityBuilder_ == null) {
                        return capability_.get(index);  } else {
                        return capabilityBuilder_.getMessageOrBuilder(index);
                    }
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder>
                getCapabilityOrBuilderList() {
                    if (capabilityBuilder_ != null) {
                        return capabilityBuilder_.getMessageOrBuilderList();
                    } else {
                        return java.util.Collections.unmodifiableList(capability_);
                    }
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder addCapabilityBuilder() {
                    return getCapabilityFieldBuilder().addBuilder(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.getDefaultInstance());
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder addCapabilityBuilder(
                        int index) {
                    return getCapabilityFieldBuilder().addBuilder(
                            index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.getDefaultInstance());
                }
                /**
                 * <code>repeated .PeerUpPacket.Capability capability = 1;</code>
                 */
                public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder>
                getCapabilityBuilderList() {
                    return getCapabilityFieldBuilder().getBuilderList();
                }
                private com.google.protobuf.RepeatedFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder>
                getCapabilityFieldBuilder() {
                    if (capabilityBuilder_ == null) {
                        capabilityBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Capability.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityOrBuilder>(
                                capability_,
                                ((bitField0_ & 0x00000001) != 0),
                                getParentForChildren(),
                                isClean());
                        capability_ = null;
                    }
                    return capabilityBuilder_;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:PeerUpPacket.CapabilityList)
            }

            // @@protoc_insertion_point(class_scope:PeerUpPacket.CapabilityList)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<CapabilityList>
                    PARSER = new com.google.protobuf.AbstractParser<CapabilityList>() {
                @java.lang.Override
                public CapabilityList parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<CapabilityList> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<CapabilityList> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        public interface OpenMessageOrBuilder extends
                // @@protoc_insertion_point(interface_extends:PeerUpPacket.OpenMessage)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>uint32 version = 1;</code>
             * @return The version.
             */
            int getVersion();

            /**
             * <code>fixed32 as = 2;</code>
             * @return The as.
             */
            int getAs();

            /**
             * <code>uint32 hold_time = 3;</code>
             * @return The holdTime.
             */
            int getHoldTime();

            /**
             * <code>.IpAddress id = 4;</code>
             * @return Whether the id field is set.
             */
            boolean hasId();
            /**
             * <code>.IpAddress id = 4;</code>
             * @return The id.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId();
            /**
             * <code>.IpAddress id = 4;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder();

            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             * @return Whether the capabilities field is set.
             */
            boolean hasCapabilities();
            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             * @return The capabilities.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getCapabilities();
            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder getCapabilitiesOrBuilder();
        }
        /**
         * Protobuf type {@code PeerUpPacket.OpenMessage}
         */
        public static final class OpenMessage extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:PeerUpPacket.OpenMessage)
                OpenMessageOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use OpenMessage.newBuilder() to construct.
            private OpenMessage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private OpenMessage() {
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new OpenMessage();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_OpenMessage_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_OpenMessage_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder.class);
            }

            private int bitField0_;
            public static final int VERSION_FIELD_NUMBER = 1;
            private int version_ = 0;
            /**
             * <code>uint32 version = 1;</code>
             * @return The version.
             */
            @java.lang.Override
            public int getVersion() {
                return version_;
            }

            public static final int AS_FIELD_NUMBER = 2;
            private int as_ = 0;
            /**
             * <code>fixed32 as = 2;</code>
             * @return The as.
             */
            @java.lang.Override
            public int getAs() {
                return as_;
            }

            public static final int HOLD_TIME_FIELD_NUMBER = 3;
            private int holdTime_ = 0;
            /**
             * <code>uint32 hold_time = 3;</code>
             * @return The holdTime.
             */
            @java.lang.Override
            public int getHoldTime() {
                return holdTime_;
            }

            public static final int ID_FIELD_NUMBER = 4;
            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress id_;
            /**
             * <code>.IpAddress id = 4;</code>
             * @return Whether the id field is set.
             */
            @java.lang.Override
            public boolean hasId() {
                return ((bitField0_ & 0x00000001) != 0);
            }
            /**
             * <code>.IpAddress id = 4;</code>
             * @return The id.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId() {
                return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
            }
            /**
             * <code>.IpAddress id = 4;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder() {
                return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
            }

            public static final int CAPABILITIES_FIELD_NUMBER = 5;
            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList capabilities_;
            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             * @return Whether the capabilities field is set.
             */
            @java.lang.Override
            public boolean hasCapabilities() {
                return ((bitField0_ & 0x00000002) != 0);
            }
            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             * @return The capabilities.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getCapabilities() {
                return capabilities_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance() : capabilities_;
            }
            /**
             * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder getCapabilitiesOrBuilder() {
                return capabilities_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance() : capabilities_;
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (version_ != 0) {
                    output.writeUInt32(1, version_);
                }
                if (as_ != 0) {
                    output.writeFixed32(2, as_);
                }
                if (holdTime_ != 0) {
                    output.writeUInt32(3, holdTime_);
                }
                if (((bitField0_ & 0x00000001) != 0)) {
                    output.writeMessage(4, getId());
                }
                if (((bitField0_ & 0x00000002) != 0)) {
                    output.writeMessage(5, getCapabilities());
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (version_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(1, version_);
                }
                if (as_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeFixed32Size(2, as_);
                }
                if (holdTime_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(3, holdTime_);
                }
                if (((bitField0_ & 0x00000001) != 0)) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeMessageSize(4, getId());
                }
                if (((bitField0_ & 0x00000002) != 0)) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeMessageSize(5, getCapabilities());
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage) obj;

                if (getVersion()
                        != other.getVersion()) return false;
                if (getAs()
                        != other.getAs()) return false;
                if (getHoldTime()
                        != other.getHoldTime()) return false;
                if (hasId() != other.hasId()) return false;
                if (hasId()) {
                    if (!getId()
                            .equals(other.getId())) return false;
                }
                if (hasCapabilities() != other.hasCapabilities()) return false;
                if (hasCapabilities()) {
                    if (!getCapabilities()
                            .equals(other.getCapabilities())) return false;
                }
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                hash = (37 * hash) + VERSION_FIELD_NUMBER;
                hash = (53 * hash) + getVersion();
                hash = (37 * hash) + AS_FIELD_NUMBER;
                hash = (53 * hash) + getAs();
                hash = (37 * hash) + HOLD_TIME_FIELD_NUMBER;
                hash = (53 * hash) + getHoldTime();
                if (hasId()) {
                    hash = (37 * hash) + ID_FIELD_NUMBER;
                    hash = (53 * hash) + getId().hashCode();
                }
                if (hasCapabilities()) {
                    hash = (37 * hash) + CAPABILITIES_FIELD_NUMBER;
                    hash = (53 * hash) + getCapabilities().hashCode();
                }
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code PeerUpPacket.OpenMessage}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:PeerUpPacket.OpenMessage)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_OpenMessage_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_OpenMessage_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.newBuilder()
                private Builder() {
                    maybeForceBuilderInitialization();
                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                    maybeForceBuilderInitialization();
                }
                private void maybeForceBuilderInitialization() {
                    if (com.google.protobuf.GeneratedMessageV3
                            .alwaysUseFieldBuilders) {
                        getIdFieldBuilder();
                        getCapabilitiesFieldBuilder();
                    }
                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    version_ = 0;
                    as_ = 0;
                    holdTime_ = 0;
                    id_ = null;
                    if (idBuilder_ != null) {
                        idBuilder_.dispose();
                        idBuilder_ = null;
                    }
                    capabilities_ = null;
                    if (capabilitiesBuilder_ != null) {
                        capabilitiesBuilder_.dispose();
                        capabilitiesBuilder_ = null;
                    }
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_OpenMessage_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage result) {
                    int from_bitField0_ = bitField0_;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.version_ = version_;
                    }
                    if (((from_bitField0_ & 0x00000002) != 0)) {
                        result.as_ = as_;
                    }
                    if (((from_bitField0_ & 0x00000004) != 0)) {
                        result.holdTime_ = holdTime_;
                    }
                    int to_bitField0_ = 0;
                    if (((from_bitField0_ & 0x00000008) != 0)) {
                        result.id_ = idBuilder_ == null
                                ? id_
                                : idBuilder_.build();
                        to_bitField0_ |= 0x00000001;
                    }
                    if (((from_bitField0_ & 0x00000010) != 0)) {
                        result.capabilities_ = capabilitiesBuilder_ == null
                                ? capabilities_
                                : capabilitiesBuilder_.build();
                        to_bitField0_ |= 0x00000002;
                    }
                    result.bitField0_ |= to_bitField0_;
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance()) return this;
                    if (other.getVersion() != 0) {
                        setVersion(other.getVersion());
                    }
                    if (other.getAs() != 0) {
                        setAs(other.getAs());
                    }
                    if (other.getHoldTime() != 0) {
                        setHoldTime(other.getHoldTime());
                    }
                    if (other.hasId()) {
                        mergeId(other.getId());
                    }
                    if (other.hasCapabilities()) {
                        mergeCapabilities(other.getCapabilities());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 8: {
                                    version_ = input.readUInt32();
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 8
                                case 21: {
                                    as_ = input.readFixed32();
                                    bitField0_ |= 0x00000002;
                                    break;
                                } // case 21
                                case 24: {
                                    holdTime_ = input.readUInt32();
                                    bitField0_ |= 0x00000004;
                                    break;
                                } // case 24
                                case 34: {
                                    input.readMessage(
                                            getIdFieldBuilder().getBuilder(),
                                            extensionRegistry);
                                    bitField0_ |= 0x00000008;
                                    break;
                                } // case 34
                                case 42: {
                                    input.readMessage(
                                            getCapabilitiesFieldBuilder().getBuilder(),
                                            extensionRegistry);
                                    bitField0_ |= 0x00000010;
                                    break;
                                } // case 42
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private int version_ ;
                /**
                 * <code>uint32 version = 1;</code>
                 * @return The version.
                 */
                @java.lang.Override
                public int getVersion() {
                    return version_;
                }
                /**
                 * <code>uint32 version = 1;</code>
                 * @param value The version to set.
                 * @return This builder for chaining.
                 */
                public Builder setVersion(int value) {

                    version_ = value;
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 version = 1;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearVersion() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    version_ = 0;
                    onChanged();
                    return this;
                }

                private int as_ ;
                /**
                 * <code>fixed32 as = 2;</code>
                 * @return The as.
                 */
                @java.lang.Override
                public int getAs() {
                    return as_;
                }
                /**
                 * <code>fixed32 as = 2;</code>
                 * @param value The as to set.
                 * @return This builder for chaining.
                 */
                public Builder setAs(int value) {

                    as_ = value;
                    bitField0_ |= 0x00000002;
                    onChanged();
                    return this;
                }
                /**
                 * <code>fixed32 as = 2;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearAs() {
                    bitField0_ = (bitField0_ & ~0x00000002);
                    as_ = 0;
                    onChanged();
                    return this;
                }

                private int holdTime_ ;
                /**
                 * <code>uint32 hold_time = 3;</code>
                 * @return The holdTime.
                 */
                @java.lang.Override
                public int getHoldTime() {
                    return holdTime_;
                }
                /**
                 * <code>uint32 hold_time = 3;</code>
                 * @param value The holdTime to set.
                 * @return This builder for chaining.
                 */
                public Builder setHoldTime(int value) {

                    holdTime_ = value;
                    bitField0_ |= 0x00000004;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 hold_time = 3;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearHoldTime() {
                    bitField0_ = (bitField0_ & ~0x00000004);
                    holdTime_ = 0;
                    onChanged();
                    return this;
                }

                private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress id_;
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> idBuilder_;
                /**
                 * <code>.IpAddress id = 4;</code>
                 * @return Whether the id field is set.
                 */
                public boolean hasId() {
                    return ((bitField0_ & 0x00000008) != 0);
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 * @return The id.
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getId() {
                    if (idBuilder_ == null) {
                        return id_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
                    } else {
                        return idBuilder_.getMessage();
                    }
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public Builder setId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                    if (idBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        id_ = value;
                    } else {
                        idBuilder_.setMessage(value);
                    }
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public Builder setId(
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                    if (idBuilder_ == null) {
                        id_ = builderForValue.build();
                    } else {
                        idBuilder_.setMessage(builderForValue.build());
                    }
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public Builder mergeId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                    if (idBuilder_ == null) {
                        if (((bitField0_ & 0x00000008) != 0) &&
                                id_ != null &&
                                id_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                            getIdBuilder().mergeFrom(value);
                        } else {
                            id_ = value;
                        }
                    } else {
                        idBuilder_.mergeFrom(value);
                    }
                    if (id_ != null) {
                        bitField0_ |= 0x00000008;
                        onChanged();
                    }
                    return this;
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public Builder clearId() {
                    bitField0_ = (bitField0_ & ~0x00000008);
                    id_ = null;
                    if (idBuilder_ != null) {
                        idBuilder_.dispose();
                        idBuilder_ = null;
                    }
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getIdBuilder() {
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return getIdFieldBuilder().getBuilder();
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getIdOrBuilder() {
                    if (idBuilder_ != null) {
                        return idBuilder_.getMessageOrBuilder();
                    } else {
                        return id_ == null ?
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : id_;
                    }
                }
                /**
                 * <code>.IpAddress id = 4;</code>
                 */
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                getIdFieldBuilder() {
                    if (idBuilder_ == null) {
                        idBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                                getId(),
                                getParentForChildren(),
                                isClean());
                        id_ = null;
                    }
                    return idBuilder_;
                }

                private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList capabilities_;
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder> capabilitiesBuilder_;
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 * @return Whether the capabilities field is set.
                 */
                public boolean hasCapabilities() {
                    return ((bitField0_ & 0x00000010) != 0);
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 * @return The capabilities.
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList getCapabilities() {
                    if (capabilitiesBuilder_ == null) {
                        return capabilities_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance() : capabilities_;
                    } else {
                        return capabilitiesBuilder_.getMessage();
                    }
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public Builder setCapabilities(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList value) {
                    if (capabilitiesBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        capabilities_ = value;
                    } else {
                        capabilitiesBuilder_.setMessage(value);
                    }
                    bitField0_ |= 0x00000010;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public Builder setCapabilities(
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder builderForValue) {
                    if (capabilitiesBuilder_ == null) {
                        capabilities_ = builderForValue.build();
                    } else {
                        capabilitiesBuilder_.setMessage(builderForValue.build());
                    }
                    bitField0_ |= 0x00000010;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public Builder mergeCapabilities(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList value) {
                    if (capabilitiesBuilder_ == null) {
                        if (((bitField0_ & 0x00000010) != 0) &&
                                capabilities_ != null &&
                                capabilities_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance()) {
                            getCapabilitiesBuilder().mergeFrom(value);
                        } else {
                            capabilities_ = value;
                        }
                    } else {
                        capabilitiesBuilder_.mergeFrom(value);
                    }
                    if (capabilities_ != null) {
                        bitField0_ |= 0x00000010;
                        onChanged();
                    }
                    return this;
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public Builder clearCapabilities() {
                    bitField0_ = (bitField0_ & ~0x00000010);
                    capabilities_ = null;
                    if (capabilitiesBuilder_ != null) {
                        capabilitiesBuilder_.dispose();
                        capabilitiesBuilder_ = null;
                    }
                    onChanged();
                    return this;
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder getCapabilitiesBuilder() {
                    bitField0_ |= 0x00000010;
                    onChanged();
                    return getCapabilitiesFieldBuilder().getBuilder();
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder getCapabilitiesOrBuilder() {
                    if (capabilitiesBuilder_ != null) {
                        return capabilitiesBuilder_.getMessageOrBuilder();
                    } else {
                        return capabilities_ == null ?
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.getDefaultInstance() : capabilities_;
                    }
                }
                /**
                 * <code>.PeerUpPacket.CapabilityList capabilities = 5;</code>
                 */
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder>
                getCapabilitiesFieldBuilder() {
                    if (capabilitiesBuilder_ == null) {
                        capabilitiesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityList.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.CapabilityListOrBuilder>(
                                getCapabilities(),
                                getParentForChildren(),
                                isClean());
                        capabilities_ = null;
                    }
                    return capabilitiesBuilder_;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:PeerUpPacket.OpenMessage)
            }

            // @@protoc_insertion_point(class_scope:PeerUpPacket.OpenMessage)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<OpenMessage>
                    PARSER = new com.google.protobuf.AbstractParser<OpenMessage>() {
                @java.lang.Override
                public OpenMessage parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<OpenMessage> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<OpenMessage> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        private int bitField0_;
        public static final int PEER_FIELD_NUMBER = 1;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer peer_;
        /**
         * <code>.Peer peer = 1;</code>
         * @return Whether the peer field is set.
         */
        @java.lang.Override
        public boolean hasPeer() {
            return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>.Peer peer = 1;</code>
         * @return The peer.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer() {
            return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
        }
        /**
         * <code>.Peer peer = 1;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder() {
            return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
        }

        public static final int LOCAL_ADDRESS_FIELD_NUMBER = 2;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress localAddress_;
        /**
         * <code>.IpAddress local_address = 2;</code>
         * @return Whether the localAddress field is set.
         */
        @java.lang.Override
        public boolean hasLocalAddress() {
            return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>.IpAddress local_address = 2;</code>
         * @return The localAddress.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getLocalAddress() {
            return localAddress_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : localAddress_;
        }
        /**
         * <code>.IpAddress local_address = 2;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getLocalAddressOrBuilder() {
            return localAddress_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : localAddress_;
        }

        public static final int LOCAL_PORT_FIELD_NUMBER = 3;
        private int localPort_ = 0;
        /**
         * <code>uint32 local_port = 3;</code>
         * @return The localPort.
         */
        @java.lang.Override
        public int getLocalPort() {
            return localPort_;
        }

        public static final int REMOTE_PORT_FIELD_NUMBER = 4;
        private int remotePort_ = 0;
        /**
         * <code>uint32 remote_port = 4;</code>
         * @return The remotePort.
         */
        @java.lang.Override
        public int getRemotePort() {
            return remotePort_;
        }

        public static final int SEND_MSG_FIELD_NUMBER = 5;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage sendMsg_;
        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         * @return Whether the sendMsg field is set.
         */
        @java.lang.Override
        public boolean hasSendMsg() {
            return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         * @return The sendMsg.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getSendMsg() {
            return sendMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : sendMsg_;
        }
        /**
         * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getSendMsgOrBuilder() {
            return sendMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : sendMsg_;
        }

        public static final int RECV_MSG_FIELD_NUMBER = 6;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage recvMsg_;
        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         * @return Whether the recvMsg field is set.
         */
        @java.lang.Override
        public boolean hasRecvMsg() {
            return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         * @return The recvMsg.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getRecvMsg() {
            return recvMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : recvMsg_;
        }
        /**
         * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getRecvMsgOrBuilder() {
            return recvMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : recvMsg_;
        }

        public static final int SYS_NAME_FIELD_NUMBER = 7;
        @SuppressWarnings("serial")
        private volatile java.lang.Object sysName_ = "";
        /**
         * <code>string sys_name = 7;</code>
         * @return The sysName.
         */
        @java.lang.Override
        public java.lang.String getSysName() {
            java.lang.Object ref = sysName_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                sysName_ = s;
                return s;
            }
        }
        /**
         * <code>string sys_name = 7;</code>
         * @return The bytes for sysName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getSysNameBytes() {
            java.lang.Object ref = sysName_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                sysName_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        public static final int SYS_DESC_FIELD_NUMBER = 8;
        @SuppressWarnings("serial")
        private volatile java.lang.Object sysDesc_ = "";
        /**
         * <code>string sys_desc = 8;</code>
         * @return The sysDesc.
         */
        @java.lang.Override
        public java.lang.String getSysDesc() {
            java.lang.Object ref = sysDesc_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                sysDesc_ = s;
                return s;
            }
        }
        /**
         * <code>string sys_desc = 8;</code>
         * @return The bytes for sysDesc.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getSysDescBytes() {
            java.lang.Object ref = sysDesc_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                sysDesc_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        public static final int MESSAGE_FIELD_NUMBER = 9;
        @SuppressWarnings("serial")
        private volatile java.lang.Object message_ = "";
        /**
         * <code>string message = 9;</code>
         * @return The message.
         */
        @java.lang.Override
        public java.lang.String getMessage() {
            java.lang.Object ref = message_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                message_ = s;
                return s;
            }
        }
        /**
         * <code>string message = 9;</code>
         * @return The bytes for message.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getMessageBytes() {
            java.lang.Object ref = message_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                message_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        public static final int TABLE_NAME_FIELD_NUMBER = 10;
        @SuppressWarnings("serial")
        private volatile java.lang.Object tableName_ = "";
        /**
         * <code>string table_name = 10;</code>
         * @return The tableName.
         */
        @java.lang.Override
        public java.lang.String getTableName() {
            java.lang.Object ref = tableName_;
            if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
            } else {
                com.google.protobuf.ByteString bs =
                        (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                tableName_ = s;
                return s;
            }
        }
        /**
         * <code>string table_name = 10;</code>
         * @return The bytes for tableName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString
        getTableNameBytes() {
            java.lang.Object ref = tableName_;
            if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                        com.google.protobuf.ByteString.copyFromUtf8(
                                (java.lang.String) ref);
                tableName_ = b;
                return b;
            } else {
                return (com.google.protobuf.ByteString) ref;
            }
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (((bitField0_ & 0x00000001) != 0)) {
                output.writeMessage(1, getPeer());
            }
            if (((bitField0_ & 0x00000002) != 0)) {
                output.writeMessage(2, getLocalAddress());
            }
            if (localPort_ != 0) {
                output.writeUInt32(3, localPort_);
            }
            if (remotePort_ != 0) {
                output.writeUInt32(4, remotePort_);
            }
            if (((bitField0_ & 0x00000004) != 0)) {
                output.writeMessage(5, getSendMsg());
            }
            if (((bitField0_ & 0x00000008) != 0)) {
                output.writeMessage(6, getRecvMsg());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysName_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 7, sysName_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysDesc_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sysDesc_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 9, message_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 10, tableName_);
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(1, getPeer());
            }
            if (((bitField0_ & 0x00000002) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(2, getLocalAddress());
            }
            if (localPort_ != 0) {
                size += com.google.protobuf.CodedOutputStream
                        .computeUInt32Size(3, localPort_);
            }
            if (remotePort_ != 0) {
                size += com.google.protobuf.CodedOutputStream
                        .computeUInt32Size(4, remotePort_);
            }
            if (((bitField0_ & 0x00000004) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(5, getSendMsg());
            }
            if (((bitField0_ & 0x00000008) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(6, getRecvMsg());
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysName_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, sysName_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sysDesc_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, sysDesc_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, message_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, tableName_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket) obj;

            if (hasPeer() != other.hasPeer()) return false;
            if (hasPeer()) {
                if (!getPeer()
                        .equals(other.getPeer())) return false;
            }
            if (hasLocalAddress() != other.hasLocalAddress()) return false;
            if (hasLocalAddress()) {
                if (!getLocalAddress()
                        .equals(other.getLocalAddress())) return false;
            }
            if (getLocalPort()
                    != other.getLocalPort()) return false;
            if (getRemotePort()
                    != other.getRemotePort()) return false;
            if (hasSendMsg() != other.hasSendMsg()) return false;
            if (hasSendMsg()) {
                if (!getSendMsg()
                        .equals(other.getSendMsg())) return false;
            }
            if (hasRecvMsg() != other.hasRecvMsg()) return false;
            if (hasRecvMsg()) {
                if (!getRecvMsg()
                        .equals(other.getRecvMsg())) return false;
            }
            if (!getSysName()
                    .equals(other.getSysName())) return false;
            if (!getSysDesc()
                    .equals(other.getSysDesc())) return false;
            if (!getMessage()
                    .equals(other.getMessage())) return false;
            if (!getTableName()
                    .equals(other.getTableName())) return false;
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (hasPeer()) {
                hash = (37 * hash) + PEER_FIELD_NUMBER;
                hash = (53 * hash) + getPeer().hashCode();
            }
            if (hasLocalAddress()) {
                hash = (37 * hash) + LOCAL_ADDRESS_FIELD_NUMBER;
                hash = (53 * hash) + getLocalAddress().hashCode();
            }
            hash = (37 * hash) + LOCAL_PORT_FIELD_NUMBER;
            hash = (53 * hash) + getLocalPort();
            hash = (37 * hash) + REMOTE_PORT_FIELD_NUMBER;
            hash = (53 * hash) + getRemotePort();
            if (hasSendMsg()) {
                hash = (37 * hash) + SEND_MSG_FIELD_NUMBER;
                hash = (53 * hash) + getSendMsg().hashCode();
            }
            if (hasRecvMsg()) {
                hash = (37 * hash) + RECV_MSG_FIELD_NUMBER;
                hash = (53 * hash) + getRecvMsg().hashCode();
            }
            hash = (37 * hash) + SYS_NAME_FIELD_NUMBER;
            hash = (53 * hash) + getSysName().hashCode();
            hash = (37 * hash) + SYS_DESC_FIELD_NUMBER;
            hash = (53 * hash) + getSysDesc().hashCode();
            hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
            hash = (53 * hash) + getMessage().hashCode();
            hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
            hash = (53 * hash) + getTableName().hashCode();
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code PeerUpPacket}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:PeerUpPacket)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacketOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                    getPeerFieldBuilder();
                    getLocalAddressFieldBuilder();
                    getSendMsgFieldBuilder();
                    getRecvMsgFieldBuilder();
                }
            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                peer_ = null;
                if (peerBuilder_ != null) {
                    peerBuilder_.dispose();
                    peerBuilder_ = null;
                }
                localAddress_ = null;
                if (localAddressBuilder_ != null) {
                    localAddressBuilder_.dispose();
                    localAddressBuilder_ = null;
                }
                localPort_ = 0;
                remotePort_ = 0;
                sendMsg_ = null;
                if (sendMsgBuilder_ != null) {
                    sendMsgBuilder_.dispose();
                    sendMsgBuilder_ = null;
                }
                recvMsg_ = null;
                if (recvMsgBuilder_ != null) {
                    recvMsgBuilder_.dispose();
                    recvMsgBuilder_ = null;
                }
                sysName_ = "";
                sysDesc_ = "";
                message_ = "";
                tableName_ = "";
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerUpPacket_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket result) {
                int from_bitField0_ = bitField0_;
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                    result.peer_ = peerBuilder_ == null
                            ? peer_
                            : peerBuilder_.build();
                    to_bitField0_ |= 0x00000001;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                    result.localAddress_ = localAddressBuilder_ == null
                            ? localAddress_
                            : localAddressBuilder_.build();
                    to_bitField0_ |= 0x00000002;
                }
                if (((from_bitField0_ & 0x00000004) != 0)) {
                    result.localPort_ = localPort_;
                }
                if (((from_bitField0_ & 0x00000008) != 0)) {
                    result.remotePort_ = remotePort_;
                }
                if (((from_bitField0_ & 0x00000010) != 0)) {
                    result.sendMsg_ = sendMsgBuilder_ == null
                            ? sendMsg_
                            : sendMsgBuilder_.build();
                    to_bitField0_ |= 0x00000004;
                }
                if (((from_bitField0_ & 0x00000020) != 0)) {
                    result.recvMsg_ = recvMsgBuilder_ == null
                            ? recvMsg_
                            : recvMsgBuilder_.build();
                    to_bitField0_ |= 0x00000008;
                }
                if (((from_bitField0_ & 0x00000040) != 0)) {
                    result.sysName_ = sysName_;
                }
                if (((from_bitField0_ & 0x00000080) != 0)) {
                    result.sysDesc_ = sysDesc_;
                }
                if (((from_bitField0_ & 0x00000100) != 0)) {
                    result.message_ = message_;
                }
                if (((from_bitField0_ & 0x00000200) != 0)) {
                    result.tableName_ = tableName_;
                }
                result.bitField0_ |= to_bitField0_;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.getDefaultInstance()) return this;
                if (other.hasPeer()) {
                    mergePeer(other.getPeer());
                }
                if (other.hasLocalAddress()) {
                    mergeLocalAddress(other.getLocalAddress());
                }
                if (other.getLocalPort() != 0) {
                    setLocalPort(other.getLocalPort());
                }
                if (other.getRemotePort() != 0) {
                    setRemotePort(other.getRemotePort());
                }
                if (other.hasSendMsg()) {
                    mergeSendMsg(other.getSendMsg());
                }
                if (other.hasRecvMsg()) {
                    mergeRecvMsg(other.getRecvMsg());
                }
                if (!other.getSysName().isEmpty()) {
                    sysName_ = other.sysName_;
                    bitField0_ |= 0x00000040;
                    onChanged();
                }
                if (!other.getSysDesc().isEmpty()) {
                    sysDesc_ = other.sysDesc_;
                    bitField0_ |= 0x00000080;
                    onChanged();
                }
                if (!other.getMessage().isEmpty()) {
                    message_ = other.message_;
                    bitField0_ |= 0x00000100;
                    onChanged();
                }
                if (!other.getTableName().isEmpty()) {
                    tableName_ = other.tableName_;
                    bitField0_ |= 0x00000200;
                    onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 10: {
                                input.readMessage(
                                        getPeerFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000001;
                                break;
                            } // case 10
                            case 18: {
                                input.readMessage(
                                        getLocalAddressFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000002;
                                break;
                            } // case 18
                            case 24: {
                                localPort_ = input.readUInt32();
                                bitField0_ |= 0x00000004;
                                break;
                            } // case 24
                            case 32: {
                                remotePort_ = input.readUInt32();
                                bitField0_ |= 0x00000008;
                                break;
                            } // case 32
                            case 42: {
                                input.readMessage(
                                        getSendMsgFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000010;
                                break;
                            } // case 42
                            case 50: {
                                input.readMessage(
                                        getRecvMsgFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000020;
                                break;
                            } // case 50
                            case 58: {
                                sysName_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000040;
                                break;
                            } // case 58
                            case 66: {
                                sysDesc_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000080;
                                break;
                            } // case 66
                            case 74: {
                                message_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000100;
                                break;
                            } // case 74
                            case 82: {
                                tableName_ = input.readStringRequireUtf8();
                                bitField0_ |= 0x00000200;
                                break;
                            } // case 82
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int bitField0_;

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer peer_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder> peerBuilder_;
            /**
             * <code>.Peer peer = 1;</code>
             * @return Whether the peer field is set.
             */
            public boolean hasPeer() {
                return ((bitField0_ & 0x00000001) != 0);
            }
            /**
             * <code>.Peer peer = 1;</code>
             * @return The peer.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer() {
                if (peerBuilder_ == null) {
                    return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
                } else {
                    return peerBuilder_.getMessage();
                }
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder setPeer(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer value) {
                if (peerBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    peer_ = value;
                } else {
                    peerBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder setPeer(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder builderForValue) {
                if (peerBuilder_ == null) {
                    peer_ = builderForValue.build();
                } else {
                    peerBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder mergePeer(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer value) {
                if (peerBuilder_ == null) {
                    if (((bitField0_ & 0x00000001) != 0) &&
                            peer_ != null &&
                            peer_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance()) {
                        getPeerBuilder().mergeFrom(value);
                    } else {
                        peer_ = value;
                    }
                } else {
                    peerBuilder_.mergeFrom(value);
                }
                if (peer_ != null) {
                    bitField0_ |= 0x00000001;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder clearPeer() {
                bitField0_ = (bitField0_ & ~0x00000001);
                peer_ = null;
                if (peerBuilder_ != null) {
                    peerBuilder_.dispose();
                    peerBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder getPeerBuilder() {
                bitField0_ |= 0x00000001;
                onChanged();
                return getPeerFieldBuilder().getBuilder();
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder() {
                if (peerBuilder_ != null) {
                    return peerBuilder_.getMessageOrBuilder();
                } else {
                    return peer_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
                }
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder>
            getPeerFieldBuilder() {
                if (peerBuilder_ == null) {
                    peerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder>(
                            getPeer(),
                            getParentForChildren(),
                            isClean());
                    peer_ = null;
                }
                return peerBuilder_;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress localAddress_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> localAddressBuilder_;
            /**
             * <code>.IpAddress local_address = 2;</code>
             * @return Whether the localAddress field is set.
             */
            public boolean hasLocalAddress() {
                return ((bitField0_ & 0x00000002) != 0);
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             * @return The localAddress.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getLocalAddress() {
                if (localAddressBuilder_ == null) {
                    return localAddress_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : localAddress_;
                } else {
                    return localAddressBuilder_.getMessage();
                }
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public Builder setLocalAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (localAddressBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    localAddress_ = value;
                } else {
                    localAddressBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public Builder setLocalAddress(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                if (localAddressBuilder_ == null) {
                    localAddress_ = builderForValue.build();
                } else {
                    localAddressBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public Builder mergeLocalAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                if (localAddressBuilder_ == null) {
                    if (((bitField0_ & 0x00000002) != 0) &&
                            localAddress_ != null &&
                            localAddress_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                        getLocalAddressBuilder().mergeFrom(value);
                    } else {
                        localAddress_ = value;
                    }
                } else {
                    localAddressBuilder_.mergeFrom(value);
                }
                if (localAddress_ != null) {
                    bitField0_ |= 0x00000002;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public Builder clearLocalAddress() {
                bitField0_ = (bitField0_ & ~0x00000002);
                localAddress_ = null;
                if (localAddressBuilder_ != null) {
                    localAddressBuilder_.dispose();
                    localAddressBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getLocalAddressBuilder() {
                bitField0_ |= 0x00000002;
                onChanged();
                return getLocalAddressFieldBuilder().getBuilder();
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getLocalAddressOrBuilder() {
                if (localAddressBuilder_ != null) {
                    return localAddressBuilder_.getMessageOrBuilder();
                } else {
                    return localAddress_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : localAddress_;
                }
            }
            /**
             * <code>.IpAddress local_address = 2;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
            getLocalAddressFieldBuilder() {
                if (localAddressBuilder_ == null) {
                    localAddressBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                            getLocalAddress(),
                            getParentForChildren(),
                            isClean());
                    localAddress_ = null;
                }
                return localAddressBuilder_;
            }

            private int localPort_ ;
            /**
             * <code>uint32 local_port = 3;</code>
             * @return The localPort.
             */
            @java.lang.Override
            public int getLocalPort() {
                return localPort_;
            }
            /**
             * <code>uint32 local_port = 3;</code>
             * @param value The localPort to set.
             * @return This builder for chaining.
             */
            public Builder setLocalPort(int value) {

                localPort_ = value;
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
            }
            /**
             * <code>uint32 local_port = 3;</code>
             * @return This builder for chaining.
             */
            public Builder clearLocalPort() {
                bitField0_ = (bitField0_ & ~0x00000004);
                localPort_ = 0;
                onChanged();
                return this;
            }

            private int remotePort_ ;
            /**
             * <code>uint32 remote_port = 4;</code>
             * @return The remotePort.
             */
            @java.lang.Override
            public int getRemotePort() {
                return remotePort_;
            }
            /**
             * <code>uint32 remote_port = 4;</code>
             * @param value The remotePort to set.
             * @return This builder for chaining.
             */
            public Builder setRemotePort(int value) {

                remotePort_ = value;
                bitField0_ |= 0x00000008;
                onChanged();
                return this;
            }
            /**
             * <code>uint32 remote_port = 4;</code>
             * @return This builder for chaining.
             */
            public Builder clearRemotePort() {
                bitField0_ = (bitField0_ & ~0x00000008);
                remotePort_ = 0;
                onChanged();
                return this;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage sendMsg_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder> sendMsgBuilder_;
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             * @return Whether the sendMsg field is set.
             */
            public boolean hasSendMsg() {
                return ((bitField0_ & 0x00000010) != 0);
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             * @return The sendMsg.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getSendMsg() {
                if (sendMsgBuilder_ == null) {
                    return sendMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : sendMsg_;
                } else {
                    return sendMsgBuilder_.getMessage();
                }
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public Builder setSendMsg(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage value) {
                if (sendMsgBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    sendMsg_ = value;
                } else {
                    sendMsgBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public Builder setSendMsg(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder builderForValue) {
                if (sendMsgBuilder_ == null) {
                    sendMsg_ = builderForValue.build();
                } else {
                    sendMsgBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000010;
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public Builder mergeSendMsg(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage value) {
                if (sendMsgBuilder_ == null) {
                    if (((bitField0_ & 0x00000010) != 0) &&
                            sendMsg_ != null &&
                            sendMsg_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance()) {
                        getSendMsgBuilder().mergeFrom(value);
                    } else {
                        sendMsg_ = value;
                    }
                } else {
                    sendMsgBuilder_.mergeFrom(value);
                }
                if (sendMsg_ != null) {
                    bitField0_ |= 0x00000010;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public Builder clearSendMsg() {
                bitField0_ = (bitField0_ & ~0x00000010);
                sendMsg_ = null;
                if (sendMsgBuilder_ != null) {
                    sendMsgBuilder_.dispose();
                    sendMsgBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder getSendMsgBuilder() {
                bitField0_ |= 0x00000010;
                onChanged();
                return getSendMsgFieldBuilder().getBuilder();
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getSendMsgOrBuilder() {
                if (sendMsgBuilder_ != null) {
                    return sendMsgBuilder_.getMessageOrBuilder();
                } else {
                    return sendMsg_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : sendMsg_;
                }
            }
            /**
             * <code>.PeerUpPacket.OpenMessage send_msg = 5;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder>
            getSendMsgFieldBuilder() {
                if (sendMsgBuilder_ == null) {
                    sendMsgBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder>(
                            getSendMsg(),
                            getParentForChildren(),
                            isClean());
                    sendMsg_ = null;
                }
                return sendMsgBuilder_;
            }

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage recvMsg_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder> recvMsgBuilder_;
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             * @return Whether the recvMsg field is set.
             */
            public boolean hasRecvMsg() {
                return ((bitField0_ & 0x00000020) != 0);
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             * @return The recvMsg.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage getRecvMsg() {
                if (recvMsgBuilder_ == null) {
                    return recvMsg_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : recvMsg_;
                } else {
                    return recvMsgBuilder_.getMessage();
                }
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public Builder setRecvMsg(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage value) {
                if (recvMsgBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    recvMsg_ = value;
                } else {
                    recvMsgBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000020;
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public Builder setRecvMsg(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder builderForValue) {
                if (recvMsgBuilder_ == null) {
                    recvMsg_ = builderForValue.build();
                } else {
                    recvMsgBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000020;
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public Builder mergeRecvMsg(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage value) {
                if (recvMsgBuilder_ == null) {
                    if (((bitField0_ & 0x00000020) != 0) &&
                            recvMsg_ != null &&
                            recvMsg_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance()) {
                        getRecvMsgBuilder().mergeFrom(value);
                    } else {
                        recvMsg_ = value;
                    }
                } else {
                    recvMsgBuilder_.mergeFrom(value);
                }
                if (recvMsg_ != null) {
                    bitField0_ |= 0x00000020;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public Builder clearRecvMsg() {
                bitField0_ = (bitField0_ & ~0x00000020);
                recvMsg_ = null;
                if (recvMsgBuilder_ != null) {
                    recvMsgBuilder_.dispose();
                    recvMsgBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder getRecvMsgBuilder() {
                bitField0_ |= 0x00000020;
                onChanged();
                return getRecvMsgFieldBuilder().getBuilder();
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder getRecvMsgOrBuilder() {
                if (recvMsgBuilder_ != null) {
                    return recvMsgBuilder_.getMessageOrBuilder();
                } else {
                    return recvMsg_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.getDefaultInstance() : recvMsg_;
                }
            }
            /**
             * <code>.PeerUpPacket.OpenMessage recv_msg = 6;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder>
            getRecvMsgFieldBuilder() {
                if (recvMsgBuilder_ == null) {
                    recvMsgBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessage.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket.OpenMessageOrBuilder>(
                            getRecvMsg(),
                            getParentForChildren(),
                            isClean());
                    recvMsg_ = null;
                }
                return recvMsgBuilder_;
            }

            private java.lang.Object sysName_ = "";
            /**
             * <code>string sys_name = 7;</code>
             * @return The sysName.
             */
            public java.lang.String getSysName() {
                java.lang.Object ref = sysName_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    sysName_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string sys_name = 7;</code>
             * @return The bytes for sysName.
             */
            public com.google.protobuf.ByteString
            getSysNameBytes() {
                java.lang.Object ref = sysName_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    sysName_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string sys_name = 7;</code>
             * @param value The sysName to set.
             * @return This builder for chaining.
             */
            public Builder setSysName(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                sysName_ = value;
                bitField0_ |= 0x00000040;
                onChanged();
                return this;
            }
            /**
             * <code>string sys_name = 7;</code>
             * @return This builder for chaining.
             */
            public Builder clearSysName() {
                sysName_ = getDefaultInstance().getSysName();
                bitField0_ = (bitField0_ & ~0x00000040);
                onChanged();
                return this;
            }
            /**
             * <code>string sys_name = 7;</code>
             * @param value The bytes for sysName to set.
             * @return This builder for chaining.
             */
            public Builder setSysNameBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                sysName_ = value;
                bitField0_ |= 0x00000040;
                onChanged();
                return this;
            }

            private java.lang.Object sysDesc_ = "";
            /**
             * <code>string sys_desc = 8;</code>
             * @return The sysDesc.
             */
            public java.lang.String getSysDesc() {
                java.lang.Object ref = sysDesc_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    sysDesc_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string sys_desc = 8;</code>
             * @return The bytes for sysDesc.
             */
            public com.google.protobuf.ByteString
            getSysDescBytes() {
                java.lang.Object ref = sysDesc_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    sysDesc_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string sys_desc = 8;</code>
             * @param value The sysDesc to set.
             * @return This builder for chaining.
             */
            public Builder setSysDesc(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                sysDesc_ = value;
                bitField0_ |= 0x00000080;
                onChanged();
                return this;
            }
            /**
             * <code>string sys_desc = 8;</code>
             * @return This builder for chaining.
             */
            public Builder clearSysDesc() {
                sysDesc_ = getDefaultInstance().getSysDesc();
                bitField0_ = (bitField0_ & ~0x00000080);
                onChanged();
                return this;
            }
            /**
             * <code>string sys_desc = 8;</code>
             * @param value The bytes for sysDesc to set.
             * @return This builder for chaining.
             */
            public Builder setSysDescBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                sysDesc_ = value;
                bitField0_ |= 0x00000080;
                onChanged();
                return this;
            }

            private java.lang.Object message_ = "";
            /**
             * <code>string message = 9;</code>
             * @return The message.
             */
            public java.lang.String getMessage() {
                java.lang.Object ref = message_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    message_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string message = 9;</code>
             * @return The bytes for message.
             */
            public com.google.protobuf.ByteString
            getMessageBytes() {
                java.lang.Object ref = message_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    message_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string message = 9;</code>
             * @param value The message to set.
             * @return This builder for chaining.
             */
            public Builder setMessage(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                message_ = value;
                bitField0_ |= 0x00000100;
                onChanged();
                return this;
            }
            /**
             * <code>string message = 9;</code>
             * @return This builder for chaining.
             */
            public Builder clearMessage() {
                message_ = getDefaultInstance().getMessage();
                bitField0_ = (bitField0_ & ~0x00000100);
                onChanged();
                return this;
            }
            /**
             * <code>string message = 9;</code>
             * @param value The bytes for message to set.
             * @return This builder for chaining.
             */
            public Builder setMessageBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                message_ = value;
                bitField0_ |= 0x00000100;
                onChanged();
                return this;
            }

            private java.lang.Object tableName_ = "";
            /**
             * <code>string table_name = 10;</code>
             * @return The tableName.
             */
            public java.lang.String getTableName() {
                java.lang.Object ref = tableName_;
                if (!(ref instanceof java.lang.String)) {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    tableName_ = s;
                    return s;
                } else {
                    return (java.lang.String) ref;
                }
            }
            /**
             * <code>string table_name = 10;</code>
             * @return The bytes for tableName.
             */
            public com.google.protobuf.ByteString
            getTableNameBytes() {
                java.lang.Object ref = tableName_;
                if (ref instanceof String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    tableName_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }
            /**
             * <code>string table_name = 10;</code>
             * @param value The tableName to set.
             * @return This builder for chaining.
             */
            public Builder setTableName(
                    java.lang.String value) {
                if (value == null) { throw new NullPointerException(); }
                tableName_ = value;
                bitField0_ |= 0x00000200;
                onChanged();
                return this;
            }
            /**
             * <code>string table_name = 10;</code>
             * @return This builder for chaining.
             */
            public Builder clearTableName() {
                tableName_ = getDefaultInstance().getTableName();
                bitField0_ = (bitField0_ & ~0x00000200);
                onChanged();
                return this;
            }
            /**
             * <code>string table_name = 10;</code>
             * @param value The bytes for tableName to set.
             * @return This builder for chaining.
             */
            public Builder setTableNameBytes(
                    com.google.protobuf.ByteString value) {
                if (value == null) { throw new NullPointerException(); }
                checkByteStringIsUtf8(value);
                tableName_ = value;
                bitField0_ |= 0x00000200;
                onChanged();
                return this;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:PeerUpPacket)
        }

        // @@protoc_insertion_point(class_scope:PeerUpPacket)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<PeerUpPacket>
                PARSER = new com.google.protobuf.AbstractParser<PeerUpPacket>() {
            @java.lang.Override
            public PeerUpPacket parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<PeerUpPacket> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<PeerUpPacket> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerUpPacket getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface PeerDownPacketOrBuilder extends
            // @@protoc_insertion_point(interface_extends:PeerDownPacket)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.Peer peer = 1;</code>
         * @return Whether the peer field is set.
         */
        boolean hasPeer();
        /**
         * <code>.Peer peer = 1;</code>
         * @return The peer.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer();
        /**
         * <code>.Peer peer = 1;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder();

        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         * @return Whether the localBgpNotification field is set.
         */
        boolean hasLocalBgpNotification();
        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         * @return The localBgpNotification.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getLocalBgpNotification();
        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getLocalBgpNotificationOrBuilder();

        /**
         * <code>uint32 local_no_notification = 3;</code>
         * @return Whether the localNoNotification field is set.
         */
        boolean hasLocalNoNotification();
        /**
         * <code>uint32 local_no_notification = 3;</code>
         * @return The localNoNotification.
         */
        int getLocalNoNotification();

        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         * @return Whether the remoteBgpNotification field is set.
         */
        boolean hasRemoteBgpNotification();
        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         * @return The remoteBgpNotification.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getRemoteBgpNotification();
        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getRemoteBgpNotificationOrBuilder();

        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         * @return Whether the remoteNoNotification field is set.
         */
        boolean hasRemoteNoNotification();
        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         * @return The remoteNoNotification.
         */
        com.google.protobuf.Empty getRemoteNoNotification();
        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         */
        com.google.protobuf.EmptyOrBuilder getRemoteNoNotificationOrBuilder();

        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         * @return Whether the unknown field is set.
         */
        boolean hasUnknown();
        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         * @return The unknown.
         */
        com.google.protobuf.Empty getUnknown();
        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         */
        com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder();

        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.ReasonCase getReasonCase();
    }
    /**
     * Protobuf type {@code PeerDownPacket}
     */
    public static final class PeerDownPacket extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:PeerDownPacket)
            PeerDownPacketOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use PeerDownPacket.newBuilder() to construct.
        private PeerDownPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private PeerDownPacket() {
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new PeerDownPacket();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Builder.class);
        }

        public interface CodeOrBuilder extends
                // @@protoc_insertion_point(interface_extends:PeerDownPacket.Code)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>uint32 code = 1;</code>
             * @return The code.
             */
            int getCode();

            /**
             * <code>uint32 subcode = 2;</code>
             * @return The subcode.
             */
            int getSubcode();
        }
        /**
         * Protobuf type {@code PeerDownPacket.Code}
         */
        public static final class Code extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:PeerDownPacket.Code)
                CodeOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use Code.newBuilder() to construct.
            private Code(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private Code() {
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new Code();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_Code_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_Code_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder.class);
            }

            public static final int CODE_FIELD_NUMBER = 1;
            private int code_ = 0;
            /**
             * <code>uint32 code = 1;</code>
             * @return The code.
             */
            @java.lang.Override
            public int getCode() {
                return code_;
            }

            public static final int SUBCODE_FIELD_NUMBER = 2;
            private int subcode_ = 0;
            /**
             * <code>uint32 subcode = 2;</code>
             * @return The subcode.
             */
            @java.lang.Override
            public int getSubcode() {
                return subcode_;
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (code_ != 0) {
                    output.writeUInt32(1, code_);
                }
                if (subcode_ != 0) {
                    output.writeUInt32(2, subcode_);
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (code_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(1, code_);
                }
                if (subcode_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(2, subcode_);
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) obj;

                if (getCode()
                        != other.getCode()) return false;
                if (getSubcode()
                        != other.getSubcode()) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                hash = (37 * hash) + CODE_FIELD_NUMBER;
                hash = (53 * hash) + getCode();
                hash = (37 * hash) + SUBCODE_FIELD_NUMBER;
                hash = (53 * hash) + getSubcode();
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code PeerDownPacket.Code}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:PeerDownPacket.Code)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_Code_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_Code_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.newBuilder()
                private Builder() {

                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);

                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    code_ = 0;
                    subcode_ = 0;
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_Code_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code result) {
                    int from_bitField0_ = bitField0_;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.code_ = code_;
                    }
                    if (((from_bitField0_ & 0x00000002) != 0)) {
                        result.subcode_ = subcode_;
                    }
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance()) return this;
                    if (other.getCode() != 0) {
                        setCode(other.getCode());
                    }
                    if (other.getSubcode() != 0) {
                        setSubcode(other.getSubcode());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 8: {
                                    code_ = input.readUInt32();
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 8
                                case 16: {
                                    subcode_ = input.readUInt32();
                                    bitField0_ |= 0x00000002;
                                    break;
                                } // case 16
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private int code_ ;
                /**
                 * <code>uint32 code = 1;</code>
                 * @return The code.
                 */
                @java.lang.Override
                public int getCode() {
                    return code_;
                }
                /**
                 * <code>uint32 code = 1;</code>
                 * @param value The code to set.
                 * @return This builder for chaining.
                 */
                public Builder setCode(int value) {

                    code_ = value;
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 code = 1;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearCode() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    code_ = 0;
                    onChanged();
                    return this;
                }

                private int subcode_ ;
                /**
                 * <code>uint32 subcode = 2;</code>
                 * @return The subcode.
                 */
                @java.lang.Override
                public int getSubcode() {
                    return subcode_;
                }
                /**
                 * <code>uint32 subcode = 2;</code>
                 * @param value The subcode to set.
                 * @return This builder for chaining.
                 */
                public Builder setSubcode(int value) {

                    subcode_ = value;
                    bitField0_ |= 0x00000002;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 subcode = 2;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearSubcode() {
                    bitField0_ = (bitField0_ & ~0x00000002);
                    subcode_ = 0;
                    onChanged();
                    return this;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:PeerDownPacket.Code)
            }

            // @@protoc_insertion_point(class_scope:PeerDownPacket.Code)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<Code>
                    PARSER = new com.google.protobuf.AbstractParser<Code>() {
                @java.lang.Override
                public Code parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<Code> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<Code> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        private int bitField0_;
        private int reasonCase_ = 0;
        @SuppressWarnings("serial")
        private java.lang.Object reason_;
        public enum ReasonCase
                implements com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
            LOCAL_BGP_NOTIFICATION(2),
            LOCAL_NO_NOTIFICATION(3),
            REMOTE_BGP_NOTIFICATION(4),
            REMOTE_NO_NOTIFICATION(5),
            UNKNOWN(6),
            REASON_NOT_SET(0);
            private final int value;
            private ReasonCase(int value) {
                this.value = value;
            }
            /**
             * @param value The number of the enum to look for.
             * @return The enum associated with the given number.
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static ReasonCase valueOf(int value) {
                return forNumber(value);
            }

            public static ReasonCase forNumber(int value) {
                switch (value) {
                    case 2: return LOCAL_BGP_NOTIFICATION;
                    case 3: return LOCAL_NO_NOTIFICATION;
                    case 4: return REMOTE_BGP_NOTIFICATION;
                    case 5: return REMOTE_NO_NOTIFICATION;
                    case 6: return UNKNOWN;
                    case 0: return REASON_NOT_SET;
                    default: return null;
                }
            }
            public int getNumber() {
                return this.value;
            }
        };

        public ReasonCase
        getReasonCase() {
            return ReasonCase.forNumber(
                    reasonCase_);
        }

        public static final int PEER_FIELD_NUMBER = 1;
        private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer peer_;
        /**
         * <code>.Peer peer = 1;</code>
         * @return Whether the peer field is set.
         */
        @java.lang.Override
        public boolean hasPeer() {
            return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>.Peer peer = 1;</code>
         * @return The peer.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer() {
            return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
        }
        /**
         * <code>.Peer peer = 1;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder() {
            return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
        }

        public static final int LOCAL_BGP_NOTIFICATION_FIELD_NUMBER = 2;
        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         * @return Whether the localBgpNotification field is set.
         */
        @java.lang.Override
        public boolean hasLocalBgpNotification() {
            return reasonCase_ == 2;
        }
        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         * @return The localBgpNotification.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getLocalBgpNotification() {
            if (reasonCase_ == 2) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
        }
        /**
         * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getLocalBgpNotificationOrBuilder() {
            if (reasonCase_ == 2) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
        }

        public static final int LOCAL_NO_NOTIFICATION_FIELD_NUMBER = 3;
        /**
         * <code>uint32 local_no_notification = 3;</code>
         * @return Whether the localNoNotification field is set.
         */
        @java.lang.Override
        public boolean hasLocalNoNotification() {
            return reasonCase_ == 3;
        }
        /**
         * <code>uint32 local_no_notification = 3;</code>
         * @return The localNoNotification.
         */
        @java.lang.Override
        public int getLocalNoNotification() {
            if (reasonCase_ == 3) {
                return (java.lang.Integer) reason_;
            }
            return 0;
        }

        public static final int REMOTE_BGP_NOTIFICATION_FIELD_NUMBER = 4;
        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         * @return Whether the remoteBgpNotification field is set.
         */
        @java.lang.Override
        public boolean hasRemoteBgpNotification() {
            return reasonCase_ == 4;
        }
        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         * @return The remoteBgpNotification.
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getRemoteBgpNotification() {
            if (reasonCase_ == 4) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
        }
        /**
         * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
         */
        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getRemoteBgpNotificationOrBuilder() {
            if (reasonCase_ == 4) {
                return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
            }
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
        }

        public static final int REMOTE_NO_NOTIFICATION_FIELD_NUMBER = 5;
        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         * @return Whether the remoteNoNotification field is set.
         */
        @java.lang.Override
        public boolean hasRemoteNoNotification() {
            return reasonCase_ == 5;
        }
        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         * @return The remoteNoNotification.
         */
        @java.lang.Override
        public com.google.protobuf.Empty getRemoteNoNotification() {
            if (reasonCase_ == 5) {
                return (com.google.protobuf.Empty) reason_;
            }
            return com.google.protobuf.Empty.getDefaultInstance();
        }
        /**
         * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
         */
        @java.lang.Override
        public com.google.protobuf.EmptyOrBuilder getRemoteNoNotificationOrBuilder() {
            if (reasonCase_ == 5) {
                return (com.google.protobuf.Empty) reason_;
            }
            return com.google.protobuf.Empty.getDefaultInstance();
        }

        public static final int UNKNOWN_FIELD_NUMBER = 6;
        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         * @return Whether the unknown field is set.
         */
        @java.lang.Override
        public boolean hasUnknown() {
            return reasonCase_ == 6;
        }
        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         * @return The unknown.
         */
        @java.lang.Override
        public com.google.protobuf.Empty getUnknown() {
            if (reasonCase_ == 6) {
                return (com.google.protobuf.Empty) reason_;
            }
            return com.google.protobuf.Empty.getDefaultInstance();
        }
        /**
         * <code>.google.protobuf.Empty unknown = 6;</code>
         */
        @java.lang.Override
        public com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder() {
            if (reasonCase_ == 6) {
                return (com.google.protobuf.Empty) reason_;
            }
            return com.google.protobuf.Empty.getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (((bitField0_ & 0x00000001) != 0)) {
                output.writeMessage(1, getPeer());
            }
            if (reasonCase_ == 2) {
                output.writeMessage(2, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_);
            }
            if (reasonCase_ == 3) {
                output.writeUInt32(
                        3, (int)((java.lang.Integer) reason_));
            }
            if (reasonCase_ == 4) {
                output.writeMessage(4, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_);
            }
            if (reasonCase_ == 5) {
                output.writeMessage(5, (com.google.protobuf.Empty) reason_);
            }
            if (reasonCase_ == 6) {
                output.writeMessage(6, (com.google.protobuf.Empty) reason_);
            }
            getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(1, getPeer());
            }
            if (reasonCase_ == 2) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(2, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_);
            }
            if (reasonCase_ == 3) {
                size += com.google.protobuf.CodedOutputStream
                        .computeUInt32Size(
                                3, (int)((java.lang.Integer) reason_));
            }
            if (reasonCase_ == 4) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(4, (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_);
            }
            if (reasonCase_ == 5) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(5, (com.google.protobuf.Empty) reason_);
            }
            if (reasonCase_ == 6) {
                size += com.google.protobuf.CodedOutputStream
                        .computeMessageSize(6, (com.google.protobuf.Empty) reason_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket)) {
                return super.equals(obj);
            }
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket) obj;

            if (hasPeer() != other.hasPeer()) return false;
            if (hasPeer()) {
                if (!getPeer()
                        .equals(other.getPeer())) return false;
            }
            if (!getReasonCase().equals(other.getReasonCase())) return false;
            switch (reasonCase_) {
                case 2:
                    if (!getLocalBgpNotification()
                            .equals(other.getLocalBgpNotification())) return false;
                    break;
                case 3:
                    if (getLocalNoNotification()
                            != other.getLocalNoNotification()) return false;
                    break;
                case 4:
                    if (!getRemoteBgpNotification()
                            .equals(other.getRemoteBgpNotification())) return false;
                    break;
                case 5:
                    if (!getRemoteNoNotification()
                            .equals(other.getRemoteNoNotification())) return false;
                    break;
                case 6:
                    if (!getUnknown()
                            .equals(other.getUnknown())) return false;
                    break;
                case 0:
                default:
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (hasPeer()) {
                hash = (37 * hash) + PEER_FIELD_NUMBER;
                hash = (53 * hash) + getPeer().hashCode();
            }
            switch (reasonCase_) {
                case 2:
                    hash = (37 * hash) + LOCAL_BGP_NOTIFICATION_FIELD_NUMBER;
                    hash = (53 * hash) + getLocalBgpNotification().hashCode();
                    break;
                case 3:
                    hash = (37 * hash) + LOCAL_NO_NOTIFICATION_FIELD_NUMBER;
                    hash = (53 * hash) + getLocalNoNotification();
                    break;
                case 4:
                    hash = (37 * hash) + REMOTE_BGP_NOTIFICATION_FIELD_NUMBER;
                    hash = (53 * hash) + getRemoteBgpNotification().hashCode();
                    break;
                case 5:
                    hash = (37 * hash) + REMOTE_NO_NOTIFICATION_FIELD_NUMBER;
                    hash = (53 * hash) + getRemoteNoNotification().hashCode();
                    break;
                case 6:
                    hash = (37 * hash) + UNKNOWN_FIELD_NUMBER;
                    hash = (53 * hash) + getUnknown().hashCode();
                    break;
                case 0:
                default:
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }
        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }
        /**
         * Protobuf type {@code PeerDownPacket}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:PeerDownPacket)
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacketOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Builder.class);
            }

            // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }
            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                    getPeerFieldBuilder();
                }
            }
            @java.lang.Override
            public Builder clear() {
                super.clear();
                bitField0_ = 0;
                peer_ = null;
                if (peerBuilder_ != null) {
                    peerBuilder_.dispose();
                    peerBuilder_ = null;
                }
                if (localBgpNotificationBuilder_ != null) {
                    localBgpNotificationBuilder_.clear();
                }
                if (remoteBgpNotificationBuilder_ != null) {
                    remoteBgpNotificationBuilder_.clear();
                }
                if (remoteNoNotificationBuilder_ != null) {
                    remoteNoNotificationBuilder_.clear();
                }
                if (unknownBuilder_ != null) {
                    unknownBuilder_.clear();
                }
                reasonCase_ = 0;
                reason_ = null;
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_PeerDownPacket_descriptor;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket getDefaultInstanceForType() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.getDefaultInstance();
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket build() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket buildPartial() {
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket(this);
                if (bitField0_ != 0) { buildPartial0(result); }
                buildPartialOneofs(result);
                onBuilt();
                return result;
            }

            private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket result) {
                int from_bitField0_ = bitField0_;
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                    result.peer_ = peerBuilder_ == null
                            ? peer_
                            : peerBuilder_.build();
                    to_bitField0_ |= 0x00000001;
                }
                result.bitField0_ |= to_bitField0_;
            }

            private void buildPartialOneofs(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket result) {
                result.reasonCase_ = reasonCase_;
                result.reason_ = this.reason_;
                if (reasonCase_ == 2 &&
                        localBgpNotificationBuilder_ != null) {
                    result.reason_ = localBgpNotificationBuilder_.build();
                }
                if (reasonCase_ == 4 &&
                        remoteBgpNotificationBuilder_ != null) {
                    result.reason_ = remoteBgpNotificationBuilder_.build();
                }
                if (reasonCase_ == 5 &&
                        remoteNoNotificationBuilder_ != null) {
                    result.reason_ = remoteNoNotificationBuilder_.build();
                }
                if (reasonCase_ == 6 &&
                        unknownBuilder_ != null) {
                    result.reason_ = unknownBuilder_.build();
                }
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }
            @java.lang.Override
            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.setField(field, value);
            }
            @java.lang.Override
            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }
            @java.lang.Override
            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }
            @java.lang.Override
            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }
            @java.lang.Override
            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }
            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket) {
                    return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket)other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket other) {
                if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.getDefaultInstance()) return this;
                if (other.hasPeer()) {
                    mergePeer(other.getPeer());
                }
                switch (other.getReasonCase()) {
                    case LOCAL_BGP_NOTIFICATION: {
                        mergeLocalBgpNotification(other.getLocalBgpNotification());
                        break;
                    }
                    case LOCAL_NO_NOTIFICATION: {
                        setLocalNoNotification(other.getLocalNoNotification());
                        break;
                    }
                    case REMOTE_BGP_NOTIFICATION: {
                        mergeRemoteBgpNotification(other.getRemoteBgpNotification());
                        break;
                    }
                    case REMOTE_NO_NOTIFICATION: {
                        mergeRemoteNoNotification(other.getRemoteNoNotification());
                        break;
                    }
                    case UNKNOWN: {
                        mergeUnknown(other.getUnknown());
                        break;
                    }
                    case REASON_NOT_SET: {
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                if (extensionRegistry == null) {
                    throw new java.lang.NullPointerException();
                }
                try {
                    boolean done = false;
                    while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0:
                                done = true;
                                break;
                            case 10: {
                                input.readMessage(
                                        getPeerFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                bitField0_ |= 0x00000001;
                                break;
                            } // case 10
                            case 18: {
                                input.readMessage(
                                        getLocalBgpNotificationFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                reasonCase_ = 2;
                                break;
                            } // case 18
                            case 24: {
                                reason_ = input.readUInt32();
                                reasonCase_ = 3;
                                break;
                            } // case 24
                            case 34: {
                                input.readMessage(
                                        getRemoteBgpNotificationFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                reasonCase_ = 4;
                                break;
                            } // case 34
                            case 42: {
                                input.readMessage(
                                        getRemoteNoNotificationFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                reasonCase_ = 5;
                                break;
                            } // case 42
                            case 50: {
                                input.readMessage(
                                        getUnknownFieldBuilder().getBuilder(),
                                        extensionRegistry);
                                reasonCase_ = 6;
                                break;
                            } // case 50
                            default: {
                                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                    done = true; // was an endgroup tag
                                }
                                break;
                            } // default:
                        } // switch (tag)
                    } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                } finally {
                    onChanged();
                } // finally
                return this;
            }
            private int reasonCase_ = 0;
            private java.lang.Object reason_;
            public ReasonCase
            getReasonCase() {
                return ReasonCase.forNumber(
                        reasonCase_);
            }

            public Builder clearReason() {
                reasonCase_ = 0;
                reason_ = null;
                onChanged();
                return this;
            }

            private int bitField0_;

            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer peer_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder> peerBuilder_;
            /**
             * <code>.Peer peer = 1;</code>
             * @return Whether the peer field is set.
             */
            public boolean hasPeer() {
                return ((bitField0_ & 0x00000001) != 0);
            }
            /**
             * <code>.Peer peer = 1;</code>
             * @return The peer.
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer() {
                if (peerBuilder_ == null) {
                    return peer_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
                } else {
                    return peerBuilder_.getMessage();
                }
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder setPeer(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer value) {
                if (peerBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    peer_ = value;
                } else {
                    peerBuilder_.setMessage(value);
                }
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder setPeer(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder builderForValue) {
                if (peerBuilder_ == null) {
                    peer_ = builderForValue.build();
                } else {
                    peerBuilder_.setMessage(builderForValue.build());
                }
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder mergePeer(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer value) {
                if (peerBuilder_ == null) {
                    if (((bitField0_ & 0x00000001) != 0) &&
                            peer_ != null &&
                            peer_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance()) {
                        getPeerBuilder().mergeFrom(value);
                    } else {
                        peer_ = value;
                    }
                } else {
                    peerBuilder_.mergeFrom(value);
                }
                if (peer_ != null) {
                    bitField0_ |= 0x00000001;
                    onChanged();
                }
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public Builder clearPeer() {
                bitField0_ = (bitField0_ & ~0x00000001);
                peer_ = null;
                if (peerBuilder_ != null) {
                    peerBuilder_.dispose();
                    peerBuilder_ = null;
                }
                onChanged();
                return this;
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder getPeerBuilder() {
                bitField0_ |= 0x00000001;
                onChanged();
                return getPeerFieldBuilder().getBuilder();
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder() {
                if (peerBuilder_ != null) {
                    return peerBuilder_.getMessageOrBuilder();
                } else {
                    return peer_ == null ?
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.getDefaultInstance() : peer_;
                }
            }
            /**
             * <code>.Peer peer = 1;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder>
            getPeerFieldBuilder() {
                if (peerBuilder_ == null) {
                    peerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder>(
                            getPeer(),
                            getParentForChildren(),
                            isClean());
                    peer_ = null;
                }
                return peerBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder> localBgpNotificationBuilder_;
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             * @return Whether the localBgpNotification field is set.
             */
            @java.lang.Override
            public boolean hasLocalBgpNotification() {
                return reasonCase_ == 2;
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             * @return The localBgpNotification.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getLocalBgpNotification() {
                if (localBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 2) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                } else {
                    if (reasonCase_ == 2) {
                        return localBgpNotificationBuilder_.getMessage();
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                }
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            public Builder setLocalBgpNotification(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code value) {
                if (localBgpNotificationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    reason_ = value;
                    onChanged();
                } else {
                    localBgpNotificationBuilder_.setMessage(value);
                }
                reasonCase_ = 2;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            public Builder setLocalBgpNotification(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder builderForValue) {
                if (localBgpNotificationBuilder_ == null) {
                    reason_ = builderForValue.build();
                    onChanged();
                } else {
                    localBgpNotificationBuilder_.setMessage(builderForValue.build());
                }
                reasonCase_ = 2;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            public Builder mergeLocalBgpNotification(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code value) {
                if (localBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 2 &&
                            reason_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance()) {
                        reason_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.newBuilder((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        reason_ = value;
                    }
                    onChanged();
                } else {
                    if (reasonCase_ == 2) {
                        localBgpNotificationBuilder_.mergeFrom(value);
                    } else {
                        localBgpNotificationBuilder_.setMessage(value);
                    }
                }
                reasonCase_ = 2;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            public Builder clearLocalBgpNotification() {
                if (localBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 2) {
                        reasonCase_ = 0;
                        reason_ = null;
                        onChanged();
                    }
                } else {
                    if (reasonCase_ == 2) {
                        reasonCase_ = 0;
                        reason_ = null;
                    }
                    localBgpNotificationBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder getLocalBgpNotificationBuilder() {
                return getLocalBgpNotificationFieldBuilder().getBuilder();
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getLocalBgpNotificationOrBuilder() {
                if ((reasonCase_ == 2) && (localBgpNotificationBuilder_ != null)) {
                    return localBgpNotificationBuilder_.getMessageOrBuilder();
                } else {
                    if (reasonCase_ == 2) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                }
            }
            /**
             * <code>.PeerDownPacket.Code local_bgp_notification = 2;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder>
            getLocalBgpNotificationFieldBuilder() {
                if (localBgpNotificationBuilder_ == null) {
                    if (!(reasonCase_ == 2)) {
                        reason_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                    }
                    localBgpNotificationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder>(
                            (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_,
                            getParentForChildren(),
                            isClean());
                    reason_ = null;
                }
                reasonCase_ = 2;
                onChanged();
                return localBgpNotificationBuilder_;
            }

            /**
             * <code>uint32 local_no_notification = 3;</code>
             * @return Whether the localNoNotification field is set.
             */
            public boolean hasLocalNoNotification() {
                return reasonCase_ == 3;
            }
            /**
             * <code>uint32 local_no_notification = 3;</code>
             * @return The localNoNotification.
             */
            public int getLocalNoNotification() {
                if (reasonCase_ == 3) {
                    return (java.lang.Integer) reason_;
                }
                return 0;
            }
            /**
             * <code>uint32 local_no_notification = 3;</code>
             * @param value The localNoNotification to set.
             * @return This builder for chaining.
             */
            public Builder setLocalNoNotification(int value) {

                reasonCase_ = 3;
                reason_ = value;
                onChanged();
                return this;
            }
            /**
             * <code>uint32 local_no_notification = 3;</code>
             * @return This builder for chaining.
             */
            public Builder clearLocalNoNotification() {
                if (reasonCase_ == 3) {
                    reasonCase_ = 0;
                    reason_ = null;
                    onChanged();
                }
                return this;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder> remoteBgpNotificationBuilder_;
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             * @return Whether the remoteBgpNotification field is set.
             */
            @java.lang.Override
            public boolean hasRemoteBgpNotification() {
                return reasonCase_ == 4;
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             * @return The remoteBgpNotification.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code getRemoteBgpNotification() {
                if (remoteBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 4) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                } else {
                    if (reasonCase_ == 4) {
                        return remoteBgpNotificationBuilder_.getMessage();
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                }
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            public Builder setRemoteBgpNotification(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code value) {
                if (remoteBgpNotificationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    reason_ = value;
                    onChanged();
                } else {
                    remoteBgpNotificationBuilder_.setMessage(value);
                }
                reasonCase_ = 4;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            public Builder setRemoteBgpNotification(
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder builderForValue) {
                if (remoteBgpNotificationBuilder_ == null) {
                    reason_ = builderForValue.build();
                    onChanged();
                } else {
                    remoteBgpNotificationBuilder_.setMessage(builderForValue.build());
                }
                reasonCase_ = 4;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            public Builder mergeRemoteBgpNotification(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code value) {
                if (remoteBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 4 &&
                            reason_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance()) {
                        reason_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.newBuilder((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        reason_ = value;
                    }
                    onChanged();
                } else {
                    if (reasonCase_ == 4) {
                        remoteBgpNotificationBuilder_.mergeFrom(value);
                    } else {
                        remoteBgpNotificationBuilder_.setMessage(value);
                    }
                }
                reasonCase_ = 4;
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            public Builder clearRemoteBgpNotification() {
                if (remoteBgpNotificationBuilder_ == null) {
                    if (reasonCase_ == 4) {
                        reasonCase_ = 0;
                        reason_ = null;
                        onChanged();
                    }
                } else {
                    if (reasonCase_ == 4) {
                        reasonCase_ = 0;
                        reason_ = null;
                    }
                    remoteBgpNotificationBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder getRemoteBgpNotificationBuilder() {
                return getRemoteBgpNotificationFieldBuilder().getBuilder();
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder getRemoteBgpNotificationOrBuilder() {
                if ((reasonCase_ == 4) && (remoteBgpNotificationBuilder_ != null)) {
                    return remoteBgpNotificationBuilder_.getMessageOrBuilder();
                } else {
                    if (reasonCase_ == 4) {
                        return (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_;
                    }
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                }
            }
            /**
             * <code>.PeerDownPacket.Code remote_bgp_notification = 4;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder>
            getRemoteBgpNotificationFieldBuilder() {
                if (remoteBgpNotificationBuilder_ == null) {
                    if (!(reasonCase_ == 4)) {
                        reason_ = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.getDefaultInstance();
                    }
                    remoteBgpNotificationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.CodeOrBuilder>(
                            (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket.Code) reason_,
                            getParentForChildren(),
                            isClean());
                    reason_ = null;
                }
                reasonCase_ = 4;
                onChanged();
                return remoteBgpNotificationBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> remoteNoNotificationBuilder_;
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             * @return Whether the remoteNoNotification field is set.
             */
            @java.lang.Override
            public boolean hasRemoteNoNotification() {
                return reasonCase_ == 5;
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             * @return The remoteNoNotification.
             */
            @java.lang.Override
            public com.google.protobuf.Empty getRemoteNoNotification() {
                if (remoteNoNotificationBuilder_ == null) {
                    if (reasonCase_ == 5) {
                        return (com.google.protobuf.Empty) reason_;
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                } else {
                    if (reasonCase_ == 5) {
                        return remoteNoNotificationBuilder_.getMessage();
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                }
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            public Builder setRemoteNoNotification(com.google.protobuf.Empty value) {
                if (remoteNoNotificationBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    reason_ = value;
                    onChanged();
                } else {
                    remoteNoNotificationBuilder_.setMessage(value);
                }
                reasonCase_ = 5;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            public Builder setRemoteNoNotification(
                    com.google.protobuf.Empty.Builder builderForValue) {
                if (remoteNoNotificationBuilder_ == null) {
                    reason_ = builderForValue.build();
                    onChanged();
                } else {
                    remoteNoNotificationBuilder_.setMessage(builderForValue.build());
                }
                reasonCase_ = 5;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            public Builder mergeRemoteNoNotification(com.google.protobuf.Empty value) {
                if (remoteNoNotificationBuilder_ == null) {
                    if (reasonCase_ == 5 &&
                            reason_ != com.google.protobuf.Empty.getDefaultInstance()) {
                        reason_ = com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) reason_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        reason_ = value;
                    }
                    onChanged();
                } else {
                    if (reasonCase_ == 5) {
                        remoteNoNotificationBuilder_.mergeFrom(value);
                    } else {
                        remoteNoNotificationBuilder_.setMessage(value);
                    }
                }
                reasonCase_ = 5;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            public Builder clearRemoteNoNotification() {
                if (remoteNoNotificationBuilder_ == null) {
                    if (reasonCase_ == 5) {
                        reasonCase_ = 0;
                        reason_ = null;
                        onChanged();
                    }
                } else {
                    if (reasonCase_ == 5) {
                        reasonCase_ = 0;
                        reason_ = null;
                    }
                    remoteNoNotificationBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            public com.google.protobuf.Empty.Builder getRemoteNoNotificationBuilder() {
                return getRemoteNoNotificationFieldBuilder().getBuilder();
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            @java.lang.Override
            public com.google.protobuf.EmptyOrBuilder getRemoteNoNotificationOrBuilder() {
                if ((reasonCase_ == 5) && (remoteNoNotificationBuilder_ != null)) {
                    return remoteNoNotificationBuilder_.getMessageOrBuilder();
                } else {
                    if (reasonCase_ == 5) {
                        return (com.google.protobuf.Empty) reason_;
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                }
            }
            /**
             * <code>.google.protobuf.Empty remote_no_notification = 5;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>
            getRemoteNoNotificationFieldBuilder() {
                if (remoteNoNotificationBuilder_ == null) {
                    if (!(reasonCase_ == 5)) {
                        reason_ = com.google.protobuf.Empty.getDefaultInstance();
                    }
                    remoteNoNotificationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>(
                            (com.google.protobuf.Empty) reason_,
                            getParentForChildren(),
                            isClean());
                    reason_ = null;
                }
                reasonCase_ = 5;
                onChanged();
                return remoteNoNotificationBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder> unknownBuilder_;
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             * @return Whether the unknown field is set.
             */
            @java.lang.Override
            public boolean hasUnknown() {
                return reasonCase_ == 6;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             * @return The unknown.
             */
            @java.lang.Override
            public com.google.protobuf.Empty getUnknown() {
                if (unknownBuilder_ == null) {
                    if (reasonCase_ == 6) {
                        return (com.google.protobuf.Empty) reason_;
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                } else {
                    if (reasonCase_ == 6) {
                        return unknownBuilder_.getMessage();
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                }
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            public Builder setUnknown(com.google.protobuf.Empty value) {
                if (unknownBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    reason_ = value;
                    onChanged();
                } else {
                    unknownBuilder_.setMessage(value);
                }
                reasonCase_ = 6;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            public Builder setUnknown(
                    com.google.protobuf.Empty.Builder builderForValue) {
                if (unknownBuilder_ == null) {
                    reason_ = builderForValue.build();
                    onChanged();
                } else {
                    unknownBuilder_.setMessage(builderForValue.build());
                }
                reasonCase_ = 6;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            public Builder mergeUnknown(com.google.protobuf.Empty value) {
                if (unknownBuilder_ == null) {
                    if (reasonCase_ == 6 &&
                            reason_ != com.google.protobuf.Empty.getDefaultInstance()) {
                        reason_ = com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) reason_)
                                .mergeFrom(value).buildPartial();
                    } else {
                        reason_ = value;
                    }
                    onChanged();
                } else {
                    if (reasonCase_ == 6) {
                        unknownBuilder_.mergeFrom(value);
                    } else {
                        unknownBuilder_.setMessage(value);
                    }
                }
                reasonCase_ = 6;
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            public Builder clearUnknown() {
                if (unknownBuilder_ == null) {
                    if (reasonCase_ == 6) {
                        reasonCase_ = 0;
                        reason_ = null;
                        onChanged();
                    }
                } else {
                    if (reasonCase_ == 6) {
                        reasonCase_ = 0;
                        reason_ = null;
                    }
                    unknownBuilder_.clear();
                }
                return this;
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            public com.google.protobuf.Empty.Builder getUnknownBuilder() {
                return getUnknownFieldBuilder().getBuilder();
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            @java.lang.Override
            public com.google.protobuf.EmptyOrBuilder getUnknownOrBuilder() {
                if ((reasonCase_ == 6) && (unknownBuilder_ != null)) {
                    return unknownBuilder_.getMessageOrBuilder();
                } else {
                    if (reasonCase_ == 6) {
                        return (com.google.protobuf.Empty) reason_;
                    }
                    return com.google.protobuf.Empty.getDefaultInstance();
                }
            }
            /**
             * <code>.google.protobuf.Empty unknown = 6;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>
            getUnknownFieldBuilder() {
                if (unknownBuilder_ == null) {
                    if (!(reasonCase_ == 6)) {
                        reason_ = com.google.protobuf.Empty.getDefaultInstance();
                    }
                    unknownBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                            com.google.protobuf.Empty, com.google.protobuf.Empty.Builder, com.google.protobuf.EmptyOrBuilder>(
                            (com.google.protobuf.Empty) reason_,
                            getParentForChildren(),
                            isClean());
                    reason_ = null;
                }
                reasonCase_ = 6;
                onChanged();
                return unknownBuilder_;
            }
            @java.lang.Override
            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:PeerDownPacket)
        }

        // @@protoc_insertion_point(class_scope:PeerDownPacket)
        private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket DEFAULT_INSTANCE;
        static {
            DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket();
        }

        public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<PeerDownPacket>
                PARSER = new com.google.protobuf.AbstractParser<PeerDownPacket>() {
            @java.lang.Override
            public PeerDownPacket parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                            .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        public static com.google.protobuf.Parser<PeerDownPacket> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<PeerDownPacket> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerDownPacket getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface RouteMonitoringPacketOrBuilder extends
            // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.Peer peer = 1;</code>
         * @return Whether the peer field is set.
         */
        boolean hasPeer();
        /**
         * <code>.Peer peer = 1;</code>
         * @return The peer.
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.Peer getPeer();
        /**
         * <code>.Peer peer = 1;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.PeerOrBuilder getPeerOrBuilder();

        /**
         * <code>repeated .RouteMonitoringPacket.Route withdraws = 2;</code>
         */
        java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route>
        getWithdrawsList();
        /**
         * <code>repeated .RouteMonitoringPacket.Route withdraws = 2;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route getWithdraws(int index);
        /**
         * <code>repeated .RouteMonitoringPacket.Route withdraws = 2;</code>
         */
        int getWithdrawsCount();
        /**
         * <code>repeated .RouteMonitoringPacket.Route withdraws = 2;</code>
         */
        java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.RouteOrBuilder>
        getWithdrawsOrBuilderList();
        /**
         * <code>repeated .RouteMonitoringPacket.Route withdraws = 2;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.RouteOrBuilder getWithdrawsOrBuilder(
                int index);

        /**
         * <code>repeated .RouteMonitoringPacket.Route reachables = 3;</code>
         */
        java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route>
        getReachablesList();
        /**
         * <code>repeated .RouteMonitoringPacket.Route reachables = 3;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route getReachables(int index);
        /**
         * <code>repeated .RouteMonitoringPacket.Route reachables = 3;</code>
         */
        int getReachablesCount();
        /**
         * <code>repeated .RouteMonitoringPacket.Route reachables = 3;</code>
         */
        java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.RouteOrBuilder>
        getReachablesOrBuilderList();
        /**
         * <code>repeated .RouteMonitoringPacket.Route reachables = 3;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.RouteOrBuilder getReachablesOrBuilder(
                int index);

        /**
         * <code>repeated .RouteMonitoringPacket.PathAttribute attributes = 4;</code>
         */
        java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute>
        getAttributesList();
        /**
         * <code>repeated .RouteMonitoringPacket.PathAttribute attributes = 4;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute getAttributes(int index);
        /**
         * <code>repeated .RouteMonitoringPacket.PathAttribute attributes = 4;</code>
         */
        int getAttributesCount();
        /**
         * <code>repeated .RouteMonitoringPacket.PathAttribute attributes = 4;</code>
         */
        java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttributeOrBuilder>
        getAttributesOrBuilderList();
        /**
         * <code>repeated .RouteMonitoringPacket.PathAttribute attributes = 4;</code>
         */
        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttributeOrBuilder getAttributesOrBuilder(
                int index);
    }
    /**
     * Protobuf type {@code RouteMonitoringPacket}
     */
    public static final class RouteMonitoringPacket extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:RouteMonitoringPacket)
            RouteMonitoringPacketOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use RouteMonitoringPacket.newBuilder() to construct.
        private RouteMonitoringPacket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }
        private RouteMonitoringPacket() {
            withdraws_ = java.util.Collections.emptyList();
            reachables_ = java.util.Collections.emptyList();
            attributes_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
                UnusedPrivateParameter unused) {
            return new RouteMonitoringPacket();
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Builder.class);
        }

        public interface RouteOrBuilder extends
                // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.Route)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>.IpAddress prefix = 1;</code>
             * @return Whether the prefix field is set.
             */
            boolean hasPrefix();
            /**
             * <code>.IpAddress prefix = 1;</code>
             * @return The prefix.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getPrefix();
            /**
             * <code>.IpAddress prefix = 1;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getPrefixOrBuilder();

            /**
             * <code>uint32 length = 2;</code>
             * @return The length.
             */
            int getLength();

            /**
             * <code>uint64 pathId = 3;</code>
             * @return The pathId.
             */
            long getPathId();

            /**
             * <code>string labels = 4;</code>
             * @return The labels.
             */
            java.lang.String getLabels();
            /**
             * <code>string labels = 4;</code>
             * @return The bytes for labels.
             */
            com.google.protobuf.ByteString
            getLabelsBytes();
        }
        /**
         * Protobuf type {@code RouteMonitoringPacket.Route}
         */
        public static final class Route extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.Route)
                RouteOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use Route.newBuilder() to construct.
            private Route(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private Route() {
                labels_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new Route();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_Route_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_Route_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.Builder.class);
            }

            private int bitField0_;
            public static final int PREFIX_FIELD_NUMBER = 1;
            private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress prefix_;
            /**
             * <code>.IpAddress prefix = 1;</code>
             * @return Whether the prefix field is set.
             */
            @java.lang.Override
            public boolean hasPrefix() {
                return ((bitField0_ & 0x00000001) != 0);
            }
            /**
             * <code>.IpAddress prefix = 1;</code>
             * @return The prefix.
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getPrefix() {
                return prefix_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : prefix_;
            }
            /**
             * <code>.IpAddress prefix = 1;</code>
             */
            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getPrefixOrBuilder() {
                return prefix_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : prefix_;
            }

            public static final int LENGTH_FIELD_NUMBER = 2;
            private int length_ = 0;
            /**
             * <code>uint32 length = 2;</code>
             * @return The length.
             */
            @java.lang.Override
            public int getLength() {
                return length_;
            }

            public static final int PATHID_FIELD_NUMBER = 3;
            private long pathId_ = 0L;
            /**
             * <code>uint64 pathId = 3;</code>
             * @return The pathId.
             */
            @java.lang.Override
            public long getPathId() {
                return pathId_;
            }

            public static final int LABELS_FIELD_NUMBER = 4;
            @SuppressWarnings("serial")
            private volatile java.lang.Object labels_ = "";
            /**
             * <code>string labels = 4;</code>
             * @return The labels.
             */
            @java.lang.Override
            public java.lang.String getLabels() {
                java.lang.Object ref = labels_;
                if (ref instanceof java.lang.String) {
                    return (java.lang.String) ref;
                } else {
                    com.google.protobuf.ByteString bs =
                            (com.google.protobuf.ByteString) ref;
                    java.lang.String s = bs.toStringUtf8();
                    labels_ = s;
                    return s;
                }
            }
            /**
             * <code>string labels = 4;</code>
             * @return The bytes for labels.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString
            getLabelsBytes() {
                java.lang.Object ref = labels_;
                if (ref instanceof java.lang.String) {
                    com.google.protobuf.ByteString b =
                            com.google.protobuf.ByteString.copyFromUtf8(
                                    (java.lang.String) ref);
                    labels_ = b;
                    return b;
                } else {
                    return (com.google.protobuf.ByteString) ref;
                }
            }

            private byte memoizedIsInitialized = -1;
            @java.lang.Override
            public final boolean isInitialized() {
                byte isInitialized = memoizedIsInitialized;
                if (isInitialized == 1) return true;
                if (isInitialized == 0) return false;

                memoizedIsInitialized = 1;
                return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                    throws java.io.IOException {
                if (((bitField0_ & 0x00000001) != 0)) {
                    output.writeMessage(1, getPrefix());
                }
                if (length_ != 0) {
                    output.writeUInt32(2, length_);
                }
                if (pathId_ != 0L) {
                    output.writeUInt64(3, pathId_);
                }
                if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labels_)) {
                    com.google.protobuf.GeneratedMessageV3.writeString(output, 4, labels_);
                }
                getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
                int size = memoizedSize;
                if (size != -1) return size;

                size = 0;
                if (((bitField0_ & 0x00000001) != 0)) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeMessageSize(1, getPrefix());
                }
                if (length_ != 0) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt32Size(2, length_);
                }
                if (pathId_ != 0L) {
                    size += com.google.protobuf.CodedOutputStream
                            .computeUInt64Size(3, pathId_);
                }
                if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labels_)) {
                    size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, labels_);
                }
                size += getUnknownFields().getSerializedSize();
                memoizedSize = size;
                return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route)) {
                    return super.equals(obj);
                }
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route) obj;

                if (hasPrefix() != other.hasPrefix()) return false;
                if (hasPrefix()) {
                    if (!getPrefix()
                            .equals(other.getPrefix())) return false;
                }
                if (getLength()
                        != other.getLength()) return false;
                if (getPathId()
                        != other.getPathId()) return false;
                if (!getLabels()
                        .equals(other.getLabels())) return false;
                if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                return true;
            }

            @java.lang.Override
            public int hashCode() {
                if (memoizedHashCode != 0) {
                    return memoizedHashCode;
                }
                int hash = 41;
                hash = (19 * hash) + getDescriptor().hashCode();
                if (hasPrefix()) {
                    hash = (37 * hash) + PREFIX_FIELD_NUMBER;
                    hash = (53 * hash) + getPrefix().hashCode();
                }
                hash = (37 * hash) + LENGTH_FIELD_NUMBER;
                hash = (53 * hash) + getLength();
                hash = (37 * hash) + PATHID_FIELD_NUMBER;
                hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
                        getPathId());
                hash = (37 * hash) + LABELS_FIELD_NUMBER;
                hash = (53 * hash) + getLabels().hashCode();
                hash = (29 * hash) + getUnknownFields().hashCode();
                memoizedHashCode = hash;
                return hash;
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(byte[] data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    byte[] data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return PARSER.parseFrom(data, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseDelimitedFrom(java.io.InputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input);
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    com.google.protobuf.CodedInputStream input)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input);
            }
            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                return com.google.protobuf.GeneratedMessageV3
                        .parseWithIOException(PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() { return newBuilder(); }
            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }
            public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }
            @java.lang.Override
            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE
                        ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                    com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.Route}
             */
            public static final class Builder extends
                    com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                    // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.Route)
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.RouteOrBuilder {
                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_Route_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_Route_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.Builder.class);
                }

                // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.newBuilder()
                private Builder() {
                    maybeForceBuilderInitialization();
                }

                private Builder(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                    maybeForceBuilderInitialization();
                }
                private void maybeForceBuilderInitialization() {
                    if (com.google.protobuf.GeneratedMessageV3
                            .alwaysUseFieldBuilders) {
                        getPrefixFieldBuilder();
                    }
                }
                @java.lang.Override
                public Builder clear() {
                    super.clear();
                    bitField0_ = 0;
                    prefix_ = null;
                    if (prefixBuilder_ != null) {
                        prefixBuilder_.dispose();
                        prefixBuilder_ = null;
                    }
                    length_ = 0;
                    pathId_ = 0L;
                    labels_ = "";
                    return this;
                }

                @java.lang.Override
                public com.google.protobuf.Descriptors.Descriptor
                getDescriptorForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_Route_descriptor;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route getDefaultInstanceForType() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.getDefaultInstance();
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route build() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route result = buildPartial();
                    if (!result.isInitialized()) {
                        throw newUninitializedMessageException(result);
                    }
                    return result;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route buildPartial() {
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route(this);
                    if (bitField0_ != 0) { buildPartial0(result); }
                    onBuilt();
                    return result;
                }

                private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route result) {
                    int from_bitField0_ = bitField0_;
                    int to_bitField0_ = 0;
                    if (((from_bitField0_ & 0x00000001) != 0)) {
                        result.prefix_ = prefixBuilder_ == null
                                ? prefix_
                                : prefixBuilder_.build();
                        to_bitField0_ |= 0x00000001;
                    }
                    if (((from_bitField0_ & 0x00000002) != 0)) {
                        result.length_ = length_;
                    }
                    if (((from_bitField0_ & 0x00000004) != 0)) {
                        result.pathId_ = pathId_;
                    }
                    if (((from_bitField0_ & 0x00000008) != 0)) {
                        result.labels_ = labels_;
                    }
                    result.bitField0_ |= to_bitField0_;
                }

                @java.lang.Override
                public Builder clone() {
                    return super.clone();
                }
                @java.lang.Override
                public Builder setField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.setField(field, value);
                }
                @java.lang.Override
                public Builder clearField(
                        com.google.protobuf.Descriptors.FieldDescriptor field) {
                    return super.clearField(field);
                }
                @java.lang.Override
                public Builder clearOneof(
                        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                    return super.clearOneof(oneof);
                }
                @java.lang.Override
                public Builder setRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        int index, java.lang.Object value) {
                    return super.setRepeatedField(field, index, value);
                }
                @java.lang.Override
                public Builder addRepeatedField(
                        com.google.protobuf.Descriptors.FieldDescriptor field,
                        java.lang.Object value) {
                    return super.addRepeatedField(field, value);
                }
                @java.lang.Override
                public Builder mergeFrom(com.google.protobuf.Message other) {
                    if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route) {
                        return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route)other);
                    } else {
                        super.mergeFrom(other);
                        return this;
                    }
                }

                public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route other) {
                    if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route.getDefaultInstance()) return this;
                    if (other.hasPrefix()) {
                        mergePrefix(other.getPrefix());
                    }
                    if (other.getLength() != 0) {
                        setLength(other.getLength());
                    }
                    if (other.getPathId() != 0L) {
                        setPathId(other.getPathId());
                    }
                    if (!other.getLabels().isEmpty()) {
                        labels_ = other.labels_;
                        bitField0_ |= 0x00000008;
                        onChanged();
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    onChanged();
                    return this;
                }

                @java.lang.Override
                public final boolean isInitialized() {
                    return true;
                }

                @java.lang.Override
                public Builder mergeFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    if (extensionRegistry == null) {
                        throw new java.lang.NullPointerException();
                    }
                    try {
                        boolean done = false;
                        while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0:
                                    done = true;
                                    break;
                                case 10: {
                                    input.readMessage(
                                            getPrefixFieldBuilder().getBuilder(),
                                            extensionRegistry);
                                    bitField0_ |= 0x00000001;
                                    break;
                                } // case 10
                                case 16: {
                                    length_ = input.readUInt32();
                                    bitField0_ |= 0x00000002;
                                    break;
                                } // case 16
                                case 24: {
                                    pathId_ = input.readUInt64();
                                    bitField0_ |= 0x00000004;
                                    break;
                                } // case 24
                                case 34: {
                                    labels_ = input.readStringRequireUtf8();
                                    bitField0_ |= 0x00000008;
                                    break;
                                } // case 34
                                default: {
                                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                        done = true; // was an endgroup tag
                                    }
                                    break;
                                } // default:
                            } // switch (tag)
                        } // while (!done)
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    } finally {
                        onChanged();
                    } // finally
                    return this;
                }
                private int bitField0_;

                private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress prefix_;
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> prefixBuilder_;
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 * @return Whether the prefix field is set.
                 */
                public boolean hasPrefix() {
                    return ((bitField0_ & 0x00000001) != 0);
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 * @return The prefix.
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getPrefix() {
                    if (prefixBuilder_ == null) {
                        return prefix_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : prefix_;
                    } else {
                        return prefixBuilder_.getMessage();
                    }
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public Builder setPrefix(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                    if (prefixBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        prefix_ = value;
                    } else {
                        prefixBuilder_.setMessage(value);
                    }
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public Builder setPrefix(
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                    if (prefixBuilder_ == null) {
                        prefix_ = builderForValue.build();
                    } else {
                        prefixBuilder_.setMessage(builderForValue.build());
                    }
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public Builder mergePrefix(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                    if (prefixBuilder_ == null) {
                        if (((bitField0_ & 0x00000001) != 0) &&
                                prefix_ != null &&
                                prefix_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                            getPrefixBuilder().mergeFrom(value);
                        } else {
                            prefix_ = value;
                        }
                    } else {
                        prefixBuilder_.mergeFrom(value);
                    }
                    if (prefix_ != null) {
                        bitField0_ |= 0x00000001;
                        onChanged();
                    }
                    return this;
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public Builder clearPrefix() {
                    bitField0_ = (bitField0_ & ~0x00000001);
                    prefix_ = null;
                    if (prefixBuilder_ != null) {
                        prefixBuilder_.dispose();
                        prefixBuilder_ = null;
                    }
                    onChanged();
                    return this;
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getPrefixBuilder() {
                    bitField0_ |= 0x00000001;
                    onChanged();
                    return getPrefixFieldBuilder().getBuilder();
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getPrefixOrBuilder() {
                    if (prefixBuilder_ != null) {
                        return prefixBuilder_.getMessageOrBuilder();
                    } else {
                        return prefix_ == null ?
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : prefix_;
                    }
                }
                /**
                 * <code>.IpAddress prefix = 1;</code>
                 */
                private com.google.protobuf.SingleFieldBuilderV3<
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                getPrefixFieldBuilder() {
                    if (prefixBuilder_ == null) {
                        prefixBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                                getPrefix(),
                                getParentForChildren(),
                                isClean());
                        prefix_ = null;
                    }
                    return prefixBuilder_;
                }

                private int length_ ;
                /**
                 * <code>uint32 length = 2;</code>
                 * @return The length.
                 */
                @java.lang.Override
                public int getLength() {
                    return length_;
                }
                /**
                 * <code>uint32 length = 2;</code>
                 * @param value The length to set.
                 * @return This builder for chaining.
                 */
                public Builder setLength(int value) {

                    length_ = value;
                    bitField0_ |= 0x00000002;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint32 length = 2;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearLength() {
                    bitField0_ = (bitField0_ & ~0x00000002);
                    length_ = 0;
                    onChanged();
                    return this;
                }

                private long pathId_ ;
                /**
                 * <code>uint64 pathId = 3;</code>
                 * @return The pathId.
                 */
                @java.lang.Override
                public long getPathId() {
                    return pathId_;
                }
                /**
                 * <code>uint64 pathId = 3;</code>
                 * @param value The pathId to set.
                 * @return This builder for chaining.
                 */
                public Builder setPathId(long value) {

                    pathId_ = value;
                    bitField0_ |= 0x00000004;
                    onChanged();
                    return this;
                }
                /**
                 * <code>uint64 pathId = 3;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearPathId() {
                    bitField0_ = (bitField0_ & ~0x00000004);
                    pathId_ = 0L;
                    onChanged();
                    return this;
                }

                private java.lang.Object labels_ = "";
                /**
                 * <code>string labels = 4;</code>
                 * @return The labels.
                 */
                public java.lang.String getLabels() {
                    java.lang.Object ref = labels_;
                    if (!(ref instanceof java.lang.String)) {
                        com.google.protobuf.ByteString bs =
                                (com.google.protobuf.ByteString) ref;
                        java.lang.String s = bs.toStringUtf8();
                        labels_ = s;
                        return s;
                    } else {
                        return (java.lang.String) ref;
                    }
                }
                /**
                 * <code>string labels = 4;</code>
                 * @return The bytes for labels.
                 */
                public com.google.protobuf.ByteString
                getLabelsBytes() {
                    java.lang.Object ref = labels_;
                    if (ref instanceof String) {
                        com.google.protobuf.ByteString b =
                                com.google.protobuf.ByteString.copyFromUtf8(
                                        (java.lang.String) ref);
                        labels_ = b;
                        return b;
                    } else {
                        return (com.google.protobuf.ByteString) ref;
                    }
                }
                /**
                 * <code>string labels = 4;</code>
                 * @param value The labels to set.
                 * @return This builder for chaining.
                 */
                public Builder setLabels(
                        java.lang.String value) {
                    if (value == null) { throw new NullPointerException(); }
                    labels_ = value;
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return this;
                }
                /**
                 * <code>string labels = 4;</code>
                 * @return This builder for chaining.
                 */
                public Builder clearLabels() {
                    labels_ = getDefaultInstance().getLabels();
                    bitField0_ = (bitField0_ & ~0x00000008);
                    onChanged();
                    return this;
                }
                /**
                 * <code>string labels = 4;</code>
                 * @param value The bytes for labels to set.
                 * @return This builder for chaining.
                 */
                public Builder setLabelsBytes(
                        com.google.protobuf.ByteString value) {
                    if (value == null) { throw new NullPointerException(); }
                    checkByteStringIsUtf8(value);
                    labels_ = value;
                    bitField0_ |= 0x00000008;
                    onChanged();
                    return this;
                }
                @java.lang.Override
                public final Builder setUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.setUnknownFields(unknownFields);
                }

                @java.lang.Override
                public final Builder mergeUnknownFields(
                        final com.google.protobuf.UnknownFieldSet unknownFields) {
                    return super.mergeUnknownFields(unknownFields);
                }


                // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.Route)
            }

            // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.Route)
            private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route DEFAULT_INSTANCE;
            static {
                DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route();
            }

            public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<Route>
                    PARSER = new com.google.protobuf.AbstractParser<Route>() {
                @java.lang.Override
                public Route parsePartialFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                        throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            public static com.google.protobuf.Parser<Route> parser() {
                return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<Route> getParserForType() {
                return PARSER;
            }

            @java.lang.Override
            public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.Route getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

        }

        public interface PathAttributeOrBuilder extends
                // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute)
                com.google.protobuf.MessageOrBuilder {

            /**
             * <code>bool optional = 1;</code>
             * @return The optional.
             */
            boolean getOptional();

            /**
             * <code>bool transitive = 2;</code>
             * @return The transitive.
             */
            boolean getTransitive();

            /**
             * <code>bool partial = 3;</code>
             * @return The partial.
             */
            boolean getPartial();

            /**
             * <code>bool extended = 4;</code>
             * @return The extended.
             */
            boolean getExtended();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Origin origin = 5;</code>
             * @return Whether the origin field is set.
             */
            boolean hasOrigin();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Origin origin = 5;</code>
             * @return The enum numeric value on the wire for origin.
             */
            int getOriginValue();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Origin origin = 5;</code>
             * @return The origin.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Origin getOrigin();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPath as_path = 6;</code>
             * @return Whether the asPath field is set.
             */
            boolean hasAsPath();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPath as_path = 6;</code>
             * @return The asPath.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath getAsPath();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPath as_path = 6;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPathOrBuilder getAsPathOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.NextHop next_hop = 7;</code>
             * @return Whether the nextHop field is set.
             */
            boolean hasNextHop();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.NextHop next_hop = 7;</code>
             * @return The nextHop.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop getNextHop();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.NextHop next_hop = 7;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHopOrBuilder getNextHopOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiExitDisc multi_exit_disc = 8;</code>
             * @return Whether the multiExitDisc field is set.
             */
            boolean hasMultiExitDisc();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiExitDisc multi_exit_disc = 8;</code>
             * @return The multiExitDisc.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc getMultiExitDisc();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiExitDisc multi_exit_disc = 8;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDiscOrBuilder getMultiExitDiscOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LocalPref local_pref = 9;</code>
             * @return Whether the localPref field is set.
             */
            boolean hasLocalPref();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LocalPref local_pref = 9;</code>
             * @return The localPref.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref getLocalPref();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LocalPref local_pref = 9;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPrefOrBuilder getLocalPrefOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AtomicAggregate atomic_aggregate = 10;</code>
             * @return Whether the atomicAggregate field is set.
             */
            boolean hasAtomicAggregate();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AtomicAggregate atomic_aggregate = 10;</code>
             * @return The atomicAggregate.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate getAtomicAggregate();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AtomicAggregate atomic_aggregate = 10;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregateOrBuilder getAtomicAggregateOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Aggregator aggregator = 11;</code>
             * @return Whether the aggregator field is set.
             */
            boolean hasAggregator();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Aggregator aggregator = 11;</code>
             * @return The aggregator.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator getAggregator();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.Aggregator aggregator = 11;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AggregatorOrBuilder getAggregatorOrBuilder();

            /**
             * <code>uint32 community = 12;</code>
             * @return Whether the community field is set.
             */
            boolean hasCommunity();
            /**
             * <code>uint32 community = 12;</code>
             * @return The community.
             */
            int getCommunity();

            /**
             * <code>uint32 originator_id = 13;</code>
             * @return Whether the originatorId field is set.
             */
            boolean hasOriginatorId();
            /**
             * <code>uint32 originator_id = 13;</code>
             * @return The originatorId.
             */
            int getOriginatorId();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ClusterList cluster_list = 14;</code>
             * @return Whether the clusterList field is set.
             */
            boolean hasClusterList();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ClusterList cluster_list = 14;</code>
             * @return The clusterList.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList getClusterList();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ClusterList cluster_list = 14;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterListOrBuilder getClusterListOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedCommunities extended_communities = 15;</code>
             * @return Whether the extendedCommunities field is set.
             */
            boolean hasExtendedCommunities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedCommunities extended_communities = 15;</code>
             * @return The extendedCommunities.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities getExtendedCommunities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedCommunities extended_communities = 15;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunitiesOrBuilder getExtendedCommunitiesOrBuilder();

            /**
             * <code>fixed32 connector = 16;</code>
             * @return Whether the connector field is set.
             */
            boolean hasConnector();
            /**
             * <code>fixed32 connector = 16;</code>
             * @return The connector.
             */
            int getConnector();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPathLimit as_path_limit = 17;</code>
             * @return Whether the asPathLimit field is set.
             */
            boolean hasAsPathLimit();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPathLimit as_path_limit = 17;</code>
             * @return The asPathLimit.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPathLimit getAsPathLimit();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AsPathLimit as_path_limit = 17;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPathLimitOrBuilder getAsPathLimitOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LargeCommunities large_communities = 18;</code>
             * @return Whether the largeCommunities field is set.
             */
            boolean hasLargeCommunities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LargeCommunities large_communities = 18;</code>
             * @return The largeCommunities.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LargeCommunities getLargeCommunities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.LargeCommunities large_communities = 18;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LargeCommunitiesOrBuilder getLargeCommunitiesOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AttrSet attr_set = 19;</code>
             * @return Whether the attrSet field is set.
             */
            boolean hasAttrSet();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AttrSet attr_set = 19;</code>
             * @return The attrSet.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AttrSet getAttrSet();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.AttrSet attr_set = 19;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AttrSetOrBuilder getAttrSetOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities extended_v6_communities = 20;</code>
             * @return Whether the extendedV6Communities field is set.
             */
            boolean hasExtendedV6Communities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities extended_v6_communities = 20;</code>
             * @return The extendedV6Communities.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities getExtendedV6Communities();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities extended_v6_communities = 20;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedV6CommunitiesOrBuilder getExtendedV6CommunitiesOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli mpReachNrli = 21;</code>
             * @return Whether the mpReachNrli field is set.
             */
            boolean hasMpReachNrli();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli mpReachNrli = 21;</code>
             * @return The mpReachNrli.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli getMpReachNrli();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli mpReachNrli = 21;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrliOrBuilder getMpReachNrliOrBuilder();

            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli mpUnreachNrli = 22;</code>
             * @return Whether the mpUnreachNrli field is set.
             */
            boolean hasMpUnreachNrli();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli mpUnreachNrli = 22;</code>
             * @return The mpUnreachNrli.
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli getMpUnreachNrli();
            /**
             * <code>.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli mpUnreachNrli = 22;</code>
             */
            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrliOrBuilder getMpUnreachNrliOrBuilder();

            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ValueCase getValueCase();
        }
        /**
         * Protobuf type {@code RouteMonitoringPacket.PathAttribute}
         */
        public static final class PathAttribute extends
                com.google.protobuf.GeneratedMessageV3 implements
                // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute)
                PathAttributeOrBuilder {
            private static final long serialVersionUID = 0L;
            // Use PathAttribute.newBuilder() to construct.
            private PathAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }
            private PathAttribute() {
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(
                    UnusedPrivateParameter unused) {
                return new PathAttribute();
            }

            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Builder.class);
            }

            /**
             * Protobuf enum {@code RouteMonitoringPacket.PathAttribute.Origin}
             */
            public enum Origin
                    implements com.google.protobuf.ProtocolMessageEnum {
                /**
                 * <code>IGP = 0;</code>
                 */
                IGP(0),
                /**
                 * <code>EGP = 1;</code>
                 */
                EGP(1),
                /**
                 * <code>INCOMPLETE = 2;</code>
                 */
                INCOMPLETE(2),
                UNRECOGNIZED(-1),
                ;

                /**
                 * <code>IGP = 0;</code>
                 */
                public static final int IGP_VALUE = 0;
                /**
                 * <code>EGP = 1;</code>
                 */
                public static final int EGP_VALUE = 1;
                /**
                 * <code>INCOMPLETE = 2;</code>
                 */
                public static final int INCOMPLETE_VALUE = 2;


                public final int getNumber() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalArgumentException(
                                "Can't get the number of an unknown enum value.");
                    }
                    return value;
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 * @deprecated Use {@link #forNumber(int)} instead.
                 */
                @java.lang.Deprecated
                public static Origin valueOf(int value) {
                    return forNumber(value);
                }

                /**
                 * @param value The numeric wire value of the corresponding enum entry.
                 * @return The enum associated with the given numeric wire value.
                 */
                public static Origin forNumber(int value) {
                    switch (value) {
                        case 0: return IGP;
                        case 1: return EGP;
                        case 2: return INCOMPLETE;
                        default: return null;
                    }
                }

                public static com.google.protobuf.Internal.EnumLiteMap<Origin>
                internalGetValueMap() {
                    return internalValueMap;
                }
                private static final com.google.protobuf.Internal.EnumLiteMap<
                        Origin> internalValueMap =
                        new com.google.protobuf.Internal.EnumLiteMap<Origin>() {
                            public Origin findValueByNumber(int number) {
                                return Origin.forNumber(number);
                            }
                        };

                public final com.google.protobuf.Descriptors.EnumValueDescriptor
                getValueDescriptor() {
                    if (this == UNRECOGNIZED) {
                        throw new java.lang.IllegalStateException(
                                "Can't get the descriptor of an unrecognized enum value.");
                    }
                    return getDescriptor().getValues().get(ordinal());
                }
                public final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptorForType() {
                    return getDescriptor();
                }
                public static final com.google.protobuf.Descriptors.EnumDescriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.getDescriptor().getEnumTypes().get(0);
                }

                private static final Origin[] VALUES = values();

                public static Origin valueOf(
                        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
                    if (desc.getType() != getDescriptor()) {
                        throw new java.lang.IllegalArgumentException(
                                "EnumValueDescriptor is not for this type.");
                    }
                    if (desc.getIndex() == -1) {
                        return UNRECOGNIZED;
                    }
                    return VALUES[desc.getIndex()];
                }

                private final int value;

                private Origin(int value) {
                    this.value = value;
                }

                // @@protoc_insertion_point(enum_scope:RouteMonitoringPacket.PathAttribute.Origin)
            }

            public interface AsPathOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.AsPath)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment>
                getSegmentsList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getSegments(int index);
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                int getSegmentsCount();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder>
                getSegmentsOrBuilderList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder getSegmentsOrBuilder(
                        int index);
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AsPath}
             */
            public static final class AsPath extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.AsPath)
                    AsPathOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use AsPath.newBuilder() to construct.
                private AsPath(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private AsPath() {
                    segments_ = java.util.Collections.emptyList();
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new AsPath();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Builder.class);
                }

                public interface SegmentOrBuilder extends
                        // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.AsPath.Segment)
                        com.google.protobuf.MessageOrBuilder {

                    /**
                     * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                     * @return The enum numeric value on the wire for type.
                     */
                    int getTypeValue();
                    /**
                     * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                     * @return The type.
                     */
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type getType();

                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @return A list containing the paths.
                     */
                    java.util.List<java.lang.Integer> getPathsList();
                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @return The count of paths.
                     */
                    int getPathsCount();
                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @param index The index of the element to return.
                     * @return The paths at the given index.
                     */
                    int getPaths(int index);
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AsPath.Segment}
                 */
                public static final class Segment extends
                        com.google.protobuf.GeneratedMessageV3 implements
                        // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.AsPath.Segment)
                        SegmentOrBuilder {
                    private static final long serialVersionUID = 0L;
                    // Use Segment.newBuilder() to construct.
                    private Segment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                        super(builder);
                    }
                    private Segment() {
                        type_ = 0;
                        paths_ = emptyIntList();
                    }

                    @java.lang.Override
                    @SuppressWarnings({"unused"})
                    protected java.lang.Object newInstance(
                            UnusedPrivateParameter unused) {
                        return new Segment();
                    }

                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_Segment_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_Segment_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder.class);
                    }

                    /**
                     * Protobuf enum {@code RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type}
                     */
                    public enum Type
                            implements com.google.protobuf.ProtocolMessageEnum {
                        /**
                         * <code>AS_SET = 0;</code>
                         */
                        AS_SET(0),
                        /**
                         * <code>AS_SEQUENCE = 1;</code>
                         */
                        AS_SEQUENCE(1),
                        UNRECOGNIZED(-1),
                        ;

                        /**
                         * <code>AS_SET = 0;</code>
                         */
                        public static final int AS_SET_VALUE = 0;
                        /**
                         * <code>AS_SEQUENCE = 1;</code>
                         */
                        public static final int AS_SEQUENCE_VALUE = 1;


                        public final int getNumber() {
                            if (this == UNRECOGNIZED) {
                                throw new java.lang.IllegalArgumentException(
                                        "Can't get the number of an unknown enum value.");
                            }
                            return value;
                        }

                        /**
                         * @param value The numeric wire value of the corresponding enum entry.
                         * @return The enum associated with the given numeric wire value.
                         * @deprecated Use {@link #forNumber(int)} instead.
                         */
                        @java.lang.Deprecated
                        public static Type valueOf(int value) {
                            return forNumber(value);
                        }

                        /**
                         * @param value The numeric wire value of the corresponding enum entry.
                         * @return The enum associated with the given numeric wire value.
                         */
                        public static Type forNumber(int value) {
                            switch (value) {
                                case 0: return AS_SET;
                                case 1: return AS_SEQUENCE;
                                default: return null;
                            }
                        }

                        public static com.google.protobuf.Internal.EnumLiteMap<Type>
                        internalGetValueMap() {
                            return internalValueMap;
                        }
                        private static final com.google.protobuf.Internal.EnumLiteMap<
                                Type> internalValueMap =
                                new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                                    public Type findValueByNumber(int number) {
                                        return Type.forNumber(number);
                                    }
                                };

                        public final com.google.protobuf.Descriptors.EnumValueDescriptor
                        getValueDescriptor() {
                            if (this == UNRECOGNIZED) {
                                throw new java.lang.IllegalStateException(
                                        "Can't get the descriptor of an unrecognized enum value.");
                            }
                            return getDescriptor().getValues().get(ordinal());
                        }
                        public final com.google.protobuf.Descriptors.EnumDescriptor
                        getDescriptorForType() {
                            return getDescriptor();
                        }
                        public static final com.google.protobuf.Descriptors.EnumDescriptor
                        getDescriptor() {
                            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.getDescriptor().getEnumTypes().get(0);
                        }

                        private static final Type[] VALUES = values();

                        public static Type valueOf(
                                com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
                            if (desc.getType() != getDescriptor()) {
                                throw new java.lang.IllegalArgumentException(
                                        "EnumValueDescriptor is not for this type.");
                            }
                            if (desc.getIndex() == -1) {
                                return UNRECOGNIZED;
                            }
                            return VALUES[desc.getIndex()];
                        }

                        private final int value;

                        private Type(int value) {
                            this.value = value;
                        }

                        // @@protoc_insertion_point(enum_scope:RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type)
                    }

                    public static final int TYPE_FIELD_NUMBER = 1;
                    private int type_ = 0;
                    /**
                     * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                     * @return The enum numeric value on the wire for type.
                     */
                    @java.lang.Override public int getTypeValue() {
                        return type_;
                    }
                    /**
                     * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                     * @return The type.
                     */
                    @java.lang.Override public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type getType() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.forNumber(type_);
                        return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.UNRECOGNIZED : result;
                    }

                    public static final int PATHS_FIELD_NUMBER = 2;
                    @SuppressWarnings("serial")
                    private com.google.protobuf.Internal.IntList paths_ =
                            emptyIntList();
                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @return A list containing the paths.
                     */
                    @java.lang.Override
                    public java.util.List<java.lang.Integer>
                    getPathsList() {
                        return paths_;
                    }
                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @return The count of paths.
                     */
                    public int getPathsCount() {
                        return paths_.size();
                    }
                    /**
                     * <code>repeated fixed32 paths = 2;</code>
                     * @param index The index of the element to return.
                     * @return The paths at the given index.
                     */
                    public int getPaths(int index) {
                        return paths_.getInt(index);
                    }
                    private int pathsMemoizedSerializedSize = -1;

                    private byte memoizedIsInitialized = -1;
                    @java.lang.Override
                    public final boolean isInitialized() {
                        byte isInitialized = memoizedIsInitialized;
                        if (isInitialized == 1) return true;
                        if (isInitialized == 0) return false;

                        memoizedIsInitialized = 1;
                        return true;
                    }

                    @java.lang.Override
                    public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
                        getSerializedSize();
                        if (type_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.AS_SET.getNumber()) {
                            output.writeEnum(1, type_);
                        }
                        if (getPathsList().size() > 0) {
                            output.writeUInt32NoTag(18);
                            output.writeUInt32NoTag(pathsMemoizedSerializedSize);
                        }
                        for (int i = 0; i < paths_.size(); i++) {
                            output.writeFixed32NoTag(paths_.getInt(i));
                        }
                        getUnknownFields().writeTo(output);
                    }

                    @java.lang.Override
                    public int getSerializedSize() {
                        int size = memoizedSize;
                        if (size != -1) return size;

                        size = 0;
                        if (type_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.AS_SET.getNumber()) {
                            size += com.google.protobuf.CodedOutputStream
                                    .computeEnumSize(1, type_);
                        }
                        {
                            int dataSize = 0;
                            dataSize = 4 * getPathsList().size();
                            size += dataSize;
                            if (!getPathsList().isEmpty()) {
                                size += 1;
                                size += com.google.protobuf.CodedOutputStream
                                        .computeInt32SizeNoTag(dataSize);
                            }
                            pathsMemoizedSerializedSize = dataSize;
                        }
                        size += getUnknownFields().getSerializedSize();
                        memoizedSize = size;
                        return size;
                    }

                    @java.lang.Override
                    public boolean equals(final java.lang.Object obj) {
                        if (obj == this) {
                            return true;
                        }
                        if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment)) {
                            return super.equals(obj);
                        }
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment) obj;

                        if (type_ != other.type_) return false;
                        if (!getPathsList()
                                .equals(other.getPathsList())) return false;
                        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                        return true;
                    }

                    @java.lang.Override
                    public int hashCode() {
                        if (memoizedHashCode != 0) {
                            return memoizedHashCode;
                        }
                        int hash = 41;
                        hash = (19 * hash) + getDescriptor().hashCode();
                        hash = (37 * hash) + TYPE_FIELD_NUMBER;
                        hash = (53 * hash) + type_;
                        if (getPathsCount() > 0) {
                            hash = (37 * hash) + PATHS_FIELD_NUMBER;
                            hash = (53 * hash) + getPathsList().hashCode();
                        }
                        hash = (29 * hash) + getUnknownFields().hashCode();
                        memoizedHashCode = hash;
                        return hash;
                    }

                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            java.nio.ByteBuffer data)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            java.nio.ByteBuffer data,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data, extensionRegistry);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            com.google.protobuf.ByteString data)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            com.google.protobuf.ByteString data,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data, extensionRegistry);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(byte[] data)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            byte[] data,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        return PARSER.parseFrom(data, extensionRegistry);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(java.io.InputStream input)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseWithIOException(PARSER, input);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            java.io.InputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseWithIOException(PARSER, input, extensionRegistry);
                    }

                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseDelimitedFrom(java.io.InputStream input)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseDelimitedWithIOException(PARSER, input);
                    }

                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseDelimitedFrom(
                            java.io.InputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            com.google.protobuf.CodedInputStream input)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseWithIOException(PARSER, input);
                    }
                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment parseFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        return com.google.protobuf.GeneratedMessageV3
                                .parseWithIOException(PARSER, input, extensionRegistry);
                    }

                    @java.lang.Override
                    public Builder newBuilderForType() { return newBuilder(); }
                    public static Builder newBuilder() {
                        return DEFAULT_INSTANCE.toBuilder();
                    }
                    public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment prototype) {
                        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                    }
                    @java.lang.Override
                    public Builder toBuilder() {
                        return this == DEFAULT_INSTANCE
                                ? new Builder() : new Builder().mergeFrom(this);
                    }

                    @java.lang.Override
                    protected Builder newBuilderForType(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        Builder builder = new Builder(parent);
                        return builder;
                    }
                    /**
                     * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AsPath.Segment}
                     */
                    public static final class Builder extends
                            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                            // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.AsPath.Segment)
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder {
                        public static final com.google.protobuf.Descriptors.Descriptor
                        getDescriptor() {
                            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_Segment_descriptor;
                        }

                        @java.lang.Override
                        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                        internalGetFieldAccessorTable() {
                            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_Segment_fieldAccessorTable
                                    .ensureFieldAccessorsInitialized(
                                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder.class);
                        }

                        // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.newBuilder()
                        private Builder() {

                        }

                        private Builder(
                                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                            super(parent);

                        }
                        @java.lang.Override
                        public Builder clear() {
                            super.clear();
                            bitField0_ = 0;
                            type_ = 0;
                            paths_ = emptyIntList();
                            return this;
                        }

                        @java.lang.Override
                        public com.google.protobuf.Descriptors.Descriptor
                        getDescriptorForType() {
                            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_Segment_descriptor;
                        }

                        @java.lang.Override
                        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getDefaultInstanceForType() {
                            return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.getDefaultInstance();
                        }

                        @java.lang.Override
                        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment build() {
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment result = buildPartial();
                            if (!result.isInitialized()) {
                                throw newUninitializedMessageException(result);
                            }
                            return result;
                        }

                        @java.lang.Override
                        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment buildPartial() {
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment(this);
                            if (bitField0_ != 0) { buildPartial0(result); }
                            onBuilt();
                            return result;
                        }

                        private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment result) {
                            int from_bitField0_ = bitField0_;
                            if (((from_bitField0_ & 0x00000001) != 0)) {
                                result.type_ = type_;
                            }
                            if (((from_bitField0_ & 0x00000002) != 0)) {
                                paths_.makeImmutable();
                                result.paths_ = paths_;
                            }
                        }

                        @java.lang.Override
                        public Builder clone() {
                            return super.clone();
                        }
                        @java.lang.Override
                        public Builder setField(
                                com.google.protobuf.Descriptors.FieldDescriptor field,
                                java.lang.Object value) {
                            return super.setField(field, value);
                        }
                        @java.lang.Override
                        public Builder clearField(
                                com.google.protobuf.Descriptors.FieldDescriptor field) {
                            return super.clearField(field);
                        }
                        @java.lang.Override
                        public Builder clearOneof(
                                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                            return super.clearOneof(oneof);
                        }
                        @java.lang.Override
                        public Builder setRepeatedField(
                                com.google.protobuf.Descriptors.FieldDescriptor field,
                                int index, java.lang.Object value) {
                            return super.setRepeatedField(field, index, value);
                        }
                        @java.lang.Override
                        public Builder addRepeatedField(
                                com.google.protobuf.Descriptors.FieldDescriptor field,
                                java.lang.Object value) {
                            return super.addRepeatedField(field, value);
                        }
                        @java.lang.Override
                        public Builder mergeFrom(com.google.protobuf.Message other) {
                            if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment) {
                                return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment)other);
                            } else {
                                super.mergeFrom(other);
                                return this;
                            }
                        }

                        public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment other) {
                            if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.getDefaultInstance()) return this;
                            if (other.type_ != 0) {
                                setTypeValue(other.getTypeValue());
                            }
                            if (!other.paths_.isEmpty()) {
                                if (paths_.isEmpty()) {
                                    paths_ = other.paths_;
                                    paths_.makeImmutable();
                                    bitField0_ |= 0x00000002;
                                } else {
                                    ensurePathsIsMutable();
                                    paths_.addAll(other.paths_);
                                }
                                onChanged();
                            }
                            this.mergeUnknownFields(other.getUnknownFields());
                            onChanged();
                            return this;
                        }

                        @java.lang.Override
                        public final boolean isInitialized() {
                            return true;
                        }

                        @java.lang.Override
                        public Builder mergeFrom(
                                com.google.protobuf.CodedInputStream input,
                                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                                throws java.io.IOException {
                            if (extensionRegistry == null) {
                                throw new java.lang.NullPointerException();
                            }
                            try {
                                boolean done = false;
                                while (!done) {
                                    int tag = input.readTag();
                                    switch (tag) {
                                        case 0:
                                            done = true;
                                            break;
                                        case 8: {
                                            type_ = input.readEnum();
                                            bitField0_ |= 0x00000001;
                                            break;
                                        } // case 8
                                        case 21: {
                                            int v = input.readFixed32();
                                            ensurePathsIsMutable();
                                            paths_.addInt(v);
                                            break;
                                        } // case 21
                                        case 18: {
                                            int length = input.readRawVarint32();
                                            int limit = input.pushLimit(length);
                                            int alloc = length > 4096 ? 4096 : length;
                                            ensurePathsIsMutable(alloc / 4);
                                            while (input.getBytesUntilLimit() > 0) {
                                                paths_.addInt(input.readFixed32());
                                            }
                                            input.popLimit(limit);
                                            break;
                                        } // case 18
                                        default: {
                                            if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                                done = true; // was an endgroup tag
                                            }
                                            break;
                                        } // default:
                                    } // switch (tag)
                                } // while (!done)
                            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                                throw e.unwrapIOException();
                            } finally {
                                onChanged();
                            } // finally
                            return this;
                        }
                        private int bitField0_;

                        private int type_ = 0;
                        /**
                         * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                         * @return The enum numeric value on the wire for type.
                         */
                        @java.lang.Override public int getTypeValue() {
                            return type_;
                        }
                        /**
                         * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                         * @param value The enum numeric value on the wire for type to set.
                         * @return This builder for chaining.
                         */
                        public Builder setTypeValue(int value) {
                            type_ = value;
                            bitField0_ |= 0x00000001;
                            onChanged();
                            return this;
                        }
                        /**
                         * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                         * @return The type.
                         */
                        @java.lang.Override
                        public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type getType() {
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type result = org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.forNumber(type_);
                            return result == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.UNRECOGNIZED : result;
                        }
                        /**
                         * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                         * @param value The type to set.
                         * @return This builder for chaining.
                         */
                        public Builder setType(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type value) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            bitField0_ |= 0x00000001;
                            type_ = value.getNumber();
                            onChanged();
                            return this;
                        }
                        /**
                         * <code>.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type type = 1;</code>
                         * @return This builder for chaining.
                         */
                        public Builder clearType() {
                            bitField0_ = (bitField0_ & ~0x00000001);
                            type_ = 0;
                            onChanged();
                            return this;
                        }

                        private com.google.protobuf.Internal.IntList paths_ = emptyIntList();
                        private void ensurePathsIsMutable() {
                            if (!paths_.isModifiable()) {
                                paths_ = makeMutableCopy(paths_);
                            }
                            bitField0_ |= 0x00000002;
                        }
                        private void ensurePathsIsMutable(int capacity) {
                            if (!paths_.isModifiable()) {
                                paths_ = makeMutableCopy(paths_, capacity);
                            }
                            bitField0_ |= 0x00000002;
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @return A list containing the paths.
                         */
                        public java.util.List<java.lang.Integer>
                        getPathsList() {
                            paths_.makeImmutable();
                            return paths_;
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @return The count of paths.
                         */
                        public int getPathsCount() {
                            return paths_.size();
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @param index The index of the element to return.
                         * @return The paths at the given index.
                         */
                        public int getPaths(int index) {
                            return paths_.getInt(index);
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @param index The index to set the value at.
                         * @param value The paths to set.
                         * @return This builder for chaining.
                         */
                        public Builder setPaths(
                                int index, int value) {

                            ensurePathsIsMutable();
                            paths_.setInt(index, value);
                            bitField0_ |= 0x00000002;
                            onChanged();
                            return this;
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @param value The paths to add.
                         * @return This builder for chaining.
                         */
                        public Builder addPaths(int value) {

                            ensurePathsIsMutable();
                            paths_.addInt(value);
                            bitField0_ |= 0x00000002;
                            onChanged();
                            return this;
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @param values The paths to add.
                         * @return This builder for chaining.
                         */
                        public Builder addAllPaths(
                                java.lang.Iterable<? extends java.lang.Integer> values) {
                            ensurePathsIsMutable();
                            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                                    values, paths_);
                            bitField0_ |= 0x00000002;
                            onChanged();
                            return this;
                        }
                        /**
                         * <code>repeated fixed32 paths = 2;</code>
                         * @return This builder for chaining.
                         */
                        public Builder clearPaths() {
                            paths_ = emptyIntList();
                            bitField0_ = (bitField0_ & ~0x00000002);
                            onChanged();
                            return this;
                        }
                        @java.lang.Override
                        public final Builder setUnknownFields(
                                final com.google.protobuf.UnknownFieldSet unknownFields) {
                            return super.setUnknownFields(unknownFields);
                        }

                        @java.lang.Override
                        public final Builder mergeUnknownFields(
                                final com.google.protobuf.UnknownFieldSet unknownFields) {
                            return super.mergeUnknownFields(unknownFields);
                        }


                        // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.AsPath.Segment)
                    }

                    // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.AsPath.Segment)
                    private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment DEFAULT_INSTANCE;
                    static {
                        DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment();
                    }

                    public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getDefaultInstance() {
                        return DEFAULT_INSTANCE;
                    }

                    private static final com.google.protobuf.Parser<Segment>
                            PARSER = new com.google.protobuf.AbstractParser<Segment>() {
                        @java.lang.Override
                        public Segment parsePartialFrom(
                                com.google.protobuf.CodedInputStream input,
                                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                                throws com.google.protobuf.InvalidProtocolBufferException {
                            Builder builder = newBuilder();
                            try {
                                builder.mergeFrom(input, extensionRegistry);
                            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                                throw e.setUnfinishedMessage(builder.buildPartial());
                            } catch (com.google.protobuf.UninitializedMessageException e) {
                                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                            } catch (java.io.IOException e) {
                                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                        .setUnfinishedMessage(builder.buildPartial());
                            }
                            return builder.buildPartial();
                        }
                    };

                    public static com.google.protobuf.Parser<Segment> parser() {
                        return PARSER;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Parser<Segment> getParserForType() {
                        return PARSER;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getDefaultInstanceForType() {
                        return DEFAULT_INSTANCE;
                    }

                }

                public static final int SEGMENTS_FIELD_NUMBER = 1;
                @SuppressWarnings("serial")
                private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment> segments_;
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment> getSegmentsList() {
                    return segments_;
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder>
                getSegmentsOrBuilderList() {
                    return segments_;
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                @java.lang.Override
                public int getSegmentsCount() {
                    return segments_.size();
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getSegments(int index) {
                    return segments_.get(index);
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder getSegmentsOrBuilder(
                        int index) {
                    return segments_.get(index);
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    for (int i = 0; i < segments_.size(); i++) {
                        output.writeMessage(1, segments_.get(i));
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    for (int i = 0; i < segments_.size(); i++) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeMessageSize(1, segments_.get(i));
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath) obj;

                    if (!getSegmentsList()
                            .equals(other.getSegmentsList())) return false;
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    if (getSegmentsCount() > 0) {
                        hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
                        hash = (53 * hash) + getSegmentsList().hashCode();
                    }
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AsPath}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.AsPath)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPathOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        if (segmentsBuilder_ == null) {
                            segments_ = java.util.Collections.emptyList();
                        } else {
                            segments_ = null;
                            segmentsBuilder_.clear();
                        }
                        bitField0_ = (bitField0_ & ~0x00000001);
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AsPath_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath(this);
                        buildPartialRepeatedFields(result);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartialRepeatedFields(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath result) {
                        if (segmentsBuilder_ == null) {
                            if (((bitField0_ & 0x00000001) != 0)) {
                                segments_ = java.util.Collections.unmodifiableList(segments_);
                                bitField0_ = (bitField0_ & ~0x00000001);
                            }
                            result.segments_ = segments_;
                        } else {
                            result.segments_ = segmentsBuilder_.build();
                        }
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath result) {
                        int from_bitField0_ = bitField0_;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.getDefaultInstance()) return this;
                        if (segmentsBuilder_ == null) {
                            if (!other.segments_.isEmpty()) {
                                if (segments_.isEmpty()) {
                                    segments_ = other.segments_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                } else {
                                    ensureSegmentsIsMutable();
                                    segments_.addAll(other.segments_);
                                }
                                onChanged();
                            }
                        } else {
                            if (!other.segments_.isEmpty()) {
                                if (segmentsBuilder_.isEmpty()) {
                                    segmentsBuilder_.dispose();
                                    segmentsBuilder_ = null;
                                    segments_ = other.segments_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                    segmentsBuilder_ =
                                            com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                                    getSegmentsFieldBuilder() : null;
                                } else {
                                    segmentsBuilder_.addAllMessages(other.segments_);
                                }
                            }
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 10: {
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment m =
                                                input.readMessage(
                                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.parser(),
                                                        extensionRegistry);
                                        if (segmentsBuilder_ == null) {
                                            ensureSegmentsIsMutable();
                                            segments_.add(m);
                                        } else {
                                            segmentsBuilder_.addMessage(m);
                                        }
                                        break;
                                    } // case 10
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment> segments_ =
                            java.util.Collections.emptyList();
                    private void ensureSegmentsIsMutable() {
                        if (!((bitField0_ & 0x00000001) != 0)) {
                            segments_ = new java.util.ArrayList<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment>(segments_);
                            bitField0_ |= 0x00000001;
                        }
                    }

                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder> segmentsBuilder_;

                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment> getSegmentsList() {
                        if (segmentsBuilder_ == null) {
                            return java.util.Collections.unmodifiableList(segments_);
                        } else {
                            return segmentsBuilder_.getMessageList();
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public int getSegmentsCount() {
                        if (segmentsBuilder_ == null) {
                            return segments_.size();
                        } else {
                            return segmentsBuilder_.getCount();
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment getSegments(int index) {
                        if (segmentsBuilder_ == null) {
                            return segments_.get(index);
                        } else {
                            return segmentsBuilder_.getMessage(index);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder setSegments(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment value) {
                        if (segmentsBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureSegmentsIsMutable();
                            segments_.set(index, value);
                            onChanged();
                        } else {
                            segmentsBuilder_.setMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder setSegments(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder builderForValue) {
                        if (segmentsBuilder_ == null) {
                            ensureSegmentsIsMutable();
                            segments_.set(index, builderForValue.build());
                            onChanged();
                        } else {
                            segmentsBuilder_.setMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder addSegments(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment value) {
                        if (segmentsBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureSegmentsIsMutable();
                            segments_.add(value);
                            onChanged();
                        } else {
                            segmentsBuilder_.addMessage(value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder addSegments(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment value) {
                        if (segmentsBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureSegmentsIsMutable();
                            segments_.add(index, value);
                            onChanged();
                        } else {
                            segmentsBuilder_.addMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder addSegments(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder builderForValue) {
                        if (segmentsBuilder_ == null) {
                            ensureSegmentsIsMutable();
                            segments_.add(builderForValue.build());
                            onChanged();
                        } else {
                            segmentsBuilder_.addMessage(builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder addSegments(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder builderForValue) {
                        if (segmentsBuilder_ == null) {
                            ensureSegmentsIsMutable();
                            segments_.add(index, builderForValue.build());
                            onChanged();
                        } else {
                            segmentsBuilder_.addMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder addAllSegments(
                            java.lang.Iterable<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment> values) {
                        if (segmentsBuilder_ == null) {
                            ensureSegmentsIsMutable();
                            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                                    values, segments_);
                            onChanged();
                        } else {
                            segmentsBuilder_.addAllMessages(values);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder clearSegments() {
                        if (segmentsBuilder_ == null) {
                            segments_ = java.util.Collections.emptyList();
                            bitField0_ = (bitField0_ & ~0x00000001);
                            onChanged();
                        } else {
                            segmentsBuilder_.clear();
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public Builder removeSegments(int index) {
                        if (segmentsBuilder_ == null) {
                            ensureSegmentsIsMutable();
                            segments_.remove(index);
                            onChanged();
                        } else {
                            segmentsBuilder_.remove(index);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder getSegmentsBuilder(
                            int index) {
                        return getSegmentsFieldBuilder().getBuilder(index);
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder getSegmentsOrBuilder(
                            int index) {
                        if (segmentsBuilder_ == null) {
                            return segments_.get(index);  } else {
                            return segmentsBuilder_.getMessageOrBuilder(index);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder>
                    getSegmentsOrBuilderList() {
                        if (segmentsBuilder_ != null) {
                            return segmentsBuilder_.getMessageOrBuilderList();
                        } else {
                            return java.util.Collections.unmodifiableList(segments_);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder addSegmentsBuilder() {
                        return getSegmentsFieldBuilder().addBuilder(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder addSegmentsBuilder(
                            int index) {
                        return getSegmentsFieldBuilder().addBuilder(
                                index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.AsPath.Segment segments = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder>
                    getSegmentsBuilderList() {
                        return getSegmentsFieldBuilder().getBuilderList();
                    }
                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder>
                    getSegmentsFieldBuilder() {
                        if (segmentsBuilder_ == null) {
                            segmentsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath.SegmentOrBuilder>(
                                    segments_,
                                    ((bitField0_ & 0x00000001) != 0),
                                    getParentForChildren(),
                                    isClean());
                            segments_ = null;
                        }
                        return segmentsBuilder_;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.AsPath)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.AsPath)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<AsPath>
                        PARSER = new com.google.protobuf.AbstractParser<AsPath>() {
                    @java.lang.Override
                    public AsPath parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<AsPath> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<AsPath> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AsPath getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface NextHopOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.NextHop)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>.IpAddress address = 1;</code>
                 * @return Whether the address field is set.
                 */
                boolean hasAddress();
                /**
                 * <code>.IpAddress address = 1;</code>
                 * @return The address.
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress();
                /**
                 * <code>.IpAddress address = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder();
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.NextHop}
             */
            public static final class NextHop extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.NextHop)
                    NextHopOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use NextHop.newBuilder() to construct.
                private NextHop(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private NextHop() {
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new NextHop();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_NextHop_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_NextHop_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.Builder.class);
                }

                private int bitField0_;
                public static final int ADDRESS_FIELD_NUMBER = 1;
                private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
                /**
                 * <code>.IpAddress address = 1;</code>
                 * @return Whether the address field is set.
                 */
                @java.lang.Override
                public boolean hasAddress() {
                    return ((bitField0_ & 0x00000001) != 0);
                }
                /**
                 * <code>.IpAddress address = 1;</code>
                 * @return The address.
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
                    return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                }
                /**
                 * <code>.IpAddress address = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
                    return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    if (((bitField0_ & 0x00000001) != 0)) {
                        output.writeMessage(1, getAddress());
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    if (((bitField0_ & 0x00000001) != 0)) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeMessageSize(1, getAddress());
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop) obj;

                    if (hasAddress() != other.hasAddress()) return false;
                    if (hasAddress()) {
                        if (!getAddress()
                                .equals(other.getAddress())) return false;
                    }
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    if (hasAddress()) {
                        hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
                        hash = (53 * hash) + getAddress().hashCode();
                    }
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.NextHop}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.NextHop)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHopOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_NextHop_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_NextHop_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.newBuilder()
                    private Builder() {
                        maybeForceBuilderInitialization();
                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);
                        maybeForceBuilderInitialization();
                    }
                    private void maybeForceBuilderInitialization() {
                        if (com.google.protobuf.GeneratedMessageV3
                                .alwaysUseFieldBuilders) {
                            getAddressFieldBuilder();
                        }
                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        address_ = null;
                        if (addressBuilder_ != null) {
                            addressBuilder_.dispose();
                            addressBuilder_ = null;
                        }
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_NextHop_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop(this);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop result) {
                        int from_bitField0_ = bitField0_;
                        int to_bitField0_ = 0;
                        if (((from_bitField0_ & 0x00000001) != 0)) {
                            result.address_ = addressBuilder_ == null
                                    ? address_
                                    : addressBuilder_.build();
                            to_bitField0_ |= 0x00000001;
                        }
                        result.bitField0_ |= to_bitField0_;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop.getDefaultInstance()) return this;
                        if (other.hasAddress()) {
                            mergeAddress(other.getAddress());
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 10: {
                                        input.readMessage(
                                                getAddressFieldBuilder().getBuilder(),
                                                extensionRegistry);
                                        bitField0_ |= 0x00000001;
                                        break;
                                    } // case 10
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
                    private com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> addressBuilder_;
                    /**
                     * <code>.IpAddress address = 1;</code>
                     * @return Whether the address field is set.
                     */
                    public boolean hasAddress() {
                        return ((bitField0_ & 0x00000001) != 0);
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     * @return The address.
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
                        if (addressBuilder_ == null) {
                            return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                        } else {
                            return addressBuilder_.getMessage();
                        }
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public Builder setAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (addressBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            address_ = value;
                        } else {
                            addressBuilder_.setMessage(value);
                        }
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public Builder setAddress(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                        if (addressBuilder_ == null) {
                            address_ = builderForValue.build();
                        } else {
                            addressBuilder_.setMessage(builderForValue.build());
                        }
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public Builder mergeAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (addressBuilder_ == null) {
                            if (((bitField0_ & 0x00000001) != 0) &&
                                    address_ != null &&
                                    address_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                                getAddressBuilder().mergeFrom(value);
                            } else {
                                address_ = value;
                            }
                        } else {
                            addressBuilder_.mergeFrom(value);
                        }
                        if (address_ != null) {
                            bitField0_ |= 0x00000001;
                            onChanged();
                        }
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public Builder clearAddress() {
                        bitField0_ = (bitField0_ & ~0x00000001);
                        address_ = null;
                        if (addressBuilder_ != null) {
                            addressBuilder_.dispose();
                            addressBuilder_ = null;
                        }
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getAddressBuilder() {
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return getAddressFieldBuilder().getBuilder();
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
                        if (addressBuilder_ != null) {
                            return addressBuilder_.getMessageOrBuilder();
                        } else {
                            return address_ == null ?
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                        }
                    }
                    /**
                     * <code>.IpAddress address = 1;</code>
                     */
                    private com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                    getAddressFieldBuilder() {
                        if (addressBuilder_ == null) {
                            addressBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                                    getAddress(),
                                    getParentForChildren(),
                                    isClean());
                            address_ = null;
                        }
                        return addressBuilder_;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.NextHop)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.NextHop)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<NextHop>
                        PARSER = new com.google.protobuf.AbstractParser<NextHop>() {
                    @java.lang.Override
                    public NextHop parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<NextHop> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<NextHop> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.NextHop getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface MultiExitDiscOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.MultiExitDisc)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>uint32 discriminator = 1;</code>
                 * @return The discriminator.
                 */
                int getDiscriminator();
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.MultiExitDisc}
             */
            public static final class MultiExitDisc extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.MultiExitDisc)
                    MultiExitDiscOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use MultiExitDisc.newBuilder() to construct.
                private MultiExitDisc(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private MultiExitDisc() {
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new MultiExitDisc();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_MultiExitDisc_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_MultiExitDisc_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.Builder.class);
                }

                public static final int DISCRIMINATOR_FIELD_NUMBER = 1;
                private int discriminator_ = 0;
                /**
                 * <code>uint32 discriminator = 1;</code>
                 * @return The discriminator.
                 */
                @java.lang.Override
                public int getDiscriminator() {
                    return discriminator_;
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    if (discriminator_ != 0) {
                        output.writeUInt32(1, discriminator_);
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    if (discriminator_ != 0) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeUInt32Size(1, discriminator_);
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc) obj;

                    if (getDiscriminator()
                            != other.getDiscriminator()) return false;
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    hash = (37 * hash) + DISCRIMINATOR_FIELD_NUMBER;
                    hash = (53 * hash) + getDiscriminator();
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.MultiExitDisc}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.MultiExitDisc)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDiscOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_MultiExitDisc_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_MultiExitDisc_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        discriminator_ = 0;
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_MultiExitDisc_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc(this);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc result) {
                        int from_bitField0_ = bitField0_;
                        if (((from_bitField0_ & 0x00000001) != 0)) {
                            result.discriminator_ = discriminator_;
                        }
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc.getDefaultInstance()) return this;
                        if (other.getDiscriminator() != 0) {
                            setDiscriminator(other.getDiscriminator());
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 8: {
                                        discriminator_ = input.readUInt32();
                                        bitField0_ |= 0x00000001;
                                        break;
                                    } // case 8
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private int discriminator_ ;
                    /**
                     * <code>uint32 discriminator = 1;</code>
                     * @return The discriminator.
                     */
                    @java.lang.Override
                    public int getDiscriminator() {
                        return discriminator_;
                    }
                    /**
                     * <code>uint32 discriminator = 1;</code>
                     * @param value The discriminator to set.
                     * @return This builder for chaining.
                     */
                    public Builder setDiscriminator(int value) {

                        discriminator_ = value;
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>uint32 discriminator = 1;</code>
                     * @return This builder for chaining.
                     */
                    public Builder clearDiscriminator() {
                        bitField0_ = (bitField0_ & ~0x00000001);
                        discriminator_ = 0;
                        onChanged();
                        return this;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.MultiExitDisc)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.MultiExitDisc)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<MultiExitDisc>
                        PARSER = new com.google.protobuf.AbstractParser<MultiExitDisc>() {
                    @java.lang.Override
                    public MultiExitDisc parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<MultiExitDisc> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<MultiExitDisc> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.MultiExitDisc getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface LocalPrefOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.LocalPref)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>uint32 preference = 1;</code>
                 * @return The preference.
                 */
                int getPreference();
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.LocalPref}
             */
            public static final class LocalPref extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.LocalPref)
                    LocalPrefOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use LocalPref.newBuilder() to construct.
                private LocalPref(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private LocalPref() {
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new LocalPref();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_LocalPref_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_LocalPref_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.Builder.class);
                }

                public static final int PREFERENCE_FIELD_NUMBER = 1;
                private int preference_ = 0;
                /**
                 * <code>uint32 preference = 1;</code>
                 * @return The preference.
                 */
                @java.lang.Override
                public int getPreference() {
                    return preference_;
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    if (preference_ != 0) {
                        output.writeUInt32(1, preference_);
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    if (preference_ != 0) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeUInt32Size(1, preference_);
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref) obj;

                    if (getPreference()
                            != other.getPreference()) return false;
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    hash = (37 * hash) + PREFERENCE_FIELD_NUMBER;
                    hash = (53 * hash) + getPreference();
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.LocalPref}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.LocalPref)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPrefOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_LocalPref_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_LocalPref_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        preference_ = 0;
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_LocalPref_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref(this);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref result) {
                        int from_bitField0_ = bitField0_;
                        if (((from_bitField0_ & 0x00000001) != 0)) {
                            result.preference_ = preference_;
                        }
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref.getDefaultInstance()) return this;
                        if (other.getPreference() != 0) {
                            setPreference(other.getPreference());
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 8: {
                                        preference_ = input.readUInt32();
                                        bitField0_ |= 0x00000001;
                                        break;
                                    } // case 8
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private int preference_ ;
                    /**
                     * <code>uint32 preference = 1;</code>
                     * @return The preference.
                     */
                    @java.lang.Override
                    public int getPreference() {
                        return preference_;
                    }
                    /**
                     * <code>uint32 preference = 1;</code>
                     * @param value The preference to set.
                     * @return This builder for chaining.
                     */
                    public Builder setPreference(int value) {

                        preference_ = value;
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>uint32 preference = 1;</code>
                     * @return This builder for chaining.
                     */
                    public Builder clearPreference() {
                        bitField0_ = (bitField0_ & ~0x00000001);
                        preference_ = 0;
                        onChanged();
                        return this;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.LocalPref)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.LocalPref)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<LocalPref>
                        PARSER = new com.google.protobuf.AbstractParser<LocalPref>() {
                    @java.lang.Override
                    public LocalPref parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<LocalPref> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<LocalPref> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.LocalPref getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface AtomicAggregateOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.AtomicAggregate)
                    com.google.protobuf.MessageOrBuilder {
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AtomicAggregate}
             */
            public static final class AtomicAggregate extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.AtomicAggregate)
                    AtomicAggregateOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use AtomicAggregate.newBuilder() to construct.
                private AtomicAggregate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private AtomicAggregate() {
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new AtomicAggregate();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AtomicAggregate_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AtomicAggregate_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.Builder.class);
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate) obj;

                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.AtomicAggregate}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.AtomicAggregate)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregateOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AtomicAggregate_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AtomicAggregate_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_AtomicAggregate_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate(this);
                        onBuilt();
                        return result;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate.getDefaultInstance()) return this;
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.AtomicAggregate)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.AtomicAggregate)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<AtomicAggregate>
                        PARSER = new com.google.protobuf.AbstractParser<AtomicAggregate>() {
                    @java.lang.Override
                    public AtomicAggregate parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<AtomicAggregate> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<AtomicAggregate> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AtomicAggregate getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface AggregatorOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.Aggregator)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>fixed32 as = 1;</code>
                 * @return The as.
                 */
                int getAs();

                /**
                 * <code>.IpAddress address = 2;</code>
                 * @return Whether the address field is set.
                 */
                boolean hasAddress();
                /**
                 * <code>.IpAddress address = 2;</code>
                 * @return The address.
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress();
                /**
                 * <code>.IpAddress address = 2;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder();
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.Aggregator}
             */
            public static final class Aggregator extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.Aggregator)
                    AggregatorOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use Aggregator.newBuilder() to construct.
                private Aggregator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private Aggregator() {
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new Aggregator();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_Aggregator_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_Aggregator_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.Builder.class);
                }

                private int bitField0_;
                public static final int AS_FIELD_NUMBER = 1;
                private int as_ = 0;
                /**
                 * <code>fixed32 as = 1;</code>
                 * @return The as.
                 */
                @java.lang.Override
                public int getAs() {
                    return as_;
                }

                public static final int ADDRESS_FIELD_NUMBER = 2;
                private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
                /**
                 * <code>.IpAddress address = 2;</code>
                 * @return Whether the address field is set.
                 */
                @java.lang.Override
                public boolean hasAddress() {
                    return ((bitField0_ & 0x00000001) != 0);
                }
                /**
                 * <code>.IpAddress address = 2;</code>
                 * @return The address.
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
                    return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                }
                /**
                 * <code>.IpAddress address = 2;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
                    return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    if (as_ != 0) {
                        output.writeFixed32(1, as_);
                    }
                    if (((bitField0_ & 0x00000001) != 0)) {
                        output.writeMessage(2, getAddress());
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    if (as_ != 0) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeFixed32Size(1, as_);
                    }
                    if (((bitField0_ & 0x00000001) != 0)) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeMessageSize(2, getAddress());
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator) obj;

                    if (getAs()
                            != other.getAs()) return false;
                    if (hasAddress() != other.hasAddress()) return false;
                    if (hasAddress()) {
                        if (!getAddress()
                                .equals(other.getAddress())) return false;
                    }
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    hash = (37 * hash) + AS_FIELD_NUMBER;
                    hash = (53 * hash) + getAs();
                    if (hasAddress()) {
                        hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
                        hash = (53 * hash) + getAddress().hashCode();
                    }
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.Aggregator}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.Aggregator)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.AggregatorOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_Aggregator_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_Aggregator_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.newBuilder()
                    private Builder() {
                        maybeForceBuilderInitialization();
                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);
                        maybeForceBuilderInitialization();
                    }
                    private void maybeForceBuilderInitialization() {
                        if (com.google.protobuf.GeneratedMessageV3
                                .alwaysUseFieldBuilders) {
                            getAddressFieldBuilder();
                        }
                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        as_ = 0;
                        address_ = null;
                        if (addressBuilder_ != null) {
                            addressBuilder_.dispose();
                            addressBuilder_ = null;
                        }
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_Aggregator_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator(this);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator result) {
                        int from_bitField0_ = bitField0_;
                        if (((from_bitField0_ & 0x00000001) != 0)) {
                            result.as_ = as_;
                        }
                        int to_bitField0_ = 0;
                        if (((from_bitField0_ & 0x00000002) != 0)) {
                            result.address_ = addressBuilder_ == null
                                    ? address_
                                    : addressBuilder_.build();
                            to_bitField0_ |= 0x00000001;
                        }
                        result.bitField0_ |= to_bitField0_;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator.getDefaultInstance()) return this;
                        if (other.getAs() != 0) {
                            setAs(other.getAs());
                        }
                        if (other.hasAddress()) {
                            mergeAddress(other.getAddress());
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 13: {
                                        as_ = input.readFixed32();
                                        bitField0_ |= 0x00000001;
                                        break;
                                    } // case 13
                                    case 18: {
                                        input.readMessage(
                                                getAddressFieldBuilder().getBuilder(),
                                                extensionRegistry);
                                        bitField0_ |= 0x00000002;
                                        break;
                                    } // case 18
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private int as_ ;
                    /**
                     * <code>fixed32 as = 1;</code>
                     * @return The as.
                     */
                    @java.lang.Override
                    public int getAs() {
                        return as_;
                    }
                    /**
                     * <code>fixed32 as = 1;</code>
                     * @param value The as to set.
                     * @return This builder for chaining.
                     */
                    public Builder setAs(int value) {

                        as_ = value;
                        bitField0_ |= 0x00000001;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>fixed32 as = 1;</code>
                     * @return This builder for chaining.
                     */
                    public Builder clearAs() {
                        bitField0_ = (bitField0_ & ~0x00000001);
                        as_ = 0;
                        onChanged();
                        return this;
                    }

                    private org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress address_;
                    private com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> addressBuilder_;
                    /**
                     * <code>.IpAddress address = 2;</code>
                     * @return Whether the address field is set.
                     */
                    public boolean hasAddress() {
                        return ((bitField0_ & 0x00000002) != 0);
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     * @return The address.
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getAddress() {
                        if (addressBuilder_ == null) {
                            return address_ == null ? org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                        } else {
                            return addressBuilder_.getMessage();
                        }
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public Builder setAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (addressBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            address_ = value;
                        } else {
                            addressBuilder_.setMessage(value);
                        }
                        bitField0_ |= 0x00000002;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public Builder setAddress(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                        if (addressBuilder_ == null) {
                            address_ = builderForValue.build();
                        } else {
                            addressBuilder_.setMessage(builderForValue.build());
                        }
                        bitField0_ |= 0x00000002;
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public Builder mergeAddress(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (addressBuilder_ == null) {
                            if (((bitField0_ & 0x00000002) != 0) &&
                                    address_ != null &&
                                    address_ != org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance()) {
                                getAddressBuilder().mergeFrom(value);
                            } else {
                                address_ = value;
                            }
                        } else {
                            addressBuilder_.mergeFrom(value);
                        }
                        if (address_ != null) {
                            bitField0_ |= 0x00000002;
                            onChanged();
                        }
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public Builder clearAddress() {
                        bitField0_ = (bitField0_ & ~0x00000002);
                        address_ = null;
                        if (addressBuilder_ != null) {
                            addressBuilder_.dispose();
                            addressBuilder_ = null;
                        }
                        onChanged();
                        return this;
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getAddressBuilder() {
                        bitField0_ |= 0x00000002;
                        onChanged();
                        return getAddressFieldBuilder().getBuilder();
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getAddressOrBuilder() {
                        if (addressBuilder_ != null) {
                            return addressBuilder_.getMessageOrBuilder();
                        } else {
                            return address_ == null ?
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance() : address_;
                        }
                    }
                    /**
                     * <code>.IpAddress address = 2;</code>
                     */
                    private com.google.protobuf.SingleFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                    getAddressFieldBuilder() {
                        if (addressBuilder_ == null) {
                            addressBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                                    getAddress(),
                                    getParentForChildren(),
                                    isClean());
                            address_ = null;
                        }
                        return addressBuilder_;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.Aggregator)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.Aggregator)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<Aggregator>
                        PARSER = new com.google.protobuf.AbstractParser<Aggregator>() {
                    @java.lang.Override
                    public Aggregator parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<Aggregator> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<Aggregator> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.Aggregator getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface ClusterListOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.ClusterList)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress>
                getClusterIdList();
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getClusterId(int index);
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                int getClusterIdCount();
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                getClusterIdOrBuilderList();
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getClusterIdOrBuilder(
                        int index);
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.ClusterList}
             */
            public static final class ClusterList extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.ClusterList)
                    ClusterListOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use ClusterList.newBuilder() to construct.
                private ClusterList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private ClusterList() {
                    clusterId_ = java.util.Collections.emptyList();
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new ClusterList();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ClusterList_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ClusterList_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.Builder.class);
                }

                public static final int CLUSTER_ID_FIELD_NUMBER = 1;
                @SuppressWarnings("serial")
                private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress> clusterId_;
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress> getClusterIdList() {
                    return clusterId_;
                }
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                getClusterIdOrBuilderList() {
                    return clusterId_;
                }
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                @java.lang.Override
                public int getClusterIdCount() {
                    return clusterId_.size();
                }
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getClusterId(int index) {
                    return clusterId_.get(index);
                }
                /**
                 * <code>repeated .IpAddress cluster_id = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getClusterIdOrBuilder(
                        int index) {
                    return clusterId_.get(index);
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    for (int i = 0; i < clusterId_.size(); i++) {
                        output.writeMessage(1, clusterId_.get(i));
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    for (int i = 0; i < clusterId_.size(); i++) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeMessageSize(1, clusterId_.get(i));
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList) obj;

                    if (!getClusterIdList()
                            .equals(other.getClusterIdList())) return false;
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    if (getClusterIdCount() > 0) {
                        hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
                        hash = (53 * hash) + getClusterIdList().hashCode();
                    }
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.ClusterList}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.ClusterList)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterListOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ClusterList_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ClusterList_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        if (clusterIdBuilder_ == null) {
                            clusterId_ = java.util.Collections.emptyList();
                        } else {
                            clusterId_ = null;
                            clusterIdBuilder_.clear();
                        }
                        bitField0_ = (bitField0_ & ~0x00000001);
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ClusterList_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList(this);
                        buildPartialRepeatedFields(result);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartialRepeatedFields(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList result) {
                        if (clusterIdBuilder_ == null) {
                            if (((bitField0_ & 0x00000001) != 0)) {
                                clusterId_ = java.util.Collections.unmodifiableList(clusterId_);
                                bitField0_ = (bitField0_ & ~0x00000001);
                            }
                            result.clusterId_ = clusterId_;
                        } else {
                            result.clusterId_ = clusterIdBuilder_.build();
                        }
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList result) {
                        int from_bitField0_ = bitField0_;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList.getDefaultInstance()) return this;
                        if (clusterIdBuilder_ == null) {
                            if (!other.clusterId_.isEmpty()) {
                                if (clusterId_.isEmpty()) {
                                    clusterId_ = other.clusterId_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                } else {
                                    ensureClusterIdIsMutable();
                                    clusterId_.addAll(other.clusterId_);
                                }
                                onChanged();
                            }
                        } else {
                            if (!other.clusterId_.isEmpty()) {
                                if (clusterIdBuilder_.isEmpty()) {
                                    clusterIdBuilder_.dispose();
                                    clusterIdBuilder_ = null;
                                    clusterId_ = other.clusterId_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                    clusterIdBuilder_ =
                                            com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                                    getClusterIdFieldBuilder() : null;
                                } else {
                                    clusterIdBuilder_.addAllMessages(other.clusterId_);
                                }
                            }
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 10: {
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress m =
                                                input.readMessage(
                                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.parser(),
                                                        extensionRegistry);
                                        if (clusterIdBuilder_ == null) {
                                            ensureClusterIdIsMutable();
                                            clusterId_.add(m);
                                        } else {
                                            clusterIdBuilder_.addMessage(m);
                                        }
                                        break;
                                    } // case 10
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress> clusterId_ =
                            java.util.Collections.emptyList();
                    private void ensureClusterIdIsMutable() {
                        if (!((bitField0_ & 0x00000001) != 0)) {
                            clusterId_ = new java.util.ArrayList<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress>(clusterId_);
                            bitField0_ |= 0x00000001;
                        }
                    }

                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder> clusterIdBuilder_;

                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress> getClusterIdList() {
                        if (clusterIdBuilder_ == null) {
                            return java.util.Collections.unmodifiableList(clusterId_);
                        } else {
                            return clusterIdBuilder_.getMessageList();
                        }
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public int getClusterIdCount() {
                        if (clusterIdBuilder_ == null) {
                            return clusterId_.size();
                        } else {
                            return clusterIdBuilder_.getCount();
                        }
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress getClusterId(int index) {
                        if (clusterIdBuilder_ == null) {
                            return clusterId_.get(index);
                        } else {
                            return clusterIdBuilder_.getMessage(index);
                        }
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder setClusterId(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (clusterIdBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureClusterIdIsMutable();
                            clusterId_.set(index, value);
                            onChanged();
                        } else {
                            clusterIdBuilder_.setMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder setClusterId(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                        if (clusterIdBuilder_ == null) {
                            ensureClusterIdIsMutable();
                            clusterId_.set(index, builderForValue.build());
                            onChanged();
                        } else {
                            clusterIdBuilder_.setMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder addClusterId(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (clusterIdBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureClusterIdIsMutable();
                            clusterId_.add(value);
                            onChanged();
                        } else {
                            clusterIdBuilder_.addMessage(value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder addClusterId(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress value) {
                        if (clusterIdBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureClusterIdIsMutable();
                            clusterId_.add(index, value);
                            onChanged();
                        } else {
                            clusterIdBuilder_.addMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder addClusterId(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                        if (clusterIdBuilder_ == null) {
                            ensureClusterIdIsMutable();
                            clusterId_.add(builderForValue.build());
                            onChanged();
                        } else {
                            clusterIdBuilder_.addMessage(builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder addClusterId(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder builderForValue) {
                        if (clusterIdBuilder_ == null) {
                            ensureClusterIdIsMutable();
                            clusterId_.add(index, builderForValue.build());
                            onChanged();
                        } else {
                            clusterIdBuilder_.addMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder addAllClusterId(
                            java.lang.Iterable<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress> values) {
                        if (clusterIdBuilder_ == null) {
                            ensureClusterIdIsMutable();
                            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                                    values, clusterId_);
                            onChanged();
                        } else {
                            clusterIdBuilder_.addAllMessages(values);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder clearClusterId() {
                        if (clusterIdBuilder_ == null) {
                            clusterId_ = java.util.Collections.emptyList();
                            bitField0_ = (bitField0_ & ~0x00000001);
                            onChanged();
                        } else {
                            clusterIdBuilder_.clear();
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public Builder removeClusterId(int index) {
                        if (clusterIdBuilder_ == null) {
                            ensureClusterIdIsMutable();
                            clusterId_.remove(index);
                            onChanged();
                        } else {
                            clusterIdBuilder_.remove(index);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder getClusterIdBuilder(
                            int index) {
                        return getClusterIdFieldBuilder().getBuilder(index);
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder getClusterIdOrBuilder(
                            int index) {
                        if (clusterIdBuilder_ == null) {
                            return clusterId_.get(index);  } else {
                            return clusterIdBuilder_.getMessageOrBuilder(index);
                        }
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                    getClusterIdOrBuilderList() {
                        if (clusterIdBuilder_ != null) {
                            return clusterIdBuilder_.getMessageOrBuilderList();
                        } else {
                            return java.util.Collections.unmodifiableList(clusterId_);
                        }
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder addClusterIdBuilder() {
                        return getClusterIdFieldBuilder().addBuilder(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder addClusterIdBuilder(
                            int index) {
                        return getClusterIdFieldBuilder().addBuilder(
                                index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .IpAddress cluster_id = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder>
                    getClusterIdBuilderList() {
                        return getClusterIdFieldBuilder().getBuilderList();
                    }
                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>
                    getClusterIdFieldBuilder() {
                        if (clusterIdBuilder_ == null) {
                            clusterIdBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddress.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.IpAddressOrBuilder>(
                                    clusterId_,
                                    ((bitField0_ & 0x00000001) != 0),
                                    getParentForChildren(),
                                    isClean());
                            clusterId_ = null;
                        }
                        return clusterIdBuilder_;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.ClusterList)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.ClusterList)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<ClusterList>
                        PARSER = new com.google.protobuf.AbstractParser<ClusterList>() {
                    @java.lang.Override
                    public ClusterList parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<ClusterList> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<ClusterList> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ClusterList getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface ExtendedCommunitiesOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.ExtendedCommunities)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity>
                getExtendedCommunitiesList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity getExtendedCommunities(int index);
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                int getExtendedCommunitiesCount();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>
                getExtendedCommunitiesOrBuilderList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder getExtendedCommunitiesOrBuilder(
                        int index);
            }
            /**
             * Protobuf type {@code RouteMonitoringPacket.PathAttribute.ExtendedCommunities}
             */
            public static final class ExtendedCommunities extends
                    com.google.protobuf.GeneratedMessageV3 implements
                    // @@protoc_insertion_point(message_implements:RouteMonitoringPacket.PathAttribute.ExtendedCommunities)
                    ExtendedCommunitiesOrBuilder {
                private static final long serialVersionUID = 0L;
                // Use ExtendedCommunities.newBuilder() to construct.
                private ExtendedCommunities(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }
                private ExtendedCommunities() {
                    extendedCommunities_ = java.util.Collections.emptyList();
                }

                @java.lang.Override
                @SuppressWarnings({"unused"})
                protected java.lang.Object newInstance(
                        UnusedPrivateParameter unused) {
                    return new ExtendedCommunities();
                }

                public static final com.google.protobuf.Descriptors.Descriptor
                getDescriptor() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ExtendedCommunities_descriptor;
                }

                @java.lang.Override
                protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
                    return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ExtendedCommunities_fieldAccessorTable
                            .ensureFieldAccessorsInitialized(
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.Builder.class);
                }

                public static final int EXTENDED_COMMUNITIES_FIELD_NUMBER = 1;
                @SuppressWarnings("serial")
                private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity> extendedCommunities_;
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity> getExtendedCommunitiesList() {
                    return extendedCommunities_;
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                @java.lang.Override
                public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>
                getExtendedCommunitiesOrBuilderList() {
                    return extendedCommunities_;
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                @java.lang.Override
                public int getExtendedCommunitiesCount() {
                    return extendedCommunities_.size();
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity getExtendedCommunities(int index) {
                    return extendedCommunities_.get(index);
                }
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder getExtendedCommunitiesOrBuilder(
                        int index) {
                    return extendedCommunities_.get(index);
                }

                private byte memoizedIsInitialized = -1;
                @java.lang.Override
                public final boolean isInitialized() {
                    byte isInitialized = memoizedIsInitialized;
                    if (isInitialized == 1) return true;
                    if (isInitialized == 0) return false;

                    memoizedIsInitialized = 1;
                    return true;
                }

                @java.lang.Override
                public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
                    for (int i = 0; i < extendedCommunities_.size(); i++) {
                        output.writeMessage(1, extendedCommunities_.get(i));
                    }
                    getUnknownFields().writeTo(output);
                }

                @java.lang.Override
                public int getSerializedSize() {
                    int size = memoizedSize;
                    if (size != -1) return size;

                    size = 0;
                    for (int i = 0; i < extendedCommunities_.size(); i++) {
                        size += com.google.protobuf.CodedOutputStream
                                .computeMessageSize(1, extendedCommunities_.get(i));
                    }
                    size += getUnknownFields().getSerializedSize();
                    memoizedSize = size;
                    return size;
                }

                @java.lang.Override
                public boolean equals(final java.lang.Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities)) {
                        return super.equals(obj);
                    }
                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities other = (org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities) obj;

                    if (!getExtendedCommunitiesList()
                            .equals(other.getExtendedCommunitiesList())) return false;
                    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
                    return true;
                }

                @java.lang.Override
                public int hashCode() {
                    if (memoizedHashCode != 0) {
                        return memoizedHashCode;
                    }
                    int hash = 41;
                    hash = (19 * hash) + getDescriptor().hashCode();
                    if (getExtendedCommunitiesCount() > 0) {
                        hash = (37 * hash) + EXTENDED_COMMUNITIES_FIELD_NUMBER;
                        hash = (53 * hash) + getExtendedCommunitiesList().hashCode();
                    }
                    hash = (29 * hash) + getUnknownFields().hashCode();
                    memoizedHashCode = hash;
                    return hash;
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        java.nio.ByteBuffer data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        java.nio.ByteBuffer data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        com.google.protobuf.ByteString data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        com.google.protobuf.ByteString data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(byte[] data)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        byte[] data,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws com.google.protobuf.InvalidProtocolBufferException {
                    return PARSER.parseFrom(data, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseDelimitedFrom(java.io.InputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input);
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseDelimitedFrom(
                        java.io.InputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        com.google.protobuf.CodedInputStream input)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input);
                }
                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities parseFrom(
                        com.google.protobuf.CodedInputStream input,
                        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                        throws java.io.IOException {
                    return com.google.protobuf.GeneratedMessageV3
                            .parseWithIOException(PARSER, input, extensionRegistry);
                }

                @java.lang.Override
                public Builder newBuilderForType() { return newBuilder(); }
                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }
                public static Builder newBuilder(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }
                @java.lang.Override
                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE
                            ? new Builder() : new Builder().mergeFrom(this);
                }

                @java.lang.Override
                protected Builder newBuilderForType(
                        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }
                /**
                 * Protobuf type {@code RouteMonitoringPacket.PathAttribute.ExtendedCommunities}
                 */
                public static final class Builder extends
                        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                        // @@protoc_insertion_point(builder_implements:RouteMonitoringPacket.PathAttribute.ExtendedCommunities)
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunitiesOrBuilder {
                    public static final com.google.protobuf.Descriptors.Descriptor
                    getDescriptor() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ExtendedCommunities_descriptor;
                    }

                    @java.lang.Override
                    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                    internalGetFieldAccessorTable() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ExtendedCommunities_fieldAccessorTable
                                .ensureFieldAccessorsInitialized(
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.class, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.Builder.class);
                    }

                    // Construct using org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.newBuilder()
                    private Builder() {

                    }

                    private Builder(
                            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                        super(parent);

                    }
                    @java.lang.Override
                    public Builder clear() {
                        super.clear();
                        bitField0_ = 0;
                        if (extendedCommunitiesBuilder_ == null) {
                            extendedCommunities_ = java.util.Collections.emptyList();
                        } else {
                            extendedCommunities_ = null;
                            extendedCommunitiesBuilder_.clear();
                        }
                        bitField0_ = (bitField0_ & ~0x00000001);
                        return this;
                    }

                    @java.lang.Override
                    public com.google.protobuf.Descriptors.Descriptor
                    getDescriptorForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.internal_static_RouteMonitoringPacket_PathAttribute_ExtendedCommunities_descriptor;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities getDefaultInstanceForType() {
                        return org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.getDefaultInstance();
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities build() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities result = buildPartial();
                        if (!result.isInitialized()) {
                            throw newUninitializedMessageException(result);
                        }
                        return result;
                    }

                    @java.lang.Override
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities buildPartial() {
                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities result = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities(this);
                        buildPartialRepeatedFields(result);
                        if (bitField0_ != 0) { buildPartial0(result); }
                        onBuilt();
                        return result;
                    }

                    private void buildPartialRepeatedFields(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities result) {
                        if (extendedCommunitiesBuilder_ == null) {
                            if (((bitField0_ & 0x00000001) != 0)) {
                                extendedCommunities_ = java.util.Collections.unmodifiableList(extendedCommunities_);
                                bitField0_ = (bitField0_ & ~0x00000001);
                            }
                            result.extendedCommunities_ = extendedCommunities_;
                        } else {
                            result.extendedCommunities_ = extendedCommunitiesBuilder_.build();
                        }
                    }

                    private void buildPartial0(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities result) {
                        int from_bitField0_ = bitField0_;
                    }

                    @java.lang.Override
                    public Builder clone() {
                        return super.clone();
                    }
                    @java.lang.Override
                    public Builder setField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.setField(field, value);
                    }
                    @java.lang.Override
                    public Builder clearField(
                            com.google.protobuf.Descriptors.FieldDescriptor field) {
                        return super.clearField(field);
                    }
                    @java.lang.Override
                    public Builder clearOneof(
                            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                        return super.clearOneof(oneof);
                    }
                    @java.lang.Override
                    public Builder setRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            int index, java.lang.Object value) {
                        return super.setRepeatedField(field, index, value);
                    }
                    @java.lang.Override
                    public Builder addRepeatedField(
                            com.google.protobuf.Descriptors.FieldDescriptor field,
                            java.lang.Object value) {
                        return super.addRepeatedField(field, value);
                    }
                    @java.lang.Override
                    public Builder mergeFrom(com.google.protobuf.Message other) {
                        if (other instanceof org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities) {
                            return mergeFrom((org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities)other);
                        } else {
                            super.mergeFrom(other);
                            return this;
                        }
                    }

                    public Builder mergeFrom(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities other) {
                        if (other == org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.getDefaultInstance()) return this;
                        if (extendedCommunitiesBuilder_ == null) {
                            if (!other.extendedCommunities_.isEmpty()) {
                                if (extendedCommunities_.isEmpty()) {
                                    extendedCommunities_ = other.extendedCommunities_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                } else {
                                    ensureExtendedCommunitiesIsMutable();
                                    extendedCommunities_.addAll(other.extendedCommunities_);
                                }
                                onChanged();
                            }
                        } else {
                            if (!other.extendedCommunities_.isEmpty()) {
                                if (extendedCommunitiesBuilder_.isEmpty()) {
                                    extendedCommunitiesBuilder_.dispose();
                                    extendedCommunitiesBuilder_ = null;
                                    extendedCommunities_ = other.extendedCommunities_;
                                    bitField0_ = (bitField0_ & ~0x00000001);
                                    extendedCommunitiesBuilder_ =
                                            com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                                    getExtendedCommunitiesFieldBuilder() : null;
                                } else {
                                    extendedCommunitiesBuilder_.addAllMessages(other.extendedCommunities_);
                                }
                            }
                        }
                        this.mergeUnknownFields(other.getUnknownFields());
                        onChanged();
                        return this;
                    }

                    @java.lang.Override
                    public final boolean isInitialized() {
                        return true;
                    }

                    @java.lang.Override
                    public Builder mergeFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws java.io.IOException {
                        if (extensionRegistry == null) {
                            throw new java.lang.NullPointerException();
                        }
                        try {
                            boolean done = false;
                            while (!done) {
                                int tag = input.readTag();
                                switch (tag) {
                                    case 0:
                                        done = true;
                                        break;
                                    case 10: {
                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity m =
                                                input.readMessage(
                                                        org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.parser(),
                                                        extensionRegistry);
                                        if (extendedCommunitiesBuilder_ == null) {
                                            ensureExtendedCommunitiesIsMutable();
                                            extendedCommunities_.add(m);
                                        } else {
                                            extendedCommunitiesBuilder_.addMessage(m);
                                        }
                                        break;
                                    } // case 10
                                    default: {
                                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                                            done = true; // was an endgroup tag
                                        }
                                        break;
                                    } // default:
                                } // switch (tag)
                            } // while (!done)
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.unwrapIOException();
                        } finally {
                            onChanged();
                        } // finally
                        return this;
                    }
                    private int bitField0_;

                    private java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity> extendedCommunities_ =
                            java.util.Collections.emptyList();
                    private void ensureExtendedCommunitiesIsMutable() {
                        if (!((bitField0_ & 0x00000001) != 0)) {
                            extendedCommunities_ = new java.util.ArrayList<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity>(extendedCommunities_);
                            bitField0_ |= 0x00000001;
                        }
                    }

                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder> extendedCommunitiesBuilder_;

                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity> getExtendedCommunitiesList() {
                        if (extendedCommunitiesBuilder_ == null) {
                            return java.util.Collections.unmodifiableList(extendedCommunities_);
                        } else {
                            return extendedCommunitiesBuilder_.getMessageList();
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public int getExtendedCommunitiesCount() {
                        if (extendedCommunitiesBuilder_ == null) {
                            return extendedCommunities_.size();
                        } else {
                            return extendedCommunitiesBuilder_.getCount();
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity getExtendedCommunities(int index) {
                        if (extendedCommunitiesBuilder_ == null) {
                            return extendedCommunities_.get(index);
                        } else {
                            return extendedCommunitiesBuilder_.getMessage(index);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder setExtendedCommunities(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity value) {
                        if (extendedCommunitiesBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.set(index, value);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.setMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder setExtendedCommunities(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder builderForValue) {
                        if (extendedCommunitiesBuilder_ == null) {
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.set(index, builderForValue.build());
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.setMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder addExtendedCommunities(org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity value) {
                        if (extendedCommunitiesBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.add(value);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.addMessage(value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder addExtendedCommunities(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity value) {
                        if (extendedCommunitiesBuilder_ == null) {
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.add(index, value);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.addMessage(index, value);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder addExtendedCommunities(
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder builderForValue) {
                        if (extendedCommunitiesBuilder_ == null) {
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.add(builderForValue.build());
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.addMessage(builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder addExtendedCommunities(
                            int index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder builderForValue) {
                        if (extendedCommunitiesBuilder_ == null) {
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.add(index, builderForValue.build());
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.addMessage(index, builderForValue.build());
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder addAllExtendedCommunities(
                            java.lang.Iterable<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity> values) {
                        if (extendedCommunitiesBuilder_ == null) {
                            ensureExtendedCommunitiesIsMutable();
                            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                                    values, extendedCommunities_);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.addAllMessages(values);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder clearExtendedCommunities() {
                        if (extendedCommunitiesBuilder_ == null) {
                            extendedCommunities_ = java.util.Collections.emptyList();
                            bitField0_ = (bitField0_ & ~0x00000001);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.clear();
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public Builder removeExtendedCommunities(int index) {
                        if (extendedCommunitiesBuilder_ == null) {
                            ensureExtendedCommunitiesIsMutable();
                            extendedCommunities_.remove(index);
                            onChanged();
                        } else {
                            extendedCommunitiesBuilder_.remove(index);
                        }
                        return this;
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder getExtendedCommunitiesBuilder(
                            int index) {
                        return getExtendedCommunitiesFieldBuilder().getBuilder(index);
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder getExtendedCommunitiesOrBuilder(
                            int index) {
                        if (extendedCommunitiesBuilder_ == null) {
                            return extendedCommunities_.get(index);  } else {
                            return extendedCommunitiesBuilder_.getMessageOrBuilder(index);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>
                    getExtendedCommunitiesOrBuilderList() {
                        if (extendedCommunitiesBuilder_ != null) {
                            return extendedCommunitiesBuilder_.getMessageOrBuilderList();
                        } else {
                            return java.util.Collections.unmodifiableList(extendedCommunities_);
                        }
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder addExtendedCommunitiesBuilder() {
                        return getExtendedCommunitiesFieldBuilder().addBuilder(
                                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder addExtendedCommunitiesBuilder(
                            int index) {
                        return getExtendedCommunitiesFieldBuilder().addBuilder(
                                index, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.getDefaultInstance());
                    }
                    /**
                     * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                     */
                    public java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder>
                    getExtendedCommunitiesBuilderList() {
                        return getExtendedCommunitiesFieldBuilder().getBuilderList();
                    }
                    private com.google.protobuf.RepeatedFieldBuilderV3<
                            org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>
                    getExtendedCommunitiesFieldBuilder() {
                        if (extendedCommunitiesBuilder_ == null) {
                            extendedCommunitiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                                    org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder, org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>(
                                    extendedCommunities_,
                                    ((bitField0_ & 0x00000001) != 0),
                                    getParentForChildren(),
                                    isClean());
                            extendedCommunities_ = null;
                        }
                        return extendedCommunitiesBuilder_;
                    }
                    @java.lang.Override
                    public final Builder setUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.setUnknownFields(unknownFields);
                    }

                    @java.lang.Override
                    public final Builder mergeUnknownFields(
                            final com.google.protobuf.UnknownFieldSet unknownFields) {
                        return super.mergeUnknownFields(unknownFields);
                    }


                    // @@protoc_insertion_point(builder_scope:RouteMonitoringPacket.PathAttribute.ExtendedCommunities)
                }

                // @@protoc_insertion_point(class_scope:RouteMonitoringPacket.PathAttribute.ExtendedCommunities)
                private static final org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities DEFAULT_INSTANCE;
                static {
                    DEFAULT_INSTANCE = new org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities();
                }

                public static org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                private static final com.google.protobuf.Parser<ExtendedCommunities>
                        PARSER = new com.google.protobuf.AbstractParser<ExtendedCommunities>() {
                    @java.lang.Override
                    public ExtendedCommunities parsePartialFrom(
                            com.google.protobuf.CodedInputStream input,
                            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                            throws com.google.protobuf.InvalidProtocolBufferException {
                        Builder builder = newBuilder();
                        try {
                            builder.mergeFrom(input, extensionRegistry);
                        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                            throw e.setUnfinishedMessage(builder.buildPartial());
                        } catch (com.google.protobuf.UninitializedMessageException e) {
                            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                        } catch (java.io.IOException e) {
                            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                                    .setUnfinishedMessage(builder.buildPartial());
                        }
                        return builder.buildPartial();
                    }
                };

                public static com.google.protobuf.Parser<ExtendedCommunities> parser() {
                    return PARSER;
                }

                @java.lang.Override
                public com.google.protobuf.Parser<ExtendedCommunities> getParserForType() {
                    return PARSER;
                }

                @java.lang.Override
                public org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

            }

            public interface ExtendedV6CommunitiesOrBuilder extends
                    // @@protoc_insertion_point(interface_extends:RouteMonitoringPacket.PathAttribute.ExtendedV6Communities)
                    com.google.protobuf.MessageOrBuilder {

                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                java.util.List<org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity>
                getExtendedCommunitiesList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity getExtendedCommunities(int index);
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                int getExtendedCommunitiesCount();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                java.util.List<? extends org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder>
                getExtendedCommunitiesOrBuilderList();
                /**
                 * <code>repeated .RouteMonitoringPacket.PathAttribute.ExtendedCommunity extended_communities = 1;</code>
                 */
                org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunityOrBuilder getExtendedCommunitiesOrBuilder(
                        int index);
            }
 