/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdDefVisitor;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

public abstract class BaseThresholdDefConfigWrapper {
    Basethresholddef m_baseDef;

    protected BaseThresholdDefConfigWrapper(Basethresholddef baseDef) {
        this.m_baseDef = baseDef;
    }

    public static BaseThresholdDefConfigWrapper getConfigWrapper(Basethresholddef baseDef) throws ThresholdExpressionException {
        if (baseDef instanceof Threshold) {
            return new ThresholdConfigWrapper((Threshold)baseDef);
        }
        if (baseDef instanceof Expression) {
            return new ExpressionConfigWrapper((Expression)baseDef);
        }
        return null;
    }

    public abstract String getDatasourceExpression();

    public abstract Collection<String> getRequiredDatasources();

    public String getDsType() {
        return this.m_baseDef.getDsType();
    }

    public Optional<String> getDsLabel() {
        return this.m_baseDef.getDsLabel();
    }

    public Double getRearm() {
        return StringUtils.parseDouble((String)this.m_baseDef.getRearm(), null);
    }

    public String getRearmString() {
        return this.m_baseDef.getRearm();
    }

    public Integer getTrigger() {
        return StringUtils.parseInt((String)this.m_baseDef.getTrigger(), null);
    }

    public String getTriggerString() {
        return this.m_baseDef.getTrigger();
    }

    public ThresholdType getType() {
        return this.m_baseDef.getType();
    }

    public Double getValue() {
        return StringUtils.parseDouble((String)this.m_baseDef.getValue(), null);
    }

    public String getValueString() {
        return this.m_baseDef.getValue();
    }

    public boolean hasRearm() {
        return this.m_baseDef.getRearm() != null;
    }

    public boolean hasTrigger() {
        return this.m_baseDef.getTrigger() != null;
    }

    public boolean hasValue() {
        return this.m_baseDef.getValue() != null;
    }

    public Optional<String> getTriggeredUEI() {
        return this.m_baseDef.getTriggeredUEI();
    }

    public Optional<String> getRearmedUEI() {
        return this.m_baseDef.getRearmedUEI();
    }

    public Basethresholddef getBasethresholddef() {
        return this.m_baseDef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseThresholdDefConfigWrapper) {
            BaseThresholdDefConfigWrapper that = (BaseThresholdDefConfigWrapper)obj;
            return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getDsType(), that.getDsType()) && Objects.equals(this.getDatasourceExpression(), that.getDatasourceExpression()) && Objects.equals(this.getDsLabel(), that.getDsLabel()) && Objects.equals(this.getTriggeredUEI(), that.getTriggeredUEI()) && Objects.equals(this.getRearmedUEI(), that.getRearmedUEI()) && Objects.equals(this.getValueString(), that.getValueString()) && Objects.equals(this.getRearmString(), that.getRearmString()) && Objects.equals(this.getTriggerString(), that.getTriggerString()) && Objects.equals(this.getBasethresholddef().getFilterOperator(), that.getBasethresholddef().getFilterOperator()) && Objects.equals(this.getBasethresholddef().getRelaxed(), that.getBasethresholddef().getRelaxed()) && Objects.equals(this.getBasethresholddef().getResourceFilters(), that.getBasethresholddef().getResourceFilters());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_baseDef);
    }

    public void merge(BaseThresholdDefConfigWrapper threshold) {
        this.m_baseDef = threshold.getBasethresholddef();
    }

    public abstract void accept(ThresholdDefVisitor var1);

    public ThresholdEvaluatorState.ThresholdValues interpolateThresholdValues(Scope scope) {
        Double thresholdValue = this.interpolateDoubleValue(this.getValueString(), scope).orElse(this.getValue());
        Double rearm = this.interpolateDoubleValue(this.getRearmString(), scope).orElse(this.getRearm());
        Integer trigger = this.interpolateIntegerValue(this.getTriggerString(), scope).orElse(this.getTrigger());
        return new ThresholdEvaluatorState.ThresholdValues(thresholdValue, rearm, trigger);
    }

    private Optional<Double> interpolateDoubleValue(String value, Scope scope) {
        String interpolatedValue = Interpolator.interpolate((String)value, (Scope)scope).output;
        return Optional.ofNullable(StringUtils.parseDouble((String)interpolatedValue, null));
    }

    private Optional<Integer> interpolateIntegerValue(String value, Scope scope) {
        String interpolatedValue = Interpolator.interpolate((String)value, (Scope)scope).output;
        return Optional.ofNullable(StringUtils.parseInt((String)interpolatedValue, null));
    }
}

