/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.RowSortedTable;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.filters.impl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterInfo(name="Trend", description="Fits a trend line or polynomial to a given column.")
public class TrendLine
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TrendLine.class);
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="outputColumn", required=true, displayName="Output", description="Output column.")
    private String m_outputColumn;
    @FilterParam(key="secondsAhead", value="0", displayName="Forecast", description="Number seconds ahead the of the column for which we want to include the trend line.")
    private long m_secondsAhead;
    @FilterParam(key="polynomialOrder", value="1", displayName="Order", description="Polynomial order of the trend line/curve. Set this to 1 for a line.")
    private int m_polynomialOrder;

    protected TrendLine() {
    }

    public TrendLine(String outputColumn, String inputColumn, long secondsAhead, int polynomialOrder) {
        this.m_outputColumn = outputColumn;
        this.m_inputColumn = inputColumn;
        this.m_secondsAhead = secondsAhead;
        this.m_polynomialOrder = polynomialOrder;
    }

    public void filter(RowSortedTable<Long, String, Double> table) throws RScriptException {
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"timestamp"), (Object)String.format("Data source must have a '%s' column.", "timestamp"));
        Utils.TableLimits limits = Utils.getRowsWithValues(table, new String[]{this.m_inputColumn});
        long numSampleRows = limits.lastRowWithValues - limits.firstRowWithValues;
        if (numSampleRows < 1L) {
            LOG.error("Insufficient values in column for trending. Excluding trend from data source.");
            return;
        }
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (long i = limits.firstRowWithValues; i < limits.lastRowWithValues; ++i) {
            obs.add(((Double)table.get((Object)i, (Object)"timestamp")).doubleValue(), ((Double)table.get((Object)i, (Object)this.m_inputColumn)).doubleValue());
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)this.m_polynomialOrder);
        double[] coeff = fitter.fit((Collection)obs.toList());
        PolynomialFunction polynomialFunction = new PolynomialFunction(coeff);
        Date lastTimestamp = new Date(((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp") - (Double)table.get((Object)(limits.lastRowWithValues - 1L), (Object)"timestamp"));
        int numStepsAhead = (int)Math.floor((double)this.m_secondsAhead * 1000.0 / (double)stepInMs);
        numStepsAhead = Math.max(1, numStepsAhead);
        for (long i = limits.firstRowWithValues; i <= limits.lastRowWithValues + (long)numStepsAhead; ++i) {
            if (i >= limits.lastRowWithValues) {
                table.put((Object)i, (Object)"timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * (i - limits.lastRowWithValues)).getTime());
            }
            Double timestamp = (Double)table.get((Object)i, (Object)"timestamp");
            table.put((Object)i, (Object)this.m_outputColumn, (Object)polynomialFunction.value(timestamp.doubleValue()));
        }
    }
}

