/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.RowSortedTable;
import java.util.Date;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.filters.impl.Utils;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecaster;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecasterParams;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalityType;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersTrainingMethod;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.PointForecast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterInfo(name="HoltWinters", description="Performs Holt-Winters forecasting.")
public class HWForecast
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HWForecast.class);
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="outputPrefix", value="HW", displayName="Output", description="Output prefix.")
    private String m_outputPrefix;
    @FilterParam(key="numPeriodsToForecast", value="3", displayName="# Periods", description="Number of periods to forecast.")
    private int m_numPeriodsToForecast;
    @FilterParam(key="periodInSeconds", required=true, displayName="Period", description="Size of a period in seconds.")
    private long m_periodInSeconds;

    protected HWForecast() {
    }

    public HWForecast(String outputPrefix, String inputColumn, int numPeriodsToForecast, long periodInSeconds) {
        this.m_outputPrefix = outputPrefix;
        this.m_inputColumn = inputColumn;
        this.m_numPeriodsToForecast = numPeriodsToForecast;
        this.m_periodInSeconds = periodInSeconds;
    }

    public void filter(RowSortedTable<Long, String, Double> table) {
        long i;
        Preconditions.checkArgument((boolean)table.containsColumn((Object)"timestamp"), (Object)String.format("Data source must have a '%s' column.", "timestamp"));
        Utils.TableLimits limits = Utils.getRowsWithValues(table, new String[]{this.m_inputColumn});
        long numSampleRows = limits.lastRowWithValues - limits.firstRowWithValues;
        if (numSampleRows < 1L) {
            LOG.error("Insufficient values in column for forecasting. Excluding forecast columns from data source.");
            return;
        }
        Date lastTimestamp = new Date(((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp")).longValue());
        long stepInMs = (long)((Double)table.get((Object)limits.lastRowWithValues, (Object)"timestamp") - (Double)table.get((Object)(limits.lastRowWithValues - 1L), (Object)"timestamp"));
        int numSamplesPerPeriod = (int)Math.floor((double)this.m_periodInSeconds * 1000.0 / (double)stepInMs);
        numSamplesPerPeriod = Math.max(1, numSamplesPerPeriod);
        int numForecasts = numSamplesPerPeriod * this.m_numPeriodsToForecast;
        HoltWintersPointForecasterParams params = new HoltWintersPointForecasterParams().setFrequency(numSamplesPerPeriod).setAlpha(0.5).setBeta(0.03).setGamma(0.002).setSeasonalityType(HoltWintersSeasonalityType.MULTIPLICATIVE).setWarmUpPeriod(numSamplesPerPeriod).setInitTrainingMethod(HoltWintersTrainingMethod.SIMPLE);
        HoltWintersPointForecaster subject = new HoltWintersPointForecaster(params);
        long firstIndexForTraining = Math.max(limits.firstRowWithValues, limits.lastRowWithValues - (long)numSamplesPerPeriod * 2L);
        double lastValue = Double.NaN;
        for (i = firstIndexForTraining; i < limits.lastRowWithValues; ++i) {
            lastValue = (Double)table.get((Object)i, (Object)this.m_inputColumn);
            subject.forecast(lastValue);
        }
        for (i = limits.lastRowWithValues + 1L; i <= limits.lastRowWithValues + (long)numForecasts; ++i) {
            PointForecast forecast = subject.forecast(lastValue);
            long idxForecast = i - limits.lastRowWithValues;
            table.put((Object)i, (Object)(this.m_outputPrefix + "Fit"), (Object)forecast.getValue());
            table.put((Object)i, (Object)"timestamp", (Object)new Date(lastTimestamp.getTime() + stepInMs * idxForecast).getTime());
            lastValue = forecast.getValue();
        }
    }

    public static void checkForecastSupport() {
    }
}

