/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import java.util.Optional;

public class AsnInfo {
    private Long asn;
    private String asName;
    private String orgId;
    private String orgName;
    private String address;
    private String city;
    private String stateProv;
    private String postalCode;
    private String country;
    private String source;
    private String rawOutput;
    private String remarks;

    public AsnInfo(Long asn, String source, String rawOutput) {
        this.asn = asn;
        this.source = source;
        this.rawOutput = rawOutput;
    }

    public Long getAsn() {
        return this.asn;
    }

    public void setAsn(Long asn) {
        this.asn = asn;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setAsName(String asName) {
        this.asName = asName;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStateProv() {
        return this.stateProv;
    }

    public void setStateProv(String stateProv) {
        this.stateProv = stateProv;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRawOutput() {
        return this.rawOutput;
    }

    public void setRawOutput(String rawOutput) {
        this.rawOutput = rawOutput;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public static AsnInfo parseOutput(Long asn, String source, String rawOutput) {
        String[] lines;
        AsnInfo asnInfo = new AsnInfo(asn, source, rawOutput);
        Object remarks = "";
        Object address = "";
        Object orgId = "";
        for (String line : lines = rawOutput.split("\\r?\\n")) {
            Optional<String> result;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    if (line.contains("ASName")) break block15;
                                    if (!line.contains("as-name")) break block16;
                                }
                                AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setAsName);
                                continue;
                            }
                            if (line.contains("OrgName")) break block17;
                            if (!line.contains("org-name")) break block18;
                        }
                        AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setOrgName);
                        continue;
                    }
                    if (line.contains("OrgId") || line.contains("org")) {
                        result = AsnInfo.getSubStringAfterColon(line);
                        if (!result.isPresent()) continue;
                        orgId = (String)orgId + result.get() + " ";
                        asnInfo.setOrgId((String)orgId);
                        continue;
                    }
                    if (line.contains("Address") || line.contains("address")) {
                        result = AsnInfo.getSubStringAfterColon(line);
                        if (!result.isPresent()) continue;
                        address = (String)address + result.get() + " ";
                        asnInfo.setAddress((String)address);
                        continue;
                    }
                    if (line.contains("City")) {
                        AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setCity);
                        continue;
                    }
                    if (line.contains("StateProv")) {
                        AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setStateProv);
                        continue;
                    }
                    if (line.contains("PostalCode")) {
                        AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setPostalCode);
                        continue;
                    }
                    if (line.contains("Country")) break block19;
                    if (!line.contains("country")) break block20;
                }
                AsnInfo.getSubStringAfterColon(line).ifPresent(asnInfo::setCountry);
                continue;
            }
            if (!line.contains("remarks") && !line.contains("Comment") && !line.contains("descr") || !(result = AsnInfo.getSubStringAfterColon(line)).isPresent()) continue;
            remarks = (String)remarks + result.get() + " ";
            asnInfo.setRemarks((String)remarks);
        }
        return asnInfo;
    }

    private static Optional<String> getSubStringAfterColon(String segment) {
        int index = segment.indexOf(":");
        if (index > 0) {
            String value = segment.substring(index + 1);
            return Optional.of(value.trim());
        }
        return Optional.empty();
    }
}

