/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.core.Port;
import rpc.core.PresentationResult;

public class BindAcknowledgePdu
extends ConnectionOrientedPdu {
    public static final int BIND_ACKNOWLEDGE_TYPE = 12;
    private PresentationResult[] resultList;
    private int maxTransmitFragment = 7160;
    private int maxReceiveFragment = 7160;
    private int associationGroupId = 0;
    private Port secondaryAddress;

    @Override
    public int getType() {
        return 12;
    }

    public int getMaxTransmitFragment() {
        return this.maxTransmitFragment;
    }

    public void setMaxTransmitFragment(int maxTransmitFragment) {
        this.maxTransmitFragment = maxTransmitFragment;
    }

    public int getMaxReceiveFragment() {
        return this.maxReceiveFragment;
    }

    public void setMaxReceiveFragment(int maxReceiveFragment) {
        this.maxReceiveFragment = maxReceiveFragment;
    }

    public int getAssociationGroupId() {
        return this.associationGroupId;
    }

    public void setAssociationGroupId(int associationGroupId) {
        this.associationGroupId = associationGroupId;
    }

    public Port getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public void setSecondaryAddress(Port secondaryAddress) {
        this.secondaryAddress = secondaryAddress;
    }

    public PresentationResult[] getResultList() {
        return this.resultList;
    }

    public void setResultList(PresentationResult[] resultList) {
        this.resultList = resultList;
    }

    @Override
    protected void readBody(NetworkDataRepresentation ndr) {
        this.setMaxTransmitFragment(ndr.readUnsignedShort());
        this.setMaxReceiveFragment(ndr.readUnsignedShort());
        this.setAssociationGroupId(ndr.readUnsignedLong());
        Port secondaryAddress = new Port();
        secondaryAddress.read(ndr);
        this.setSecondaryAddress(secondaryAddress);
        ndr.getBuffer().align(4);
        int count = ndr.readUnsignedSmall();
        PresentationResult[] resultList = new PresentationResult[count];
        for (int i = 0; i < count; ++i) {
            resultList[i] = new PresentationResult();
            resultList[i].read(ndr);
        }
        this.setResultList(resultList);
    }

    @Override
    protected void writeBody(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort(this.getMaxTransmitFragment());
        ndr.writeUnsignedShort(this.getMaxReceiveFragment());
        ndr.writeUnsignedLong(this.getAssociationGroupId());
        Port secondaryAddress = this.getSecondaryAddress();
        if (secondaryAddress == null) {
            secondaryAddress = new Port();
        }
        secondaryAddress.write(ndr);
        ndr.getBuffer().align(4);
        PresentationResult[] resultList = this.getResultList();
        int count = resultList.length;
        ndr.writeUnsignedSmall((short)count);
        for (int i = 0; i < count; ++i) {
            resultList[i].write(ndr);
        }
    }
}

