/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.util.SAMLUtil;
import org.w3c.dom.Node;

public class SAMLDefaultLogger
implements SAMLLogger {
    private static final Logger log = LoggerFactory.getLogger(SAMLDefaultLogger.class);
    private boolean logMessagesOnException = false;
    private boolean logAllMessages = false;
    private boolean logErrors = true;

    @Override
    public void log(String operation, String result, SAMLMessageContext context) {
        this.log(operation, result, context, SecurityContextHolder.getContext().getAuthentication(), null);
    }

    @Override
    public void log(String operation, String result, SAMLMessageContext context, Exception e) {
        this.log(operation, result, context, SecurityContextHolder.getContext().getAuthentication(), e);
    }

    @Override
    public void log(String operation, String result, SAMLMessageContext context, Authentication a, Exception e) {
        boolean exceptionOccurred;
        if (!log.isInfoEnabled()) {
            return;
        }
        if (operation == null) {
            operation = "";
        }
        if (result == null) {
            result = "";
        }
        if (context == null) {
            context = new SAMLMessageContext();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(operation);
        sb.append(";");
        sb.append(result);
        sb.append(";");
        if (context.getInboundMessageTransport() != null) {
            HTTPInTransport transport = (HTTPInTransport)context.getInboundMessageTransport();
            sb.append(transport.getPeerAddress());
        }
        sb.append(";");
        if (context.getLocalEntityId() != null) {
            sb.append(context.getLocalEntityId());
        }
        sb.append(";");
        if (context.getPeerEntityId() != null) {
            sb.append(context.getPeerEntityId());
        }
        sb.append(";");
        if (a != null) {
            if (a.getCredentials() != null && a.getCredentials() instanceof SAMLCredential) {
                SAMLCredential credential = (SAMLCredential)a.getCredentials();
                if (credential.getNameID() != null) {
                    sb.append(credential.getNameID().getValue());
                } else {
                    sb.append(a.getPrincipal());
                }
            } else {
                sb.append(a.getPrincipal());
            }
        }
        sb.append(";");
        boolean bl = exceptionOccurred = e != null;
        if (this.logAllMessages || this.logMessagesOnException && exceptionOccurred) {
            try {
                String messageStr;
                if (context.getInboundSAMLMessage() != null) {
                    messageStr = XMLHelper.nodeToString((Node)SAMLUtil.marshallMessage((XMLObject)context.getInboundSAMLMessage()));
                    sb.append(messageStr);
                }
                if (context.getOutboundSAMLMessage() != null) {
                    messageStr = XMLHelper.nodeToString((Node)SAMLUtil.marshallMessage((XMLObject)context.getOutboundSAMLMessage()));
                    sb.append(messageStr);
                }
            }
            catch (MessageEncodingException e1) {
                log.warn("Error marshaling message during logging", (Throwable)e1);
            }
        }
        sb.append(";");
        if (this.logErrors && e != null) {
            StringWriter errorWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(errorWriter));
            sb.append(errorWriter.getBuffer());
        }
        log.info(sb.toString());
    }

    @Deprecated
    public void setLogMessages(boolean logMessages) {
        this.setLogAllMessages(logMessages);
    }

    public void setLogAllMessages(boolean logAllMessages) {
        this.logAllMessages = logAllMessages;
    }

    public void setLogMessagesOnException(boolean logMessagesOnException) {
        this.logMessagesOnException = logMessagesOnException;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }
}

