/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.support.AgentBasedSyncAbstractDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpDetector
extends AgentBasedSyncAbstractDetector<SnmpAgentConfig> {
    protected static final String DEFAULT_SERVICE_NAME = "SNMP";
    private static final Logger LOG = LoggerFactory.getLogger(SnmpDetector.class);
    private ExecutorService snmpDetectorExecutor;
    private SecureCredentialsVault m_scv;
    private String useSnmpProfiles;
    private String ttl;
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_TIMEOUT = -1;
    private static final int DEFAULT_RETRIES = -1;
    private String m_oid = ".1.3.6.1.2.1.1.2.0";
    private boolean m_isTable = false;
    private boolean m_hex = false;
    private String m_forceVersion;
    private String m_vbvalue;
    private MatchType matchType;

    public SnmpDetector() {
        super(DEFAULT_SERVICE_NAME, -1, -1, -1);
    }

    public SnmpDetector(String serviceName, int port) {
        super(serviceName, port, -1, -1);
    }

    public String getIsTable() {
        return String.valueOf(this.m_isTable);
    }

    public void setIsTable(String table) {
        this.m_isTable = "true".equalsIgnoreCase(table);
    }

    public void setHex(String hex) {
        this.m_hex = "true".equalsIgnoreCase(hex);
    }

    public String getHex() {
        return String.valueOf(this.m_hex);
    }

    protected boolean isHex() {
        return this.m_hex;
    }

    private void updateCommunityStrings(SnmpAgentConfig config) {
        Credentials creds;
        if (config.getAddress().isLoopbackAddress() && (creds = this.m_scv.getCredentials("appliance.snmp")) != null && creds.getAttribute("community") != null) {
            config.setReadCommunity(creds.getAttribute("community"));
        }
    }

    public SnmpAgentConfig getAgentConfig(DetectRequest request) {
        if (request.getRuntimeAttributes() != null) {
            SnmpAgentConfig config = SnmpAgentConfig.fromMap((Map)request.getRuntimeAttributes());
            if (!"Default".equals(request.getRuntimeAttributes().get("location"))) {
                this.updateCommunityStrings(config);
            }
            return config;
        }
        return new SnmpAgentConfig();
    }

    public boolean isServiceDetected(InetAddress address, SnmpAgentConfig agentConfig) {
        try {
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            String expectedValue = this.getVbvalue();
            if (this.m_isTable) {
                LOG.debug(this.getServiceName() + ": table detect enabled");
                SnmpObjId snmpObjId = SnmpObjId.get((String)this.getOid());
                Map table = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)DEFAULT_SERVICE_NAME, (SnmpObjId)snmpObjId);
                List<String> retrievedValues = table.values().stream().map(snmpValue -> this.m_hex ? snmpValue.toHexString() : snmpValue.toString()).collect(Collectors.toList());
                return this.isServiceDetected(this.matchType, retrievedValues, expectedValue);
            }
            String retrievedValue = SnmpDetector.getValue(agentConfig, this.getOid(), this.m_hex);
            MatchType matchType = this.matchType;
            if (matchType == null && expectedValue != null) {
                matchType = MatchType.Any;
            }
            return this.isServiceDetected(matchType, Lists.newArrayList((Object[])new String[]{retrievedValue}), expectedValue);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public List<SnmpAgentConfig> getListOfAgentConfigs(DetectRequest request) {
        ArrayList<SnmpAgentConfig> agentConfigList = new ArrayList<SnmpAgentConfig>();
        Map runTimeAttributes = request.getRuntimeAttributes();
        if (this.useSnmpProfiles() && SnmpDetector.hasMultipleAgentConfigs((Map)runTimeAttributes)) {
            runTimeAttributes.forEach((label, configAsString) -> {
                if (label.contains("SNMP_AGENT_CONFIG_")) {
                    SnmpAgentConfig config = SnmpAgentConfig.parseProtocolConfigurationString((String)configAsString);
                    if (!"Default".equals(request.getRuntimeAttributes().get("location"))) {
                        this.updateCommunityStrings(config);
                    }
                    agentConfigList.add(config);
                }
            });
        } else if (SnmpDetector.hasMultipleAgentConfigs((Map)runTimeAttributes)) {
            runTimeAttributes.forEach((label, configAsString) -> {
                if (label.contains("SNMP_AGENT_CONFIG_") && label.contains("default")) {
                    SnmpAgentConfig config = SnmpAgentConfig.parseProtocolConfigurationString((String)configAsString);
                    if (!"Default".equals(request.getRuntimeAttributes().get("location"))) {
                        this.updateCommunityStrings(config);
                    }
                    agentConfigList.add(config);
                }
            });
        }
        return agentConfigList;
    }

    public boolean isServiceDetected(InetAddress address, List<SnmpAgentConfig> agentConfigList) {
        List<CompletableFuture> futures = agentConfigList.stream().map(agentConfig -> this.runServiceDetection(address, (SnmpAgentConfig)agentConfig)).collect(Collectors.toList());
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        CompletionStage futureList = allFutures.thenApply(result -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        CompletionStage future = ((CompletableFuture)futureList).thenApply(results -> results.stream().anyMatch(result -> result));
        try {
            return (Boolean)((CompletableFuture)future).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("SNMP Service detection encountered an error for IPAddress {} ", (Object)address, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Boolean> runServiceDetection(InetAddress address, SnmpAgentConfig agentConfig) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.isServiceDetected(address, agentConfig);
            }
            catch (Throwable t) {
                LOG.warn("SNMP Service detection encountered an error for IPAddress {} with agentConfig {} ", new Object[]{address, agentConfig, t});
                return false;
            }
        }, this.snmpDetectorExecutor);
    }

    private boolean isServiceDetected(MatchType matchType, List<String> retrievedValues, String expectedValue) {
        MatchType matchType2 = matchType = matchType == null ? MatchType.Exist : matchType;
        if (matchType != MatchType.Exist && expectedValue == null) {
            throw new IllegalArgumentException(this.getServiceName() + ": expectedValue was not defined using matchType=" + matchType + " but is required. Otherwise set matchType to " + MatchType.Exist);
        }
        boolean isServiceDetected = matchType.isServiceDetected(retrievedValues, expectedValue);
        LOG.debug(this.getServiceName() + ": services detected {} using matchType={}, expectedValue={}, retrievedValues={}", new Object[]{isServiceDetected, matchType, expectedValue, retrievedValues});
        return isServiceDetected;
    }

    protected void configureAgentVersion(SnmpAgentConfig agentConfig) {
        if (this.getForceVersion() != null) {
            String version = this.getForceVersion();
            if ("v1".equalsIgnoreCase(version) || "snmpv1".equalsIgnoreCase(version)) {
                agentConfig.setVersion(1);
            } else if ("v2".equalsIgnoreCase(version) || "v2c".equalsIgnoreCase(version) || "snmpv2".equalsIgnoreCase(version) || "snmpv2c".equalsIgnoreCase(version)) {
                agentConfig.setVersion(2);
            } else if ("v3".equalsIgnoreCase(version) || "snmpv3".equalsIgnoreCase(version)) {
                agentConfig.setVersion(3);
            }
        }
    }

    protected void configureAgentPTR(SnmpAgentConfig agentConfig) {
        if (this.getPort() > 0) {
            agentConfig.setPort(this.getPort());
        }
        if (this.getTimeout() > 0) {
            agentConfig.setTimeout(this.getTimeout());
        }
        if (this.getRetries() > -1) {
            agentConfig.setRetries(this.getRetries());
        }
    }

    protected static String getValue(SnmpAgentConfig agentConfig, String oid, boolean hex) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        if (val == null || val.isNull() || val.isEndOfMib() || val.isError()) {
            return null;
        }
        return hex ? val.toHexString() : val.toString();
    }

    public void setOid(String oid) {
        this.m_oid = oid;
    }

    public String getOid() {
        return this.m_oid;
    }

    public void setForceVersion(String forceVersion) {
        this.m_forceVersion = forceVersion;
    }

    public String getForceVersion() {
        return this.m_forceVersion;
    }

    public void setVbvalue(String vbvalue) {
        this.m_vbvalue = vbvalue;
    }

    public String getVbvalue() {
        return this.m_vbvalue;
    }

    protected void onInit() {
    }

    public void dispose() {
    }

    public void setMatchType(String matchType) {
        this.matchType = MatchType.createFrom(matchType);
    }

    public String getMatchType() {
        return this.matchType.name();
    }

    public void setSnmpDetectorExecutor(ExecutorService snmpDetectorExecutor) {
        this.snmpDetectorExecutor = snmpDetectorExecutor;
    }

    private boolean useSnmpProfiles() {
        return !Strings.isNullOrEmpty((String)this.useSnmpProfiles) && this.useSnmpProfiles.equals(Boolean.toString(true));
    }

    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public void setUseSnmpProfiles(String useSnmpProfiles) {
        this.useSnmpProfiles = useSnmpProfiles;
    }

    public String getUseSnmpProfiles() {
        return this.useSnmpProfiles;
    }

    public void setSecureCredentialsVault(SecureCredentialsVault scv) {
        this.m_scv = scv;
    }

    public static enum MatchType {
        Any{

            @Override
            boolean isServiceDetected(List<String> retrievedValues, String expectedValuePattern) {
                Pattern expectedPattern = Pattern.compile(Objects.requireNonNull(expectedValuePattern));
                if ((retrievedValues = MatchType.removeNullElements(retrievedValues)).isEmpty()) {
                    return false;
                }
                boolean anyMatch = retrievedValues.stream().anyMatch(eachRetrievedValue -> expectedPattern.matcher((CharSequence)eachRetrievedValue).matches());
                return anyMatch;
            }
        }
        ,
        All{

            @Override
            boolean isServiceDetected(List<String> retrievedValues, String expectedValuePattern) {
                Pattern expectedPattern = Pattern.compile(Objects.requireNonNull(expectedValuePattern));
                if ((retrievedValues = MatchType.removeNullElements(retrievedValues)).isEmpty()) {
                    return false;
                }
                boolean allMatch = retrievedValues.stream().allMatch(eachRetrievedValue -> expectedPattern.matcher((CharSequence)eachRetrievedValue).matches());
                return allMatch;
            }
        }
        ,
        None{

            @Override
            boolean isServiceDetected(List<String> retrievedValues, String expectedValuePattern) {
                return !Any.isServiceDetected(retrievedValues, expectedValuePattern);
            }
        }
        ,
        Exist{

            @Override
            boolean isServiceDetected(List<String> retrievedValues, String expectedValuePattern) {
                return !MatchType.removeNullElements(retrievedValues).isEmpty();
            }
        };


        abstract boolean isServiceDetected(List<String> var1, String var2);

        private static List<String> removeNullElements(List<String> input) {
            return input.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        public static MatchType createFrom(String input) {
            Objects.requireNonNull(input);
            for (MatchType eachType : MatchType.values()) {
                if (!eachType.name().equalsIgnoreCase(input)) continue;
                return eachType;
            }
            throw new IllegalArgumentException("No MatchType found for name " + input);
        }
    }
}

