/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.util.Arrays;
import java.util.List;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpGetter;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpLocPortGetter
extends SnmpGetter {
    private static final Logger LOG = LoggerFactory.getLogger(LldpLocPortGetter.class);
    public static final String LLDP_LOC_PORTID_SUBTYPE = "lldpLocPortIdSubtype";
    public static final String LLDP_LOC_PORTID = "lldpLocPortId";
    public static final String LLDP_LOC_DESCR = "lldpLocPortDesc";
    public static final SnmpObjId LLDP_LOC_PORTID_SUBTYPE_OID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.2");
    public static final SnmpObjId LLDP_LOC_PORTID_OID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.3");
    public static final SnmpObjId LLDP_LOC_DESCR_OID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.4");

    public LldpLocPortGetter(SnmpAgentConfig peer, LocationAwareSnmpClient client, String location) {
        super(peer, client, location);
    }

    public List<SnmpValue> get(Integer lldpRemLocalPortNum) {
        return this.get(Arrays.asList(SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID_SUBTYPE_OID), SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID_OID), SnmpObjId.get((SnmpObjId)LLDP_LOC_DESCR_OID)), lldpRemLocalPortNum);
    }

    public LldpLink getLldpLink(LldpRemTableTracker.LldpRemRow row) {
        List<SnmpValue> val = this.get(row.getLldpRemLocalPortNum());
        LldpLink lldplink = row.getLldpLink();
        if (val == null) {
            LOG.debug("getLldpLink: cannot find local instance for lldp local port number {}", (Object)lldplink.getLldpRemLocalPortNum());
            LOG.debug("getLldpLink: setting default not found Values: portidtype \"InterfaceAlias\", portid=\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortDescr("");
            return lldplink;
        }
        if (val.get(0) == null || val.get(0).isError() || !val.get(0).isNumeric()) {
            LOG.debug("getLldpLink: port id subtype is null or invalid for lldp local port number {}", (Object)lldplink.getLldpRemLocalPortNum());
            LOG.debug("getLldpLink: setting default not found Values: portidtype \"InterfaceAlias\"");
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
        } else {
            lldplink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.get((Integer)val.get(0).toInt()));
        }
        if (val.get(1) == null || val.get(1).isError()) {
            LOG.debug("getLldpLink: port id is null for lldp local port number {}", (Object)lldplink.getLldpRemLocalPortNum());
            LOG.debug("get: setting default not found Values: portid=\"Not Found On lldpLocPortTable\"");
            lldplink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
        } else {
            lldplink.setLldpPortId(LldpRemTableTracker.decodeLldpPortId(lldplink.getLldpPortIdSubType().getValue(), val.get(1)));
        }
        if (val.get(2) != null && !val.get(2).isError()) {
            lldplink.setLldpPortDescr(val.get(2).toDisplayString());
        } else {
            lldplink.setLldpPortDescr("");
        }
        if (val.get(0).isNumeric() && val.get(0).toInt() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL.getValue().intValue()) {
            try {
                lldplink.setLldpPortIfindex(Integer.valueOf(val.get(1).toInt()));
            }
            catch (Exception e) {
                LOG.warn("getLldpLink: failed to convert to ifindex local port id {}", (Object)val.get(1));
            }
        }
        return lldplink;
    }
}

