/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.client.JestClient;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.features.jest.client.SearchResultUtils;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.LimitedCardinalityField;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.elastic.Direction;
import org.opennms.netmgt.flows.elastic.ElasticFlowQueryService;
import org.opennms.netmgt.flows.elastic.GPath;
import org.opennms.netmgt.flows.elastic.ProportionalSumAggregation;
import org.opennms.netmgt.flows.elastic.SearchQueryProvider;
import org.opennms.netmgt.flows.elastic.TableUtils;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.opennms.netmgt.flows.processing.ConversationKeyUtils;

public class RawFlowQueryService
extends ElasticFlowQueryService {
    public static final String INDEX_NAME = "netflow";
    public static final String OTHER_NAME = "Other";
    public static final String UNKNOWN_APPLICATION_NAME = "Unknown";
    private final SearchQueryProvider searchQueryProvider = new SearchQueryProvider();
    private static Predicate<String> IS_INT = Pattern.compile("-?\\d+").asPredicate();
    private static Comparator<TrafficSummary<String>> TRAFFIC_SUMMARY_STRING_AS_INT_COMPARATOR = (s1, s2) -> {
        boolean d1 = IS_INT.test((String)s1.getEntity());
        boolean d2 = IS_INT.test((String)s2.getEntity());
        return d1 && d2 ? new Integer((String)s1.getEntity()).compareTo(new Integer((String)s2.getEntity())) : (d1 ? -1 : (d2 ? 1 : ((String)s1.getEntity()).compareTo((String)s2.getEntity())));
    };

    public RawFlowQueryService(JestClient client, IndexSelector indexSelector) {
        super(client, indexSelector);
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        String query = this.searchQueryProvider.getFlowCountQuery(filters);
        return this.searchAsync(query, RawFlowQueryService.extractTimeRangeFilter(filters)).thenApply(SearchResultUtils::getTotal);
    }

    public CompletableFuture<List<String>> getApplications(String matchingPrefix, long limit, List<Filter> filters) {
        String query = this.searchQueryProvider.getApplicationsQuery(matchingPrefix, limit, filters);
        return this.searchAsync(query, RawFlowQueryService.extractTimeRangeFilter(filters)).thenApply(res -> RawFlowQueryService.processGroupedByResult(res, limit));
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplicationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFromTopN(N, "netflow.application", UNKNOWN_APPLICATION_NAME, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getApplicationSummaries(Set<String> applications, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFrom(applications, "netflow.application", null, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getApplicationSeries(Set<String> applications, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFor(applications, "netflow.application", step, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, CompletableFuture::completedFuture));
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFromTopN(N, step, "netflow.application", UNKNOWN_APPLICATION_NAME, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, CompletableFuture::completedFuture));
    }

    public CompletableFuture<List<String>> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, List<Filter> filters) {
        if (applicationPattern.equals(".*")) {
            applicationPattern = String.format("(\\\"%s\\\"|null)", applicationPattern);
        } else if (!applicationPattern.equals("null")) {
            applicationPattern = String.format("\\\"%s\\\"", applicationPattern);
        }
        String regex = String.format("\\[\\\"%s\\\",%s,\\\"%s\\\",\\\"%s\\\",%s\\]", locationPattern, protocolPattern, lowerIPPattern, upperIPPattern, applicationPattern);
        String query = this.searchQueryProvider.getConversationsRegexQuery(regex, limit, filters);
        return this.searchAsync(query, RawFlowQueryService.extractTimeRangeFilter(filters)).thenApply(res -> RawFlowQueryService.processGroupedByResult(res, limit));
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getTopNConversationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFromTopN(N, "netflow.convo_key", null, includeOther, filters).thenCompose(summaries -> RawFlowQueryService.transpose(summaries.stream().map(summary -> this.resolveHostnameForConversation((String)summary.getEntity(), filters).thenApply(conversation -> TrafficSummary.from((Object)conversation).withBytesAndEcnInfo(summary).build())).collect(Collectors.toList()), Collectors.toList()));
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getConversationSummaries(Set<String> conversations, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFrom(RawFlowQueryService.unescapeConversations(conversations), "netflow.convo_key", null, includeOther, filters).thenCompose(summaries -> RawFlowQueryService.transpose(summaries.stream().map(summary -> this.resolveHostnameForConversation((String)summary.getEntity(), filters).thenApply(conversation -> TrafficSummary.from((Object)conversation).withBytesAndEcnInfo(summary).build())).collect(Collectors.toList()), Collectors.toList()));
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getConversationSeries(Set<String> conversations, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFor(RawFlowQueryService.unescapeConversations(conversations), "netflow.convo_key", step, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, convoKey -> this.resolveHostnameForConversation((String)convoKey, filters)));
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getTopNConversationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFromTopN(N, step, "netflow.convo_key", null, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, convoKey -> this.resolveHostnameForConversation((String)convoKey, filters)));
    }

    public CompletableFuture<List<String>> getHosts(String regex, long limit, List<Filter> filters) {
        String hostsQuery = this.searchQueryProvider.getHostsQuery(regex, limit, filters);
        return this.searchAsync(hostsQuery, RawFlowQueryService.extractTimeRangeFilter(filters)).thenApply(res -> RawFlowQueryService.processGroupedByResult(res, limit));
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getTopNHostSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFromTopN(N, "hosts", null, includeOther, filters).thenCompose(summaries -> RawFlowQueryService.transpose(summaries.stream().map(summary -> this.resolveHostnameForHost((String)summary.getEntity(), filters).thenApply(host -> TrafficSummary.from((Object)host).withBytesAndEcnInfo(summary).build())).collect(Collectors.toList()), Collectors.toList()));
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getHostSummaries(Set<String> hosts, boolean includeOther, List<Filter> filters) {
        return this.getTotalBytesFrom(hosts, "hosts", null, includeOther, filters).thenCompose(summaries -> RawFlowQueryService.transpose(summaries.stream().map(summary -> this.resolveHostnameForHost((String)summary.getEntity(), filters).thenApply(host -> TrafficSummary.from((Object)host).withBytesAndEcnInfo(summary).build())).collect(Collectors.toList()), Collectors.toList()));
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getHostSeries(Set<String> hosts, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFor(hosts, "hosts", step, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, host -> this.resolveHostnameForHost((String)host, filters)));
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getTopNHostSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getSeriesFromTopN(N, step, "hosts", null, includeOther, filters).thenCompose(res -> RawFlowQueryService.mapTable((Table<Directional<String>, Long, Double>)res, host -> this.resolveHostnameForHost((String)host, filters)));
    }

    private static <X> GPath<List<X>> compositeKeyValuesPath(String field, GPath<X> fieldValueAccess) {
        return fieldValueAccess.field(field).field("key").array("buckets").field("my_buckets").field("aggregations", "aggs");
    }

    public CompletableFuture<List<String>> getFieldValues(LimitedCardinalityField field, List<Filter> filters) {
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.extractTimeRangeFilter(filters);
        return this.searchAsync(this.searchQueryProvider.getAllValues(field.fieldName, field.size, filters), timeRangeFilter).thenApply(res -> {
            List<String> fieldValues = RawFlowQueryService.compositeKeyValuesPath(field.fieldName, GPath.string()).eval((JsonElement)res.getJsonObject());
            return fieldValues != null ? fieldValues : Collections.emptyList();
        });
    }

    public CompletableFuture<List<TrafficSummary<String>>> getFieldSummaries(LimitedCardinalityField field, List<Filter> filters) {
        return this.getTotalBytesForSize(field.size, field.fieldName, null, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getFieldSeries(LimitedCardinalityField field, long step, List<Filter> filters) {
        return this.getSeriesForSize(field.size, step, field.fieldName, null, filters);
    }

    public CompletableFuture<Conversation> resolveHostnameForConversation(String convoKey, List<Filter> filters) {
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.extractTimeRangeFilter(filters);
        if (OTHER_NAME.equals(convoKey)) {
            return CompletableFuture.completedFuture(Conversation.forOther().build());
        }
        ConversationKey key = ConversationKeyUtils.fromJsonString((String)convoKey);
        Conversation.Builder result = Conversation.from((ConversationKey)key);
        String hostnameQuery = this.searchQueryProvider.getHostnameByConversationQuery(convoKey, filters);
        return this.searchAsync(hostnameQuery, timeRangeFilter).thenApply(res -> {
            JsonObject hit = (JsonObject)res.getFirstHit(JsonObject.class).source;
            if (Objects.equals(hit.getAsJsonPrimitive("netflow.src_addr").getAsString(), key.getLowerIp())) {
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.src_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Conversation.Builder)result).withLowerHostname(arg_0));
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.dst_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Conversation.Builder)result).withUpperHostname(arg_0));
            } else if (Objects.equals(hit.getAsJsonPrimitive("netflow.dst_addr").getAsString(), key.getLowerIp())) {
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.dst_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Conversation.Builder)result).withLowerHostname(arg_0));
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.src_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Conversation.Builder)result).withUpperHostname(arg_0));
            }
            return result.build();
        });
    }

    public CompletableFuture<Host> resolveHostnameForHost(String host, List<Filter> filters) {
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.extractTimeRangeFilter(filters);
        if (OTHER_NAME.equals(host)) {
            return CompletableFuture.completedFuture(Host.forOther().build());
        }
        Host.Builder result = Host.from((String)host);
        String hostnameQuery = this.searchQueryProvider.getHostnameByHostQuery(host, filters);
        return this.searchAsync(hostnameQuery, timeRangeFilter).thenApply(res -> {
            JsonObject hit = (JsonObject)res.getFirstHit(JsonObject.class).source;
            if (Objects.equals(hit.getAsJsonPrimitive("netflow.src_addr").getAsString(), host)) {
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.src_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Host.Builder)result).withHostname(arg_0));
            } else if (Objects.equals(hit.getAsJsonPrimitive("netflow.dst_addr").getAsString(), host)) {
                Optional.ofNullable(hit.getAsJsonPrimitive("netflow.dst_addr_hostname")).map(JsonPrimitive::getAsString).ifPresent(arg_0 -> ((Host.Builder)result).withHostname(arg_0));
            }
            return result.build();
        });
    }

    private CompletableFuture<List<String>> getTopN(int N, String groupByTerm, String keyForMissingTerm, List<Filter> filters) {
        if (N < 1) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        int multiplier = 2;
        String query = this.searchQueryProvider.getTopNQuery(2 * N, groupByTerm, keyForMissingTerm, filters);
        return this.searchAsync(query, RawFlowQueryService.extractTimeRangeFilter(filters)).thenApply(res -> RawFlowQueryService.processGroupedByResult(res, N));
    }

    private CompletableFuture<Table<Directional<String>, Long, Double>> getSeriesFor(Set<String> entities, String groupByTerm, long step, boolean includeOther, List<Filter> filters) {
        Objects.requireNonNull(groupByTerm);
        if (entities == null || entities.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.getRequiredTimeRangeFilter(filters);
        String seriesFromQuery = this.searchQueryProvider.getSeriesFromQuery(entities, step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), groupByTerm, filters);
        CompletionStage seriesFuture = this.searchAsync(seriesFromQuery, timeRangeFilter).thenApply(res -> {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            RawFlowQueryService.toTable((ImmutableTable.Builder<Directional<String>, Long, Double>)builder, res);
            return builder;
        });
        if (includeOther) {
            String seriesFromOthersQuery = this.searchQueryProvider.getSeriesFromOthersQuery(entities, step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), groupByTerm, false, filters);
            seriesFuture = ((CompletableFuture)seriesFuture).thenCombine(this.searchAsync(seriesFromOthersQuery, timeRangeFilter), (builder, res) -> RawFlowQueryService.processOthersResult(res, (ImmutableTable.Builder<Directional<String>, Long, Double>)builder));
        }
        return ((CompletableFuture)seriesFuture).thenApply(builder -> builder.build());
    }

    private CompletableFuture<Table<Directional<String>, Long, Double>> getSeriesFromTopN(List<String> topN, long step, String groupByTerm, String keyForMissingTerm, boolean includeOther, List<Filter> filters) {
        boolean missingTermIncludedInTopN;
        CompletionStage<Object> seriesFuture;
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.getRequiredTimeRangeFilter(filters);
        if (topN.size() < 1) {
            seriesFuture = CompletableFuture.completedFuture(ImmutableTable.builder());
        } else {
            String seriesFromTopNQuery = this.searchQueryProvider.getSeriesFromQuery(topN, step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), groupByTerm, filters);
            seriesFuture = this.searchAsync(seriesFromTopNQuery, timeRangeFilter).thenApply(res -> {
                ImmutableTable.Builder builder = ImmutableTable.builder();
                RawFlowQueryService.toTable((ImmutableTable.Builder<Directional<String>, Long, Double>)builder, res);
                return builder;
            });
        }
        boolean bl = missingTermIncludedInTopN = keyForMissingTerm != null && topN.contains(keyForMissingTerm);
        if (missingTermIncludedInTopN) {
            String seriesFromMissingQuery = this.searchQueryProvider.getSeriesFromMissingQuery(step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), groupByTerm, keyForMissingTerm, filters);
            seriesFuture = ((CompletableFuture)seriesFuture).thenCombine(this.searchAsync(seriesFromMissingQuery, RawFlowQueryService.extractTimeRangeFilter(filters)), (builder, res) -> {
                RawFlowQueryService.toTable((ImmutableTable.Builder<Directional<String>, Long, Double>)builder, res);
                return builder;
            });
        }
        if (includeOther) {
            String seriesFromOthersQuery = this.searchQueryProvider.getSeriesFromOthersQuery(topN, step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), groupByTerm, missingTermIncludedInTopN, filters);
            seriesFuture = ((CompletableFuture)seriesFuture).thenCombine(this.searchAsync(seriesFromOthersQuery, timeRangeFilter), (builder, res) -> RawFlowQueryService.processOthersResult(res, (ImmutableTable.Builder<Directional<String>, Long, Double>)builder));
        }
        return ((CompletableFuture)seriesFuture).thenApply(builder -> TableUtils.sortTableByRowKeys(builder.build(), topN));
    }

    private static ImmutableTable.Builder<Directional<String>, Long, Double> toTable(ImmutableTable.Builder<Directional<String>, Long, Double> builder, SearchResult res) {
        MetricAggregation aggs = res.getAggregations();
        if (aggs == null) {
            return builder;
        }
        TermsAggregation groupedBy = aggs.getTermsAggregation("grouped_by");
        if (groupedBy == null) {
            return builder;
        }
        for (TermsAggregation.Entry bucket : groupedBy.getBuckets()) {
            TermsAggregation directionAgg = bucket.getTermsAggregation("direction");
            for (TermsAggregation.Entry directionBucket : directionAgg.getBuckets()) {
                boolean isIngress = RawFlowQueryService.isIngress(directionBucket);
                ProportionalSumAggregation sumAgg = (ProportionalSumAggregation)directionBucket.getAggregation("bytes", ProportionalSumAggregation.class);
                for (ProportionalSumAggregation.DateHistogram dateHistogram : sumAgg.getBuckets()) {
                    builder.put((Object)new Directional((Object)bucket.getKey(), isIngress), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
                }
            }
        }
        return builder;
    }

    private CompletableFuture<Table<Directional<String>, Long, Double>> getSeriesForSize(int size, long step, String groupByTerm, String keyForMissingTerm, List<Filter> filters) {
        FilterAndGroupBy fag = new FilterAndGroupBy(filters, groupByTerm, step);
        return ((CompletableFuture)this.seriesForSize(fag, size).thenCompose(this.addSeriesForMissing(fag, keyForMissingTerm))).thenApply(builder -> builder.build());
    }

    private CompletableFuture<Table<Directional<String>, Long, Double>> getSeriesFromTopN(int N, long step, String groupByTerm, String keyForMissingTerm, boolean includeOther, List<Filter> filters) {
        return this.getTopN(N, groupByTerm, keyForMissingTerm, filters).thenCompose(topN -> this.getSeriesFromTopN((List<String>)topN, step, groupByTerm, keyForMissingTerm, includeOther, filters));
    }

    private CompletableFuture<List<TrafficSummary<String>>> getTotalBytesFrom(Collection<String> from, String groupByTerm, String keyForMissingTerm, boolean includeOther, List<Filter> filters) {
        boolean missingTermIncluded;
        CompletionStage summariesFuture;
        TimeRangeFilter timeRangeFilter = RawFlowQueryService.getRequiredTimeRangeFilter(filters);
        long start = timeRangeFilter.getStart();
        long end = Math.max(timeRangeFilter.getStart(), timeRangeFilter.getEnd() - 1L);
        long step = timeRangeFilter.getEnd() - timeRangeFilter.getStart();
        if (from.size() < 1) {
            summariesFuture = CompletableFuture.completedFuture(new LinkedHashMap());
        } else {
            String bytesFromQuery = this.searchQueryProvider.getSeriesFromQuery(from, step, start, end, groupByTerm, filters);
            summariesFuture = this.searchAsync(bytesFromQuery, timeRangeFilter).thenApply(RawFlowQueryService::toTrafficSummaries);
        }
        boolean bl = missingTermIncluded = keyForMissingTerm != null && from.contains(keyForMissingTerm);
        if (missingTermIncluded) {
            String bytesFromMissingQuery = this.searchQueryProvider.getSeriesFromMissingQuery(step, start, end, groupByTerm, keyForMissingTerm, filters);
            summariesFuture = ((CompletableFuture)summariesFuture).thenCombine(this.searchAsync(bytesFromMissingQuery, timeRangeFilter), (summaries, results) -> {
                summaries.putAll(RawFlowQueryService.toTrafficSummaries(results));
                return summaries;
            });
        }
        if (includeOther) {
            String bytesFromOthersQuery = this.searchQueryProvider.getSeriesFromOthersQuery(from, step, start, end, groupByTerm, missingTermIncluded, filters);
            summariesFuture = ((CompletableFuture)summariesFuture).thenCombine(this.searchAsync(bytesFromOthersQuery, timeRangeFilter), (summaries, results) -> {
                MetricAggregation aggs = results.getAggregations();
                if (aggs == null) {
                    return summaries;
                }
                TermsAggregation directionAgg = aggs.getTermsAggregation("direction");
                if (directionAgg == null) {
                    return summaries;
                }
                TrafficSummary.Builder trafficSummary = TrafficSummary.from((Object)OTHER_NAME);
                for (TermsAggregation.Entry directionBucket : directionAgg.getBuckets()) {
                    boolean isIngress = RawFlowQueryService.isIngress(directionBucket);
                    ProportionalSumAggregation sumAgg = (ProportionalSumAggregation)directionBucket.getAggregation("bytes", ProportionalSumAggregation.class);
                    List<ProportionalSumAggregation.DateHistogram> sumBuckets = sumAgg.getBuckets();
                    if (sumBuckets.size() != 1) {
                        throw new IllegalStateException("Expected 1 bucket, but got: " + sumBuckets);
                    }
                    Double sum = sumBuckets.iterator().next().getValue();
                    if (!isIngress) {
                        trafficSummary.withBytesOut(sum.longValue());
                    } else {
                        trafficSummary.withBytesIn(sum.longValue());
                    }
                    trafficSummary.withEcnInfo((MetricAggregation)directionBucket);
                }
                summaries.put(OTHER_NAME, trafficSummary.build());
                return summaries;
            });
        }
        return ((CompletableFuture)summariesFuture).thenApply(summaries -> {
            ArrayList<Object> topNRes = new ArrayList<Object>(from.size());
            for (String topNEntry : from) {
                TrafficSummary summary = (TrafficSummary)summaries.remove(topNEntry);
                if (summary == null) continue;
                topNRes.add(summary);
            }
            topNRes.addAll(summaries.values());
            return topNRes;
        });
    }

    private CompletableFuture<List<TrafficSummary<String>>> getTotalBytesForSize(int size, String groupByTerm, String keyForMissingTerm, List<Filter> filters) {
        FilterAndGroupBy fag = new FilterAndGroupBy(filters, groupByTerm);
        return ((CompletableFuture)this.totalBytesForSize(fag, size).thenCompose(this.addTotalBytesForMissing(fag, keyForMissingTerm))).thenApply(this.orderSummariesByIntKeys());
    }

    private static <T> Function<T, CompletableFuture<T>> keepValue() {
        return t -> CompletableFuture.completedFuture(t);
    }

    private CompletableFuture<ImmutableTable.Builder<Directional<String>, Long, Double>> seriesForSize(FilterAndGroupBy fag, int size) {
        if (size < 1) {
            return CompletableFuture.completedFuture(ImmutableTable.builder());
        }
        String bytesFromQuery = this.searchQueryProvider.getSeriesFromQuery(size, fag.step, fag.start, fag.end, fag.groupByTerm, fag.filters);
        return this.searchAsync(bytesFromQuery, fag.timeRangeFilter).thenApply(searchResult -> {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            RawFlowQueryService.toTable((ImmutableTable.Builder<Directional<String>, Long, Double>)builder, searchResult);
            return builder;
        });
    }

    private Function<ImmutableTable.Builder<Directional<String>, Long, Double>, CompletableFuture<ImmutableTable.Builder<Directional<String>, Long, Double>>> addSeriesForMissing(FilterAndGroupBy fag, String keyForMissingTerm) {
        if (keyForMissingTerm != null) {
            String seriesFromMissingQuery = this.searchQueryProvider.getSeriesFromMissingQuery(fag.step, fag.start, fag.end, fag.groupByTerm, keyForMissingTerm, fag.filters);
            CompletableFuture<SearchResult> missingFuture = this.searchAsync(seriesFromMissingQuery, fag.timeRangeFilter);
            return builder -> missingFuture.thenApply(searchResult -> RawFlowQueryService.toTable((ImmutableTable.Builder<Directional<String>, Long, Double>)builder, searchResult));
        }
        return RawFlowQueryService.keepValue();
    }

    private CompletableFuture<Map<String, TrafficSummary<String>>> totalBytesForSize(FilterAndGroupBy fag, int size) {
        if (size < 1) {
            return CompletableFuture.completedFuture(new LinkedHashMap());
        }
        String bytesFromQuery = this.searchQueryProvider.getSeriesFromQuery(size, fag.step, fag.start, fag.end, fag.groupByTerm, fag.filters);
        return this.searchAsync(bytesFromQuery, fag.timeRangeFilter).thenApply(RawFlowQueryService::toTrafficSummaries);
    }

    private Function<Map<String, TrafficSummary<String>>, CompletableFuture<Map<String, TrafficSummary<String>>>> addTotalBytesForMissing(FilterAndGroupBy fag, String keyForMissingTerm) {
        if (keyForMissingTerm != null) {
            String bytesFromMissingQuery = this.searchQueryProvider.getSeriesFromMissingQuery(fag.step, fag.start, fag.end, fag.groupByTerm, keyForMissingTerm, fag.filters);
            CompletableFuture<SearchResult> missingFuture = this.searchAsync(bytesFromMissingQuery, fag.timeRangeFilter);
            return summaries -> missingFuture.thenApply(results -> {
                summaries.putAll(RawFlowQueryService.toTrafficSummaries(results));
                return summaries;
            });
        }
        return RawFlowQueryService.keepValue();
    }

    private Function<Map<String, TrafficSummary<String>>, List<TrafficSummary<String>>> orderSummariesByIntKeys() {
        return summaries -> summaries.values().stream().sorted(TRAFFIC_SUMMARY_STRING_AS_INT_COMPARATOR).collect(Collectors.toList());
    }

    private static Map<String, TrafficSummary<String>> toTrafficSummaries(SearchResult res) {
        LinkedHashMap<String, TrafficSummary<String>> summaries = new LinkedHashMap<String, TrafficSummary<String>>();
        MetricAggregation aggs = res.getAggregations();
        if (aggs == null) {
            return summaries;
        }
        TermsAggregation groupedBy = aggs.getTermsAggregation("grouped_by");
        if (groupedBy == null) {
            return summaries;
        }
        for (TermsAggregation.Entry bucket : groupedBy.getBuckets()) {
            TrafficSummary.Builder trafficSummary = TrafficSummary.from((Object)bucket.getKey());
            TermsAggregation directionAgg = bucket.getTermsAggregation("direction");
            for (TermsAggregation.Entry directionBucket : directionAgg.getBuckets()) {
                boolean isIngress = RawFlowQueryService.isIngress(directionBucket);
                ProportionalSumAggregation sumAgg = (ProportionalSumAggregation)directionBucket.getAggregation("bytes", ProportionalSumAggregation.class);
                List<ProportionalSumAggregation.DateHistogram> sumBuckets = sumAgg.getBuckets();
                if (sumBuckets.size() != 1) {
                    throw new IllegalStateException("Expected 1 bucket, but got: " + sumBuckets);
                }
                Double sum = sumBuckets.iterator().next().getValue();
                if (!isIngress) {
                    trafficSummary.withBytesOut(sum.longValue());
                } else {
                    trafficSummary.withBytesIn(sum.longValue());
                }
                trafficSummary.withEcnInfo((MetricAggregation)directionBucket);
            }
            summaries.put(bucket.getKey(), (TrafficSummary<String>)trafficSummary.build());
        }
        return summaries;
    }

    private CompletableFuture<List<TrafficSummary<String>>> getTotalBytesFromTopN(int N, String groupByTerm, String keyForMissingTerm, boolean includeOther, List<Filter> filters) {
        return this.getTopN(N, groupByTerm, keyForMissingTerm, filters).thenCompose(topN -> this.getTotalBytesFrom((Collection<String>)topN, groupByTerm, keyForMissingTerm, includeOther, filters));
    }

    private static ImmutableTable.Builder<Directional<String>, Long, Double> processOthersResult(SearchResult res, ImmutableTable.Builder<Directional<String>, Long, Double> builder) {
        MetricAggregation aggs = res.getAggregations();
        if (aggs == null) {
            return builder;
        }
        TermsAggregation directionAgg = aggs.getTermsAggregation("direction");
        if (directionAgg == null) {
            return builder;
        }
        for (TermsAggregation.Entry directionBucket : directionAgg.getBuckets()) {
            boolean isIngress = RawFlowQueryService.isIngress(directionBucket);
            ProportionalSumAggregation sumAgg = (ProportionalSumAggregation)directionBucket.getAggregation("bytes", ProportionalSumAggregation.class);
            for (ProportionalSumAggregation.DateHistogram dateHistogram : sumAgg.getBuckets()) {
                builder.put((Object)new Directional((Object)OTHER_NAME, isIngress), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
            }
        }
        return builder;
    }

    private static List<String> processGroupedByResult(SearchResult searchResult, long limit) {
        MetricAggregation aggs = searchResult.getAggregations();
        if (aggs == null) {
            return Collections.emptyList();
        }
        TermsAggregation groupedBy = aggs.getTermsAggregation("grouped_by");
        if (groupedBy == null) {
            return Collections.emptyList();
        }
        return groupedBy.getBuckets().stream().map(TermsAggregation.Entry::getKey).limit(limit).collect(Collectors.toList());
    }

    private static TimeRangeFilter getRequiredTimeRangeFilter(Collection<Filter> filters) {
        TimeRangeFilter filter = RawFlowQueryService.extractTimeRangeFilter(filters);
        if (filter == null) {
            throw new IllegalArgumentException("Time range is required.");
        }
        return filter;
    }

    private static TimeRangeFilter extractTimeRangeFilter(Collection<Filter> filters) {
        return filters.stream().filter(f -> f instanceof TimeRangeFilter).map(f -> (TimeRangeFilter)f).findFirst().orElse(null);
    }

    private static boolean isIngress(TermsAggregation.Entry entry) {
        String directionAsString = entry.getKeyAsString();
        if (Direction.INGRESS.name().equalsIgnoreCase(directionAsString)) {
            return true;
        }
        if (Direction.EGRESS.name().equalsIgnoreCase(directionAsString)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown direction value: " + directionAsString);
    }

    private static Set<String> unescapeConversations(Set<String> conversations) {
        return conversations.stream().map(conversation -> conversation.replace("\\\"", "\"")).collect(Collectors.toSet());
    }

    private static class FilterAndGroupBy {
        public final String groupByTerm;
        public final List<Filter> filters;
        public final TimeRangeFilter timeRangeFilter;
        public final long start;
        public final long end;
        public final long step;

        public FilterAndGroupBy(List<Filter> filters, String groupByTerm) {
            Objects.requireNonNull(filters);
            Objects.requireNonNull(groupByTerm);
            this.filters = filters;
            this.groupByTerm = groupByTerm;
            this.timeRangeFilter = RawFlowQueryService.getRequiredTimeRangeFilter(filters);
            this.start = this.timeRangeFilter.getStart();
            this.end = Math.max(this.timeRangeFilter.getStart(), this.timeRangeFilter.getEnd() - 1L);
            this.step = this.timeRangeFilter.getEnd() - this.timeRangeFilter.getStart();
        }

        public FilterAndGroupBy(List<Filter> filters, String groupByTerm, long step) {
            Objects.requireNonNull(filters);
            Objects.requireNonNull(groupByTerm);
            this.filters = filters;
            this.groupByTerm = groupByTerm;
            this.step = step;
            this.timeRangeFilter = RawFlowQueryService.getRequiredTimeRangeFilter(filters);
            this.start = this.timeRangeFilter.getStart();
            this.end = this.timeRangeFilter.getEnd();
        }
    }
}

