/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import io.searchbox.client.JestClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.template.DefaultTemplateInitializer;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.integration.api.v1.flows.FlowException;
import org.opennms.integration.api.v1.flows.FlowRepository;
import org.opennms.netmgt.flows.api.UnrecoverableFlowException;
import org.opennms.netmgt.flows.elastic.AggregateIndexInitializer;
import org.opennms.netmgt.flows.elastic.RawIndexInitializer;
import org.osgi.framework.BundleContext;

public class InitializingFlowRepository
implements FlowRepository {
    private final List<DefaultTemplateInitializer> initializers;
    private final FlowRepository delegate;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public InitializingFlowRepository(BundleContext bundleContext, FlowRepository delegate, JestClient client, IndexSettings rawIndexSettings, IndexSettings aggIndexSettings) {
        this(delegate, new RawIndexInitializer(bundleContext, client, rawIndexSettings), new AggregateIndexInitializer(bundleContext, client, aggIndexSettings));
    }

    protected InitializingFlowRepository(FlowRepository delegate, JestClient client) {
        this(delegate, new RawIndexInitializer(client), new AggregateIndexInitializer(client));
    }

    private InitializingFlowRepository(FlowRepository delegate, DefaultTemplateInitializer ... initializers) {
        this.delegate = Objects.requireNonNull(delegate);
        this.initializers = Arrays.asList(initializers);
    }

    public void persist(Collection<? extends Flow> flows) throws FlowException {
        try {
            this.ensureInitialized();
            this.delegate.persist(flows);
        }
        catch (ConnectionPoolShutdownException ex) {
            throw new UnrecoverableFlowException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void ensureInitialized() {
        if (this.initialized.get()) {
            return;
        }
        for (DefaultTemplateInitializer initializer : this.initializers) {
            if (initializer.isInitialized()) continue;
            initializer.initialize();
        }
        this.initialized.set(true);
    }
}

