/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.category.AvailabilityIpInterface;
import org.opennms.web.category.AvailabilityMonitoredService;
import org.opennms.web.category.AvailabilityNode;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryList;
import org.opennms.web.category.CategoryModel;
import org.opennms.web.category.NodeList;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="availabilityRestService")
@Path(value="availability")
@Tag(name="Availability", description="Availability API")
@Transactional
@Produces(value={"application/xml", "application/json", "application/atom+xml"})
public class AvailabilityRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityRestService.class);
    private static CategoryList m_categoryList;
    @Autowired
    private NodeDao m_nodeDao;

    private static void assertCategoryListExists() throws ServletException {
        if (m_categoryList == null) {
            m_categoryList = new CategoryList();
        }
    }

    @GET
    public AvailabilityData getNodeAvailability() {
        try {
            return new AvailabilityData(m_categoryList.getCategoryData());
        }
        catch (IOException e) {
            LOG.warn("Failed to get availability data: {}", (Object)e.getMessage(), (Object)e);
            throw AvailabilityRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get availability data: {}", e.getMessage());
        }
    }

    @GET
    @Path(value="/categories/{category}")
    public Category getCategory(@PathParam(value="category") String categoryName) {
        try {
            String category = URLDecoder.decode(categoryName, StandardCharsets.UTF_8.name());
            Category cat = CategoryModel.getInstance().getCategory(category);
            if (cat == null) {
                throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Category {} was not found.", categoryName);
            }
            return cat;
        }
        catch (IOException e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get availability data for category {} : {}", categoryName, e.getMessage());
        }
    }

    @GET
    @Path(value="/categories/{category}/nodes")
    public NodeList getCategoryNodes(@PathParam(value="category") String categoryName) {
        try {
            String category = URLDecoder.decode(categoryName, StandardCharsets.UTF_8.name());
            Category cat = CategoryModel.getInstance().getCategory(category);
            if (cat == null) {
                throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Category {} was not found.", categoryName);
            }
            return cat.getNodes();
        }
        catch (IOException e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get availability data for category {} : {}", categoryName, e.getMessage());
        }
    }

    @GET
    @Path(value="/categories/{category}/nodes/{nodeId}")
    public AvailabilityNode getCategoryNode(@PathParam(value="category") String categoryName, @PathParam(value="nodeId") Long nodeId) {
        try {
            String category = URLDecoder.decode(categoryName, StandardCharsets.UTF_8.name());
            Category cat = CategoryModel.getInstance().getCategory(category);
            if (cat == null) {
                throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Category {} was not found.", categoryName);
            }
            AvailabilityNode node = cat.getNode(nodeId);
            if (node == null) {
                throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Node {} was not found for category {}.", Long.toString(nodeId), categoryName);
            }
            return this.getAvailabilityNode(node.getId().intValue());
        }
        catch (Exception e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get availability data for category {} : {}", categoryName, e.getMessage());
        }
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    public AvailabilityNode getNode(@PathParam(value="nodeId") Integer nodeId) {
        try {
            AvailabilityNode avail = this.getAvailabilityNode(nodeId);
            if (avail == null) {
                throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Node {} was not found.", Integer.toString(nodeId));
            }
            return avail;
        }
        catch (Exception e) {
            LOG.warn("Failed to get availability data for node {}: {}", new Object[]{nodeId, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, "Failed to get availability data for node {} : {}", nodeId.toString(), e.getMessage());
        }
    }

    AvailabilityNode getAvailabilityNode(int id) throws Exception {
        OnmsNode dbNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(id));
        this.initialize(dbNode);
        if (dbNode == null) {
            throw AvailabilityRestService.getException(Response.Status.NOT_FOUND, "Node {} was not found.", Integer.toString(id));
        }
        double nodeAvail = CategoryModel.getNodeAvailability((int)id);
        AvailabilityNode node = new AvailabilityNode(dbNode, nodeAvail);
        for (OnmsIpInterface iface : dbNode.getIpInterfaces()) {
            double ifaceAvail = CategoryModel.getInterfaceAvailability((int)id, (String)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
            AvailabilityIpInterface ai = new AvailabilityIpInterface(iface, ifaceAvail);
            for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
                double serviceAvail = CategoryModel.getServiceAvailability((int)id, (String)InetAddressUtils.str((InetAddress)iface.getIpAddress()), (int)svc.getServiceId());
                AvailabilityMonitoredService ams = new AvailabilityMonitoredService(svc, serviceAvail, !svc.isDown());
                ai.addService(ams);
            }
            node.addIpInterface(ai);
        }
        return node;
    }

    private void initialize(OnmsNode dbNode) {
        this.m_nodeDao.initialize((Object)dbNode);
        this.m_nodeDao.initialize((Object)dbNode.getIpInterfaces());
        for (OnmsIpInterface iface : dbNode.getIpInterfaces()) {
            this.m_nodeDao.initialize((Object)iface.getMonitoredServices());
        }
    }

    void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    static {
        try {
            AvailabilityRestService.assertCategoryListExists();
        }
        catch (ServletException e) {
            LOG.warn("Failed to create category list.", (Throwable)e);
        }
    }

    @XmlRootElement(name="categories")
    @JsonRootName(value="categories")
    private static final class CategoryRestList
    extends JaxbListWrapper<Category> {
        private static final long serialVersionUID = 1L;

        public CategoryRestList() {
        }

        public CategoryRestList(Collection<? extends Category> categories) {
            super(categories);
        }

        @XmlElement(name="category")
        @JsonProperty(value="category")
        public List<Category> getObjects() {
            return super.getObjects();
        }
    }

    @XmlRootElement(name="section")
    @XmlAccessorType(value=XmlAccessType.NONE)
    private static final class CategoryRestInfo {
        @XmlAttribute(name="name")
        private final String m_categoryName;
        @XmlElement(name="categories")
        private final CategoryRestList m_categories;

        public CategoryRestInfo() {
            this.m_categoryName = null;
            this.m_categories = new CategoryRestList();
        }

        public CategoryRestInfo(String categoryName, List<Category> categories) {
            this.m_categoryName = categoryName;
            this.m_categories = new CategoryRestList(categories);
        }
    }

    @XmlRootElement(name="availability")
    @XmlAccessorType(value=XmlAccessType.NONE)
    private static final class AvailabilityData {
        @XmlElement(name="section")
        private final List<CategoryRestInfo> m_categoryList = new ArrayList<CategoryRestInfo>();

        protected AvailabilityData() {
        }

        public AvailabilityData(Map<String, List<Category>> categoryData) {
            for (Map.Entry<String, List<Category>> entry : categoryData.entrySet()) {
                this.m_categoryList.add(new CategoryRestInfo(entry.getKey(), entry.getValue()));
            }
        }
    }
}

