/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support.menu;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opennms.core.resource.Vault;
import org.opennms.web.rest.support.menu.MainMenu;
import org.opennms.web.rest.support.menu.MenuEntry;
import org.opennms.web.rest.support.menu.MenuRequestContext;
import org.opennms.web.rest.support.menu.Notices;
import org.opennms.web.rest.support.menu.TileProviderItem;
import org.opennms.web.rest.support.menu.TopMenuEntry;
import org.opennms.web.rest.support.menu.xml.MenuXml;

public class MenuProvider {
    private final String ROLE_BASED_NAV_BAR_ENTRY_CLASS = "org.opennms.web.navigate.RoleBasedNavBarEntry";
    private final String ADMIN_ROLE_ICON = "fa-cogs";
    private static final ImmutableSet<String> ADMIN_ROLES = ImmutableSet.of((Object)"ROLE_ADMIN", (Object)"ROLE_FILESYSTEM_EDITOR");
    private String dispatcherServletPath;

    public MenuProvider(String dispatcherServletPath) {
        this.dispatcherServletPath = dispatcherServletPath;
    }

    public String getDispatcherServletPath() {
        return this.dispatcherServletPath;
    }

    public void setDispatcherServletPath(String path) {
        this.dispatcherServletPath = path;
    }

    public MainMenu getMainMenu(MenuRequestContext context) throws Exception, IOException {
        MainMenu mainMenu = new MainMenu();
        boolean isProvision = context.isUserInRole("ROLE_PROVISION");
        boolean isFlow = context.isUserInRole("ROLE_FLOW_MANAGER");
        boolean isAdmin = context.isUserInRole("ROLE_ADMIN");
        mainMenu.baseHref = context.calculateUrlBase();
        mainMenu.homeUrl = mainMenu.baseHref + "index.jsp";
        mainMenu.formattedTime = context.getFormattedTime();
        mainMenu.username = context.getRemoteUser();
        mainMenu.baseNodeUrl = "element/node.jsp?node=";
        mainMenu.noticeStatus = context.getNoticeStatus();
        mainMenu.notices = this.buildNotices(context);
        mainMenu.copyrightDates = String.format("2002-%d", LocalDate.now().getYear());
        mainMenu.version = Vault.getProperty((String)"version.display");
        List<TileProviderItem> tileProviders = this.getTileProviders();
        if (!tileProviders.isEmpty()) {
            mainMenu.userTileProviders.clear();
            mainMenu.userTileProviders.addAll(tileProviders);
        }
        MenuXml.BeansElement xBeans = null;
        String path = this.dispatcherServletPath;
        try (FileInputStream fis = new FileInputStream(path);){
            xBeans = this.parseDispatcherServletXml(fis);
        }
        List<TopMenuEntry> topMenuEntries = this.parseXmlToMenuEntries(xBeans);
        this.evaluateRoleBasedEntries(topMenuEntries, context);
        for (TopMenuEntry topMenu : topMenuEntries) {
            mainMenu.addTopMenu(topMenu);
        }
        mainMenu.helpMenu = this.getHelpMenuEntry(isAdmin);
        mainMenu.selfServiceMenu = this.getSelfServiceMenuEntry(context.getRemoteUser());
        mainMenu.userNotificationMenu = this.getUserNotificationMenu(context.getRemoteUser());
        if (isAdmin || isProvision) {
            mainMenu.provisionMenu = this.getProvisionMenu();
        }
        if (isFlow) {
            mainMenu.flowsMenu = this.getFlowsMenu();
        }
        if (isAdmin) {
            mainMenu.configurationMenu = this.getConfigurationMenu();
        }
        return mainMenu;
    }

    public MenuXml.BeansElement parseDispatcherServletXml(InputStream inputStream) {
        MenuXml.BeansElement xBeansElem = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MenuXml.BeansElement.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            xBeansElem = (MenuXml.BeansElement)jaxbUnmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            String string = e.getMessage();
        }
        return xBeansElem;
    }

    public List<TopMenuEntry> parseXmlToMenuEntries(MenuXml.BeansElement xBeansElem) throws Exception {
        ArrayList<TopMenuEntry> topMenuEntries = new ArrayList<TopMenuEntry>();
        Optional<MenuXml.BeanElement> xNavBarEntriesElem = xBeansElem.getBeans().stream().filter(b -> b.getId() != null && b.getId().equals("navBarEntries")).findFirst();
        if (!xNavBarEntriesElem.isPresent() || xNavBarEntriesElem.get().getConstructorArgElement() == null) {
            throw new Exception("Could not find 'navBarEntries' item");
        }
        List<MenuXml.BeanOrRefElement> xBeansOrRefs = xNavBarEntriesElem.get().getConstructorArgElement().getBeansOrRefs();
        for (MenuXml.BeanOrRefElement xTopLevelBeanOrRef : xBeansOrRefs) {
            Optional<TopMenuEntry> topEntry = Optional.empty();
            if (xTopLevelBeanOrRef instanceof MenuXml.BeanElement) {
                topEntry = this.parseTopMenuEntry((MenuXml.BeanElement)xTopLevelBeanOrRef);
            } else if (xTopLevelBeanOrRef instanceof MenuXml.BeanRefElement) {
                topEntry = this.parseTopMenuEntryFromRef((MenuXml.BeanRefElement)xTopLevelBeanOrRef, xBeansElem);
            }
            topEntry.ifPresent(topMenuEntries::add);
        }
        return topMenuEntries;
    }

    private void evaluateRoleBasedEntries(List<TopMenuEntry> topMenuEntries, MenuRequestContext context) {
        for (TopMenuEntry topEntry : topMenuEntries) {
            if (topEntry.items == null || topEntry.items.isEmpty()) continue;
            for (int i = topEntry.items.size() - 1; i >= 0; --i) {
                MenuEntry entry = topEntry.items.get(i);
                if (!this.evaluateRoleBasedMenuEntry(entry, context)) {
                    topEntry.items.remove(i);
                    continue;
                }
                if (!this.isInAnyRole((Set<String>)ADMIN_ROLES, entry)) continue;
                entry.iconType = "fa";
                entry.icon = "fa-cogs";
            }
        }
    }

    private boolean evaluateRoleBasedMenuEntry(MenuEntry menuEntry, MenuRequestContext context) {
        List<String> roles;
        if (menuEntry.className != null && menuEntry.className.equals("org.opennms.web.navigate.RoleBasedNavBarEntry") && !(roles = this.rolesAsList(menuEntry.roles)).isEmpty()) {
            if (roles.stream().noneMatch(context::isUserInRole)) {
                return false;
            }
        }
        return true;
    }

    private Optional<TopMenuEntry> parseTopMenuEntry(MenuXml.BeanElement xTopLevelBean) {
        TopMenuEntry topEntry = new TopMenuEntry();
        topEntry.id = xTopLevelBean.getId();
        topEntry.className = xTopLevelBean.getClassName();
        for (MenuXml.BeanPropertyElement prop : xTopLevelBean.getProperties()) {
            this.setFromBeanProperty(prop, "name", s -> {
                topEntry.name = s;
            });
            this.setFromBeanProperty(prop, "url", s -> {
                topEntry.url = s;
            });
            this.setFromBeanProperty(prop, "locationMatch", s -> {
                topEntry.locationMatch = s;
            });
            this.setFromBeanProperty(prop, "roles", s -> {
                topEntry.roles = s;
            });
        }
        boolean isValid = false;
        if (!Strings.isNullOrEmpty((String)topEntry.name) && !Strings.isNullOrEmpty((String)topEntry.url)) {
            isValid = true;
            MenuXml.BeanPropertyElement xEntries = xTopLevelBean.getProperties().stream().filter(p -> !Strings.isNullOrEmpty((String)p.getName()) && p.getName().equals("entries")).findFirst().orElse(null);
            if (xEntries != null) {
                for (MenuXml.BeanElement xBean : xEntries.getBeans()) {
                    MenuEntry menuEntry = new MenuEntry();
                    menuEntry.id = xBean.getId();
                    menuEntry.className = xBean.getClassName();
                    for (MenuXml.BeanPropertyElement prop : xBean.getProperties()) {
                        this.setFromBeanProperty(prop, "name", s -> {
                            menuEntry.name = s;
                        });
                        this.setFromBeanProperty(prop, "url", s -> {
                            menuEntry.url = s;
                        });
                        this.setFromBeanProperty(prop, "locationMatch", s -> {
                            menuEntry.locationMatch = s;
                        });
                        this.setFromBeanProperty(prop, "roles", s -> {
                            menuEntry.roles = s;
                        });
                    }
                    if (Strings.isNullOrEmpty((String)menuEntry.name) || Strings.isNullOrEmpty((String)menuEntry.url)) continue;
                    topEntry.addItem(menuEntry);
                }
            }
        }
        return isValid ? Optional.of(topEntry) : Optional.empty();
    }

    private TopMenuEntry getHelpMenuEntry(boolean isAdmin) {
        TopMenuEntry helpMenu = new TopMenuEntry();
        helpMenu.name = "Help";
        MenuEntry helpEntry = new MenuEntry();
        helpEntry.name = "Help";
        helpEntry.url = "help/index.jsp";
        helpEntry.iconType = "fa";
        helpEntry.icon = "fa-question-circle";
        helpMenu.addItem(helpEntry);
        MenuEntry aboutEntry = new MenuEntry();
        aboutEntry.name = "About";
        aboutEntry.url = "about/index.jsp";
        aboutEntry.iconType = "fa";
        aboutEntry.icon = "fa-info-circle";
        helpMenu.addItem(aboutEntry);
        MenuEntry apiDocumentationEntry = new MenuEntry();
        apiDocumentationEntry.name = "API Documentation";
        apiDocumentationEntry.url = "ui/index.html#/open-api";
        apiDocumentationEntry.iconType = "fa";
        apiDocumentationEntry.icon = "fa-info-circle";
        helpMenu.addItem(apiDocumentationEntry);
        if (isAdmin) {
            MenuEntry supportEntry = new MenuEntry();
            supportEntry.name = "Support";
            supportEntry.url = "support/index.jsp";
            supportEntry.iconType = "fa";
            supportEntry.icon = "fa-cogs";
            this.mergeRole(supportEntry, "ROLE_ADMIN");
            helpMenu.addItem(supportEntry);
        }
        return helpMenu;
    }

    private TopMenuEntry getSelfServiceMenuEntry(String username) {
        TopMenuEntry selfServiceMenu = new TopMenuEntry();
        selfServiceMenu.name = username;
        selfServiceMenu.url = "account/selfService/index.jsp";
        selfServiceMenu.iconType = "fa";
        selfServiceMenu.icon = "fa-user";
        MenuEntry changePasswordMenu = new MenuEntry();
        changePasswordMenu.name = "Change Password";
        changePasswordMenu.iconType = "fa";
        changePasswordMenu.icon = "fa-key";
        changePasswordMenu.url = "account/selfService/newPasswordEntry";
        selfServiceMenu.addItem(changePasswordMenu);
        MenuEntry logoutMenu = new MenuEntry();
        logoutMenu.id = "logout";
        logoutMenu.name = "Log Out";
        logoutMenu.iconType = "fa";
        logoutMenu.icon = "fa-sign-out";
        logoutMenu.url = "j_spring_security_logout";
        selfServiceMenu.addItem(logoutMenu);
        return selfServiceMenu;
    }

    private TopMenuEntry getUserNotificationMenu(String username) {
        TopMenuEntry notificationsMenu = new TopMenuEntry();
        MenuEntry userMenu = new MenuEntry();
        userMenu.url = "notification/browse?acktype=unack&filter=user==" + username;
        userMenu.id = "user";
        userMenu.icon = "fa-user";
        userMenu.iconType = "fa";
        notificationsMenu.addItem(userMenu);
        MenuEntry teamMenu = new MenuEntry();
        teamMenu.url = "notification/browse?acktype=unack";
        teamMenu.id = "team";
        teamMenu.icon = "fa-users";
        teamMenu.iconType = "fa";
        notificationsMenu.addItem(teamMenu);
        MenuEntry onCallMenu = new MenuEntry();
        onCallMenu.id = "oncall";
        onCallMenu.url = "roles";
        onCallMenu.name = "On-Call Schedule";
        onCallMenu.icon = "fa-calendar";
        onCallMenu.iconType = "fa";
        notificationsMenu.addItem(onCallMenu);
        return notificationsMenu;
    }

    private MenuEntry getProvisionMenu() {
        MenuEntry provisionMenu = new MenuEntry();
        provisionMenu.name = "Quick-Add Node";
        provisionMenu.url = "admin/ng-requisitions/quick-add-node.jsp#/";
        provisionMenu.iconType = "fa";
        provisionMenu.icon = "fa-plus-circle";
        this.mergeRole(provisionMenu, "ROLE_ADMIN");
        this.mergeRole(provisionMenu, "ROLE_PROVISION");
        return provisionMenu;
    }

    private MenuEntry getFlowsMenu() {
        MenuEntry flowsMenu = new MenuEntry();
        flowsMenu.name = "Flows Management";
        flowsMenu.url = "admin/classification/index.jsp";
        flowsMenu.iconType = "fa";
        flowsMenu.icon = "fa-minus-circle";
        this.mergeRole(flowsMenu, "ROLE_FLOW_MANAGER");
        return flowsMenu;
    }

    private MenuEntry getConfigurationMenu() {
        MenuEntry configurationMenu = new MenuEntry();
        configurationMenu.name = "Configure OpenNMS";
        configurationMenu.url = "admin/index.jsp";
        configurationMenu.iconType = "fa";
        configurationMenu.icon = "fa-cogs";
        this.mergeRole(configurationMenu, "ROLE_ADMIN");
        return configurationMenu;
    }

    private Notices buildNotices(MenuRequestContext context) {
        Notices notices = new Notices();
        notices.status = context.getNoticeStatus();
        return notices;
    }

    private Optional<TopMenuEntry> parseTopMenuEntryFromRef(MenuXml.BeanRefElement xBeanRefElement, MenuXml.BeansElement xBeansElem) {
        String refName = xBeanRefElement.getBeanRef();
        Optional<MenuXml.BeanElement> xBean = xBeansElem.getBeans().stream().filter(b -> b.getName() != null && b.getName().equals(refName)).findFirst();
        if (xBean.isPresent()) {
            return this.parseTopMenuEntry(xBean.get());
        }
        return Optional.empty();
    }

    private List<TileProviderItem> getTileProviders() {
        ArrayList<TileProviderItem> list = new ArrayList<TileProviderItem>();
        String name = System.getProperty("gwt.openlayers.name");
        String url = System.getProperty("gwt.openlayers.url");
        String attribution = System.getProperty("gwt.openlayers.options.attribution");
        String userDefinedAsDefault = System.getProperty("gwt.openlayers.userDefinedAsDefault");
        if (!Strings.isNullOrEmpty((String)url)) {
            TileProviderItem item = new TileProviderItem();
            item.name = !Strings.isNullOrEmpty((String)name) ? name : "User-Defined";
            item.url = url;
            item.attribution = !Strings.isNullOrEmpty((String)attribution) ? attribution : "";
            item.userDefinedAsDefault = !Strings.isNullOrEmpty((String)userDefinedAsDefault) && userDefinedAsDefault.equals("true");
            list.add(item);
        }
        return list;
    }

    private void setFromBeanProperty(MenuXml.BeanPropertyElement propElem, String name, Consumer<String> consumer) {
        if (propElem.getName() != null && propElem.getName().equals(name)) {
            consumer.accept(propElem.getValue());
        }
    }

    private void mergeRole(MenuEntry entry, String role) {
        String trimmedRole = role.trim();
        if (Strings.isNullOrEmpty((String)entry.roles)) {
            entry.roles = trimmedRole;
            return;
        }
        List<String> roles = this.rolesAsList(entry.roles);
        if (roles.stream().noneMatch(s -> s.equals(trimmedRole))) {
            roles.add(trimmedRole);
            entry.roles = String.join((CharSequence)",", roles);
        }
    }

    private List<String> rolesAsList(String roles) {
        if (Strings.isNullOrEmpty((String)roles)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(roles.split(",")));
    }

    private boolean isInRole(String role, MenuEntry entry) {
        return this.rolesAsList(entry.roles).stream().anyMatch(s -> s.equals(role));
    }

    private boolean isInAnyRole(Set<String> requiredRoles, MenuEntry entry) {
        List<String> entryRoles = this.rolesAsList(entry.roles);
        return entryRoles.stream().anyMatch(requiredRoles::contains);
    }
}

