/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support.menu;

import java.time.Instant;
import java.time.ZoneId;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.time.CentralizedDateTimeFormat;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.web.api.Util;
import org.opennms.web.rest.support.menu.MenuRequestContext;

public class HttpMenuRequestContext
implements MenuRequestContext {
    private final HttpServletRequest request;
    private final CentralizedDateTimeFormat dateTimeFormat = new CentralizedDateTimeFormat();

    public HttpMenuRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    @Override
    public String calculateUrlBase() {
        return Util.calculateUrlBase((HttpServletRequest)this.request);
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public String getFormattedTime() {
        return this.dateTimeFormat.format(Instant.now(), this.extractUserTimeZone());
    }

    @Override
    public String getNoticeStatus() {
        try {
            return NotifdConfigFactory.getPrettyStatus();
        }
        catch (Throwable throwable) {
            return "Unknown";
        }
    }

    private ZoneId extractUserTimeZone() {
        ZoneId timeZoneId = (ZoneId)this.request.getSession().getAttribute("org.opennms.ui.timezoneid");
        if (timeZoneId == null) {
            timeZoneId = ZoneId.systemDefault();
        }
        return timeZoneId;
    }
}

