/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.Capability;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UpdatePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Aggregator;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AsPath;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AsPathLimit;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AtomicAggregate;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.AttrSet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ClusterList;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Community;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Connector;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ExtendedCommunities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.ExtendedV6Communities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.LargeCommunities;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.LocalPref;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiExistDisc;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiprotocolReachableNlri;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.MultiprotocolUnreachableNlri;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.NextHop;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Origin;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.OriginatorId;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Unknown;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.InformationElement;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.InitiationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerDownPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerUpPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMirroringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMonitoringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.StatisticsReportPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.TerminationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.UnknownPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.LocalBgpNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.LocalNoNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.Reason;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.RemoteBgpNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.RemoteNoNotification;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.AdjRibIn;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.AdjRibOut;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.DuplicatePrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.DuplicateUpdate;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.DuplicateWithdraw;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.ExportRib;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.InvalidUpdateDueToAsConfedLoop;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.InvalidUpdateDueToAsPathLoop;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.InvalidUpdateDueToClusterListLoop;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.InvalidUpdateDueToOriginatorId;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.LocalRib;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.Metric;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.PerAfiAdjRibIn;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.PerAfiAdjRibOut;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.PerAfiExportRib;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.PerAfiLocalRib;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.PrefixTreatAsWithdraw;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.Rejected;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.UpdateTreatAsWithdraw;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.state.ParserState;
import org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpParser
implements TcpParser {
    public static final Logger LOG = LoggerFactory.getLogger(BmpParser.class);
    public static final RateLimitedLog RATE_LIMITED_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    public static final long HEARTBEAT_INTERVAL = 14400000L;
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;
    private final Meter recordsDispatched;
    private ScheduledFuture<?> heartbeatFuture;
    private Set<InetAddress> connections = Sets.newConcurrentHashSet();
    private final DnsResolver dnsResolver;
    private boolean dnsLookupsEnabled = true;
    private final Bulkhead bulkhead;

    public BmpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, DnsResolver dnsResolver, Bulkhead bulkhead, MetricRegistry metricRegistry) {
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.recordsDispatched = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsDispatched"}));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "BMP";
    }

    public void start(ScheduledExecutorService executorService) {
        this.sendHeartbeat(HeartbeatMode.STARTED, InetSocketAddress.createUnresolved("0.0.0.0", 0));
        this.heartbeatFuture = executorService.scheduleAtFixedRate(() -> this.sendHeartbeat(HeartbeatMode.PERIODIC, InetSocketAddress.createUnresolved("0.0.0.0", 0)), 14400000L, 14400000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.heartbeatFuture.cancel(false);
        this.sendHeartbeat(HeartbeatMode.STOPPED, InetSocketAddress.createUnresolved("0.0.0.0", 0));
    }

    public TcpParser.Handler accept(final InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        return new TcpParser.Handler(){
            private static final int ADD_PATH_CAP = 69;
            private InetAddress bgpId;
            private final Map<InetAddress, PeerInfo> peerInfoMap = new HashMap<InetAddress, PeerInfo>();
            private PeerAccessor peerAccessor = peerHeader -> {
                if (peerHeader == null || peerHeader.id == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(this.peerInfoMap.get(peerHeader.id));
            };

            public Optional<CompletableFuture<?>> parse(ByteBuf buffer) throws Exception {
                buffer.markReaderIndex();
                if (!buffer.isReadable(6)) {
                    buffer.resetReaderIndex();
                    return Optional.empty();
                }
                Header header = new Header(BufferUtils.slice((ByteBuf)buffer, (int)6));
                if (!buffer.isReadable(header.payloadLength())) {
                    buffer.resetReaderIndex();
                    return Optional.empty();
                }
                Packet packet = header.parsePayload(BufferUtils.slice((ByteBuf)buffer, (int)header.payloadLength()), this.peerAccessor);
                LOG.trace("Got packet: {}", (Object)packet);
                Transport.Message.Builder message = Transport.Message.newBuilder().setVersion(header.version);
                packet.accept(new Serializer(message));
                packet.accept(new Packet.Visitor.Adapter(){

                    @Override
                    public void visit(InitiationPacket packet) {
                        packet.information.first(InformationElement.Type.BGP_ID).map(InetAddressUtils::addr).ifPresent(_bgpId -> {
                            bgpId = _bgpId;
                        });
                    }
                });
                packet.accept(new Packet.Visitor.Adapter(){

                    @Override
                    public void visit(PeerUpPacket packet) {
                        packet.sendOpenMessage.ifPresent(msg -> msg.capabilities.stream().filter(c -> c.getCode() == 69).forEach(c -> {
                            ByteBuf b = Unpooled.wrappedBuffer((byte[])c.getValue().toByteArray());
                            int afi = BufferUtils.uint16((ByteBuf)b);
                            int safi = BufferUtils.uint8((ByteBuf)b);
                            int sendReceive = BufferUtils.uint8((ByteBuf)b);
                            peerInfoMap.computeIfAbsent(packet.peerHeader.id, k -> new PeerInfo()).addPathCapability(afi, safi, sendReceive, true);
                        }));
                        packet.recvOpenMessage.ifPresent(msg -> msg.capabilities.stream().filter(c -> c.getCode() == 69).forEach(c -> {
                            ByteBuf b = Unpooled.wrappedBuffer((byte[])c.getValue().toByteArray());
                            int afi = BufferUtils.uint16((ByteBuf)b);
                            int safi = BufferUtils.uint8((ByteBuf)b);
                            int sendReceive = BufferUtils.uint8((ByteBuf)b);
                            peerInfoMap.computeIfAbsent(packet.peerHeader.id, k -> new PeerInfo()).addPathCapability(afi, safi, sendReceive, false);
                        }));
                    }
                });
                if (this.bgpId != null) {
                    message.setBgpId(BmpParser.address(this.bgpId));
                }
                CompletionStage<Object> enriched = CompletableFuture.completedFuture(message);
                if (BmpParser.this.dnsLookupsEnabled) {
                    try {
                        BmpParser.this.bulkhead.acquirePermission();
                        enriched = ((CompletableFuture)((CompletableFuture)enriched).thenCompose(BmpParser.this.resolvePeer(packet))).thenCompose(BmpParser.this.resolveSysName(packet, remoteAddress.getAddress()));
                        ((CompletableFuture)enriched).whenComplete((v, e) -> BmpParser.this.bulkhead.releasePermission());
                    }
                    catch (BulkheadFullException bfe) {
                        RATE_LIMITED_LOG.warn("Skipping enrichment. Too many requests already in flight (bulk-head is full).");
                    }
                }
                CompletableFuture dispatched = new CompletableFuture();
                ((CompletableFuture)enriched).whenComplete((msg, e) -> {
                    ByteBuffer payload = ByteBuffer.wrap(msg.build().toByteArray());
                    CompletableFuture dispatchFuture = BmpParser.this.dispatcher.send((Message)new TelemetryMessage(remoteAddress, payload));
                    BmpParser.this.recordsDispatched.mark();
                    dispatchFuture.whenComplete((status, ex) -> {
                        if (ex != null) {
                            dispatched.completeExceptionally((Throwable)ex);
                        } else {
                            dispatched.complete(status);
                        }
                    });
                });
                return Optional.of(dispatched);
            }

            public void active() {
                BmpParser.this.connections.add(remoteAddress.getAddress());
                BmpParser.this.sendHeartbeat(HeartbeatMode.CHANGE, remoteAddress);
            }

            public void inactive() {
                BmpParser.this.connections.remove(remoteAddress.getAddress());
                BmpParser.this.sendHeartbeat(HeartbeatMode.CHANGE, remoteAddress);
            }
        };
    }

    public Object dumpInternalState() {
        return ParserState.builder().withConnections(this.connections).build();
    }

    private Function<Transport.Message.Builder, CompletableFuture<Transport.Message.Builder>> resolvePeer(Packet packet) {
        return message -> packet.map(new Packet.Mapper.Adapter<CompletableFuture<Transport.Message.Builder>>(CompletableFuture.completedFuture(message)){

            private CompletableFuture<Transport.Message.Builder> resolvePeer(PeerHeader peerHeader, Transport.Peer.Builder builder) {
                return BmpParser.this.dnsResolver.reverseLookup(peerHeader.address).thenApply(hostname -> {
                    hostname.ifPresent(arg_0 -> ((Transport.Peer.Builder)builder).setHostname(arg_0));
                    return message;
                });
            }

            @Override
            public CompletableFuture<Transport.Message.Builder> map(PeerUpPacket packet) {
                return this.resolvePeer(packet.peerHeader, message.getPeerUpBuilder().getPeerBuilder());
            }

            @Override
            public CompletableFuture<Transport.Message.Builder> map(PeerDownPacket packet) {
                return this.resolvePeer(packet.peerHeader, message.getPeerDownBuilder().getPeerBuilder());
            }

            @Override
            public CompletableFuture<Transport.Message.Builder> map(StatisticsReportPacket packet) {
                return this.resolvePeer(packet.peerHeader, message.getStatisticsReportBuilder().getPeerBuilder());
            }

            @Override
            public CompletableFuture<Transport.Message.Builder> map(RouteMonitoringPacket packet) {
                return this.resolvePeer(packet.peerHeader, message.getRouteMonitoringBuilder().getPeerBuilder());
            }
        });
    }

    private Function<Transport.Message.Builder, CompletableFuture<Transport.Message.Builder>> resolveSysName(Packet packet, final InetAddress sourceAddress) {
        return message -> packet.map(new Packet.Mapper.Adapter<CompletableFuture<Transport.Message.Builder>>(CompletableFuture.completedFuture(message)){

            @Override
            public CompletableFuture<Transport.Message.Builder> map(InitiationPacket packet) {
                return BmpParser.this.dnsResolver.reverseLookup(sourceAddress).thenApply(hostname -> {
                    hostname.ifPresent(arg_0 -> ((Transport.InitiationPacket.Builder)message.getInitiationBuilder()).setHostname(arg_0));
                    return message;
                });
            }
        });
    }

    private void sendHeartbeat(HeartbeatMode mode, InetSocketAddress remoteAddress) {
        Transport.Message.Builder message = Transport.Message.newBuilder();
        message.getHeartbeatBuilder().setMode(mode.map(m -> {
            switch (m) {
                case STARTED: {
                    return Transport.Heartbeat.Mode.STARTED;
                }
                case STOPPED: {
                    return Transport.Heartbeat.Mode.STOPPED;
                }
                case PERIODIC: {
                    return Transport.Heartbeat.Mode.PERIODIC;
                }
                case CHANGE: {
                    return Transport.Heartbeat.Mode.CHANGE;
                }
            }
            throw new IllegalStateException();
        })).addAllRouters(Iterables.transform(this.connections, BmpParser::address));
        this.dispatcher.send((Message)new TelemetryMessage(remoteAddress, ByteBuffer.wrap(message.build().toByteArray())));
        this.recordsDispatched.mark();
    }

    public boolean isDnsLookupsEnabled() {
        return this.dnsLookupsEnabled;
    }

    public void setDnsLookupsEnabled(boolean dnsLookupsEnabled) {
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    private static Transport.RouteMonitoringPacket.PathAttribute.Builder pathAttribute(UpdatePacket.PathAttribute attribute) {
        final Transport.RouteMonitoringPacket.PathAttribute.Builder attributesBuilder = Transport.RouteMonitoringPacket.PathAttribute.newBuilder();
        attributesBuilder.setOptional(attribute.optional).setTransitive(attribute.transitive).setPartial(attribute.partial).setExtended(attribute.extended);
        attribute.attribute.accept(new Attribute.Visitor(){

            @Override
            public void visit(Aggregator aggregator) {
                attributesBuilder.getAggregatorBuilder().setAs(aggregator.as).setAddress(BmpParser.address(aggregator.address));
            }

            @Override
            public void visit(AsPath asPath) {
                Transport.RouteMonitoringPacket.PathAttribute.AsPath.Builder asPathBuilder = attributesBuilder.getAsPathBuilder();
                for (AsPath.Segment segment : asPath.segments) {
                    Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Builder segmentBuilder = asPathBuilder.addSegmentsBuilder();
                    segmentBuilder.setType(segment.type.map(t -> {
                        switch (t) {
                            case AS_SET: {
                                return Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.AS_SET;
                            }
                            case AS_SEQUENCE: {
                                return Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.AS_SEQUENCE;
                            }
                            case UNKNOWN: {
                                return Transport.RouteMonitoringPacket.PathAttribute.AsPath.Segment.Type.UNRECOGNIZED;
                            }
                        }
                        throw new IllegalStateException();
                    }));
                    for (long as : segment.path) {
                        segmentBuilder.addPaths((int)as);
                    }
                }
            }

            @Override
            public void visit(AtomicAggregate atomicAggregate) {
                attributesBuilder.getAtomicAggregateBuilder();
            }

            @Override
            public void visit(LocalPref localPref) {
                attributesBuilder.getLocalPrefBuilder().setPreference((int)localPref.preference);
            }

            @Override
            public void visit(MultiExistDisc multiExistDisc) {
                attributesBuilder.getMultiExitDiscBuilder().setDiscriminator((int)multiExistDisc.discriminator);
            }

            @Override
            public void visit(NextHop nextHop) {
                attributesBuilder.getNextHopBuilder().setAddress(BmpParser.address(nextHop.address));
            }

            @Override
            public void visit(Origin origin) {
                attributesBuilder.setOrigin(origin.value.map(v -> {
                    switch (v) {
                        case IGP: {
                            return Transport.RouteMonitoringPacket.PathAttribute.Origin.IGP;
                        }
                        case EGP: {
                            return Transport.RouteMonitoringPacket.PathAttribute.Origin.EGP;
                        }
                        case INCOMPLETE: {
                            return Transport.RouteMonitoringPacket.PathAttribute.Origin.INCOMPLETE;
                        }
                        case UNKNOWN: {
                            return Transport.RouteMonitoringPacket.PathAttribute.Origin.UNRECOGNIZED;
                        }
                    }
                    throw new IllegalStateException();
                }));
            }

            @Override
            public void visit(Community community) {
                attributesBuilder.setCommunity((int)community.community);
            }

            @Override
            public void visit(OriginatorId originatorId) {
                attributesBuilder.setOriginatorId((int)originatorId.originatorId);
            }

            @Override
            public void visit(ClusterList clusterList) {
                Transport.RouteMonitoringPacket.PathAttribute.ClusterList.Builder clusterListBuilder = Transport.RouteMonitoringPacket.PathAttribute.ClusterList.newBuilder();
                for (InetAddress clusterId : clusterList.clusterIds) {
                    clusterListBuilder.addClusterId(BmpParser.address(clusterId));
                }
                attributesBuilder.setClusterList(clusterListBuilder);
            }

            @Override
            public void visit(ExtendedCommunities extendedCommunities) {
                Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.Builder extendedCommunitiesBuilder = Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunities.newBuilder();
                for (ExtendedCommunities.ExtendedCommunity extendedCommunity : extendedCommunities.extendedCommunities) {
                    Transport.RouteMonitoringPacket.PathAttribute.ExtendedCommunity.Builder builder = extendedCommunitiesBuilder.addExtendedCommunitiesBuilder().setHighType(extendedCommunity.highType).setLowType(extendedCommunity.lowType).setAuthoritative(extendedCommunity.authoritative).setTransitive(extendedCommunity.transitive);
                    if (extendedCommunity.value == null) continue;
                    builder.setType(extendedCommunity.value.type).setValue(extendedCommunity.value.value);
                }
                attributesBuilder.setExtendedCommunities(extendedCommunitiesBuilder);
            }

            @Override
            public void visit(ExtendedV6Communities extendedV6Communities) {
                Transport.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities.Builder extendedV6CommunitiesBuilder = Transport.RouteMonitoringPacket.PathAttribute.ExtendedV6Communities.newBuilder();
                for (ExtendedV6Communities.ExtendedV6Community extendedCommunity : extendedV6Communities.extendedCommunities) {
                    extendedV6CommunitiesBuilder.addExtendedCommunitiesBuilder().setHighType(extendedCommunity.highType).setLowType(extendedCommunity.lowType).setAuthoritative(extendedCommunity.authoritative).setTransitive(extendedCommunity.transitive).setType(extendedCommunity.value.type).setValue(extendedCommunity.value.value);
                }
                attributesBuilder.setExtendedV6Communities(extendedV6CommunitiesBuilder);
            }

            @Override
            public void visit(Connector connector) {
                attributesBuilder.setConnector(connector.connector);
            }

            @Override
            public void visit(AsPathLimit asPathLimit) {
                attributesBuilder.setAsPathLimit(Transport.RouteMonitoringPacket.PathAttribute.AsPathLimit.newBuilder().setUpperBound(asPathLimit.upperBound).setAs((int)asPathLimit.as).build());
            }

            @Override
            public void visit(LargeCommunities largeCommunities) {
                Transport.RouteMonitoringPacket.PathAttribute.LargeCommunities.Builder largeCommunitiesBuilder = Transport.RouteMonitoringPacket.PathAttribute.LargeCommunities.newBuilder();
                for (LargeCommunities.LargeCommunity largeCommunity : largeCommunities.largeCommunities) {
                    largeCommunitiesBuilder.addLargeCommunitiesBuilder().setGlobalAdministrator((int)largeCommunity.globalAdministrator).setLocalDataPart1((int)largeCommunity.localDataPart1).setLocalDataPart2((int)largeCommunity.localDataPart2);
                }
                attributesBuilder.setLargeCommunities(largeCommunitiesBuilder);
            }

            @Override
            public void visit(AttrSet attrSet) {
                Transport.RouteMonitoringPacket.PathAttribute.AttrSet.Builder attrSetBuilder = Transport.RouteMonitoringPacket.PathAttribute.AttrSet.newBuilder().setOriginAs((int)attrSet.originAs);
                for (UpdatePacket.PathAttribute attribute : attrSet.pathAttributes) {
                    attrSetBuilder.addPathAttributes(BmpParser.pathAttribute(attribute));
                }
                attributesBuilder.setAttrSet(attrSetBuilder);
            }

            @Override
            public void visit(Unknown unknown) {
            }

            @Override
            public void visit(MultiprotocolReachableNlri multiprotocolReachableNrli) {
                Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli mpReachNrli = Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolReachableNrli.newBuilder().addAllAdvertised((Iterable)multiprotocolReachableNrli.advertised.stream().map(r -> Transport.RouteMonitoringPacket.Route.newBuilder().setLabels(r.labels != null ? r.labels : "").setLength(r.length).setPathId(r.pathId).setPrefix(BmpParser.address(r.prefix)).build()).collect(Collectors.toList())).addAllVpnAdvertised((Iterable)multiprotocolReachableNrli.vpnAdvertised.stream().map(r -> Transport.RouteMonitoringPacket.Route.newBuilder().setLabels(r.labels != null ? r.labels : "").setLength(r.length).setPathId(r.pathId).setPrefix(BmpParser.address(r.prefix)).build()).collect(Collectors.toList())).setAfi(multiprotocolReachableNrli.afi).setSafi(multiprotocolReachableNrli.safi).setNextHop(BmpParser.address(multiprotocolReachableNrli.nextHop)).build();
                attributesBuilder.setMpReachNrli(mpReachNrli);
            }

            @Override
            public void visit(MultiprotocolUnreachableNlri multiprotocolUnreachableNlri) {
                Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli mpReachNrli = Transport.RouteMonitoringPacket.PathAttribute.MultiprotocolUnreachableNrli.newBuilder().addAllWithdrawn((Iterable)multiprotocolUnreachableNlri.withdrawn.stream().map(r -> Transport.RouteMonitoringPacket.Route.newBuilder().setLabels(r.labels != null ? r.labels : "").setLength(r.length).setPathId(r.pathId).setPrefix(BmpParser.address(r.prefix)).build()).collect(Collectors.toList())).addAllVpnWithdrawn((Iterable)multiprotocolUnreachableNlri.vpnWithdrawn.stream().map(r -> Transport.RouteMonitoringPacket.Route.newBuilder().setLabels(r.labels != null ? r.labels : "").setLength(r.length).setPathId(r.pathId).setPrefix(BmpParser.address(r.prefix)).build()).collect(Collectors.toList())).setAfi(multiprotocolUnreachableNlri.afi).setSafi(multiprotocolUnreachableNlri.safi).build();
                attributesBuilder.setMpUnreachNrli(mpReachNrli);
            }
        });
        return attributesBuilder;
    }

    public static Transport.IpAddress address(InetAddress address) {
        Transport.IpAddress.Builder builder = Transport.IpAddress.newBuilder();
        if (address instanceof Inet4Address) {
            builder.setV4(ByteString.copyFrom((byte[])address.getAddress()));
        } else if (address instanceof Inet6Address) {
            builder.setV6(ByteString.copyFrom((byte[])address.getAddress()));
        } else {
            throw new IllegalStateException();
        }
        return builder.build();
    }

    private static class Serializer
    implements Packet.Visitor {
        private final Transport.Message.Builder message;

        private Serializer(Transport.Message.Builder message) {
            this.message = Objects.requireNonNull(message);
        }

        private static Transport.Peer peer(PeerHeader peerHeader) {
            Transport.Peer.Builder peer = Transport.Peer.newBuilder();
            peer.setType(peerHeader.type.map(v -> {
                switch (v) {
                    case GLOBAL_INSTANCE: {
                        return Transport.Peer.Type.GLOBAL_INSTANCE;
                    }
                    case RD_INSTANCE: {
                        return Transport.Peer.Type.RD_INSTANCE;
                    }
                    case LOCAL_INSTANCE: {
                        return Transport.Peer.Type.LOCAL_INSTANCE;
                    }
                }
                throw new IllegalStateException();
            }));
            if (peerHeader.type == PeerHeader.Type.LOC_RIB_INSTANCE) {
                Transport.Peer.LocRibFlags.Builder locRibFlags = peer.getLocRibFlagsBuilder();
                locRibFlags.setFiltered(peerHeader.locRibFlags.filtered);
                peer.setLocRibFlags(locRibFlags.build());
            } else {
                Transport.Peer.PeerFlags.Builder peerFlags = peer.getPeerFlagsBuilder();
                peerFlags.setIpVersion(peerHeader.flags.addressVersion.map(v -> {
                    switch (v) {
                        case IP_V4: {
                            return Transport.Peer.PeerFlags.IpVersion.IP_V4;
                        }
                        case IP_V6: {
                            return Transport.Peer.PeerFlags.IpVersion.IP_V6;
                        }
                    }
                    throw new IllegalStateException();
                }));
                peerFlags.setPolicy(peerHeader.flags.policy.map(v -> {
                    switch (v) {
                        case PRE_POLICY: {
                            return Transport.Peer.PeerFlags.Policy.PRE_POLICY;
                        }
                        case POST_POLICY: {
                            return Transport.Peer.PeerFlags.Policy.POST_POLICY;
                        }
                    }
                    throw new IllegalStateException();
                }));
                peerFlags.setLegacyAsPath(peerHeader.flags.legacyASPath);
                peerFlags.setAdjIn(peerHeader.flags.adjIn);
                peer.setPeerFlags(peerFlags.build());
            }
            peer.setDistinguisher(peerHeader.distinguisher.longValue());
            peer.setAddress(BmpParser.address(peerHeader.address));
            peer.setAs((int)peerHeader.as);
            peer.setId(BmpParser.address(peerHeader.id));
            peer.getTimestampBuilder().setSeconds(peerHeader.timestamp.getEpochSecond()).setNanos(peerHeader.timestamp.getNano());
            return peer.build();
        }

        @Override
        public void visit(InitiationPacket packet) {
            Transport.InitiationPacket.Builder message = this.message.getInitiationBuilder();
            message.setSysName(packet.information.first(InformationElement.Type.SYS_NAME).orElse(""));
            message.addAllSysDesc((Iterable)packet.information.all(InformationElement.Type.SYS_DESCR).collect(Collectors.toList()));
            message.addAllMessage((Iterable)packet.information.all(InformationElement.Type.STRING).collect(Collectors.toList()));
            packet.information.first(InformationElement.Type.BGP_ID).map(addr -> BmpParser.address(InetAddressUtils.addr((String)addr))).ifPresent(arg_0 -> ((Transport.InitiationPacket.Builder)message).setBgpId(arg_0));
        }

        @Override
        public void visit(TerminationPacket packet) {
            final Transport.TerminationPacket.Builder message = this.message.getTerminationBuilder();
            Iterator iterator = packet.information.iterator();
            while (iterator.hasNext()) {
                TerminationPacket.Element information = (TerminationPacket.Element)iterator.next();
                ((TerminationPacket.Information)information.value).accept(new TerminationPacket.Information.Visitor(){

                    @Override
                    public void visit(TerminationPacket.StringInformation string) {
                        message.addMessage(string.string);
                    }

                    @Override
                    public void visit(TerminationPacket.ReasonInformation reason) {
                        message.setReason(reason.reason);
                    }

                    @Override
                    public void visit(TerminationPacket.UnknownInformation unknown) {
                        message.getUnknownBuilder();
                    }
                });
            }
        }

        @Override
        public void visit(PeerUpPacket packet) {
            Transport.PeerUpPacket.Builder message = this.message.getPeerUpBuilder();
            message.setPeer(Serializer.peer(packet.peerHeader));
            message.setLocalAddress(BmpParser.address(packet.localAddress));
            message.setLocalPort(packet.localPort);
            message.setRemotePort(packet.remotePort);
            Transport.PeerUpPacket.CapabilityList.Builder sendCapabilitiesBuilder = Transport.PeerUpPacket.CapabilityList.newBuilder();
            packet.sendOpenMessage.ifPresent(sendOpenMessage -> {
                for (Capability capability : sendOpenMessage.capabilities) {
                    sendCapabilitiesBuilder.addCapability(Transport.PeerUpPacket.Capability.newBuilder().setCode(capability.getCode()).setLength(capability.getLength()).setValue(capability.getValue()).build());
                }
                message.getSendMsgBuilder().setVersion(sendOpenMessage.version).setAs(sendOpenMessage.as).setHoldTime(sendOpenMessage.holdTime).setId(BmpParser.address(sendOpenMessage.id)).setCapabilities(sendCapabilitiesBuilder.build());
            });
            packet.recvOpenMessage.ifPresent(recvOpenMessage -> {
                Transport.PeerUpPacket.CapabilityList.Builder recvCapabilitiesBuilder = Transport.PeerUpPacket.CapabilityList.newBuilder();
                for (Capability capability : recvOpenMessage.capabilities) {
                    recvCapabilitiesBuilder.addCapability(Transport.PeerUpPacket.Capability.newBuilder().setCode(capability.getCode()).setLength(capability.getLength()).setValue(capability.getValue()).build());
                }
                message.getRecvMsgBuilder().setVersion(recvOpenMessage.version).setAs(recvOpenMessage.as).setHoldTime(recvOpenMessage.holdTime).setId(BmpParser.address(recvOpenMessage.id)).setCapabilities(recvCapabilitiesBuilder.build());
            });
            message.setSysName(packet.information.first(InformationElement.Type.SYS_NAME).orElse(""));
            message.setTableName(packet.information.first(InformationElement.Type.VRF_TABLE_NAME).orElse(""));
            message.setSysDesc(packet.information.all(InformationElement.Type.SYS_DESCR).collect(Collectors.joining("\n")));
            message.setMessage(packet.information.all(InformationElement.Type.STRING).collect(Collectors.joining("\n")));
        }

        @Override
        public void visit(PeerDownPacket packet) {
            final Transport.PeerDownPacket.Builder message = this.message.getPeerDownBuilder();
            message.setPeer(Serializer.peer(packet.peerHeader));
            packet.reason.accept(new Reason.Visitor(){

                @Override
                public void visit(LocalBgpNotification localBgpNotification) {
                    localBgpNotification.notification.ifPresent(notification -> message.getLocalBgpNotificationBuilder().setCode(notification.code).setSubcode(notification.subcode));
                }

                @Override
                public void visit(LocalNoNotification localNoNotification) {
                    message.setLocalNoNotification(localNoNotification.code);
                }

                @Override
                public void visit(RemoteBgpNotification remoteBgpNotification) {
                    remoteBgpNotification.notification.ifPresent(notification -> message.getRemoteBgpNotificationBuilder().setCode(notification.code).setSubcode(notification.subcode));
                }

                @Override
                public void visit(RemoteNoNotification remoteNoNotification) {
                    message.setRemoteNoNotification(Empty.getDefaultInstance());
                }

                @Override
                public void visit(org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.down.Unknown unknown) {
                    message.setUnknown(Empty.getDefaultInstance());
                }
            });
        }

        @Override
        public void visit(StatisticsReportPacket packet) {
            final Transport.StatisticsReportPacket.Builder message = this.message.getStatisticsReportBuilder();
            message.setPeer(Serializer.peer(packet.peerHeader));
            Iterator iterator = packet.statistics.iterator();
            while (iterator.hasNext()) {
                StatisticsReportPacket.Element statistic = (StatisticsReportPacket.Element)iterator.next();
                ((Metric)statistic.value).accept(new Metric.Visitor(){

                    @Override
                    public void visit(DuplicatePrefix duplicatePrefix) {
                        message.getDuplicatePrefixBuilder().setCount((int)duplicatePrefix.counter);
                    }

                    @Override
                    public void visit(DuplicateWithdraw duplicateWithdraw) {
                        message.getDuplicateWithdrawBuilder().setCount((int)duplicateWithdraw.counter);
                    }

                    @Override
                    public void visit(AdjRibIn adjRibIn) {
                        message.getAdjRibInBuilder().setValue(adjRibIn.gauge.longValue());
                    }

                    @Override
                    public void visit(AdjRibOut adjRibOut) {
                        message.getAdjRibOutBuilder().setValue(adjRibOut.gauge.longValue());
                    }

                    @Override
                    public void visit(ExportRib exportRib) {
                        message.getExportRibBuilder().setValue(exportRib.gauge.longValue());
                    }

                    @Override
                    public void visit(InvalidUpdateDueToAsConfedLoop invalidUpdateDueToAsConfedLoop) {
                        message.getInvalidUpdateDueToAsConfedLoopBuilder().setCount((int)invalidUpdateDueToAsConfedLoop.counter);
                    }

                    @Override
                    public void visit(InvalidUpdateDueToAsPathLoop invalidUpdateDueToAsPathLoop) {
                        message.getInvalidUpdateDueToAsPathLoopBuilder().setCount((int)invalidUpdateDueToAsPathLoop.counter);
                    }

                    @Override
                    public void visit(InvalidUpdateDueToClusterListLoop invalidUpdateDueToClusterListLoop) {
                        message.getInvalidUpdateDueToClusterListLoopBuilder().setCount((int)invalidUpdateDueToClusterListLoop.counter);
                    }

                    @Override
                    public void visit(InvalidUpdateDueToOriginatorId invalidUpdateDueToOriginatorId) {
                        message.getInvalidUpdateDueToOriginatorIdBuilder().setCount((int)invalidUpdateDueToOriginatorId.counter);
                    }

                    @Override
                    public void visit(PerAfiAdjRibIn perAfiAdjRibIn) {
                        String key = String.format("%d:%d", perAfiAdjRibIn.afi, perAfiAdjRibIn.safi);
                        message.putPerAfiAdjRibIn(key, Transport.StatisticsReportPacket.Gauge.newBuilder().setValue(perAfiAdjRibIn.gauge.longValue()).build());
                    }

                    @Override
                    public void visit(PerAfiLocalRib perAfiLocalRib) {
                        String key = String.format("%d:%d", perAfiLocalRib.afi, perAfiLocalRib.safi);
                        message.putPerAfiLocalRib(key, Transport.StatisticsReportPacket.Gauge.newBuilder().setValue(perAfiLocalRib.gauge.longValue()).build());
                    }

                    @Override
                    public void visit(PrefixTreatAsWithdraw prefixTreatAsWithdraw) {
                        message.getPrefixTreatAsWithdrawBuilder().setCount((int)prefixTreatAsWithdraw.counter);
                    }

                    @Override
                    public void visit(UpdateTreatAsWithdraw updateTreatAsWithdraw) {
                        message.getUpdateTreatAsWithdrawBuilder().setCount((int)updateTreatAsWithdraw.counter);
                    }

                    @Override
                    public void visit(LocalRib localRib) {
                        message.getLocalRibBuilder().setValue(localRib.gauge.longValue());
                    }

                    @Override
                    public void visit(DuplicateUpdate duplicateUpdate) {
                        message.getDuplicateUpdateBuilder().setCount((int)duplicateUpdate.counter);
                    }

                    @Override
                    public void visit(Rejected rejected) {
                        message.getRejectedBuilder().setCount((int)rejected.counter);
                    }

                    @Override
                    public void visit(PerAfiAdjRibOut perAfiAdjRibOut) {
                        String key = String.format("%d:%d", perAfiAdjRibOut.afi, perAfiAdjRibOut.safi);
                        message.putPerAfiAdjRibOut(key, Transport.StatisticsReportPacket.Gauge.newBuilder().setValue(perAfiAdjRibOut.gauge.longValue()).build());
                    }

                    @Override
                    public void visit(PerAfiExportRib perAfiExportRib) {
                        String key = String.format("%d:%d", perAfiExportRib.afi, perAfiExportRib.safi);
                        message.putPerAfiExportRib(key, Transport.StatisticsReportPacket.Gauge.newBuilder().setValue(perAfiExportRib.gauge.longValue()).build());
                    }

                    @Override
                    public void visit(org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.stats.Unknown unknown) {
                    }
                });
            }
        }

        @Override
        public void visit(RouteMonitoringPacket packet) {
            Transport.RouteMonitoringPacket.Builder message = this.message.getRouteMonitoringBuilder();
            message.setPeer(Serializer.peer(packet.peerHeader));
            packet.updateMessage.ifPresent(updateMessage -> {
                for (UpdatePacket.Prefix prefix : updateMessage.withdrawRoutes) {
                    message.addWithdrawsBuilder().setPrefix(BmpParser.address(prefix.prefix)).setLength(prefix.length);
                }
                for (UpdatePacket.Prefix prefix : updateMessage.reachableRoutes) {
                    message.addReachablesBuilder().setPrefix(BmpParser.address(prefix.prefix)).setLength(prefix.length);
                }
                for (UpdatePacket.PathAttribute attribute : updateMessage.pathAttributes) {
                    message.addAttributes(BmpParser.pathAttribute(attribute));
                }
            });
        }

        @Override
        public void visit(RouteMirroringPacket packet) {
        }

        @Override
        public void visit(UnknownPacket packet) {
        }
    }

    private static enum HeartbeatMode {
        STARTED,
        CHANGE,
        PERIODIC,
        STOPPED;


        public <R> R map(Function<HeartbeatMode, R> mapper) {
            return mapper.apply(this);
        }
    }
}

