/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api.functions.reduce;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.AbstractReductionFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.reduce.ReductionFunctionEntityVisitor;

@Entity
@DiscriminatorValue(value="threshold")
public class ThresholdEntity
extends AbstractReductionFunctionEntity {
    @Column(name="threshold", nullable=false)
    private float m_threshold;

    public ThresholdEntity() {
    }

    public ThresholdEntity(float threshold) {
        this.setThreshold(threshold);
    }

    public void setThreshold(float threshold) {
        Preconditions.checkArgument((threshold > 0.0f ? 1 : 0) != 0, (Object)"threshold must be strictly positive");
        Preconditions.checkArgument((threshold <= 1.0f ? 1 : 0) != 0, (Object)"threshold must be less or equal to 1");
        this.m_threshold = threshold;
    }

    public float getThreshold() {
        return this.m_threshold;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("threshold", this.m_threshold).toString();
    }

    @Override
    public <T> T accept(ReductionFunctionEntityVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

