/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.SingleResultQuerier;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.config.translator.Assignment;
import org.opennms.netmgt.config.translator.EventTranslationSpec;
import org.opennms.netmgt.config.translator.EventTranslatorConfiguration;
import org.opennms.netmgt.config.translator.Mapping;
import org.opennms.netmgt.config.translator.Value;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyAccessorFactory;

public final class EventTranslatorConfigFactory
implements EventTranslatorConfig {
    private static final Logger LOG = LoggerFactory.getLogger(EventTranslatorConfigFactory.class);
    private static EventTranslatorConfig m_singleton = null;
    private EventTranslatorConfiguration m_config;
    private List<TranslationSpec> m_translationSpecs;
    private static boolean m_loaded = false;
    private DataSource m_dbConnFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventTranslatorConfigFactory(String configFile, DataSource dbConnFactory) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.unmarshall(stream, dbConnFactory);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public EventTranslatorConfigFactory(InputStream rdr, DataSource dbConnFactory) throws IOException {
        this.unmarshall(rdr, dbConnFactory);
    }

    private synchronized void unmarshall(InputStream stream, DataSource dbConnFactory) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.m_config = (EventTranslatorConfiguration)JaxbUtils.unmarshal(EventTranslatorConfiguration.class, (Reader)reader);
            this.m_dbConnFactory = dbConnFactory;
        }
    }

    private synchronized void unmarshall(InputStream stream) throws IOException {
        this.unmarshall(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws Exception {
        EventTranslatorConfigFactory eventTranslatorConfigFactory = this;
        synchronized (eventTranslatorConfigFactory) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRANSLATOR_CONFIG_FILE_NAME);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.unmarshall(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }
    }

    public static synchronized void init() throws IOException, ClassNotFoundException, SQLException, PropertyVetoException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRANSLATOR_CONFIG_FILE_NAME);
        m_singleton = new EventTranslatorConfigFactory(cfgFile.getPath(), DataSourceFactory.getInstance());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, ClassNotFoundException, SQLException, PropertyVetoException {
        m_singleton = null;
        m_loaded = false;
        EventTranslatorConfigFactory.init();
    }

    public static synchronized EventTranslatorConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("getInstance: The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(EventTranslatorConfig singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    private synchronized EventTranslatorConfiguration getConfig() {
        return this.m_config;
    }

    @Override
    public List<String> getUEIList() {
        return this.getTranslationUEIs();
    }

    private List<String> getTranslationUEIs() {
        return this.getConfig().getEventTranslationSpecs().parallelStream().map(EventTranslationSpec::getUei).distinct().collect(Collectors.toList());
    }

    @Override
    public List<Event> translateEvent(Event e) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (TranslationSpec spec : this.getTranslationSpecs()) {
            events.addAll(spec.translate(e));
        }
        return events;
    }

    private List<TranslationSpec> getTranslationSpecs() {
        if (this.m_translationSpecs == null) {
            this.m_translationSpecs = this.constructTranslationSpecs();
        }
        return this.m_translationSpecs;
    }

    private List<TranslationSpec> constructTranslationSpecs() {
        return this.getConfig().getEventTranslationSpecs().parallelStream().map(x$0 -> new TranslationSpec((EventTranslationSpec)x$0)).collect(Collectors.toList());
    }

    ValueSpec getValueSpec(Value val) {
        if ("field".equals(val.getType())) {
            return new FieldValueSpec(val);
        }
        if ("parameter".equals(val.getType())) {
            return new ParameterValueSpec(val);
        }
        if ("constant".equals(val.getType())) {
            return new ConstantValueSpec(val);
        }
        if ("sql".equals(val.getType())) {
            return new SqlValueSpec(val);
        }
        return new ValueSpecUnspecified();
    }

    public static Event cloneEvent(Event orig) {
        Event copy = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            copy = (Event)in.readObject();
        }
        catch (IOException e) {
            LOG.error("Exception cloning event", (Throwable)e);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Exception cloning event", (Throwable)cnfe);
        }
        return copy;
    }

    class ParameterValueSpec
    extends AttributeValueSpec {
        ParameterValueSpec(Value val) {
            super(val);
        }

        @Override
        public String getAttributeValue(Event e) {
            String attrName = this.getAttributeName();
            for (Parm parm : e.getParmCollection()) {
                if (parm.getParmName().equals(attrName)) {
                    LOG.debug("getAttributeValue: eventParm name: '{} equals translation parameter name: ' {}", (Object)attrName, (Object)parm.getParmName());
                    return parm.getValue() == null ? "" : parm.getValue().getContent();
                }
                String trimmedAttrName = StringUtils.removeStart((String)attrName, (String)"~");
                if (!attrName.startsWith("~") || !parm.getParmName().matches(trimmedAttrName)) continue;
                LOG.debug("getAttributeValue: eventParm name: '{} matches translation parameter name expression: ' {}", (Object)trimmedAttrName, (Object)parm.getParmName());
                return parm.getValue() == null ? "" : parm.getValue().getContent();
            }
            return null;
        }
    }

    class FieldValueSpec
    extends AttributeValueSpec {
        public FieldValueSpec(Value val) {
            super(val);
        }

        @Override
        public String getAttributeValue(Event e) {
            try {
                BeanWrapper bean = this.getBeanWrapper(e);
                return (String)bean.convertIfNecessary(bean.getPropertyValue(this.getAttributeName()), String.class);
            }
            catch (FatalBeanException ex) {
                LOG.error("Property {} does not exist on Event", (Object)ex, (Object)this.getAttributeName());
                throw new TranslationFailedException("Property " + this.getAttributeName() + " does not exist on Event");
            }
        }

        private BeanWrapper getBeanWrapper(Event e) {
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)e);
            bean.registerCustomEditor(String.class, (PropertyEditor)new StringPropertyEditor());
            return bean;
        }
    }

    static class StringPropertyEditor
    extends PropertyEditorSupport {
        StringPropertyEditor() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null || value instanceof String) {
                super.setValue(value);
            } else {
                super.setValue(value.toString());
            }
        }

        @Override
        public String getAsText() {
            return (String)super.getValue();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(text);
        }
    }

    abstract class AttributeValueSpec
    extends ValueSpec {
        Value m_val;

        AttributeValueSpec(Value val) {
            this.m_val = val;
        }

        @Override
        public boolean matches(Event e) {
            String attributeValue = this.getAttributeValue(e);
            if (attributeValue == null) {
                LOG.debug("AttributeValueSpec.matches: Event attributeValue doesn't match because attributeValue itself is null");
                return false;
            }
            if (!this.m_val.getMatches().isPresent()) {
                LOG.debug("AttributeValueSpec.matches: Event attributeValue: {} matches because pattern is null", (Object)attributeValue);
                return true;
            }
            Pattern p = Pattern.compile((String)this.m_val.getMatches().get());
            Matcher m = p.matcher(attributeValue);
            LOG.debug("AttributeValueSpec.matches: Event attributeValue: {} {} pattern: {}", new Object[]{attributeValue, m.matches() ? "matches" : "doesn't match", this.m_val.getMatches()});
            return m.matches();
        }

        @Override
        public String getResult(Event srcEvent) {
            if (!this.m_val.getMatches().isPresent()) {
                return this.m_val.getResult();
            }
            String attributeValue = this.getAttributeValue(srcEvent);
            if (attributeValue == null) {
                throw new TranslationFailedException("failed to match null against '" + (String)this.m_val.getMatches().get() + "' for attribute " + this.getAttributeName());
            }
            Pattern p = Pattern.compile((String)this.m_val.getMatches().get());
            Matcher m = p.matcher(attributeValue);
            if (!m.matches()) {
                throw new TranslationFailedException("failed to match " + attributeValue + " against '" + (String)this.m_val.getMatches().get() + "' for attribute " + this.getAttributeName());
            }
            MatchTable matches = new MatchTable(m);
            return PropertiesUtils.substitute((String)this.m_val.getResult(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{matches});
        }

        public String getAttributeName() {
            return this.m_val.getName().orElse(null);
        }

        public abstract String getAttributeValue(Event var1);
    }

    class SqlValueSpec
    extends ValueSpec {
        Value m_val;
        List<ValueSpec> m_nestedValues;

        public SqlValueSpec(Value val) {
            this.m_val = val;
            this.m_nestedValues = null;
        }

        public List<ValueSpec> getNestedValues() {
            if (this.m_nestedValues == null) {
                this.m_nestedValues = this.constructNestedValues();
            }
            return this.m_nestedValues;
        }

        private List<ValueSpec> constructNestedValues() {
            ArrayList<ValueSpec> nestedValues = new ArrayList<ValueSpec>();
            for (Value val : this.m_val.getValues()) {
                nestedValues.add(EventTranslatorConfigFactory.this.getValueSpec(val));
            }
            return nestedValues;
        }

        @Override
        public boolean matches(Event e) {
            for (ValueSpec nestedVal : this.getNestedValues()) {
                if (nestedVal.matches(e)) continue;
                return false;
            }
            Query query = this.createQuery(e);
            int rowCount = query.execute();
            if (rowCount < 1) {
                LOG.info("No results found for query {}. No match.", (Object)query.reproduceStatement());
                return false;
            }
            return true;
        }

        public Query createQuery(Event srcEvent) {
            Object[] args = new Object[this.getNestedValues().size()];
            SingleResultQuerier querier = new SingleResultQuerier(EventTranslatorConfigFactory.this.m_dbConnFactory, this.m_val.getResult());
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.getNestedValues().get(i).getResult(srcEvent);
            }
            return new Query(querier, args);
        }

        @Override
        public String getResult(Event srcEvent) {
            Query query = this.createQuery(srcEvent);
            query.execute();
            if (query.getRowCount() < 1) {
                LOG.info("No results found for query {}. Returning null", (Object)query.reproduceStatement());
                return null;
            }
            Object result = query.getResult();
            LOG.debug("getResult: result of single result querier is: {}", result);
            if (result != null) {
                return result.toString();
            }
            return null;
        }

        private class Query {
            SingleResultQuerier m_querier;
            Object[] m_args;

            Query(SingleResultQuerier querier, Object[] args) {
                this.m_querier = querier;
                this.m_args = Arrays.copyOf(args, args.length);
            }

            public int getRowCount() {
                return this.m_querier.getCount();
            }

            public int execute() {
                this.m_querier.execute(this.m_args);
                return this.getRowCount();
            }

            public String reproduceStatement() {
                return this.m_querier.reproduceStatement(this.m_args);
            }

            public Object getResult() {
                return this.m_querier.getResult();
            }
        }
    }

    class ValueSpecUnspecified
    extends ValueSpec {
        ValueSpecUnspecified() {
        }

        @Override
        public boolean matches(Event e) {
            return true;
        }

        @Override
        public String getResult(Event srcEvent) {
            return "value unspecified";
        }
    }

    class ConstantValueSpec
    extends ValueSpec {
        Value m_constant;

        public ConstantValueSpec(Value constant) {
            this.m_constant = constant;
        }

        @Override
        public boolean matches(Event e) {
            if (this.m_constant.getMatches().isPresent()) {
                LOG.warn("ConstantValueSpec.matches: matches not allowed for constant value.");
                throw new IllegalStateException("Illegal to use matches with constant type values");
            }
            return true;
        }

        @Override
        public String getResult(Event srcEvent) {
            return this.m_constant.getResult();
        }
    }

    abstract class ValueSpec {
        ValueSpec() {
        }

        public abstract boolean matches(Event var1);

        public abstract String getResult(Event var1);
    }

    class ParameterAssignmentSpec
    extends AssignmentSpec {
        ParameterAssignmentSpec(Assignment assign) {
            super(assign);
        }

        @Override
        protected void setValue(Event targetEvent, String value) {
            if (value == null) {
                LOG.debug("Value of parameter is null setting to blank");
                value = "";
            }
            for (Parm parm : targetEvent.getParmCollection()) {
                if (!parm.getParmName().equals(this.getAttributeName())) continue;
                org.opennms.netmgt.xml.event.Value val = parm.getValue();
                if (val == null) {
                    val = new org.opennms.netmgt.xml.event.Value();
                    parm.setValue(val);
                }
                LOG.debug("Overriding value of parameter {}. Setting it to {}", (Object)value, (Object)this.getAttributeName());
                val.setContent(value);
                return;
            }
            Parm newParm = new Parm();
            newParm.setParmName(this.getAttributeName());
            org.opennms.netmgt.xml.event.Value val = new org.opennms.netmgt.xml.event.Value();
            newParm.setValue(val);
            LOG.debug("Setting value of parameter {} to {}", (Object)value, (Object)this.getAttributeName());
            val.setContent(value);
            targetEvent.addParm(newParm);
        }
    }

    class FieldAssignmentSpec
    extends AssignmentSpec {
        FieldAssignmentSpec(Assignment field) {
            super(field);
        }

        @Override
        protected void setValue(Event targetEvent, String value) {
            try {
                BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)targetEvent);
                bean.setPropertyValue(this.getAttributeName(), (Object)value);
            }
            catch (FatalBeanException e) {
                LOG.error("Unable to set value for attribute {}to value {} Exception: {}", new Object[]{e, this.getAttributeName(), value});
                throw new TranslationFailedException("Unable to set value for attribute " + this.getAttributeName() + " to value " + value);
            }
        }
    }

    abstract class AssignmentSpec {
        private Assignment m_assignment;
        private ValueSpec m_valueSpec;

        AssignmentSpec(Assignment assignment) {
            this.m_assignment = assignment;
            this.m_valueSpec = null;
        }

        public void apply(Event srcEvent, Event targetEvent) {
            this.setValue(targetEvent, this.getValueSpec().getResult(srcEvent));
        }

        private Assignment getAssignment() {
            return this.m_assignment;
        }

        protected String getAttributeName() {
            return this.getAssignment().getName();
        }

        private ValueSpec constructValueSpec() {
            Value val = this.getAssignment().getValue();
            return EventTranslatorConfigFactory.this.getValueSpec(val);
        }

        protected abstract void setValue(Event var1, String var2);

        private ValueSpec getValueSpec() {
            if (this.m_valueSpec == null) {
                this.m_valueSpec = this.constructValueSpec();
            }
            return this.m_valueSpec;
        }

        boolean matches(Event e) {
            return this.getValueSpec().matches(e);
        }
    }

    class TranslationMapping {
        Mapping m_mapping;
        List<AssignmentSpec> m_assignments;

        TranslationMapping(Mapping mapping) {
            this.m_mapping = mapping;
            this.m_assignments = null;
        }

        public Event translate(Event srcEvent) {
            Event targetEvent = this.cloneEvent(srcEvent);
            for (AssignmentSpec assignSpec : this.getAssignmentSpecs()) {
                if (assignSpec.matches(srcEvent)) {
                    assignSpec.apply(srcEvent, targetEvent);
                    continue;
                }
                if (assignSpec.getAssignment().hasDefault()) {
                    assignSpec.setValue(targetEvent, assignSpec.getAssignment().getDefault());
                    continue;
                }
                return null;
            }
            targetEvent.setSource("event-translator");
            return targetEvent;
        }

        private Event cloneEvent(Event srcEvent) {
            Event clonedEvent = EventTranslatorConfigFactory.cloneEvent(srcEvent);
            if (clonedEvent == null) {
                throw new IllegalStateException("unable to clone event: " + srcEvent);
            }
            clonedEvent.setAlarmData(null);
            clonedEvent.setSeverity(null);
            clonedEvent.setDescr(null);
            if (!this.m_mapping.getPreserveSnmpData().booleanValue()) {
                clonedEvent.setSnmp(null);
            }
            return clonedEvent;
        }

        public Mapping getMapping() {
            return this.m_mapping;
        }

        private List<AssignmentSpec> getAssignmentSpecs() {
            if (this.m_assignments == null) {
                this.m_assignments = this.constructAssignmentSpecs();
            }
            return this.m_assignments;
        }

        private List<AssignmentSpec> constructAssignmentSpecs() {
            Mapping mapping = this.getMapping();
            ArrayList<AssignmentSpec> assignments = new ArrayList<AssignmentSpec>();
            for (Assignment assign : mapping.getAssignments()) {
                AssignmentSpec assignSpec = "parameter".equals(assign.getType()) ? new ParameterAssignmentSpec(assign) : new FieldAssignmentSpec(assign);
                assignments.add(assignSpec);
            }
            return assignments;
        }
    }

    class TranslationSpec {
        private EventTranslationSpec m_spec;
        private List<TranslationMapping> m_translationMappings;

        TranslationSpec(EventTranslationSpec spec) {
            this.m_spec = spec;
            this.m_translationMappings = null;
        }

        public List<Event> translate(Event e) {
            if (!this.ueiMatches(e)) {
                return Collections.emptyList();
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (TranslationMapping mapping : this.getTranslationMappings()) {
                Event translatedEvent = mapping.translate(e);
                if (translatedEvent == null) continue;
                events.add(translatedEvent);
            }
            return events;
        }

        String getUei() {
            return this.m_spec.getUei();
        }

        public EventTranslationSpec getEventTranslationSpec() {
            return this.m_spec;
        }

        private List<TranslationMapping> constructTranslationMappings() {
            if (this.m_spec.getMappings() == null) {
                return Collections.emptyList();
            }
            List mappings = this.m_spec.getMappings();
            ArrayList<TranslationMapping> transMaps = new ArrayList<TranslationMapping>(mappings.size());
            for (Mapping mapping : mappings) {
                TranslationMapping transMap = new TranslationMapping(mapping);
                transMaps.add(transMap);
            }
            return Collections.unmodifiableList(transMaps);
        }

        List<TranslationMapping> getTranslationMappings() {
            if (this.m_translationMappings == null) {
                this.m_translationMappings = this.constructTranslationMappings();
            }
            return Collections.unmodifiableList(this.m_translationMappings);
        }

        private boolean ueiMatches(Event e) {
            return e.getUei().equals(this.m_spec.getUei()) || this.m_spec.getUei().endsWith("/") && e.getUei().startsWith(this.m_spec.getUei());
        }
    }

    static class TranslationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -7219413891842193464L;

        TranslationFailedException(String msg) {
            super(msg);
        }
    }
}

