/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.jasperreports.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomJRJdtCompiler
extends JRAbstractJavaCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(CustomJRJdtCompiler.class);
    private static final String JDT_PROPERTIES_PREFIX = "org.eclipse.jdt.core.";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR = "compilers.jdt.class.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR = "compilers.jdt.name.environment.answer.instance.error";
    private final ClassLoader classLoader = this.getClassLoader();

    public CustomJRJdtCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) {
        INameEnvironment env = this.getNameEnvironment(units);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        CompilerOptions options = this.getJdtSettings();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        CompilerRequestor requestor = this.getCompilerRequestor(units);
        Compiler compiler = new Compiler(env, policy, options, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        do {
            ICompilationUnit[] compilationUnits = requestor.processCompilationUnits();
            compiler.compile(compilationUnits);
        } while (requestor.hasMissingMethods());
        requestor.processProblems();
        return requestor.getFormattedProblems();
    }

    protected INameEnvironment getNameEnvironment(final JRCompilationUnit[] units) {
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result.append(sep);
                    result.append(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(sep);
                    result.append(packageName[i]);
                    sep = ".";
                }
                result.append(sep);
                result.append(typeName);
                return this.findType(result.toString());
            }

            private int getClassIndex(String className) {
                int classIdx;
                for (classIdx = 0; classIdx < units.length && !className.equals(units[classIdx].getName()); ++classIdx) {
                }
                if (classIdx >= units.length) {
                    classIdx = -1;
                }
                return classIdx;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private NameEnvironmentAnswer findType(String className) {
                NameEnvironmentAnswer nameEnvironmentAnswer;
                int classIdx = this.getClassIndex(className);
                if (classIdx >= 0) {
                    CompilationUnit compilationUnit = new CompilationUnit(units[classIdx].getSourceCode(), className);
                    return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                }
                String resourceName = className.replace('.', '/') + ".class";
                InputStream is = CustomJRJdtCompiler.this.getResource(resourceName);
                if (is == null) return null;
                try {
                    byte[] classBytes = JRLoader.loadBytes((InputStream)is);
                    char[] fileName = className.toCharArray();
                    ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                    nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (JRException e) {
                        LOG.error("Compilation error", (Throwable)e);
                        return null;
                    }
                    catch (ClassFormatException exc) {
                        LOG.error("Compilation error", (Throwable)exc);
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        throw new JRRuntimeException(CustomJRJdtCompiler.EXCEPTION_MESSAGE_KEY_NAME_ENVIRONMENT_ANSWER_INSTANCE_ERROR, (Object[])null, (Throwable)e);
                    }
                }
                try {
                    is.close();
                    return nameEnvironmentAnswer;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return nameEnvironmentAnswer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isPackage(String result) {
                int classIdx = this.getClassIndex(result);
                if (classIdx >= 0) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                boolean isPackage = true;
                InputStream is = CustomJRJdtCompiler.this.getResource(resourceName);
                if (is != null) {
                    try {
                        isPackage = is.read() > 0;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return isPackage;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result.append(sep);
                        result.append(parentPackageName[i]);
                        sep = ".";
                    }
                }
                if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                    return false;
                }
                result.append(sep);
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        return env;
    }

    protected CompilerRequestor getCompilerRequestor(JRCompilationUnit[] units) {
        return new CompilerRequestor(this.jasperReportsContext, this, units);
    }

    protected CompilerOptions getJdtSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        List properties = JRPropertiesUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getProperties(JDT_PROPERTIES_PREFIX);
        for (JRPropertiesUtil.PropertySuffix property : properties) {
            String propVal = property.getValue();
            if (propVal == null || propVal.length() <= 0) continue;
            settings.put(property.getKey(), propVal);
        }
        Properties systemProps = System.getProperties();
        Enumeration<?> it = systemProps.propertyNames();
        while (it.hasMoreElements()) {
            String propVal;
            String propName = (String)it.nextElement();
            if (!propName.startsWith(JDT_PROPERTIES_PREFIX) || (propVal = systemProps.getProperty(propName)) == null || propVal.length() <= 0) continue;
            settings.put(propName, propVal);
        }
        return new CompilerOptions(settings);
    }

    private ClassLoader getClassLoader() {
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        if (clsLoader != null) {
            try {
                Class.forName(CustomJRJdtCompiler.class.getName(), true, clsLoader);
            }
            catch (ClassNotFoundException e) {
                clsLoader = null;
            }
        }
        if (clsLoader == null) {
            clsLoader = JRClassLoader.class.getClassLoader();
        }
        return clsLoader;
    }

    protected InputStream getResource(String resourceName) {
        if (this.classLoader == null) {
            return CustomJRJdtCompiler.class.getResourceAsStream("/" + resourceName);
        }
        return this.classLoader.getResourceAsStream(resourceName);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(className);
        }
        return this.classLoader.loadClass(className);
    }

    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("compilers.language.expected.java", new Object[]{language, "java"});
        }
    }

    protected JRCompilationUnit recreateCompileUnit(JRCompilationUnit compilationUnit, Set<Method> missingMethods) {
        String unitName = compilationUnit.getName();
        JRSourceCompileTask sourceTask = compilationUnit.getCompileTask();
        JRCompilationSourceCode sourceCode = JRClassGenerator.modifySource((JRSourceCompileTask)sourceTask, missingMethods, (String)compilationUnit.getSourceCode());
        File sourceFile = compilationUnit.getSourceFile();
        File saveSourceDir = sourceFile == null ? null : sourceFile.getParentFile();
        sourceFile = this.getSourceFile(saveSourceDir, unitName, sourceCode);
        return new JRCompilationUnit(unitName, sourceCode, sourceFile, compilationUnit.getExpressions(), sourceTask);
    }

    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRClassGenerator.generateClass((JRSourceCompileTask)sourceTask);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".java";
    }

    protected String getCompilerClass() {
        return CustomJRJdtCompiler.class.getCanonicalName();
    }

    public static class CompilationUnitResult {
        private Set<Method> resolvedMethods;
        private Set<Method> missingMethods;
        private IProblem[] problems;

        public boolean hasMissingMethods() {
            return this.missingMethods != null && this.missingMethods.size() > 0;
        }

        public Set<Method> getMissingMethods() {
            return this.missingMethods;
        }

        public void addMissingMethod(Method missingMethod) {
            if (this.resolvedMethods == null || !this.resolvedMethods.contains(missingMethod)) {
                if (this.missingMethods == null) {
                    this.missingMethods = new HashSet<Method>();
                }
                this.missingMethods.add(missingMethod);
            }
        }

        public IProblem[] getProblems() {
            return this.problems;
        }

        public void setProblems(IProblem[] problems) {
            this.problems = problems;
        }

        public void resolveMissingMethods() {
            if (this.missingMethods != null && this.missingMethods.size() > 0) {
                if (this.resolvedMethods == null) {
                    this.resolvedMethods = new HashSet<Method>();
                }
                this.resolvedMethods.addAll(this.missingMethods);
            }
        }

        public void reset() {
            this.missingMethods = null;
            this.problems = null;
        }
    }

    public static class CompilationUnit
    implements ICompilationUnit {
        protected String srcCode;
        protected String className;

        public CompilationUnit(String srcCode, String className) {
            this.srcCode = srcCode;
            this.className = className;
        }

        public char[] getFileName() {
            return this.className.toCharArray();
        }

        public char[] getContents() {
            return this.srcCode.toCharArray();
        }

        public char[] getMainTypeName() {
            return this.className.toCharArray();
        }

        public char[][] getPackageName() {
            return new char[0][0];
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }
    }

    public static class CompilerRequestor
    implements ICompilerRequestor {
        public static final String EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR = "compilers.jdt.method.invoking.error";
        public static final String EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR = "compilers.jdt.method.resolving.error";
        private final JasperReportsContext jasperReportsContext;
        protected final CustomJRJdtCompiler compiler;
        protected final JRCompilationUnit[] units;
        protected final CompilationUnitResult[] unitResults;

        public CompilerRequestor(JasperReportsContext jasperReportsContext, CustomJRJdtCompiler compiler, JRCompilationUnit[] units) {
            this.jasperReportsContext = jasperReportsContext;
            this.compiler = compiler;
            this.units = units;
            this.unitResults = new CompilationUnitResult[units.length];
            this.reset();
        }

        public void acceptResult(CompilationResult result) {
            int classIdx;
            String className = ((CompilationUnit)result.getCompilationUnit()).className;
            for (classIdx = 0; classIdx < this.units.length && !className.equals(this.units[classIdx].getName()); ++classIdx) {
            }
            if (result.hasErrors()) {
                IProblem[] problems = this.getJavaCompilationErrors(result);
                this.unitResults[classIdx].problems = problems;
                String sourceCode = this.units[classIdx].getSourceCode();
                for (int i = 0; i < problems.length; ++i) {
                    IProblem problem = problems[i];
                    if (0x4000064 != problem.getID() || problem.getSourceStart() < 0 || problem.getSourceEnd() < 0) continue;
                    String methodName = sourceCode.substring(problem.getSourceStart(), problem.getSourceEnd() + 1);
                    Method method = FunctionsUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getMethod4Function(methodName);
                    if (method == null) continue;
                    this.unitResults[classIdx].addMissingMethod(method);
                }
            } else {
                ClassFile[] resultClassFiles = result.getClassFiles();
                for (int i = 0; i < resultClassFiles.length; ++i) {
                    this.units[classIdx].setCompileData((Serializable)resultClassFiles[i].getBytes());
                }
            }
        }

        public void processProblems() {
        }

        public String getFormattedProblems() {
            StringBuilder problemBuilder = new StringBuilder();
            for (int u = 0; u < this.units.length; ++u) {
                String sourceCode = this.units[u].getSourceCode();
                IProblem[] problems = this.unitResults[u].problems;
                if (problems == null || problems.length <= 0) continue;
                for (int i = 0; i < problems.length; ++i) {
                    int j;
                    IProblem problem = problems[i];
                    problemBuilder.append(i + 1);
                    problemBuilder.append(". ");
                    problemBuilder.append(problem.getMessage());
                    if (problem.getSourceStart() < 0 || problem.getSourceEnd() < 0) continue;
                    int problemStartIndex = sourceCode.lastIndexOf("\n", problem.getSourceStart()) + 1;
                    int problemEndIndex = sourceCode.indexOf("\n", problem.getSourceEnd());
                    if (problemEndIndex < 0) {
                        problemEndIndex = sourceCode.length();
                    }
                    problemBuilder.append("\n");
                    problemBuilder.append(sourceCode.substring(problemStartIndex, problemEndIndex));
                    problemBuilder.append("\n");
                    for (j = problemStartIndex; j < problem.getSourceStart(); ++j) {
                        problemBuilder.append(" ");
                    }
                    if (problem.getSourceStart() == problem.getSourceEnd()) {
                        problemBuilder.append("^");
                    } else {
                        problemBuilder.append("<");
                        for (j = problem.getSourceStart() + 1; j < problem.getSourceEnd(); ++j) {
                            problemBuilder.append("-");
                        }
                        problemBuilder.append(">");
                    }
                    problemBuilder.append("\n");
                }
                problemBuilder.append(problems.length);
                problemBuilder.append(" errors\n");
            }
            return problemBuilder.length() > 0 ? problemBuilder.toString() : null;
        }

        public boolean hasMissingMethods() {
            for (CompilationUnitResult unitResult : this.unitResults) {
                if (!unitResult.hasMissingMethods()) continue;
                return true;
            }
            return false;
        }

        public CompilationUnit[] processCompilationUnits() {
            CompilationUnit[] compilationUnits = new CompilationUnit[this.units.length];
            for (int i = 0; i < compilationUnits.length; ++i) {
                if (this.unitResults[i].hasMissingMethods()) {
                    this.units[i] = this.compiler.recreateCompileUnit(this.units[i], this.unitResults[i].getMissingMethods());
                    this.unitResults[i].resolveMissingMethods();
                }
                compilationUnits[i] = new CompilationUnit(this.units[i].getSourceCode(), this.units[i].getName());
            }
            this.reset();
            return compilationUnits;
        }

        protected void reset() {
            for (int i = 0; i < this.unitResults.length; ++i) {
                if (this.unitResults[i] == null) {
                    this.unitResults[i] = new CompilationUnitResult();
                }
                this.unitResults[i].reset();
            }
        }

        protected IProblem[] getJavaCompilationErrors(CompilationResult result) {
            try {
                Method getErrorsMethod = result.getClass().getMethod("getErrors", null);
                return (IProblem[])getErrorsMethod.invoke((Object)result, (Object[])null);
            }
            catch (SecurityException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR, (Object[])null, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_RESOLVING_ERROR, (Object[])null, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, (Object[])null, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, (Object[])null, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_INVOKING_ERROR, (Object[])null, (Throwable)e);
            }
        }
    }
}

