/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.OspfArea;
import org.opennms.netmgt.enlinkd.model.OspfAreaTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.OspfAreaDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class OspfTopologyServiceImpl
extends TopologyServiceImpl
implements OspfTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(OspfTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private OspfLinkDao m_ospfLinkDao;
    private OspfElementDao m_ospfElementDao;
    private OspfAreaDao m_ospfAreaDao;

    public void delete(int nodeid) {
        this.m_ospfElementDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_ospfLinkDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_ospfAreaDao.deleteByNodeId(Integer.valueOf(nodeid));
        this.m_ospfElementDao.flush();
        this.m_ospfLinkDao.flush();
        this.m_ospfAreaDao.flush();
    }

    public void reconcile(int nodeId, Date now) {
        OspfElement element = (OspfElement)this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getOspfNodeLastPollTime().getTime() < now.getTime()) {
            this.m_ospfElementDao.delete((Object)element);
            this.m_ospfElementDao.flush();
        }
        this.m_ospfLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ospfLinkDao.flush();
        this.m_ospfAreaDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ospfAreaDao.flush();
    }

    @Transactional
    public void store(int nodeId, OspfElement element) {
        if (element == null) {
            return;
        }
        OspfElement dbelement = (OspfElement)this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_ospfElementDao.saveOrUpdate((Object)dbelement);
            this.m_ospfElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
        this.m_ospfElementDao.saveOrUpdate((Object)element);
        this.m_ospfElementDao.flush();
        this.updatesAvailable();
    }

    public void store(int nodeId, OspfLink link) {
        if (link == null) {
            return;
        }
        this.saveOspfLink(nodeId, link);
        this.updatesAvailable();
    }

    public void store(int nodeId, OspfArea area) {
        if (area == null) {
            return;
        }
        this.saveOspfArea(nodeId, area);
        this.updatesAvailable();
    }

    private void saveOspfArea(final int nodeId, final OspfArea area) {
        new UpsertTemplate<OspfArea, OspfAreaDao>(this.m_transactionManager, this.m_ospfAreaDao){

            protected OspfArea query() {
                return ((OspfAreaDao)this.m_dao).get(Integer.valueOf(nodeId), area.getOspfAreaId());
            }

            protected OspfArea doUpdate(OspfArea dbOspfArea) {
                dbOspfArea.merge(area);
                ((OspfAreaDao)this.m_dao).update((Object)dbOspfArea);
                ((OspfAreaDao)this.m_dao).flush();
                return dbOspfArea;
            }

            protected OspfArea doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                area.setNode(node);
                area.setOspfAreaLastPollTime(area.getOspfAreaCreateTime());
                ((OspfAreaDao)this.m_dao).saveOrUpdate((Object)area);
                ((OspfAreaDao)this.m_dao).flush();
                return area;
            }
        }.execute();
    }

    private void saveOspfLink(final int nodeId, final OspfLink saveMe) {
        new UpsertTemplate<OspfLink, OspfLinkDao>(this.m_transactionManager, this.m_ospfLinkDao){

            protected OspfLink query() {
                return ((OspfLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getOspfRemRouterId(), saveMe.getOspfRemIpAddr(), saveMe.getOspfRemAddressLessIndex());
            }

            protected OspfLink doUpdate(OspfLink dbOspfLink) {
                dbOspfLink.merge(saveMe);
                ((OspfLinkDao)this.m_dao).update((Object)dbOspfLink);
                ((OspfLinkDao)this.m_dao).flush();
                return dbOspfLink;
            }

            protected OspfLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setOspfLinkLastPollTime(saveMe.getOspfLinkCreateTime());
                ((OspfLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((OspfLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }

    public OspfAreaDao getOspfAreaDao() {
        return this.m_ospfAreaDao;
    }

    public void setOspfAreaDao(OspfAreaDao ospfAreaDao) {
        this.m_ospfAreaDao = ospfAreaDao;
    }

    public List<OspfElement> findAllOspfElements() {
        return this.m_ospfElementDao.findAll();
    }

    public List<OspfAreaTopologyEntity> findAllOspfAreas() {
        return this.getTopologyEntityCache().getOspfAreaTopologyEntities();
    }

    public List<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> match() {
        List allLinks = this.getTopologyEntityCache().getOspfLinkTopologyEntities();
        ArrayList<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> results = new ArrayList<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        HashMap<CompositeKey, OspfLinkTopologyEntity> targetLinks = new HashMap<CompositeKey, OspfLinkTopologyEntity>();
        for (OspfLinkTopologyEntity targetLink : allLinks) {
            targetLinks.put(new CompositeKey(new Object[]{targetLink.getOspfIpAddr(), targetLink.getOspfRemIpAddr()}), targetLink);
        }
        for (OspfLinkTopologyEntity sourceLink : allLinks) {
            OspfLinkTopologyEntity targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            parsed.add(sourceLink.getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOspfLinks: source: {}", (Object)sourceLink);
            }
            if ((targetLink = (OspfLinkTopologyEntity)targetLinks.get(new CompositeKey(new Object[]{sourceLink.getOspfRemIpAddr(), sourceLink.getOspfIpAddr()}))) == null) {
                LOG.debug("getOspfLinks: cannot find target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || parsed.contains(targetLink.getId())) continue;
            LOG.debug("getOspfLinks: target: {}", (Object)targetLink);
            parsed.add(targetLink.getId());
            results.add((TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>)TopologyService.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    public void deletePersistedData() {
        this.m_ospfElementDao.deleteAll();
        this.m_ospfElementDao.flush();
        this.m_ospfLinkDao.deleteAll();
        this.m_ospfLinkDao.flush();
    }
}

