/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import org.hibernate.PropertyAccessException;
import org.hibernate.bytecode.ReflectionOptimizer;

@Deprecated
public class AccessOptimizerAdapter
implements ReflectionOptimizer.AccessOptimizer,
Serializable {
    public static final String PROPERTY_GET_EXCEPTION = "exception getting property value with CGLIB (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    public static final String PROPERTY_SET_EXCEPTION = "exception setting property value with CGLIB (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    private Class mappedClass;
    private BulkBean bulkBean;

    public AccessOptimizerAdapter(BulkBean bulkBean, Class mappedClass) {
        this.bulkBean = bulkBean;
        this.mappedClass = mappedClass;
    }

    public String[] getPropertyNames() {
        return this.bulkBean.getGetters();
    }

    public Object[] getPropertyValues(Object object) {
        try {
            return this.bulkBean.getPropertyValues(object);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, PROPERTY_GET_EXCEPTION, false, this.mappedClass, AccessOptimizerAdapter.getterName(t, this.bulkBean));
        }
    }

    public void setPropertyValues(Object object, Object[] values) {
        try {
            this.bulkBean.setPropertyValues(object, values);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, PROPERTY_SET_EXCEPTION, true, this.mappedClass, AccessOptimizerAdapter.setterName(t, this.bulkBean));
        }
    }

    private static String setterName(Throwable t, BulkBean optimizer) {
        if (t instanceof BulkBeanException) {
            return optimizer.getSetters()[((BulkBeanException)t).getIndex()];
        }
        return "?";
    }

    private static String getterName(Throwable t, BulkBean optimizer) {
        if (t instanceof BulkBeanException) {
            return optimizer.getGetters()[((BulkBeanException)t).getIndex()];
        }
        return "?";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mappedClass);
        out.writeObject(this.bulkBean.getGetters());
        out.writeObject(this.bulkBean.getSetters());
        out.writeObject(this.bulkBean.getPropertyTypes());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class beanClass = (Class)in.readObject();
        String[] getters = (String[])in.readObject();
        String[] setters = (String[])in.readObject();
        Class[] types = (Class[])in.readObject();
        this.bulkBean = BulkBean.create((Class)beanClass, (String[])getters, (String[])setters, (Class[])types);
    }
}

