/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import java.util.Properties;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.camel.JmsQueueNameFactory;
import org.opennms.core.rpc.camel.CamelRpcRequest;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.opennms.core.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRpcClientPreProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcClientPreProcessor.class);
    public static final String CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY = "org.opennms.jms.timeout";
    public static final long CAMEL_JMS_REQUEST_TIMEOUT_DEFAULT = 20000L;
    protected final Long CAMEL_JMS_REQUEST_TIMEOUT;
    private MetricRegistry metrics = new MetricRegistry();
    private JmxReporter metricsReporter = null;

    public CamelRpcClientPreProcessor() {
        long camelJmsRequestTimeout = PropertiesUtils.getProperty((Properties)System.getProperties(), (String)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY, (long)20000L);
        if (camelJmsRequestTimeout <= 0L) {
            LOG.error("Invalid value {} for property {} - must be greater than zero!", (Object)camelJmsRequestTimeout, (Object)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY);
            camelJmsRequestTimeout = 20000L;
        }
        LOG.debug("Value {} set for property {}", (Object)camelJmsRequestTimeout, (Object)CAMEL_JMS_REQUEST_TIMEOUT_PROPERTY);
        this.CAMEL_JMS_REQUEST_TIMEOUT = camelJmsRequestTimeout;
    }

    public void process(Exchange exchange) throws Exception {
        String tracingInfo;
        CamelRpcRequest wrapper = (CamelRpcRequest)exchange.getIn().getBody(CamelRpcRequest.class);
        JmsQueueNameFactory queueNameFactory = new JmsQueueNameFactory("RPC", wrapper.getModule().getId(), wrapper.getRequest().getLocation());
        exchange.getIn().setHeader("JmsQueueName", (Object)queueNameFactory.getName());
        exchange.getIn().setHeader("CamelJmsRequestTimeout", (Object)(wrapper.getRequest().getTimeToLiveMs() != null ? wrapper.getRequest().getTimeToLiveMs() : this.CAMEL_JMS_REQUEST_TIMEOUT));
        if (wrapper.getRequest().getSystemId() != null) {
            exchange.getIn().setHeader("SystemId", (Object)wrapper.getRequest().getSystemId());
        }
        if (wrapper.getTracingInfo().size() > 0 && (tracingInfo = TracingInfoCarrier.marshalTracingInfo(wrapper.getTracingInfo())) != null) {
            exchange.getIn().setHeader("RpcTracingInfo", (Object)tracingInfo);
        }
        String request = wrapper.getModule().marshalRequest(wrapper.getRequest());
        exchange.getIn().setBody((Object)request);
        Histogram rpcRequestSize = this.metrics.histogram(MetricRegistry.name((String)wrapper.getRequest().getLocation(), (String[])new String[]{wrapper.getModule().getId(), "requestSize"}));
        rpcRequestSize.update(request.getBytes().length);
    }

    public void start() {
        this.metricsReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).inDomain("org.opennms.core.ipc.rpc").build();
        this.metricsReporter.start();
    }

    public void stop() {
        if (this.metricsReporter != null) {
            this.metricsReporter.close();
        }
    }
}

