/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.util.List;
import java.util.Map;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceMapper;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceWithMetadata;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugin.grpc.proto.services.InventoryUpdateList;
import org.opennms.plugin.grpc.proto.services.ServiceComponent;
import org.opennms.plugin.grpc.proto.services.StateUpdate;
import org.opennms.plugin.grpc.proto.services.StateUpdateList;

public class MonitoredServiceMapperImpl
implements MonitoredServiceMapper {
    @Override
    public ServiceComponent toInventoryUpdate(MonitoredServiceWithMetadata service) {
        List<String> categories;
        Map<String, String> map;
        if (service == null) {
            return null;
        }
        ServiceComponent.Builder serviceComponent = ServiceComponent.newBuilder();
        if (service != null) {
            serviceComponent.setForeignService(this.foreignService(service));
        }
        if (service != null) {
            serviceComponent.setName(this.displayName(service));
        }
        serviceComponent.setHealthy(this.serviceMonitoredServiceStatus(service));
        if (serviceComponent.getMutableAttributes() != null && (map = this.attributes(service)) != null) {
            serviceComponent.getMutableAttributes().putAll(map);
        }
        if ((categories = this.serviceNodeCategories(service)) != null) {
            for (String serviceNodeCategory : categories) {
                serviceComponent.addTags(serviceNodeCategory);
            }
        }
        return serviceComponent.build();
    }

    @Override
    public InventoryUpdateList toInventoryUpdates(List<MonitoredServiceWithMetadata> services, RuntimeInfo runtimeInfo, boolean snapshot) {
        if (services == null && runtimeInfo == null) {
            return null;
        }
        InventoryUpdateList.Builder inventoryUpdateList = InventoryUpdateList.newBuilder();
        if (runtimeInfo != null && runtimeInfo.getSystemId() != null) {
            inventoryUpdateList.setForeignSource(runtimeInfo.getSystemId());
        }
        if (services != null) {
            for (MonitoredServiceWithMetadata service : services) {
                inventoryUpdateList.addServices(this.toInventoryUpdate(service));
            }
        }
        inventoryUpdateList.setSnapshot(snapshot);
        inventoryUpdateList.setForeignType("OpenNMS");
        return inventoryUpdateList.build();
    }

    @Override
    public StateUpdate toStateUpdate(MonitoredServiceWithMetadata service) {
        if (service == null) {
            return null;
        }
        StateUpdate.Builder stateUpdate = StateUpdate.newBuilder();
        if (service != null) {
            stateUpdate.setForeignService(this.foreignService(service));
        }
        stateUpdate.setHealthy(this.serviceMonitoredServiceStatus(service));
        return stateUpdate.build();
    }

    @Override
    public StateUpdateList toStateUpdates(List<MonitoredServiceWithMetadata> updates, RuntimeInfo runtimeInfo) {
        if (updates == null && runtimeInfo == null) {
            return null;
        }
        StateUpdateList.Builder stateUpdateList = StateUpdateList.newBuilder();
        if (runtimeInfo != null && runtimeInfo.getSystemId() != null) {
            stateUpdateList.setForeignSource(runtimeInfo.getSystemId());
        }
        if (updates != null) {
            for (MonitoredServiceWithMetadata update : updates) {
                stateUpdateList.addUpdates(this.toStateUpdate(update));
            }
        }
        stateUpdateList.setForeignType("OpenNMS");
        return stateUpdateList.build();
    }

    private boolean serviceMonitoredServiceStatus(MonitoredServiceWithMetadata monitoredServiceWithMetadata) {
        if (monitoredServiceWithMetadata == null) {
            return false;
        }
        MonitoredService monitoredService = monitoredServiceWithMetadata.getMonitoredService();
        if (monitoredService == null) {
            return false;
        }
        boolean status = monitoredService.getStatus();
        return status;
    }

    private List<String> serviceNodeCategories(MonitoredServiceWithMetadata monitoredServiceWithMetadata) {
        if (monitoredServiceWithMetadata == null) {
            return null;
        }
        Node node = monitoredServiceWithMetadata.getNode();
        if (node == null) {
            return null;
        }
        List categories = node.getCategories();
        if (categories == null) {
            return null;
        }
        return categories;
    }
}

