/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.jceks;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.opennms.core.fileutils.FileUpdateCallback;
import org.opennms.core.fileutils.FileUpdateWatcher;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEKSSecureCredentialsVault
implements SecureCredentialsVault,
FileUpdateCallback {
    public static final Logger LOG = LoggerFactory.getLogger(JCEKSSecureCredentialsVault.class);
    private final KeyStore m_keystore;
    private final File m_keystoreFile;
    private final char[] m_password;
    private final byte[] m_salt;
    private final int m_iterationCount;
    private final int m_keyLength;
    private final HashMap<String, Credentials> m_credentialsCache = new HashMap();
    private FileUpdateWatcher m_fileUpdateWatcher;
    private final AtomicBoolean m_fileUpdated = new AtomicBoolean(false);
    private long m_lastModified = System.currentTimeMillis();
    public static final String KEYSTORE_KEY_PROPERTY = "org.opennms.features.scv.jceks.key";
    public static final String DEFAULT_KEYSTORE_KEY = "QqSezYvBtk2gzrdpggMHvt5fJGWCdkRw";

    public JCEKSSecureCredentialsVault(String keystoreFile, String password, boolean useWatcher) {
        this(keystoreFile, password, useWatcher, new byte[]{0, 13, 13, 11, 10, 1, 1});
    }

    public JCEKSSecureCredentialsVault(String keystoreFile, String password) {
        this(keystoreFile, password, false, new byte[]{0, 13, 13, 11, 10, 1, 1});
    }

    public JCEKSSecureCredentialsVault(String keystoreFile, String password, boolean useWatcher, byte[] salt) {
        this(keystoreFile, password, useWatcher, salt, 16, 4096);
    }

    public JCEKSSecureCredentialsVault(String keystoreFile, String password, boolean useWatcher, byte[] salt, int iterationCount, int keyLength) {
        this.m_password = Objects.requireNonNull(password).toCharArray();
        this.m_salt = Objects.requireNonNull(salt);
        this.m_iterationCount = iterationCount;
        this.m_keyLength = keyLength;
        this.m_keystoreFile = new File(keystoreFile);
        try {
            this.m_keystore = KeyStore.getInstance("JCEKS");
            if (!this.m_keystoreFile.isFile()) {
                LOG.info("No existing keystore found at: {}. Using empty keystore.", (Object)this.m_keystoreFile);
                this.m_keystore.load(null, this.m_password);
            } else {
                LOG.info("Loading existing keystore from: {}", (Object)this.m_keystoreFile);
                try (FileInputStream is = new FileInputStream(this.m_keystoreFile);){
                    this.m_keystore.load(is, this.m_password);
                }
            }
            if (useWatcher) {
                this.createFileUpdateWatcher();
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void createFileUpdateWatcher() {
        if (this.m_fileUpdateWatcher == null) {
            try {
                this.m_fileUpdateWatcher = new FileUpdateWatcher(this.m_keystoreFile.getAbsolutePath(), (FileUpdateCallback)this, true);
            }
            catch (IOException e) {
                LOG.warn("Failed to create file update watcher", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredentials() {
        HashMap<String, Credentials> hashMap = this.m_credentialsCache;
        synchronized (hashMap) {
            if (!this.m_credentialsCache.isEmpty() && !this.m_fileUpdated.get()) {
                return;
            }
            if (this.m_fileUpdated.get()) {
                this.m_fileUpdated.set(false);
                this.m_credentialsCache.clear();
            }
            try {
                KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.m_password);
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
                for (String alias : this.getAliases()) {
                    KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)this.m_keystore.getEntry(alias, keyStorePP);
                    if (ske == null) continue;
                    PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(ske.getSecretKey(), PBEKeySpec.class);
                    this.m_credentialsCache.put(alias, (Credentials)JCEKSSecureCredentialsVault.fromBase64EncodedByteArray(new String(keySpec.getPassword()).getBytes()));
                }
            }
            catch (IOException | ClassNotFoundException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | InvalidKeySpecException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials(String alias) {
        this.loadCredentials();
        HashMap<String, Credentials> hashMap = this.m_credentialsCache;
        synchronized (hashMap) {
            return this.m_credentialsCache.get(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(String alias, Credentials credentials) {
        try {
            this.loadCredentials();
            byte[] credentialBytes = JCEKSSecureCredentialsVault.toBase64EncodedByteArray((Serializable)credentials);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            SecretKey generatedSecret = factory.generateSecret(new PBEKeySpec(new String(credentialBytes).toCharArray(), this.m_salt, this.m_iterationCount, this.m_keyLength));
            KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.m_password);
            this.m_keystore.setEntry(alias, new KeyStore.SecretKeyEntry(generatedSecret), keyStorePP);
            HashMap<String, Credentials> hashMap = this.m_credentialsCache;
            synchronized (hashMap) {
                this.writeKeystoreToDisk();
                this.m_credentialsCache.put(alias, credentials);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCredentials(String alias) {
        try {
            HashMap<String, Credentials> hashMap = this.m_credentialsCache;
            synchronized (hashMap) {
                this.m_keystore.deleteEntry(alias);
                this.m_credentialsCache.remove(alias);
                this.writeKeystoreToDisk();
            }
        }
        catch (KeyStoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void destroy() {
        if (this.m_fileUpdateWatcher != null) {
            this.m_fileUpdateWatcher.destroy();
        }
    }

    private void writeKeystoreToDisk() {
        try (FileOutputStream os = new FileOutputStream(this.m_keystoreFile);){
            this.m_keystore.store(os, this.m_password);
            this.m_lastModified = this.m_keystoreFile.lastModified();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static byte[] toBase64EncodedByteArray(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(o);
        out.close();
        return Base64.encodeBase64((byte[])baos.toByteArray());
    }

    private static <T extends Serializable> T fromBase64EncodedByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        byte[] decodedBytes = Base64.decodeBase64((byte[])bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(decodedBytes);
        ObjectInputStream in = new ObjectInputStream(bais);
        Serializable o = (Serializable)in.readObject();
        in.close();
        return (T)o;
    }

    public Set<String> getAliases() {
        try {
            return Sets.newHashSet(Collections.list(this.m_keystore.aliases()));
        }
        catch (KeyStoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String getKeystoreFilename() {
        String opennmsHome = System.getProperty("opennms.home");
        if (opennmsHome == null) {
            try {
                System.err.println("opennms.home is not set; using a temporary directory for scv keystore. This is very likely not what you want.");
                opennmsHome = Files.createTempDirectory("opennms-home-", new FileAttribute[0]).toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create a temporary scv keystore home!", e);
            }
        }
        return Paths.get(opennmsHome, "etc", "scv.jce").toString();
    }

    private static String getKeystorePassword() {
        return System.getProperty(KEYSTORE_KEY_PROPERTY, DEFAULT_KEYSTORE_KEY);
    }

    public static JCEKSSecureCredentialsVault defaultScv() {
        return new JCEKSSecureCredentialsVault(JCEKSSecureCredentialsVault.getKeystoreFilename(), JCEKSSecureCredentialsVault.getKeystorePassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        HashMap<String, Credentials> hashMap = this.m_credentialsCache;
        synchronized (hashMap) {
            if (this.m_keystoreFile.lastModified() == this.m_lastModified) {
                return;
            }
            try (FileInputStream is = new FileInputStream(this.m_keystoreFile);){
                this.m_keystore.load(is, this.m_password);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error("Exception while loading keystore file {}", (Object)this.m_keystoreFile, (Object)e);
            }
            this.m_fileUpdated.set(true);
        }
    }
}

