/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.xml.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opennms.shaded.jasper.com.lowagie.text.ExceptionConverter;
import org.opennms.shaded.jasper.com.lowagie.text.xml.XmlDomWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmpReader {
    private Document domDocument;

    public XmpReader(byte[] byArray) throws SAXException, IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.domDocument = documentBuilder.parse(byteArrayInputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExceptionConverter(parserConfigurationException);
        }
    }

    public boolean replace(String string, String string2, String string3) {
        NodeList nodeList = this.domDocument.getElementsByTagNameNS(string, string2);
        if (nodeList.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            this.setNodeText(this.domDocument, node, string3);
        }
        return true;
    }

    public boolean add(String string, String string2, String string3, String string4) {
        NodeList nodeList = this.domDocument.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node2 = namedNodeMap.item(j);
                if (!string2.equals(node2.getNodeValue())) continue;
                node2 = this.domDocument.createElement(string3);
                node2.appendChild(this.domDocument.createTextNode(string4));
                node.appendChild(node2);
                return true;
            }
        }
        return false;
    }

    public boolean setNodeText(Document document, Node node, String string) {
        if (node == null) {
            return false;
        }
        Node node2 = null;
        while ((node2 = node.getFirstChild()) != null) {
            node.removeChild(node2);
        }
        node.appendChild(document.createTextNode(string));
        return true;
    }

    public byte[] serializeDoc() throws IOException {
        XmlDomWriter xmlDomWriter = new XmlDomWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xmlDomWriter.setOutput(byteArrayOutputStream, null);
        byteArrayOutputStream.write("<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n".getBytes("UTF-8"));
        byteArrayOutputStream.flush();
        NodeList nodeList = this.domDocument.getElementsByTagName("x:xmpmeta");
        xmlDomWriter.write(nodeList.item(0));
        byteArrayOutputStream.flush();
        for (int i = 0; i < 20; ++i) {
            byteArrayOutputStream.write("                                                                                                   \n".getBytes());
        }
        byteArrayOutputStream.write("<?xpacket end=\"w\"?>".getBytes());
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

