/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.export.pdf.PdfStructure;
import net.sf.jasperreports.export.pdf.PdfStructureEntry;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.pdf.classic.ClassicStructureEntry;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfDictionary;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfString;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfStructureElement;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfStructureTreeRoot;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfWriter;

public class ClassicPdfStructure
implements PdfStructure {
    private ClassicPdfProducer pdfProducer;
    private Map<String, PdfName> pdfNames;

    public ClassicPdfStructure(ClassicPdfProducer pdfProducer) {
        this.pdfProducer = pdfProducer;
        this.pdfNames = new HashMap<String, PdfName>();
    }

    @Override
    public PdfStructureEntry createAllTag(String language) {
        PdfWriter pdfWriter = this.pdfProducer.getPdfWriter();
        PdfStructureTreeRoot root = pdfWriter.getStructureTreeRoot();
        PdfName pdfNameALL = new PdfName("All");
        root.mapRole(pdfNameALL, PdfName.SECT);
        root.mapRole(PdfName.IMAGE, PdfName.FIGURE);
        root.mapRole(PdfName.TEXT, PdfName.P);
        PdfStructureElement allTag = new PdfStructureElement(root, pdfNameALL);
        if (pdfWriter.getPDFXConformance() == 3) {
            root.mapRole(new PdfName("Anchor"), PdfName.NONSTRUCT);
            root.mapRole(PdfName.TEXT, PdfName.SPAN);
        } else {
            root.mapRole(new PdfName("Anchor"), PdfName.TEXT);
        }
        if (language != null) {
            allTag.put(PdfName.LANG, new PdfString(language));
        }
        return new ClassicStructureEntry(this, allTag);
    }

    protected PdfName pdfName(String name) {
        PdfName pdfName = this.pdfNames.get(name);
        if (pdfName == null) {
            pdfName = new PdfName(name);
            this.pdfNames.put(name, pdfName);
        }
        return pdfName;
    }

    protected ClassicStructureEntry createElement(PdfStructureEntry parent, String name) {
        PdfStructureElement parentElement = ((ClassicStructureEntry)parent).getElement();
        PdfStructureElement element = new PdfStructureElement(parentElement, this.pdfName(name));
        return new ClassicStructureEntry(this, element);
    }

    @Override
    public PdfStructureEntry createTag(PdfStructureEntry parent, String name) {
        return this.createElement(parent, name);
    }

    @Override
    public PdfStructureEntry beginTag(PdfStructureEntry parent, String name) {
        ClassicStructureEntry tag = this.createElement(parent, name);
        this.pdfProducer.getPdfContentByte().beginMarkedContentSequence(tag.getElement());
        return tag;
    }

    @Override
    public PdfStructureEntry beginTag(PdfStructureEntry parent, String name, String text) {
        PdfDictionary markedContentProps = new PdfDictionary();
        markedContentProps.put(PdfName.ACTUALTEXT, new PdfString(text, "UnicodeBig"));
        ClassicStructureEntry tag = this.createElement(parent, name);
        this.pdfProducer.getPdfContentByte().beginMarkedContentSequence(tag.getElement(), markedContentProps);
        return tag;
    }

    @Override
    public void endTag() {
        this.pdfProducer.getPdfContentByte().endMarkedContentSequence();
    }
}

