/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.karaf.scheduler.Job;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.SchedulerError;
import org.apache.karaf.scheduler.core.InternalScheduleOptions;
import org.apache.karaf.scheduler.core.KarafStdScheduler;
import org.apache.karaf.scheduler.core.KarafStdSchedulerFactory;
import org.apache.karaf.scheduler.core.NonParallelQuartzJobExecutor;
import org.apache.karaf.scheduler.core.QuartzJobExecutor;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements Scheduler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PREFIX = "Apache Karaf Quartz Scheduler ";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_OPTIONS = "QuartzJobScheduler.Options";
    static final String DATA_MAP_CONTEXT = "QuartzJobScheduler.Context";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    private volatile org.quartz.Scheduler scheduler;

    public QuartzScheduler(Properties configuration) {
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", Boolean.TRUE.toString());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(QuartzScheduler.class.getClassLoader());
            KarafStdSchedulerFactory factory = new KarafStdSchedulerFactory(configuration);
            this.scheduler = factory.getScheduler();
            this.scheduler.start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create quartz scheduler", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void deactivate() {
        org.quartz.Scheduler s = this.scheduler;
        this.scheduler = null;
        this.dispose(s);
    }

    private void dispose(org.quartz.Scheduler s) {
        if (s != null) {
            try {
                s.shutdown();
            }
            catch (SchedulerException e) {
                this.logger.debug("Exception during shutdown of scheduler.", (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Apache Karaf Quartz Scheduler stopped.");
            }
        }
    }

    private JobDataMap initDataMap(String jobName, Object job, InternalScheduleOptions options) {
        JobDataMap jobDataMap = new JobDataMap();
        JobDataMap jobContextMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_NAME, jobName);
        jobDataMap.put(DATA_MAP_OPTIONS, (Object)options);
        jobContextMap.put(DATA_MAP_OBJECT, job);
        jobContextMap.put(DATA_MAP_LOGGER, (Object)this.logger);
        jobDataMap.put(DATA_MAP_CONTEXT, (Object)jobContextMap);
        return jobDataMap;
    }

    private JobDetail createJobDetail(String name, JobDataMap jobDataMap, boolean concurrent) {
        return JobBuilder.newJob(concurrent ? QuartzJobExecutor.class : NonParallelQuartzJobExecutor.class).withIdentity(name).usingJobData(jobDataMap).build();
    }

    private void checkJob(Object job) throws IllegalArgumentException {
        if (!(job instanceof Runnable) && !(job instanceof Job)) {
            throw new IllegalArgumentException("Job object is neither an instance of " + Runnable.class.getName() + " nor " + Job.class.getName());
        }
    }

    org.quartz.Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ScheduleOptions NOW() {
        return this.AT(new Date());
    }

    @Override
    public ScheduleOptions NOW(int times, long period) {
        return this.AT(new Date(), times, period);
    }

    @Override
    public ScheduleOptions AT(Date date) {
        return new InternalScheduleOptions(date);
    }

    @Override
    public ScheduleOptions AT(Date date, int times, long period) {
        return new InternalScheduleOptions(date, times, period);
    }

    @Override
    public ScheduleOptions EXPR(String expression) {
        return new InternalScheduleOptions(expression);
    }

    @Override
    public void schedule(Object job, ScheduleOptions options) throws IllegalArgumentException, SchedulerError {
        String name;
        this.checkJob(job);
        if (!(options instanceof InternalScheduleOptions)) {
            throw new IllegalArgumentException("Options has not been created via schedule or is null.");
        }
        InternalScheduleOptions opts = (InternalScheduleOptions)options;
        org.quartz.Scheduler s = this.scheduler;
        if (s == null) {
            throw new IllegalStateException("Scheduler is not available anymore.");
        }
        if (opts.name != null) {
            try {
                JobKey key = JobKey.jobKey(opts.name);
                JobDetail jobdetail = s.getJobDetail(key);
                if (jobdetail != null) {
                    s.deleteJob(key);
                    this.logger.debug("Unscheduling job with name {}", (Object)opts.name);
                }
            }
            catch (SchedulerException key) {
                // empty catch block
            }
            name = opts.name;
        } else {
            opts.name = name = job.getClass().getName() + ':' + UUID.randomUUID();
        }
        Trigger trigger = opts.compile().withIdentity(name).build();
        JobDataMap jobDataMap = this.initDataMap(name, job, opts);
        JobDetail detail = this.createJobDetail(name, jobDataMap, opts.canRunConcurrently);
        this.logger.debug("Scheduling job {} with name {} and trigger {}", new Object[]{job, name, trigger});
        try {
            s.scheduleJob(detail, trigger);
        }
        catch (SchedulerException ex) {
            throw new SchedulerError(ex);
        }
    }

    @Override
    public void reschedule(String jobName, ScheduleOptions options) throws SchedulerError {
        org.quartz.Scheduler s = this.scheduler;
        if (jobName == null) {
            throw new IllegalArgumentException("Job name is mandatory");
        }
        JobKey key = JobKey.jobKey(jobName);
        if (key == null) {
            throw new IllegalStateException("No job found with name " + jobName);
        }
        try {
            JobDetail detail = s.getJobDetail(key);
            String contextKey = key.toString();
            JobDataMap karafContext = (JobDataMap)((KarafStdScheduler)s).getStorage().get((Serializable)((Object)contextKey));
            Object job = karafContext.get(DATA_MAP_OBJECT);
            s.deleteJob(key);
            InternalScheduleOptions opts = (InternalScheduleOptions)options;
            Trigger trigger = opts.compile().withIdentity(jobName).build();
            JobDataMap jobDataMap = this.initDataMap(jobName, job, opts);
            detail = this.createJobDetail(jobName, jobDataMap, opts.canRunConcurrently);
            this.logger.debug("Update job scheduling {} with name {} and trigger\u00a0{}", new Object[]{job, jobName, trigger});
            s.scheduleJob(detail, trigger);
        }
        catch (SchedulerException e) {
            throw new SchedulerError(e);
        }
    }

    @Override
    public boolean unschedule(String jobName) {
        org.quartz.Scheduler s = this.scheduler;
        if (jobName != null && s != null) {
            try {
                JobKey key = JobKey.jobKey(jobName);
                JobDetail jobdetail = s.getJobDetail(key);
                if (jobdetail != null) {
                    s.deleteJob(key);
                    this.logger.debug("Unscheduling job with name {}", (Object)jobName);
                    return true;
                }
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Map<String, ScheduleOptions> getJobs() throws SchedulerError {
        try {
            HashMap<String, ScheduleOptions> jobs = new HashMap<String, ScheduleOptions>();
            org.quartz.Scheduler s = this.scheduler;
            if (s != null) {
                for (String group : s.getJobGroupNames()) {
                    for (JobKey key : s.getJobKeys(GroupMatcher.jobGroupEquals(group))) {
                        JobDetail detail = s.getJobDetail(key);
                        ScheduleOptions options = (ScheduleOptions)detail.getJobDataMap().get(DATA_MAP_OPTIONS);
                        jobs.put(key.getName(), options);
                    }
                }
            }
            return jobs;
        }
        catch (SchedulerException ex) {
            throw new SchedulerError(ex);
        }
    }

    @Override
    public boolean trigger(String jobName) throws SchedulerError {
        org.quartz.Scheduler s = this.scheduler;
        if (jobName != null && s != null) {
            try {
                JobKey key = JobKey.jobKey(jobName);
                JobDetail jobdetail = s.getJobDetail(key);
                if (jobdetail != null) {
                    this.scheduler.triggerJob(key, jobdetail.getJobDataMap());
                    return true;
                }
            }
            catch (SchedulerException ex) {
                throw new SchedulerError(ex);
            }
        }
        return false;
    }
}

