/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.rest.internal;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.features.apilayer.uiextension.UIExtensionRegistry;
import org.opennms.integration.api.v1.ui.UIExtension;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.api.SearchService;
import org.opennms.netmgt.search.rest.SearchRestService;

public class SearchRestServiceImpl
implements SearchRestService {
    private final SearchService searchService;
    private final UIExtensionRegistry extensionRegistry;

    public SearchRestServiceImpl(SearchService searchService, UIExtensionRegistry extensionRegistry) {
        this.searchService = Objects.requireNonNull(searchService);
        this.extensionRegistry = Objects.requireNonNull(extensionRegistry);
    }

    @Override
    public Response query(SecurityContext securityContext, String context, String query, int limit) {
        SearchQuery searchQuery = new SearchQuery(query);
        searchQuery.setPrincipal(securityContext.getUserPrincipal());
        searchQuery.setUserInRoleFunction(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0));
        searchQuery.setContext(context);
        searchQuery.setMaxResults(limit < 0 ? 0 : limit);
        List searchResult = this.searchService.query(searchQuery);
        SearchResult pluginSearchResult = this.getPluginSearchResult(query);
        if (searchResult.isEmpty() && pluginSearchResult.isEmpty()) {
            return Response.noContent().build();
        }
        JSONArray jsonResult = new JSONArray();
        for (SearchResult eachResult : searchResult) {
            jsonResult.put((Object)new JSONObject((Object)eachResult));
        }
        if (!pluginSearchResult.isEmpty()) {
            jsonResult.put((Object)new JSONObject((Object)pluginSearchResult));
        }
        return Response.ok().entity((Object)jsonResult.toString()).build();
    }

    private SearchResult getPluginSearchResult(String query) {
        SearchResult searchResult = new SearchResult("Plugins");
        List extensions = this.extensionRegistry.listExtensions();
        for (UIExtension ext : extensions) {
            if (!ext.getMenuEntry().toLowerCase(Locale.ROOT).contains(query.toLowerCase(Locale.ROOT))) continue;
            SearchResultItem item = new SearchResultItem();
            item.addMatch(new Match("label", "Plugin", ext.getMenuEntry()));
            item.setIdentifier(ext.getMenuEntry());
            item.setLabel(ext.getMenuEntry());
            item.setWeight(100);
            String relativeUrl = String.format("ui/#/plugins/%s/%s/%s", ext.getExtensionId(), ext.getResourceRootPath(), ext.getModuleFileName());
            item.setUrl(relativeUrl);
            searchResult.addItem(item);
        }
        return searchResult;
    }
}

